/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem SalesOrderBOMItem}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.field.SalesOrderBOMItemField
 * SalesOrderBOMItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.link.SalesOrderBOMItemLink
 * SalesOrderBOMItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DELETE_BOM_ITEM_WITH_CHANGE_NUMBER_AC
 * DELETE_BOM_ITEM_WITH_CHANGE_NUMBER_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_NODE_NUMBER
 * BILL_OF_MATERIAL_ITEM_NODE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#HEADER_CHANGE_DOCUMENT
 * HEADER_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_UUID
 * BILL_OF_MATERIAL_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_INTERNAL_CHANGE_COUNT
 * BOM_ITEM_INTERNAL_CHANGE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#ENGINEERING_CHANGE_DOC_FOR_EDIT
 * ENGINEERING_CHANGE_DOC_FOR_EDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#ENGINEERING_CHANGE_DOCUMENT
 * ENGINEERING_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#CHG_TO_ENGINEERING_CHG_DOCUMENT
 * CHG_TO_ENGINEERING_CHG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#INHERITED_NODE_NUMBER_FOR_BOM_ITEM
 * INHERITED_NODE_NUMBER_FOR_BOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_RECORD_CREATION_DATE
 * BOM_ITEM_RECORD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_CREATED_BY_USER
 * BOM_ITEM_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_LAST_CHANGE_DATE
 * BOM_ITEM_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_LAST_CHANGED_BY_USER
 * BOM_ITEM_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_COMPONENT
 * BILL_OF_MATERIAL_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_CATEGORY
 * BILL_OF_MATERIAL_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_NUMBER
 * BILL_OF_MATERIAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_UNIT
 * BILL_OF_MATERIAL_ITEM_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BILL_OF_MATERIAL_ITEM_QUANTITY
 * BILL_OF_MATERIAL_ITEM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_ASSEMBLY
 * IS_ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_SUB_ITEM
 * IS_SUB_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_SORTER
 * BOM_ITEM_SORTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_HAS_FIXED_QUANTITY
 * BOM_ITEM_HAS_FIXED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MATERIAL_COMPONENT_PRICE
 * MATERIAL_COMPONENT_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IDENTIFIER_BOM_ITEM
 * IDENTIFIER_BOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MATERIAL_PRICE_UNIT_QTY
 * MATERIAL_PRICE_UNIT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#COMPONENT_SCRAP_IN_PERCENT
 * COMPONENT_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#OPERATION_SCRAP_IN_PERCENT
 * OPERATION_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_NET_SCRAP
 * IS_NET_SCRAP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#NUMBER_OF_VARIABLE_SIZE_ITEM
 * NUMBER_OF_VARIABLE_SIZE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#QUANTITY_VARIABLE_SIZE_ITEM
 * QUANTITY_VARIABLE_SIZE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#FORMULA_KEY
 * FORMULA_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#COMPONENT_DESCRIPTION
 * COMPONENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_TEXT2
 * BOM_ITEM_TEXT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DOCUMENT_TYPE
 * DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DOC_NUMBER
 * DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DOCUMENT_VERSION
 * DOCUMENT_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DOCUMENT_PART
 * DOCUMENT_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#CLASS_NUMBER
 * CLASS_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#RESULTING_ITEM_CATEGORY
 * RESULTING_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DEPENDENCY_OBJECT_NUMBER
 * DEPENDENCY_OBJECT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#OBJECT_TYPE
 * OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_CLASSIFICATION_RELEVANT
 * IS_CLASSIFICATION_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_BULK_MATERIAL
 * IS_BULK_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_IS_SPARE_PART
 * BOM_ITEM_IS_SPARE_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_IS_SALES_RELEVANT
 * BOM_ITEM_IS_SALES_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_PRODUCTION_RELEVANT
 * IS_PRODUCTION_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_IS_PLANT_MAINT_RELEVANT
 * BOM_ITEM_IS_PLANT_MAINT_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_ITEM_IS_COSTING_RELEVANT
 * BOM_ITEM_IS_COSTING_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_ENGINEERING_RELEVANT
 * IS_ENGINEERING_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SPECIAL_PROCUREMENT_TYPE
 * SPECIAL_PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_BOM_RECURSIVE_ALLOWED
 * IS_BOM_RECURSIVE_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#OPERATION_LEAD_TIME_OFFSET
 * OPERATION_LEAD_TIME_OFFSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#OPS_LEAD_TIME_OFFSET_UNIT
 * OPS_LEAD_TIME_OFFSET_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_MATERIAL_PROVISION
 * IS_MATERIAL_PROVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#BOM_IS_RECURSIVE
 * BOM_IS_RECURSIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DOCUMENT_IS_CREATED_BY_CAD
 * DOCUMENT_IS_CREATED_BY_CAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DISTR_KEY_COMP_CONSUMPTION
 * DISTR_KEY_COMP_CONSUMPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DELIVERY_DURATION_IN_DAYS
 * DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#CREDITOR
 * CREDITOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#COST_ELEMENT
 * COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SIZE1
 * SIZE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SIZE2
 * SIZE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SIZE3
 * SIZE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#UNIT_OF_MEASURE_FOR_SIZE1_TO3
 * UNIT_OF_MEASURE_FOR_SIZE1_TO3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#GOODS_RECEIPT_DURATION
 * GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#REQUIRED_COMPONENT
 * REQUIRED_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MULTIPLE_SELECTION_ALLOWED
 * MULTIPLE_SELECTION_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#PROD_ORDER_ISSUE_LOCATION
 * PROD_ORDER_ISSUE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#MATERIAL_IS_CO_PRODUCT
 * MATERIAL_IS_CO_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#EXPLOSION_TYPE
 * EXPLOSION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#ALTERNATIVE_ITEM_GROUP
 * ALTERNATIVE_ITEM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#ALTERNATIVE_ITEM_PRIORITY
 * ALTERNATIVE_ITEM_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#ALTERNATIVE_ITEM_STRATEGY
 * ALTERNATIVE_ITEM_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#USAGE_PROBABILITY_PERCENT
 * USAGE_PROBABILITY_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#FOLLOW_UP_GROUP
 * FOLLOW_UP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#DISCONTINUATION_GROUP
 * DISCONTINUATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_CONFIGURABLE_BOM
 * IS_CONFIGURABLE_BOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#REFERENCE_POINT
 * REFERENCE_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#LEAD_TIME_OFFSET
 * LEAD_TIME_OFFSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#IS_ALE
 * IS_ALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#TO_BOM_ITEM_CATEGORY
 * TO_BOM_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOMItem#TO_BILL_OF_MATERIAL
 * TO_BILL_OF_MATERIAL}</li>
 * </ul>
 *
 */
public interface SalesOrderBOMItemSelectable extends EntitySelectable<SalesOrderBOMItem>
{

}
