/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM SalesOrderBOM}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.field.SalesOrderBOMField
 * SalesOrderBOMField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.link.SalesOrderBOMLink
 * SalesOrderBOMLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#DELETE_BOM_HDR_WITH_CHANGE_NUMBER_AC
 * DELETE_BOM_HDR_WITH_CHANGE_NUMBER_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_ITEM_OC
 * BILL_OF_MATERIAL_ITEM_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#ENGINEERING_CHANGE_DOCUMENT
 * ENGINEERING_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#ENGINEERING_CHANGE_DOC_FOR_EDIT
 * ENGINEERING_CHANGE_DOC_FOR_EDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_HEADER_UUID
 * BILL_OF_MATERIAL_HEADER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_HEADER_INTERNAL_CHANGE_COUNT
 * BOM_HEADER_INTERNAL_CHANGE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_HEADER_TEXT
 * BOM_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_USAGE_PRIORITY
 * BOM_USAGE_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_AUTHSN_GRP
 * BILL_OF_MATERIAL_AUTHSN_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_TECHNICAL_TYPE
 * BOM_TECHNICAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_GROUP
 * BOM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_ALTERNATIVE_TEXT
 * BOM_ALTERNATIVE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BILL_OF_MATERIAL_STATUS
 * BILL_OF_MATERIAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#CHG_TO_ENGINEERING_CHG_DOCUMENT
 * CHG_TO_ENGINEERING_CHG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_IS_ARCHIVED_FOR_DELETION
 * BOM_IS_ARCHIVED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#IS_CONFIGURED_MATERIAL
 * IS_CONFIGURED_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_IS_CONFIGURABLE
 * BOM_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#IS_ALE IS_ALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_HEADER_BASE_UNIT
 * BOM_HEADER_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_HEADER_QUANTITY_IN_BASE_UNIT
 * BOM_HEADER_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#RECORD_CREATION_DATE
 * RECORD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_IS_TO_BE_DELETED
 * BOM_IS_TO_BE_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#DOCUMENT_IS_CREATED_BY_CAD
 * DOCUMENT_IS_CREATED_BY_CAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#LABORATORY_OR_DESIGN_OFFICE
 * LABORATORY_OR_DESIGN_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#BOM_ASSET_NTWK_HNDOVR_IS_RELEVANT
 * BOM_ASSET_NTWK_HNDOVR_IS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.orderbillofmaterial.SalesOrderBOM#TO_BILL_OF_MATERIAL_ITEM
 * TO_BILL_OF_MATERIAL_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderBOMSelectable extends EntitySelectable<SalesOrderBOM>
{

}
