/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.field.OutbDeliveryDocFlowField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.selectable.OutbDeliveryDocFlowSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_OutbDeliveryDocFlowType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OutbDeliveryDocFlow extends VdmEntity<OutbDeliveryDocFlow>
{

    /**
     * Selector for all available fields of OutbDeliveryDocFlow.
     *
     */
    public final static OutbDeliveryDocFlowSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Deliveryversion</b>
     * </p>
     *
     * @return DLV.Version
     */
    @SerializedName( "Deliveryversion" )
    @JsonProperty( "Deliveryversion" )
    @Nullable
    @ODataField( odataName = "Deliveryversion" )
    private String deliveryversion;
    /**
     * Use with available fluent helpers to apply the <b>Deliveryversion</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> DELIVERYVERSION =
        new OutbDeliveryDocFlowField<String>("Deliveryversion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @return Preceding Doc.
     */
    @Key
    @SerializedName( "PrecedingDocument" )
    @JsonProperty( "PrecedingDocument" )
    @Nullable
    @ODataField( odataName = "PrecedingDocument" )
    private String precedingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocument</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> PRECEDING_DOCUMENT =
        new OutbDeliveryDocFlowField<String>("PrecedingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @return Prec.Doc.Categ.
     */
    @SerializedName( "PrecedingDocumentCategory" )
    @JsonProperty( "PrecedingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PrecedingDocumentCategory" )
    private String precedingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocumentCategory</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> PRECEDING_DOCUMENT_CATEGORY =
        new OutbDeliveryDocFlowField<String>("PrecedingDocumentCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentItem</b>
     * </p>
     *
     * @return Preceding Item
     */
    @Key
    @SerializedName( "PrecedingDocumentItem" )
    @JsonProperty( "PrecedingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PrecedingDocumentItem" )
    private String precedingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocumentItem</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> PRECEDING_DOCUMENT_ITEM =
        new OutbDeliveryDocFlowField<String>("PrecedingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subsequentdocument</b>
     * </p>
     *
     * @return Follow-on Doc.
     */
    @SerializedName( "Subsequentdocument" )
    @JsonProperty( "Subsequentdocument" )
    @Nullable
    @ODataField( odataName = "Subsequentdocument" )
    private String subsequentdocument;
    /**
     * Use with available fluent helpers to apply the <b>Subsequentdocument</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> SUBSEQUENTDOCUMENT =
        new OutbDeliveryDocFlowField<String>("Subsequentdocument");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "QuantityInBaseUnit" )
    @JsonProperty( "QuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInBaseUnit" )
    private BigDecimal quantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<BigDecimal> QUANTITY_IN_BASE_UNIT =
        new OutbDeliveryDocFlowField<BigDecimal>("QuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentItem</b>
     * </p>
     *
     * @return Subsequent Item
     */
    @SerializedName( "SubsequentDocumentItem" )
    @JsonProperty( "SubsequentDocumentItem" )
    @Nullable
    @ODataField( odataName = "SubsequentDocumentItem" )
    private String subsequentDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocumentItem</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> SUBSEQUENT_DOCUMENT_ITEM =
        new OutbDeliveryDocFlowField<String>("SubsequentDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDFulfillmentCalculationRule</b>
     * </p>
     *
     * @return Pos./Negative
     */
    @SerializedName( "SDFulfillmentCalculationRule" )
    @JsonProperty( "SDFulfillmentCalculationRule" )
    @Nullable
    @ODataField( odataName = "SDFulfillmentCalculationRule" )
    private String sDFulfillmentCalculationRule;
    /**
     * Use with available fluent helpers to apply the <b>SDFulfillmentCalculationRule</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> SD_FULFILLMENT_CALCULATION_RULE =
        new OutbDeliveryDocFlowField<String>("SDFulfillmentCalculationRule");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @return Subs.Doc.Categ.
     */
    @Key
    @SerializedName( "SubsequentDocumentCategory" )
    @JsonProperty( "SubsequentDocumentCategory" )
    @Nullable
    @ODataField( odataName = "SubsequentDocumentCategory" )
    private String subsequentDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubsequentDocumentCategory</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<String> SUBSEQUENT_DOCUMENT_CATEGORY =
        new OutbDeliveryDocFlowField<String>("SubsequentDocumentCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransferOrderInWrhsMgmtIsConfd</b>
     * </p>
     *
     * @return Confirmation ID
     */
    @SerializedName( "TransferOrderInWrhsMgmtIsConfd" )
    @JsonProperty( "TransferOrderInWrhsMgmtIsConfd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "TransferOrderInWrhsMgmtIsConfd" )
    private Boolean transferOrderInWrhsMgmtIsConfd;
    /**
     * Use with available fluent helpers to apply the <b>TransferOrderInWrhsMgmtIsConfd</b> field to query operations.
     *
     */
    public final static OutbDeliveryDocFlowField<Boolean> TRANSFER_ORDER_IN_WRHS_MGMT_IS_CONFD =
        new OutbDeliveryDocFlowField<Boolean>("TransferOrderInWrhsMgmtIsConfd");

    @Nonnull
    @Override
    public Class<OutbDeliveryDocFlow> getType()
    {
        return OutbDeliveryDocFlow.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Deliveryversion</b>
     * </p>
     *
     * @param deliveryversion
     *            DLV.Version
     */
    public void setDeliveryversion( @Nullable final String deliveryversion )
    {
        rememberChangedField("Deliveryversion", this.deliveryversion);
        this.deliveryversion = deliveryversion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @param precedingDocument
     *            Preceding Doc.
     */
    public void setPrecedingDocument( @Nullable final String precedingDocument )
    {
        rememberChangedField("PrecedingDocument", this.precedingDocument);
        this.precedingDocument = precedingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @param precedingDocumentCategory
     *            Prec.Doc.Categ.
     */
    public void setPrecedingDocumentCategory( @Nullable final String precedingDocumentCategory )
    {
        rememberChangedField("PrecedingDocumentCategory", this.precedingDocumentCategory);
        this.precedingDocumentCategory = precedingDocumentCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentItem</b>
     * </p>
     *
     * @param precedingDocumentItem
     *            Preceding Item
     */
    public void setPrecedingDocumentItem( @Nullable final String precedingDocumentItem )
    {
        rememberChangedField("PrecedingDocumentItem", this.precedingDocumentItem);
        this.precedingDocumentItem = precedingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Subsequentdocument</b>
     * </p>
     *
     * @param subsequentdocument
     *            Follow-on Doc.
     */
    public void setSubsequentdocument( @Nullable final String subsequentdocument )
    {
        rememberChangedField("Subsequentdocument", this.subsequentdocument);
        this.subsequentdocument = subsequentdocument;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInBaseUnit</b>
     * </p>
     *
     * @param quantityInBaseUnit
     *            Quantity
     */
    public void setQuantityInBaseUnit( @Nullable final BigDecimal quantityInBaseUnit )
    {
        rememberChangedField("QuantityInBaseUnit", this.quantityInBaseUnit);
        this.quantityInBaseUnit = quantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentItem</b>
     * </p>
     *
     * @param subsequentDocumentItem
     *            Subsequent Item
     */
    public void setSubsequentDocumentItem( @Nullable final String subsequentDocumentItem )
    {
        rememberChangedField("SubsequentDocumentItem", this.subsequentDocumentItem);
        this.subsequentDocumentItem = subsequentDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDFulfillmentCalculationRule</b>
     * </p>
     *
     * @param sDFulfillmentCalculationRule
     *            Pos./Negative
     */
    public void setSDFulfillmentCalculationRule( @Nullable final String sDFulfillmentCalculationRule )
    {
        rememberChangedField("SDFulfillmentCalculationRule", this.sDFulfillmentCalculationRule);
        this.sDFulfillmentCalculationRule = sDFulfillmentCalculationRule;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubsequentDocumentCategory</b>
     * </p>
     *
     * @param subsequentDocumentCategory
     *            Subs.Doc.Categ.
     */
    public void setSubsequentDocumentCategory( @Nullable final String subsequentDocumentCategory )
    {
        rememberChangedField("SubsequentDocumentCategory", this.subsequentDocumentCategory);
        this.subsequentDocumentCategory = subsequentDocumentCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TransferOrderInWrhsMgmtIsConfd</b>
     * </p>
     *
     * @param transferOrderInWrhsMgmtIsConfd
     *            Confirmation ID
     */
    public void setTransferOrderInWrhsMgmtIsConfd( @Nullable final Boolean transferOrderInWrhsMgmtIsConfd )
    {
        rememberChangedField("TransferOrderInWrhsMgmtIsConfd", this.transferOrderInWrhsMgmtIsConfd);
        this.transferOrderInWrhsMgmtIsConfd = transferOrderInWrhsMgmtIsConfd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_OutbDeliveryDocFlow";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PrecedingDocument", getPrecedingDocument());
        result.put("PrecedingDocumentItem", getPrecedingDocumentItem());
        result.put("SubsequentDocumentCategory", getSubsequentDocumentCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Deliveryversion", getDeliveryversion());
        values.put("PrecedingDocument", getPrecedingDocument());
        values.put("PrecedingDocumentCategory", getPrecedingDocumentCategory());
        values.put("PrecedingDocumentItem", getPrecedingDocumentItem());
        values.put("Subsequentdocument", getSubsequentdocument());
        values.put("QuantityInBaseUnit", getQuantityInBaseUnit());
        values.put("SubsequentDocumentItem", getSubsequentDocumentItem());
        values.put("SDFulfillmentCalculationRule", getSDFulfillmentCalculationRule());
        values.put("SubsequentDocumentCategory", getSubsequentDocumentCategory());
        values.put("TransferOrderInWrhsMgmtIsConfd", getTransferOrderInWrhsMgmtIsConfd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Deliveryversion") ) {
                final Object value = values.remove("Deliveryversion");
                if( (value == null) || (!value.equals(getDeliveryversion())) ) {
                    setDeliveryversion(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocument") ) {
                final Object value = values.remove("PrecedingDocument");
                if( (value == null) || (!value.equals(getPrecedingDocument())) ) {
                    setPrecedingDocument(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocumentCategory") ) {
                final Object value = values.remove("PrecedingDocumentCategory");
                if( (value == null) || (!value.equals(getPrecedingDocumentCategory())) ) {
                    setPrecedingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocumentItem") ) {
                final Object value = values.remove("PrecedingDocumentItem");
                if( (value == null) || (!value.equals(getPrecedingDocumentItem())) ) {
                    setPrecedingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Subsequentdocument") ) {
                final Object value = values.remove("Subsequentdocument");
                if( (value == null) || (!value.equals(getSubsequentdocument())) ) {
                    setSubsequentdocument(((String) value));
                }
            }
            if( values.containsKey("QuantityInBaseUnit") ) {
                final Object value = values.remove("QuantityInBaseUnit");
                if( (value == null) || (!value.equals(getQuantityInBaseUnit())) ) {
                    setQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubsequentDocumentItem") ) {
                final Object value = values.remove("SubsequentDocumentItem");
                if( (value == null) || (!value.equals(getSubsequentDocumentItem())) ) {
                    setSubsequentDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SDFulfillmentCalculationRule") ) {
                final Object value = values.remove("SDFulfillmentCalculationRule");
                if( (value == null) || (!value.equals(getSDFulfillmentCalculationRule())) ) {
                    setSDFulfillmentCalculationRule(((String) value));
                }
            }
            if( values.containsKey("SubsequentDocumentCategory") ) {
                final Object value = values.remove("SubsequentDocumentCategory");
                if( (value == null) || (!value.equals(getSubsequentDocumentCategory())) ) {
                    setSubsequentDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("TransferOrderInWrhsMgmtIsConfd") ) {
                final Object value = values.remove("TransferOrderInWrhsMgmtIsConfd");
                if( (value == null) || (!value.equals(getTransferOrderInWrhsMgmtIsConfd())) ) {
                    setTransferOrderInWrhsMgmtIsConfd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OutbDeliveryDocFlowField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OutbDeliveryDocFlowField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OutbDeliveryDocFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OutbDeliveryDocFlowField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

}
