/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.selectable.OutbDeliveryPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryPartner OutbDeliveryPartner}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class OutbDeliveryPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<OutbDeliveryPartnerByKeyFluentHelper, OutbDeliveryPartner, OutbDeliveryPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryPartner
     * OutbDeliveryPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OutbDeliveryPartner}
     * @param partnerFunction
     *            Partner Functn
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OutbDeliveryPartner}
     * @param sDDocument
     *            SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public OutbDeliveryPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String partnerFunction,
        final String sDDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("PartnerFunction", partnerFunction);
        this.key.put("SDDocument", sDDocument);
    }

    @Override
    @Nonnull
    protected Class<OutbDeliveryPartner> getEntityClass()
    {
        return OutbDeliveryPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
