/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link OutboundDeliveryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService OutboundDeliveryService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultOutboundDeliveryServiceBatch
    extends
    BatchFluentHelperBasic<OutboundDeliveryServiceBatch, OutboundDeliveryServiceBatchChangeSet>
    implements
    OutboundDeliveryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultOutboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOutboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultOutboundDeliveryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOutboundDeliveryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultOutboundDeliveryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultOutboundDeliveryServiceBatchChangeSet(this, service);
    }

}
