/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem;

/**
 * Implementation of the {@link OutboundDeliveryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService OutboundDeliveryService}.
 *
 */
public class DefaultOutboundDeliveryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<OutboundDeliveryServiceBatch, OutboundDeliveryServiceBatchChangeSet>
    implements
    OutboundDeliveryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService service;

    @SuppressWarnings( "deprecation" )
    DefaultOutboundDeliveryServiceBatchChangeSet(
        @Nonnull final DefaultOutboundDeliveryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultOutboundDeliveryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet updateOutbDeliveryItem(
        @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return addRequestUpdate(service::updateOutbDeliveryItem, outbDeliveryItem);
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet deleteOutbDeliveryItem(
        @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return addRequestDelete(service::deleteOutbDeliveryItem, outbDeliveryItem);
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet createOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestCreate(service::createOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet updateOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestUpdate(service::updateOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet deleteOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestDelete(service::deleteOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryServiceBatchChangeSet updateOutbDeliveryDocFlow(
        @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateOutbDeliveryDocFlow, outbDeliveryDocFlow);
    }

}
