/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryService OutboundDeliveryService}.
 *
 */
public interface OutboundDeliveryServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<OutboundDeliveryServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<OutboundDeliveryServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem
     * OutbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem
     *            OutbDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet updateOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem
     * OutbDeliveryItem} entity in the S/4HANA system.
     *
     * @param outbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryItem
     *            OutbDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet deleteOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     * OutbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet
        createOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     * OutbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet
        updateOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     * OutbDeliveryHeader} entity in the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet
        deleteOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlow
     * OutbDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddelivery.OutbDeliveryDocFlow
     *            OutbDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryServiceBatchChangeSet
        updateOutbDeliveryDocFlow( @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow );

}
