/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>CreatedDeliveryItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreatedDeliveryItem extends VdmComplex<CreatedDeliveryItem>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *
     */
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;

    @Nonnull
    @Override
    public Class<CreatedDeliveryItem> getType()
    {
        return CreatedDeliveryItem.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            The deliveryDocument to set.
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            The deliveryDocumentItem to set.
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

}
