/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.HandlingUnitHeaderDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link.HandlingUnitHeaderDeliveryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.HandlingUnitHeaderDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Handling Unit Headers
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_HandlingUnitHeaderDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class HandlingUnitHeaderDelivery extends VdmEntity<HandlingUnitHeaderDelivery>
{

    /**
     * Selector for all available fields of HandlingUnitHeaderDelivery.
     *
     */
    public final static HandlingUnitHeaderDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> CREATED_BY_USER =
        new HandlingUnitHeaderDeliveryField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<LocalDateTime> CREATION_DATE =
        new HandlingUnitHeaderDeliveryField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<LocalTime> CREATION_TIME =
        new HandlingUnitHeaderDeliveryField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery Document
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> DELIVERY_DOCUMENT =
        new HandlingUnitHeaderDeliveryField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     *
     * @return Total Volume
     */
    @SerializedName( "GrossVolume" )
    @JsonProperty( "GrossVolume" )
    @Nullable
    @ODataField( odataName = "GrossVolume" )
    private BigDecimal grossVolume;
    /**
     * Use with available fluent helpers to apply the <b>GrossVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> GROSS_VOLUME =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("GrossVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @return Total Weight
     */
    @SerializedName( "GrossWeight" )
    @JsonProperty( "GrossWeight" )
    @Nullable
    @ODataField( odataName = "GrossWeight" )
    private BigDecimal grossWeight;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> GROSS_WEIGHT =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("GrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitBaseUnitOfMeasure</b>
     * </p>
     *
     * @return Base Unit
     */
    @SerializedName( "HandlingUnitBaseUnitOfMeasure" )
    @JsonProperty( "HandlingUnitBaseUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "HandlingUnitBaseUnitOfMeasure" )
    private String handlingUnitBaseUnitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitBaseUnitOfMeasure</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_BASE_UNIT_OF_MEASURE =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitBaseUnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitContentDescription</b>
     * </p>
     *
     * @return Content
     */
    @SerializedName( "HandlingUnitContentDescription" )
    @JsonProperty( "HandlingUnitContentDescription" )
    @Nullable
    @ODataField( odataName = "HandlingUnitContentDescription" )
    private String handlingUnitContentDescription;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitContentDescription</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_CONTENT_DESCRIPTION =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitContentDescription");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalId</b>
     * </p>
     *
     * @return Handling Unit
     */
    @SerializedName( "HandlingUnitExternalId" )
    @JsonProperty( "HandlingUnitExternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitExternalId" )
    private String handlingUnitExternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitExternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_EXTERNAL_ID =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitExternalId");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalIdType</b>
     * </p>
     *
     * @return ID Type
     */
    @SerializedName( "HandlingUnitExternalIdType" )
    @JsonProperty( "HandlingUnitExternalIdType" )
    @Nullable
    @ODataField( odataName = "HandlingUnitExternalIdType" )
    private String handlingUnitExternalIdType;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitExternalIdType</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_EXTERNAL_ID_TYPE =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitExternalIdType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @return Height
     */
    @SerializedName( "HandlingUnitHeight" )
    @JsonProperty( "HandlingUnitHeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitHeight" )
    private BigDecimal handlingUnitHeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitHeight</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_HEIGHT =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitHeight");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalId</b>
     * </p>
     *
     * @return Internal HU no.
     */
    @Key
    @SerializedName( "HandlingUnitInternalId" )
    @JsonProperty( "HandlingUnitInternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInternalId" )
    private String handlingUnitInternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_INTERNAL_ID =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitInternalId");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalStatus</b>
     * </p>
     *
     * @return HU status
     */
    @SerializedName( "HandlingUnitInternalStatus" )
    @JsonProperty( "HandlingUnitInternalStatus" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInternalStatus" )
    private String handlingUnitInternalStatus;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInternalStatus</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_INTERNAL_STATUS =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitInternalStatus");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @return Length
     */
    @SerializedName( "HandlingUnitLength" )
    @JsonProperty( "HandlingUnitLength" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLength" )
    private BigDecimal handlingUnitLength;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLength</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_LENGTH =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitLength");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLowerLevelRefer</b>
     * </p>
     *
     * @return Higher-level HU
     */
    @SerializedName( "HandlingUnitLowerLevelRefer" )
    @JsonProperty( "HandlingUnitLowerLevelRefer" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLowerLevelRefer" )
    private String handlingUnitLowerLevelRefer;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLowerLevelRefer</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_LOWER_LEVEL_REFER =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitLowerLevelRefer");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxVolume</b>
     * </p>
     *
     * @return Allowed volume
     */
    @SerializedName( "HandlingUnitMaxVolume" )
    @JsonProperty( "HandlingUnitMaxVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitMaxVolume" )
    private BigDecimal handlingUnitMaxVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitMaxVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_MAX_VOLUME =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitMaxVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     *
     * @return Allowed weight
     */
    @SerializedName( "HandlingUnitMaxWeight" )
    @JsonProperty( "HandlingUnitMaxWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitMaxWeight" )
    private BigDecimal handlingUnitMaxWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitMaxWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_MAX_WEIGHT =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitMaxWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     *
     * @return Loading Volume
     */
    @SerializedName( "HandlingUnitNetVolume" )
    @JsonProperty( "HandlingUnitNetVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNetVolume" )
    private BigDecimal handlingUnitNetVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNetVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_NET_VOLUME =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitNetVolume");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitSecondExternalId</b>
     * </p>
     *
     * @return HU ID 2
     */
    @SerializedName( "HandlingUnitSecondExternalId" )
    @JsonProperty( "HandlingUnitSecondExternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitSecondExternalId" )
    private String handlingUnitSecondExternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitSecondExternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_SECOND_EXTERNAL_ID =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitSecondExternalId");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @return Tare Volume
     */
    @SerializedName( "HandlingUnitTareVolume" )
    @JsonProperty( "HandlingUnitTareVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolume" )
    private BigDecimal handlingUnitTareVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolume</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_TARE_VOLUME =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitTareVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "HandlingUnitTareVolumeUnit" )
    @JsonProperty( "HandlingUnitTareVolumeUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolumeUnit" )
    private String handlingUnitTareVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolumeUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_TARE_VOLUME_UNIT =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitTareVolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @return Tare Weight
     */
    @SerializedName( "HandlingUnitTareWeight" )
    @JsonProperty( "HandlingUnitTareWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeight" )
    private BigDecimal handlingUnitTareWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_TARE_WEIGHT =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitTareWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "HandlingUnitTareWeightUnit" )
    @JsonProperty( "HandlingUnitTareWeightUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeightUnit" )
    private String handlingUnitTareWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeightUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_TARE_WEIGHT_UNIT =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitTareWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitUoMDimension</b>
     * </p>
     *
     * @return Unit
     */
    @SerializedName( "HandlingUnitUoMDimension" )
    @JsonProperty( "HandlingUnitUoMDimension" )
    @Nullable
    @ODataField( odataName = "HandlingUnitUoMDimension" )
    private String handlingUnitUoMDimension;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitUoMDimension</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> HANDLING_UNIT_UO_M_DIMENSION =
        new HandlingUnitHeaderDeliveryField<String>("HandlingUnitUoMDimension");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @return Width
     */
    @SerializedName( "HandlingUnitWidth" )
    @JsonProperty( "HandlingUnitWidth" )
    @Nullable
    @ODataField( odataName = "HandlingUnitWidth" )
    private BigDecimal handlingUnitWidth;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitWidth</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> HANDLING_UNIT_WIDTH =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("HandlingUnitWidth");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<LocalDateTime> LAST_CHANGE_DATE =
        new HandlingUnitHeaderDeliveryField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> LAST_CHANGED_BY_USER =
        new HandlingUnitHeaderDeliveryField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time of change
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<LocalTime> LAST_CHANGE_TIME =
        new HandlingUnitHeaderDeliveryField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @return Loading Weight
     */
    @SerializedName( "NetWeight" )
    @JsonProperty( "NetWeight" )
    @Nullable
    @ODataField( odataName = "NetWeight" )
    private BigDecimal netWeight;
    /**
     * Use with available fluent helpers to apply the <b>NetWeight</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<BigDecimal> NET_WEIGHT =
        new HandlingUnitHeaderDeliveryField<BigDecimal>("NetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @return PackMaterials
     */
    @SerializedName( "PackagingMaterial" )
    @JsonProperty( "PackagingMaterial" )
    @Nullable
    @ODataField( odataName = "PackagingMaterial" )
    private String packagingMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterial</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> PACKAGING_MATERIAL =
        new HandlingUnitHeaderDeliveryField<String>("PackagingMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialCategory</b>
     * </p>
     *
     * @return Pack. Mat. Cat.
     */
    @SerializedName( "PackagingMaterialCategory" )
    @JsonProperty( "PackagingMaterialCategory" )
    @Nullable
    @ODataField( odataName = "PackagingMaterialCategory" )
    private String packagingMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterialCategory</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> PACKAGING_MATERIAL_CATEGORY =
        new HandlingUnitHeaderDeliveryField<String>("PackagingMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialGroup</b>
     * </p>
     *
     * @return Matl Grp Pckmat
     */
    @SerializedName( "PackagingMaterialGroup" )
    @JsonProperty( "PackagingMaterialGroup" )
    @Nullable
    @ODataField( odataName = "PackagingMaterialGroup" )
    private String packagingMaterialGroup;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterialGroup</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> PACKAGING_MATERIAL_GROUP =
        new HandlingUnitHeaderDeliveryField<String>("PackagingMaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     *
     * @return Packag.Mat.Type
     */
    @SerializedName( "PackagingMaterialType" )
    @JsonProperty( "PackagingMaterialType" )
    @Nullable
    @ODataField( odataName = "PackagingMaterialType" )
    private String packagingMaterialType;
    /**
     * Use with available fluent helpers to apply the <b>PackagingMaterialType</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> PACKAGING_MATERIAL_TYPE =
        new HandlingUnitHeaderDeliveryField<String>("PackagingMaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionNumber</b>
     * </p>
     *
     * @return Packing object
     */
    @SerializedName( "PackingInstructionNumber" )
    @JsonProperty( "PackingInstructionNumber" )
    @Nullable
    @ODataField( odataName = "PackingInstructionNumber" )
    private String packingInstructionNumber;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionNumber</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> PACKING_INSTRUCTION_NUMBER =
        new HandlingUnitHeaderDeliveryField<String>("PackingInstructionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> SHIPPING_POINT =
        new HandlingUnitHeaderDeliveryField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> VOLUME_UNIT =
        new HandlingUnitHeaderDeliveryField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "WeightUnit" )
    @JsonProperty( "WeightUnit" )
    @Nullable
    @ODataField( odataName = "WeightUnit" )
    private String weightUnit;
    /**
     * Use with available fluent helpers to apply the <b>WeightUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryField<String> WEIGHT_UNIT =
        new HandlingUnitHeaderDeliveryField<String>("WeightUnit");
    /**
     * Navigation property <b>to_HandlingUnitItemDelivery</b> for <b>HandlingUnitHeaderDelivery</b> to multiple
     * <b>HandlingUnitItemDelivery</b>.
     *
     */
    @SerializedName( "to_HandlingUnitItemDelivery" )
    @JsonProperty( "to_HandlingUnitItemDelivery" )
    @ODataField( odataName = "to_HandlingUnitItemDelivery" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<HandlingUnitItemDelivery> toHandlingUnitItemDelivery;
    /**
     * Use with available fluent helpers to apply the <b>to_HandlingUnitItemDelivery</b> navigation property to query
     * operations.
     *
     */
    public final static HandlingUnitHeaderDeliveryLink<HandlingUnitItemDelivery> TO_HANDLING_UNIT_ITEM_DELIVERY =
        new HandlingUnitHeaderDeliveryLink<HandlingUnitItemDelivery>("to_HandlingUnitItemDelivery");

    @Nonnull
    @Override
    public Class<HandlingUnitHeaderDelivery> getType()
    {
        return HandlingUnitHeaderDelivery.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery Document
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     *
     * @param grossVolume
     *            Total Volume
     */
    public void setGrossVolume( @Nullable final BigDecimal grossVolume )
    {
        rememberChangedField("GrossVolume", this.grossVolume);
        this.grossVolume = grossVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @param grossWeight
     *            Total Weight
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitBaseUnitOfMeasure</b>
     * </p>
     *
     * @param handlingUnitBaseUnitOfMeasure
     *            Base Unit
     */
    public void setHandlingUnitBaseUnitOfMeasure( @Nullable final String handlingUnitBaseUnitOfMeasure )
    {
        rememberChangedField("HandlingUnitBaseUnitOfMeasure", this.handlingUnitBaseUnitOfMeasure);
        this.handlingUnitBaseUnitOfMeasure = handlingUnitBaseUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitContentDescription</b>
     * </p>
     *
     * @param handlingUnitContentDescription
     *            Content
     */
    public void setHandlingUnitContentDescription( @Nullable final String handlingUnitContentDescription )
    {
        rememberChangedField("HandlingUnitContentDescription", this.handlingUnitContentDescription);
        this.handlingUnitContentDescription = handlingUnitContentDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalId</b>
     * </p>
     *
     * @param handlingUnitExternalId
     *            Handling Unit
     */
    public void setHandlingUnitExternalId( @Nullable final String handlingUnitExternalId )
    {
        rememberChangedField("HandlingUnitExternalId", this.handlingUnitExternalId);
        this.handlingUnitExternalId = handlingUnitExternalId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalIdType</b>
     * </p>
     *
     * @param handlingUnitExternalIdType
     *            ID Type
     */
    public void setHandlingUnitExternalIdType( @Nullable final String handlingUnitExternalIdType )
    {
        rememberChangedField("HandlingUnitExternalIdType", this.handlingUnitExternalIdType);
        this.handlingUnitExternalIdType = handlingUnitExternalIdType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @param handlingUnitHeight
     *            Height
     */
    public void setHandlingUnitHeight( @Nullable final BigDecimal handlingUnitHeight )
    {
        rememberChangedField("HandlingUnitHeight", this.handlingUnitHeight);
        this.handlingUnitHeight = handlingUnitHeight;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalId</b>
     * </p>
     *
     * @param handlingUnitInternalId
     *            Internal HU no.
     */
    public void setHandlingUnitInternalId( @Nullable final String handlingUnitInternalId )
    {
        rememberChangedField("HandlingUnitInternalId", this.handlingUnitInternalId);
        this.handlingUnitInternalId = handlingUnitInternalId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalStatus</b>
     * </p>
     *
     * @param handlingUnitInternalStatus
     *            HU status
     */
    public void setHandlingUnitInternalStatus( @Nullable final String handlingUnitInternalStatus )
    {
        rememberChangedField("HandlingUnitInternalStatus", this.handlingUnitInternalStatus);
        this.handlingUnitInternalStatus = handlingUnitInternalStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @param handlingUnitLength
     *            Length
     */
    public void setHandlingUnitLength( @Nullable final BigDecimal handlingUnitLength )
    {
        rememberChangedField("HandlingUnitLength", this.handlingUnitLength);
        this.handlingUnitLength = handlingUnitLength;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLowerLevelRefer</b>
     * </p>
     *
     * @param handlingUnitLowerLevelRefer
     *            Higher-level HU
     */
    public void setHandlingUnitLowerLevelRefer( @Nullable final String handlingUnitLowerLevelRefer )
    {
        rememberChangedField("HandlingUnitLowerLevelRefer", this.handlingUnitLowerLevelRefer);
        this.handlingUnitLowerLevelRefer = handlingUnitLowerLevelRefer;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxVolume</b>
     * </p>
     *
     * @param handlingUnitMaxVolume
     *            Allowed volume
     */
    public void setHandlingUnitMaxVolume( @Nullable final BigDecimal handlingUnitMaxVolume )
    {
        rememberChangedField("HandlingUnitMaxVolume", this.handlingUnitMaxVolume);
        this.handlingUnitMaxVolume = handlingUnitMaxVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     *
     * @param handlingUnitMaxWeight
     *            Allowed weight
     */
    public void setHandlingUnitMaxWeight( @Nullable final BigDecimal handlingUnitMaxWeight )
    {
        rememberChangedField("HandlingUnitMaxWeight", this.handlingUnitMaxWeight);
        this.handlingUnitMaxWeight = handlingUnitMaxWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     *
     * @param handlingUnitNetVolume
     *            Loading Volume
     */
    public void setHandlingUnitNetVolume( @Nullable final BigDecimal handlingUnitNetVolume )
    {
        rememberChangedField("HandlingUnitNetVolume", this.handlingUnitNetVolume);
        this.handlingUnitNetVolume = handlingUnitNetVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitSecondExternalId</b>
     * </p>
     *
     * @param handlingUnitSecondExternalId
     *            HU ID 2
     */
    public void setHandlingUnitSecondExternalId( @Nullable final String handlingUnitSecondExternalId )
    {
        rememberChangedField("HandlingUnitSecondExternalId", this.handlingUnitSecondExternalId);
        this.handlingUnitSecondExternalId = handlingUnitSecondExternalId;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @param handlingUnitTareVolume
     *            Tare Volume
     */
    public void setHandlingUnitTareVolume( @Nullable final BigDecimal handlingUnitTareVolume )
    {
        rememberChangedField("HandlingUnitTareVolume", this.handlingUnitTareVolume);
        this.handlingUnitTareVolume = handlingUnitTareVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @param handlingUnitTareVolumeUnit
     *            Volume Unit
     */
    public void setHandlingUnitTareVolumeUnit( @Nullable final String handlingUnitTareVolumeUnit )
    {
        rememberChangedField("HandlingUnitTareVolumeUnit", this.handlingUnitTareVolumeUnit);
        this.handlingUnitTareVolumeUnit = handlingUnitTareVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @param handlingUnitTareWeight
     *            Tare Weight
     */
    public void setHandlingUnitTareWeight( @Nullable final BigDecimal handlingUnitTareWeight )
    {
        rememberChangedField("HandlingUnitTareWeight", this.handlingUnitTareWeight);
        this.handlingUnitTareWeight = handlingUnitTareWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @param handlingUnitTareWeightUnit
     *            Unit of Weight
     */
    public void setHandlingUnitTareWeightUnit( @Nullable final String handlingUnitTareWeightUnit )
    {
        rememberChangedField("HandlingUnitTareWeightUnit", this.handlingUnitTareWeightUnit);
        this.handlingUnitTareWeightUnit = handlingUnitTareWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitUoMDimension</b>
     * </p>
     *
     * @param handlingUnitUoMDimension
     *            Unit
     */
    public void setHandlingUnitUoMDimension( @Nullable final String handlingUnitUoMDimension )
    {
        rememberChangedField("HandlingUnitUoMDimension", this.handlingUnitUoMDimension);
        this.handlingUnitUoMDimension = handlingUnitUoMDimension;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @param handlingUnitWidth
     *            Width
     */
    public void setHandlingUnitWidth( @Nullable final BigDecimal handlingUnitWidth )
    {
        rememberChangedField("HandlingUnitWidth", this.handlingUnitWidth);
        this.handlingUnitWidth = handlingUnitWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time of change
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @param netWeight
     *            Loading Weight
     */
    public void setNetWeight( @Nullable final BigDecimal netWeight )
    {
        rememberChangedField("NetWeight", this.netWeight);
        this.netWeight = netWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     *
     * @param packagingMaterial
     *            PackMaterials
     */
    public void setPackagingMaterial( @Nullable final String packagingMaterial )
    {
        rememberChangedField("PackagingMaterial", this.packagingMaterial);
        this.packagingMaterial = packagingMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialCategory</b>
     * </p>
     *
     * @param packagingMaterialCategory
     *            Pack. Mat. Cat.
     */
    public void setPackagingMaterialCategory( @Nullable final String packagingMaterialCategory )
    {
        rememberChangedField("PackagingMaterialCategory", this.packagingMaterialCategory);
        this.packagingMaterialCategory = packagingMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialGroup</b>
     * </p>
     *
     * @param packagingMaterialGroup
     *            Matl Grp Pckmat
     */
    public void setPackagingMaterialGroup( @Nullable final String packagingMaterialGroup )
    {
        rememberChangedField("PackagingMaterialGroup", this.packagingMaterialGroup);
        this.packagingMaterialGroup = packagingMaterialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     *
     * @param packagingMaterialType
     *            Packag.Mat.Type
     */
    public void setPackagingMaterialType( @Nullable final String packagingMaterialType )
    {
        rememberChangedField("PackagingMaterialType", this.packagingMaterialType);
        this.packagingMaterialType = packagingMaterialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionNumber</b>
     * </p>
     *
     * @param packingInstructionNumber
     *            Packing object
     */
    public void setPackingInstructionNumber( @Nullable final String packingInstructionNumber )
    {
        rememberChangedField("PackingInstructionNumber", this.packingInstructionNumber);
        this.packingInstructionNumber = packingInstructionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @param weightUnit
     *            Unit of Weight
     */
    public void setWeightUnit( @Nullable final String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_HandlingUnitHeaderDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("HandlingUnitInternalId", getHandlingUnitInternalId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("GrossVolume", getGrossVolume());
        values.put("GrossWeight", getGrossWeight());
        values.put("HandlingUnitBaseUnitOfMeasure", getHandlingUnitBaseUnitOfMeasure());
        values.put("HandlingUnitContentDescription", getHandlingUnitContentDescription());
        values.put("HandlingUnitExternalId", getHandlingUnitExternalId());
        values.put("HandlingUnitExternalIdType", getHandlingUnitExternalIdType());
        values.put("HandlingUnitHeight", getHandlingUnitHeight());
        values.put("HandlingUnitInternalId", getHandlingUnitInternalId());
        values.put("HandlingUnitInternalStatus", getHandlingUnitInternalStatus());
        values.put("HandlingUnitLength", getHandlingUnitLength());
        values.put("HandlingUnitLowerLevelRefer", getHandlingUnitLowerLevelRefer());
        values.put("HandlingUnitMaxVolume", getHandlingUnitMaxVolume());
        values.put("HandlingUnitMaxWeight", getHandlingUnitMaxWeight());
        values.put("HandlingUnitNetVolume", getHandlingUnitNetVolume());
        values.put("HandlingUnitSecondExternalId", getHandlingUnitSecondExternalId());
        values.put("HandlingUnitTareVolume", getHandlingUnitTareVolume());
        values.put("HandlingUnitTareVolumeUnit", getHandlingUnitTareVolumeUnit());
        values.put("HandlingUnitTareWeight", getHandlingUnitTareWeight());
        values.put("HandlingUnitTareWeightUnit", getHandlingUnitTareWeightUnit());
        values.put("HandlingUnitUoMDimension", getHandlingUnitUoMDimension());
        values.put("HandlingUnitWidth", getHandlingUnitWidth());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("NetWeight", getNetWeight());
        values.put("PackagingMaterial", getPackagingMaterial());
        values.put("PackagingMaterialCategory", getPackagingMaterialCategory());
        values.put("PackagingMaterialGroup", getPackagingMaterialGroup());
        values.put("PackagingMaterialType", getPackagingMaterialType());
        values.put("PackingInstructionNumber", getPackingInstructionNumber());
        values.put("ShippingPoint", getShippingPoint());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("WeightUnit", getWeightUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("GrossVolume") ) {
                final Object value = values.remove("GrossVolume");
                if( (value == null) || (!value.equals(getGrossVolume())) ) {
                    setGrossVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitBaseUnitOfMeasure") ) {
                final Object value = values.remove("HandlingUnitBaseUnitOfMeasure");
                if( (value == null) || (!value.equals(getHandlingUnitBaseUnitOfMeasure())) ) {
                    setHandlingUnitBaseUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitContentDescription") ) {
                final Object value = values.remove("HandlingUnitContentDescription");
                if( (value == null) || (!value.equals(getHandlingUnitContentDescription())) ) {
                    setHandlingUnitContentDescription(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitExternalId") ) {
                final Object value = values.remove("HandlingUnitExternalId");
                if( (value == null) || (!value.equals(getHandlingUnitExternalId())) ) {
                    setHandlingUnitExternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitExternalIdType") ) {
                final Object value = values.remove("HandlingUnitExternalIdType");
                if( (value == null) || (!value.equals(getHandlingUnitExternalIdType())) ) {
                    setHandlingUnitExternalIdType(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitHeight") ) {
                final Object value = values.remove("HandlingUnitHeight");
                if( (value == null) || (!value.equals(getHandlingUnitHeight())) ) {
                    setHandlingUnitHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitInternalId") ) {
                final Object value = values.remove("HandlingUnitInternalId");
                if( (value == null) || (!value.equals(getHandlingUnitInternalId())) ) {
                    setHandlingUnitInternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitInternalStatus") ) {
                final Object value = values.remove("HandlingUnitInternalStatus");
                if( (value == null) || (!value.equals(getHandlingUnitInternalStatus())) ) {
                    setHandlingUnitInternalStatus(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitLength") ) {
                final Object value = values.remove("HandlingUnitLength");
                if( (value == null) || (!value.equals(getHandlingUnitLength())) ) {
                    setHandlingUnitLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitLowerLevelRefer") ) {
                final Object value = values.remove("HandlingUnitLowerLevelRefer");
                if( (value == null) || (!value.equals(getHandlingUnitLowerLevelRefer())) ) {
                    setHandlingUnitLowerLevelRefer(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitMaxVolume") ) {
                final Object value = values.remove("HandlingUnitMaxVolume");
                if( (value == null) || (!value.equals(getHandlingUnitMaxVolume())) ) {
                    setHandlingUnitMaxVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitMaxWeight") ) {
                final Object value = values.remove("HandlingUnitMaxWeight");
                if( (value == null) || (!value.equals(getHandlingUnitMaxWeight())) ) {
                    setHandlingUnitMaxWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitNetVolume") ) {
                final Object value = values.remove("HandlingUnitNetVolume");
                if( (value == null) || (!value.equals(getHandlingUnitNetVolume())) ) {
                    setHandlingUnitNetVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitSecondExternalId") ) {
                final Object value = values.remove("HandlingUnitSecondExternalId");
                if( (value == null) || (!value.equals(getHandlingUnitSecondExternalId())) ) {
                    setHandlingUnitSecondExternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolume") ) {
                final Object value = values.remove("HandlingUnitTareVolume");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolume())) ) {
                    setHandlingUnitTareVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolumeUnit") ) {
                final Object value = values.remove("HandlingUnitTareVolumeUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolumeUnit())) ) {
                    setHandlingUnitTareVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeight") ) {
                final Object value = values.remove("HandlingUnitTareWeight");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeight())) ) {
                    setHandlingUnitTareWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeightUnit") ) {
                final Object value = values.remove("HandlingUnitTareWeightUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeightUnit())) ) {
                    setHandlingUnitTareWeightUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitUoMDimension") ) {
                final Object value = values.remove("HandlingUnitUoMDimension");
                if( (value == null) || (!value.equals(getHandlingUnitUoMDimension())) ) {
                    setHandlingUnitUoMDimension(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitWidth") ) {
                final Object value = values.remove("HandlingUnitWidth");
                if( (value == null) || (!value.equals(getHandlingUnitWidth())) ) {
                    setHandlingUnitWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("NetWeight") ) {
                final Object value = values.remove("NetWeight");
                if( (value == null) || (!value.equals(getNetWeight())) ) {
                    setNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("PackagingMaterial") ) {
                final Object value = values.remove("PackagingMaterial");
                if( (value == null) || (!value.equals(getPackagingMaterial())) ) {
                    setPackagingMaterial(((String) value));
                }
            }
            if( values.containsKey("PackagingMaterialCategory") ) {
                final Object value = values.remove("PackagingMaterialCategory");
                if( (value == null) || (!value.equals(getPackagingMaterialCategory())) ) {
                    setPackagingMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("PackagingMaterialGroup") ) {
                final Object value = values.remove("PackagingMaterialGroup");
                if( (value == null) || (!value.equals(getPackagingMaterialGroup())) ) {
                    setPackagingMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PackagingMaterialType") ) {
                final Object value = values.remove("PackagingMaterialType");
                if( (value == null) || (!value.equals(getPackagingMaterialType())) ) {
                    setPackagingMaterialType(((String) value));
                }
            }
            if( values.containsKey("PackingInstructionNumber") ) {
                final Object value = values.remove("PackingInstructionNumber");
                if( (value == null) || (!value.equals(getPackingInstructionNumber())) ) {
                    setPackingInstructionNumber(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_HandlingUnitItemDelivery") ) {
                final Object value = (values).remove("to_HandlingUnitItemDelivery");
                if( value instanceof Iterable ) {
                    if( toHandlingUnitItemDelivery == null ) {
                        toHandlingUnitItemDelivery = Lists.newArrayList();
                    } else {
                        toHandlingUnitItemDelivery = Lists.newArrayList(toHandlingUnitItemDelivery);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        HandlingUnitItemDelivery entity;
                        if( toHandlingUnitItemDelivery.size() > i ) {
                            entity = toHandlingUnitItemDelivery.get(i);
                        } else {
                            entity = new HandlingUnitItemDelivery();
                            toHandlingUnitItemDelivery.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> HandlingUnitHeaderDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new HandlingUnitHeaderDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> HandlingUnitHeaderDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new HandlingUnitHeaderDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toHandlingUnitItemDelivery != null ) {
            (values).put("to_HandlingUnitItemDelivery", toHandlingUnitItemDelivery);
        }
        return values;
    }

    /**
     * Fetches the <b>HandlingUnitItemDelivery</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_HandlingUnitItemDelivery</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>HandlingUnitItemDelivery</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<HandlingUnitItemDelivery> fetchHandlingUnitItemDelivery()
    {
        return fetchFieldAsList("to_HandlingUnitItemDelivery", HandlingUnitItemDelivery.class);
    }

    /**
     * Retrieval of associated <b>HandlingUnitItemDelivery</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_HandlingUnitItemDelivery</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItemDelivery</b> of a queried <b>HandlingUnitHeaderDelivery</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>HandlingUnitItemDelivery</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<HandlingUnitItemDelivery> getHandlingUnitItemDeliveryOrFetch()
    {
        if( toHandlingUnitItemDelivery == null ) {
            toHandlingUnitItemDelivery = fetchHandlingUnitItemDelivery();
        }
        return toHandlingUnitItemDelivery;
    }

    /**
     * Retrieval of associated <b>HandlingUnitItemDelivery</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_HandlingUnitItemDelivery</b>.
     * <p>
     * If the navigation property for an entity <b>HandlingUnitHeaderDelivery</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_HandlingUnitItemDelivery</b> is already loaded, the
     *         result will contain the <b>HandlingUnitItemDelivery</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<HandlingUnitItemDelivery>> getHandlingUnitItemDeliveryIfPresent()
    {
        return Option.of(toHandlingUnitItemDelivery);
    }

    /**
     * Overwrites the list of associated <b>HandlingUnitItemDelivery</b> entities for the loaded navigation property
     * <b>to_HandlingUnitItemDelivery</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItemDelivery</b> of a queried <b>HandlingUnitHeaderDelivery</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>HandlingUnitItemDelivery</b> entities.
     */
    public void setHandlingUnitItemDelivery( @Nonnull final List<HandlingUnitItemDelivery> value )
    {
        if( toHandlingUnitItemDelivery == null ) {
            toHandlingUnitItemDelivery = Lists.newArrayList();
        }
        toHandlingUnitItemDelivery.clear();
        toHandlingUnitItemDelivery.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>HandlingUnitItemDelivery</b> entities. This corresponds to the OData
     * navigation property <b>to_HandlingUnitItemDelivery</b>.
     * <p>
     * If the navigation property <b>to_HandlingUnitItemDelivery</b> of a queried <b>HandlingUnitHeaderDelivery</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>HandlingUnitItemDelivery</b> entities.
     */
    public void addHandlingUnitItemDelivery( HandlingUnitItemDelivery... entity )
    {
        if( toHandlingUnitItemDelivery == null ) {
            toHandlingUnitItemDelivery = Lists.newArrayList();
        }
        toHandlingUnitItemDelivery.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of HandlingUnitHeaderDelivery instances.
     *
     */
    public final static class HandlingUnitHeaderDeliveryBuilder
    {

        private List<HandlingUnitItemDelivery> toHandlingUnitItemDelivery = Lists.newArrayList();

        private HandlingUnitHeaderDelivery.HandlingUnitHeaderDeliveryBuilder toHandlingUnitItemDelivery(
            final List<HandlingUnitItemDelivery> value )
        {
            toHandlingUnitItemDelivery.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_HandlingUnitItemDelivery</b> for <b>HandlingUnitHeaderDelivery</b> to multiple
         * <b>HandlingUnitItemDelivery</b>.
         *
         * @param value
         *            The HandlingUnitItemDeliverys to build this HandlingUnitHeaderDelivery with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public HandlingUnitHeaderDelivery.HandlingUnitHeaderDeliveryBuilder handlingUnitItemDelivery(
            HandlingUnitItemDelivery... value )
        {
            return toHandlingUnitItemDelivery(Lists.newArrayList(value));
        }

    }

}
