/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.HandlingUnitItemDeliveryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.HandlingUnitItemDeliverySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Handling Unit Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_HandlingUnitItemDeliveryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class HandlingUnitItemDelivery extends VdmEntity<HandlingUnitItemDelivery>
{

    /**
     * Selector for all available fields of HandlingUnitItemDelivery.
     *
     */
    public final static HandlingUnitItemDeliverySelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> BATCH =
        new HandlingUnitItemDeliveryField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> DELIVERY_DOCUMENT =
        new HandlingUnitItemDeliveryField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "DeliveryDocumentItem" )
    @JsonProperty( "DeliveryDocumentItem" )
    @Nullable
    @ODataField( odataName = "DeliveryDocumentItem" )
    private String deliveryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocumentItem</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> DELIVERY_DOCUMENT_ITEM =
        new HandlingUnitItemDeliveryField<String>("DeliveryDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalId</b>
     * </p>
     *
     * @return Handling Unit
     */
    @SerializedName( "HandlingUnitExternalId" )
    @JsonProperty( "HandlingUnitExternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitExternalId" )
    private String handlingUnitExternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitExternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_EXTERNAL_ID =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitExternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalId</b>
     * </p>
     *
     * @return Internal HU no.
     */
    @Key
    @SerializedName( "HandlingUnitInternalId" )
    @JsonProperty( "HandlingUnitInternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInternalId" )
    private String handlingUnitInternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_INTERNAL_ID =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     *
     * @return HU item
     */
    @Key
    @SerializedName( "HandlingUnitItem" )
    @JsonProperty( "HandlingUnitItem" )
    @Nullable
    @ODataField( odataName = "HandlingUnitItem" )
    private String handlingUnitItem;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitItem</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_ITEM =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNestedInternalId</b>
     * </p>
     *
     * @return Lower-level HU
     */
    @SerializedName( "HandlingUnitNestedInternalId" )
    @JsonProperty( "HandlingUnitNestedInternalId" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNestedInternalId" )
    private String handlingUnitNestedInternalId;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNestedInternalId</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_NESTED_INTERNAL_ID =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitNestedInternalId");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNrOfAuxPackgMat</b>
     * </p>
     *
     * @return No.AuxPckgMatls
     */
    @SerializedName( "HandlingUnitNrOfAuxPackgMat" )
    @JsonProperty( "HandlingUnitNrOfAuxPackgMat" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNrOfAuxPackgMat" )
    private Integer handlingUnitNrOfAuxPackgMat;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNrOfAuxPackgMat</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<Integer> HANDLING_UNIT_NR_OF_AUX_PACKG_MAT =
        new HandlingUnitItemDeliveryField<Integer>("HandlingUnitNrOfAuxPackgMat");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNumberOfSerialnumb</b>
     * </p>
     *
     * @return No.serial no.
     */
    @SerializedName( "HandlingUnitNumberOfSerialnumb" )
    @JsonProperty( "HandlingUnitNumberOfSerialnumb" )
    @Nullable
    @ODataField( odataName = "HandlingUnitNumberOfSerialnumb" )
    private Integer handlingUnitNumberOfSerialnumb;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitNumberOfSerialnumb</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<Integer> HANDLING_UNIT_NUMBER_OF_SERIALNUMB =
        new HandlingUnitItemDeliveryField<Integer>("HandlingUnitNumberOfSerialnumb");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     *
     * @return Packed Quantity
     */
    @SerializedName( "HandlingUnitQuantity" )
    @JsonProperty( "HandlingUnitQuantity" )
    @Nullable
    @ODataField( odataName = "HandlingUnitQuantity" )
    private BigDecimal handlingUnitQuantity;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitQuantity</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<BigDecimal> HANDLING_UNIT_QUANTITY =
        new HandlingUnitItemDeliveryField<BigDecimal>("HandlingUnitQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     *
     * @return UoM of HU item
     */
    @SerializedName( "HandlingUnitQuantityUnit" )
    @JsonProperty( "HandlingUnitQuantityUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitQuantityUnit" )
    private String handlingUnitQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitQuantityUnit</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_QUANTITY_UNIT =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTypeOfContent</b>
     * </p>
     *
     * @return Item type
     */
    @SerializedName( "HandlingUnitTypeOfContent" )
    @JsonProperty( "HandlingUnitTypeOfContent" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTypeOfContent" )
    private String handlingUnitTypeOfContent;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTypeOfContent</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> HANDLING_UNIT_TYPE_OF_CONTENT =
        new HandlingUnitItemDeliveryField<String>("HandlingUnitTypeOfContent");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> MATERIAL =
        new HandlingUnitItemDeliveryField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Partner mat.
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> MATERIAL_BY_CUSTOMER =
        new HandlingUnitItemDeliveryField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> MATERIAL_NAME =
        new HandlingUnitItemDeliveryField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @return SerialNoProfile
     */
    @SerializedName( "SerialNumberProfile" )
    @JsonProperty( "SerialNumberProfile" )
    @Nullable
    @ODataField( odataName = "SerialNumberProfile" )
    private String serialNumberProfile;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberProfile</b> field to query operations.
     *
     */
    public final static HandlingUnitItemDeliveryField<String> SERIAL_NUMBER_PROFILE =
        new HandlingUnitItemDeliveryField<String>("SerialNumberProfile");

    @Nonnull
    @Override
    public Class<HandlingUnitItemDelivery> getType()
    {
        return HandlingUnitItemDelivery.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocumentItem</b>
     * </p>
     *
     * @param deliveryDocumentItem
     *            Item
     */
    public void setDeliveryDocumentItem( @Nullable final String deliveryDocumentItem )
    {
        rememberChangedField("DeliveryDocumentItem", this.deliveryDocumentItem);
        this.deliveryDocumentItem = deliveryDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalId</b>
     * </p>
     *
     * @param handlingUnitExternalId
     *            Handling Unit
     */
    public void setHandlingUnitExternalId( @Nullable final String handlingUnitExternalId )
    {
        rememberChangedField("HandlingUnitExternalId", this.handlingUnitExternalId);
        this.handlingUnitExternalId = handlingUnitExternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalId</b>
     * </p>
     *
     * @param handlingUnitInternalId
     *            Internal HU no.
     */
    public void setHandlingUnitInternalId( @Nullable final String handlingUnitInternalId )
    {
        rememberChangedField("HandlingUnitInternalId", this.handlingUnitInternalId);
        this.handlingUnitInternalId = handlingUnitInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     *
     * @param handlingUnitItem
     *            HU item
     */
    public void setHandlingUnitItem( @Nullable final String handlingUnitItem )
    {
        rememberChangedField("HandlingUnitItem", this.handlingUnitItem);
        this.handlingUnitItem = handlingUnitItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNestedInternalId</b>
     * </p>
     *
     * @param handlingUnitNestedInternalId
     *            Lower-level HU
     */
    public void setHandlingUnitNestedInternalId( @Nullable final String handlingUnitNestedInternalId )
    {
        rememberChangedField("HandlingUnitNestedInternalId", this.handlingUnitNestedInternalId);
        this.handlingUnitNestedInternalId = handlingUnitNestedInternalId;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNrOfAuxPackgMat</b>
     * </p>
     *
     * @param handlingUnitNrOfAuxPackgMat
     *            No.AuxPckgMatls
     */
    public void setHandlingUnitNrOfAuxPackgMat( @Nullable final Integer handlingUnitNrOfAuxPackgMat )
    {
        rememberChangedField("HandlingUnitNrOfAuxPackgMat", this.handlingUnitNrOfAuxPackgMat);
        this.handlingUnitNrOfAuxPackgMat = handlingUnitNrOfAuxPackgMat;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNumberOfSerialnumb</b>
     * </p>
     *
     * @param handlingUnitNumberOfSerialnumb
     *            No.serial no.
     */
    public void setHandlingUnitNumberOfSerialnumb( @Nullable final Integer handlingUnitNumberOfSerialnumb )
    {
        rememberChangedField("HandlingUnitNumberOfSerialnumb", this.handlingUnitNumberOfSerialnumb);
        this.handlingUnitNumberOfSerialnumb = handlingUnitNumberOfSerialnumb;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     *
     * @param handlingUnitQuantity
     *            Packed Quantity
     */
    public void setHandlingUnitQuantity( @Nullable final BigDecimal handlingUnitQuantity )
    {
        rememberChangedField("HandlingUnitQuantity", this.handlingUnitQuantity);
        this.handlingUnitQuantity = handlingUnitQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     *
     * @param handlingUnitQuantityUnit
     *            UoM of HU item
     */
    public void setHandlingUnitQuantityUnit( @Nullable final String handlingUnitQuantityUnit )
    {
        rememberChangedField("HandlingUnitQuantityUnit", this.handlingUnitQuantityUnit);
        this.handlingUnitQuantityUnit = handlingUnitQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTypeOfContent</b>
     * </p>
     *
     * @param handlingUnitTypeOfContent
     *            Item type
     */
    public void setHandlingUnitTypeOfContent( @Nullable final String handlingUnitTypeOfContent )
    {
        rememberChangedField("HandlingUnitTypeOfContent", this.handlingUnitTypeOfContent);
        this.handlingUnitTypeOfContent = handlingUnitTypeOfContent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Partner mat.
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberProfile</b>
     * </p>
     *
     * @param serialNumberProfile
     *            SerialNoProfile
     */
    public void setSerialNumberProfile( @Nullable final String serialNumberProfile )
    {
        rememberChangedField("SerialNumberProfile", this.serialNumberProfile);
        this.serialNumberProfile = serialNumberProfile;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_HandlingUnitItemDelivery";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("HandlingUnitInternalId", getHandlingUnitInternalId());
        result.put("HandlingUnitItem", getHandlingUnitItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Batch", getBatch());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("DeliveryDocumentItem", getDeliveryDocumentItem());
        values.put("HandlingUnitExternalId", getHandlingUnitExternalId());
        values.put("HandlingUnitInternalId", getHandlingUnitInternalId());
        values.put("HandlingUnitItem", getHandlingUnitItem());
        values.put("HandlingUnitNestedInternalId", getHandlingUnitNestedInternalId());
        values.put("HandlingUnitNrOfAuxPackgMat", getHandlingUnitNrOfAuxPackgMat());
        values.put("HandlingUnitNumberOfSerialnumb", getHandlingUnitNumberOfSerialnumb());
        values.put("HandlingUnitQuantity", getHandlingUnitQuantity());
        values.put("HandlingUnitQuantityUnit", getHandlingUnitQuantityUnit());
        values.put("HandlingUnitTypeOfContent", getHandlingUnitTypeOfContent());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("MaterialName", getMaterialName());
        values.put("SerialNumberProfile", getSerialNumberProfile());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocumentItem") ) {
                final Object value = values.remove("DeliveryDocumentItem");
                if( (value == null) || (!value.equals(getDeliveryDocumentItem())) ) {
                    setDeliveryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitExternalId") ) {
                final Object value = values.remove("HandlingUnitExternalId");
                if( (value == null) || (!value.equals(getHandlingUnitExternalId())) ) {
                    setHandlingUnitExternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitInternalId") ) {
                final Object value = values.remove("HandlingUnitInternalId");
                if( (value == null) || (!value.equals(getHandlingUnitInternalId())) ) {
                    setHandlingUnitInternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitItem") ) {
                final Object value = values.remove("HandlingUnitItem");
                if( (value == null) || (!value.equals(getHandlingUnitItem())) ) {
                    setHandlingUnitItem(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitNestedInternalId") ) {
                final Object value = values.remove("HandlingUnitNestedInternalId");
                if( (value == null) || (!value.equals(getHandlingUnitNestedInternalId())) ) {
                    setHandlingUnitNestedInternalId(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitNrOfAuxPackgMat") ) {
                final Object value = values.remove("HandlingUnitNrOfAuxPackgMat");
                if( (value == null) || (!value.equals(getHandlingUnitNrOfAuxPackgMat())) ) {
                    setHandlingUnitNrOfAuxPackgMat(((Integer) value));
                }
            }
            if( values.containsKey("HandlingUnitNumberOfSerialnumb") ) {
                final Object value = values.remove("HandlingUnitNumberOfSerialnumb");
                if( (value == null) || (!value.equals(getHandlingUnitNumberOfSerialnumb())) ) {
                    setHandlingUnitNumberOfSerialnumb(((Integer) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantity") ) {
                final Object value = values.remove("HandlingUnitQuantity");
                if( (value == null) || (!value.equals(getHandlingUnitQuantity())) ) {
                    setHandlingUnitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantityUnit") ) {
                final Object value = values.remove("HandlingUnitQuantityUnit");
                if( (value == null) || (!value.equals(getHandlingUnitQuantityUnit())) ) {
                    setHandlingUnitQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTypeOfContent") ) {
                final Object value = values.remove("HandlingUnitTypeOfContent");
                if( (value == null) || (!value.equals(getHandlingUnitTypeOfContent())) ) {
                    setHandlingUnitTypeOfContent(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("SerialNumberProfile") ) {
                final Object value = values.remove("SerialNumberProfile");
                if( (value == null) || (!value.equals(getSerialNumberProfile())) ) {
                    setSerialNumberProfile(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> HandlingUnitItemDeliveryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new HandlingUnitItemDeliveryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> HandlingUnitItemDeliveryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new HandlingUnitItemDeliveryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH);
    }

}
