/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.OutbDeliveryAddress2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.OutbDeliveryAddress2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Outbound Delivery Partner Addresses 2
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_OutbDeliveryAddress2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OutbDeliveryAddress2 extends VdmEntity<OutbDeliveryAddress2>
{

    /**
     * Selector for all available fields of OutbDeliveryAddress2.
     *
     */
    public final static OutbDeliveryAddress2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return SD Document
     */
    @Key
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> DELIVERY_DOCUMENT =
        new OutbDeliveryAddress2Field<String>("DeliveryDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Functn
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PARTNER_FUNCTION =
        new OutbDeliveryAddress2Field<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @return DLV.Version
     */
    @SerializedName( "DeliveryVersion" )
    @JsonProperty( "DeliveryVersion" )
    @Nullable
    @ODataField( odataName = "DeliveryVersion" )
    private String deliveryVersion;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryVersion</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> DELIVERY_VERSION =
        new OutbDeliveryAddress2Field<String>("DeliveryVersion");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @return Street 3
     */
    @SerializedName( "AdditionalStreetPrefixName" )
    @JsonProperty( "AdditionalStreetPrefixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetPrefixName" )
    private String additionalStreetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetPrefixName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> ADDITIONAL_STREET_PREFIX_NAME =
        new OutbDeliveryAddress2Field<String>("AdditionalStreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> ADDRESS_ID =
        new OutbDeliveryAddress2Field<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "AdditionalStreetSuffixName" )
    @JsonProperty( "AdditionalStreetSuffixName" )
    @Nullable
    @ODataField( odataName = "AdditionalStreetSuffixName" )
    private String additionalStreetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalStreetSuffixName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> ADDITIONAL_STREET_SUFFIX_NAME =
        new OutbDeliveryAddress2Field<String>("AdditionalStreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @return Time Zone
     */
    @SerializedName( "AddressTimeZone" )
    @JsonProperty( "AddressTimeZone" )
    @Nullable
    @ODataField( odataName = "AddressTimeZone" )
    private String addressTimeZone;
    /**
     * Use with available fluent helpers to apply the <b>AddressTimeZone</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> ADDRESS_TIME_ZONE =
        new OutbDeliveryAddress2Field<String>("AddressTimeZone");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @return Building Code
     */
    @SerializedName( "Building" )
    @JsonProperty( "Building" )
    @Nullable
    @ODataField( odataName = "Building" )
    private String building;
    /**
     * Use with available fluent helpers to apply the <b>Building</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> BUILDING = new OutbDeliveryAddress2Field<String>("Building");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> BUSINESS_PARTNER_NAME1 =
        new OutbDeliveryAddress2Field<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> BUSINESS_PARTNER_NAME2 =
        new OutbDeliveryAddress2Field<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "BusinessPartnerName3" )
    @JsonProperty( "BusinessPartnerName3" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName3" )
    private String businessPartnerName3;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName3</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> BUSINESS_PARTNER_NAME3 =
        new OutbDeliveryAddress2Field<String>("BusinessPartnerName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "BusinessPartnerName4" )
    @JsonProperty( "BusinessPartnerName4" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName4" )
    private String businessPartnerName4;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName4</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> BUSINESS_PARTNER_NAME4 =
        new OutbDeliveryAddress2Field<String>("BusinessPartnerName4");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PersonFamilyName</b>
     * </p>
     *
     * @return Last Name
     */
    @SerializedName( "PersonFamilyName" )
    @JsonProperty( "PersonFamilyName" )
    @Nullable
    @ODataField( odataName = "PersonFamilyName" )
    private String personFamilyName;
    /**
     * Use with available fluent helpers to apply the <b>PersonFamilyName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PERSON_FAMILY_NAME =
        new OutbDeliveryAddress2Field<String>("PersonFamilyName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PersonGivenName</b>
     * </p>
     *
     * @return First Name
     */
    @SerializedName( "PersonGivenName" )
    @JsonProperty( "PersonGivenName" )
    @Nullable
    @ODataField( odataName = "PersonGivenName" )
    private String personGivenName;
    /**
     * Use with available fluent helpers to apply the <b>PersonGivenName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PERSON_GIVEN_NAME =
        new OutbDeliveryAddress2Field<String>("PersonGivenName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @return c/o
     */
    @SerializedName( "CareOfName" )
    @JsonProperty( "CareOfName" )
    @Nullable
    @ODataField( odataName = "CareOfName" )
    private String careOfName;
    /**
     * Use with available fluent helpers to apply the <b>CareOfName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> CARE_OF_NAME =
        new OutbDeliveryAddress2Field<String>("CareOfName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> CITY_NAME = new OutbDeliveryAddress2Field<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @return Company Post Cd
     */
    @SerializedName( "CompanyPostalCode" )
    @JsonProperty( "CompanyPostalCode" )
    @Nullable
    @ODataField( odataName = "CompanyPostalCode" )
    private String companyPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyPostalCode</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> COMPANY_POSTAL_CODE =
        new OutbDeliveryAddress2Field<String>("CompanyPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> CORRESPONDENCE_LANGUAGE =
        new OutbDeliveryAddress2Field<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Reg.
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> COUNTRY = new OutbDeliveryAddress2Field<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @return County
     */
    @SerializedName( "County" )
    @JsonProperty( "County" )
    @Nullable
    @ODataField( odataName = "County" )
    private String county;
    /**
     * Use with available fluent helpers to apply the <b>County</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> COUNTY = new OutbDeliveryAddress2Field<String>("County");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceNumber</b>
     * </p>
     *
     * @return Delivery Service No.
     */
    @SerializedName( "DeliveryServiceNumber" )
    @JsonProperty( "DeliveryServiceNumber" )
    @Nullable
    @ODataField( odataName = "DeliveryServiceNumber" )
    private String deliveryServiceNumber;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryServiceNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> DELIVERY_SERVICE_NUMBER =
        new OutbDeliveryAddress2Field<String>("DeliveryServiceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceTypeCode</b>
     * </p>
     *
     * @return Delvry Serv Type
     */
    @SerializedName( "DeliveryServiceTypeCode" )
    @JsonProperty( "DeliveryServiceTypeCode" )
    @Nullable
    @ODataField( odataName = "DeliveryServiceTypeCode" )
    private String deliveryServiceTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryServiceTypeCode</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> DELIVERY_SERVICE_TYPE_CODE =
        new OutbDeliveryAddress2Field<String>("DeliveryServiceTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "District" )
    @JsonProperty( "District" )
    @Nullable
    @ODataField( odataName = "District" )
    private String district;
    /**
     * Use with available fluent helpers to apply the <b>District</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> DISTRICT = new OutbDeliveryAddress2Field<String>("District");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> EMAIL_ADDRESS =
        new OutbDeliveryAddress2Field<String>("EmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return Fax
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> FAX_NUMBER =
        new OutbDeliveryAddress2Field<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberExtension</b>
     * </p>
     *
     * @return Extension
     */
    @SerializedName( "FaxNumberExtension" )
    @JsonProperty( "FaxNumberExtension" )
    @Nullable
    @ODataField( odataName = "FaxNumberExtension" )
    private String faxNumberExtension;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumberExtension</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> FAX_NUMBER_EXTENSION =
        new OutbDeliveryAddress2Field<String>("FaxNumberExtension");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @return Floor
     */
    @SerializedName( "Floor" )
    @JsonProperty( "Floor" )
    @Nullable
    @ODataField( odataName = "Floor" )
    private String floor;
    /**
     * Use with available fluent helpers to apply the <b>Floor</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> FLOOR = new OutbDeliveryAddress2Field<String>("Floor");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Title Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> FORM_OF_ADDRESS =
        new OutbDeliveryAddress2Field<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HomeCityName</b>
     * </p>
     *
     * @return Different City
     */
    @SerializedName( "HomeCityName" )
    @JsonProperty( "HomeCityName" )
    @Nullable
    @ODataField( odataName = "HomeCityName" )
    private String homeCityName;
    /**
     * Use with available fluent helpers to apply the <b>HomeCityName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> HOME_CITY_NAME =
        new OutbDeliveryAddress2Field<String>("HomeCityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> HOUSE_NUMBER =
        new OutbDeliveryAddress2Field<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @return Supplement
     */
    @SerializedName( "HouseNumberSupplementText" )
    @JsonProperty( "HouseNumberSupplementText" )
    @Nullable
    @ODataField( odataName = "HouseNumberSupplementText" )
    private String houseNumberSupplementText;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumberSupplementText</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> HOUSE_NUMBER_SUPPLEMENT_TEXT =
        new OutbDeliveryAddress2Field<String>("HouseNumberSupplementText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobilePhoneNumber</b>
     * </p>
     *
     * @return Telephone
     */
    @SerializedName( "MobilePhoneNumber" )
    @JsonProperty( "MobilePhoneNumber" )
    @Nullable
    @ODataField( odataName = "MobilePhoneNumber" )
    private String mobilePhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>MobilePhoneNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> MOBILE_PHONE_NUMBER =
        new OutbDeliveryAddress2Field<String>("MobilePhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Telephone
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PHONE_NUMBER =
        new OutbDeliveryAddress2Field<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumberExtension</b>
     * </p>
     *
     * @return Extension
     */
    @SerializedName( "PhoneNumberExtension" )
    @JsonProperty( "PhoneNumberExtension" )
    @Nullable
    @ODataField( odataName = "PhoneNumberExtension" )
    private String phoneNumberExtension;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumberExtension</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PHONE_NUMBER_EXTENSION =
        new OutbDeliveryAddress2Field<String>("PhoneNumberExtension");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX = new OutbDeliveryAddress2Field<String>("POBox");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @return PO Box City
     */
    @SerializedName( "POBoxDeviatingCityName" )
    @JsonProperty( "POBoxDeviatingCityName" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingCityName" )
    private String pOBoxDeviatingCityName;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingCityName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX_DEVIATING_CITY_NAME =
        new OutbDeliveryAddress2Field<String>("POBoxDeviatingCityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCountry</b>
     * </p>
     *
     * @return PO Box C/R
     */
    @SerializedName( "POBoxDeviatingCountry" )
    @JsonProperty( "POBoxDeviatingCountry" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingCountry" )
    private String pOBoxDeviatingCountry;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingCountry</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX_DEVIATING_COUNTRY =
        new OutbDeliveryAddress2Field<String>("POBoxDeviatingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingRegion</b>
     * </p>
     *
     * @return PO Region
     */
    @SerializedName( "POBoxDeviatingRegion" )
    @JsonProperty( "POBoxDeviatingRegion" )
    @Nullable
    @ODataField( odataName = "POBoxDeviatingRegion" )
    private String pOBoxDeviatingRegion;
    /**
     * Use with available fluent helpers to apply the <b>POBoxDeviatingRegion</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX_DEVIATING_REGION =
        new OutbDeliveryAddress2Field<String>("POBoxDeviatingRegion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>POBoxIsWithoutNumber</b>
     * </p>
     *
     * @return PO Box w/o No.
     */
    @SerializedName( "POBoxIsWithoutNumber" )
    @JsonProperty( "POBoxIsWithoutNumber" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "POBoxIsWithoutNumber" )
    private Boolean pOBoxIsWithoutNumber;
    /**
     * Use with available fluent helpers to apply the <b>POBoxIsWithoutNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<Boolean> PO_BOX_IS_WITHOUT_NUMBER =
        new OutbDeliveryAddress2Field<Boolean>("POBoxIsWithoutNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxLobbyName</b>
     * </p>
     *
     * @return PO Box Lobby
     */
    @SerializedName( "POBoxLobbyName" )
    @JsonProperty( "POBoxLobbyName" )
    @Nullable
    @ODataField( odataName = "POBoxLobbyName" )
    private String pOBoxLobbyName;
    /**
     * Use with available fluent helpers to apply the <b>POBoxLobbyName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX_LOBBY_NAME =
        new OutbDeliveryAddress2Field<String>("POBoxLobbyName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @return PO Box Post Cde
     */
    @SerializedName( "POBoxPostalCode" )
    @JsonProperty( "POBoxPostalCode" )
    @Nullable
    @ODataField( odataName = "POBoxPostalCode" )
    private String pOBoxPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>POBoxPostalCode</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PO_BOX_POSTAL_CODE =
        new OutbDeliveryAddress2Field<String>("POBoxPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> POSTAL_CODE =
        new OutbDeliveryAddress2Field<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @return Comm. Method
     */
    @SerializedName( "PrfrdCommMediumType" )
    @JsonProperty( "PrfrdCommMediumType" )
    @Nullable
    @ODataField( odataName = "PrfrdCommMediumType" )
    private String prfrdCommMediumType;
    /**
     * Use with available fluent helpers to apply the <b>PrfrdCommMediumType</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> PRFRD_COMM_MEDIUM_TYPE =
        new OutbDeliveryAddress2Field<String>("PrfrdCommMediumType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> REGION = new OutbDeliveryAddress2Field<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @return Room Number
     */
    @SerializedName( "RoomNumber" )
    @JsonProperty( "RoomNumber" )
    @Nullable
    @ODataField( odataName = "RoomNumber" )
    private String roomNumber;
    /**
     * Use with available fluent helpers to apply the <b>RoomNumber</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> ROOM_NUMBER =
        new OutbDeliveryAddress2Field<String>("RoomNumber");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> STREET_NAME =
        new OutbDeliveryAddress2Field<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @return Street 2
     */
    @SerializedName( "StreetPrefixName" )
    @JsonProperty( "StreetPrefixName" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName" )
    private String streetPrefixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> STREET_PREFIX_NAME =
        new OutbDeliveryAddress2Field<String>("StreetPrefixName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @return Street 4
     */
    @SerializedName( "StreetSuffixName" )
    @JsonProperty( "StreetSuffixName" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName" )
    private String streetSuffixName;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> STREET_SUFFIX_NAME =
        new OutbDeliveryAddress2Field<String>("StreetSuffixName");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> TAX_JURISDICTION =
        new OutbDeliveryAddress2Field<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @return Transport Zone
     */
    @SerializedName( "TransportZone" )
    @JsonProperty( "TransportZone" )
    @Nullable
    @ODataField( odataName = "TransportZone" )
    private String transportZone;
    /**
     * Use with available fluent helpers to apply the <b>TransportZone</b> field to query operations.
     *
     */
    public final static OutbDeliveryAddress2Field<String> TRANSPORT_ZONE =
        new OutbDeliveryAddress2Field<String>("TransportZone");

    @Nonnull
    @Override
    public Class<OutbDeliveryAddress2> getType()
    {
        return OutbDeliveryAddress2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            SD Document
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Functn
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryVersion</b>
     * </p>
     *
     * @param deliveryVersion
     *            DLV.Version
     */
    public void setDeliveryVersion( @Nullable final String deliveryVersion )
    {
        rememberChangedField("DeliveryVersion", this.deliveryVersion);
        this.deliveryVersion = deliveryVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetPrefixName</b>
     * </p>
     *
     * @param additionalStreetPrefixName
     *            Street 3
     */
    public void setAdditionalStreetPrefixName( @Nullable final String additionalStreetPrefixName )
    {
        rememberChangedField("AdditionalStreetPrefixName", this.additionalStreetPrefixName);
        this.additionalStreetPrefixName = additionalStreetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalStreetSuffixName</b>
     * </p>
     *
     * @param additionalStreetSuffixName
     *            Street 5
     */
    public void setAdditionalStreetSuffixName( @Nullable final String additionalStreetSuffixName )
    {
        rememberChangedField("AdditionalStreetSuffixName", this.additionalStreetSuffixName);
        this.additionalStreetSuffixName = additionalStreetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AddressTimeZone</b>
     * </p>
     *
     * @param addressTimeZone
     *            Time Zone
     */
    public void setAddressTimeZone( @Nullable final String addressTimeZone )
    {
        rememberChangedField("AddressTimeZone", this.addressTimeZone);
        this.addressTimeZone = addressTimeZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @param building
     *            Building Code
     */
    public void setBuilding( @Nullable final String building )
    {
        rememberChangedField("Building", this.building);
        this.building = building;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName3</b>
     * </p>
     *
     * @param businessPartnerName3
     *            Name 3
     */
    public void setBusinessPartnerName3( @Nullable final String businessPartnerName3 )
    {
        rememberChangedField("BusinessPartnerName3", this.businessPartnerName3);
        this.businessPartnerName3 = businessPartnerName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName4</b>
     * </p>
     *
     * @param businessPartnerName4
     *            Name 4
     */
    public void setBusinessPartnerName4( @Nullable final String businessPartnerName4 )
    {
        rememberChangedField("BusinessPartnerName4", this.businessPartnerName4);
        this.businessPartnerName4 = businessPartnerName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PersonFamilyName</b>
     * </p>
     *
     * @param personFamilyName
     *            Last Name
     */
    public void setPersonFamilyName( @Nullable final String personFamilyName )
    {
        rememberChangedField("PersonFamilyName", this.personFamilyName);
        this.personFamilyName = personFamilyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PersonGivenName</b>
     * </p>
     *
     * @param personGivenName
     *            First Name
     */
    public void setPersonGivenName( @Nullable final String personGivenName )
    {
        rememberChangedField("PersonGivenName", this.personGivenName);
        this.personGivenName = personGivenName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CareOfName</b>
     * </p>
     *
     * @param careOfName
     *            c/o
     */
    public void setCareOfName( @Nullable final String careOfName )
    {
        rememberChangedField("CareOfName", this.careOfName);
        this.careOfName = careOfName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompanyPostalCode</b>
     * </p>
     *
     * @param companyPostalCode
     *            Company Post Cd
     */
    public void setCompanyPostalCode( @Nullable final String companyPostalCode )
    {
        rememberChangedField("CompanyPostalCode", this.companyPostalCode);
        this.companyPostalCode = companyPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Language
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Reg.
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @param county
     *            County
     */
    public void setCounty( @Nullable final String county )
    {
        rememberChangedField("County", this.county);
        this.county = county;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceNumber</b>
     * </p>
     *
     * @param deliveryServiceNumber
     *            Delivery Service No.
     */
    public void setDeliveryServiceNumber( @Nullable final String deliveryServiceNumber )
    {
        rememberChangedField("DeliveryServiceNumber", this.deliveryServiceNumber);
        this.deliveryServiceNumber = deliveryServiceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryServiceTypeCode</b>
     * </p>
     *
     * @param deliveryServiceTypeCode
     *            Delvry Serv Type
     */
    public void setDeliveryServiceTypeCode( @Nullable final String deliveryServiceTypeCode )
    {
        rememberChangedField("DeliveryServiceTypeCode", this.deliveryServiceTypeCode);
        this.deliveryServiceTypeCode = deliveryServiceTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *            District
     */
    public void setDistrict( @Nullable final String district )
    {
        rememberChangedField("District", this.district);
        this.district = district;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            Fax
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberExtension</b>
     * </p>
     *
     * @param faxNumberExtension
     *            Extension
     */
    public void setFaxNumberExtension( @Nullable final String faxNumberExtension )
    {
        rememberChangedField("FaxNumberExtension", this.faxNumberExtension);
        this.faxNumberExtension = faxNumberExtension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *            Floor
     */
    public void setFloor( @Nullable final String floor )
    {
        rememberChangedField("Floor", this.floor);
        this.floor = floor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Title Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HomeCityName</b>
     * </p>
     *
     * @param homeCityName
     *            Different City
     */
    public void setHomeCityName( @Nullable final String homeCityName )
    {
        rememberChangedField("HomeCityName", this.homeCityName);
        this.homeCityName = homeCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @param houseNumberSupplementText
     *            Supplement
     */
    public void setHouseNumberSupplementText( @Nullable final String houseNumberSupplementText )
    {
        rememberChangedField("HouseNumberSupplementText", this.houseNumberSupplementText);
        this.houseNumberSupplementText = houseNumberSupplementText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobilePhoneNumber</b>
     * </p>
     *
     * @param mobilePhoneNumber
     *            Telephone
     */
    public void setMobilePhoneNumber( @Nullable final String mobilePhoneNumber )
    {
        rememberChangedField("MobilePhoneNumber", this.mobilePhoneNumber);
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Telephone
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumberExtension</b>
     * </p>
     *
     * @param phoneNumberExtension
     *            Extension
     */
    public void setPhoneNumberExtension( @Nullable final String phoneNumberExtension )
    {
        rememberChangedField("PhoneNumberExtension", this.phoneNumberExtension);
        this.phoneNumberExtension = phoneNumberExtension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCityName</b>
     * </p>
     *
     * @param pOBoxDeviatingCityName
     *            PO Box City
     */
    public void setPOBoxDeviatingCityName( @Nullable final String pOBoxDeviatingCityName )
    {
        rememberChangedField("POBoxDeviatingCityName", this.pOBoxDeviatingCityName);
        this.pOBoxDeviatingCityName = pOBoxDeviatingCityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingCountry</b>
     * </p>
     *
     * @param pOBoxDeviatingCountry
     *            PO Box C/R
     */
    public void setPOBoxDeviatingCountry( @Nullable final String pOBoxDeviatingCountry )
    {
        rememberChangedField("POBoxDeviatingCountry", this.pOBoxDeviatingCountry);
        this.pOBoxDeviatingCountry = pOBoxDeviatingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>POBoxDeviatingRegion</b>
     * </p>
     *
     * @param pOBoxDeviatingRegion
     *            PO Region
     */
    public void setPOBoxDeviatingRegion( @Nullable final String pOBoxDeviatingRegion )
    {
        rememberChangedField("POBoxDeviatingRegion", this.pOBoxDeviatingRegion);
        this.pOBoxDeviatingRegion = pOBoxDeviatingRegion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>POBoxIsWithoutNumber</b>
     * </p>
     *
     * @param pOBoxIsWithoutNumber
     *            PO Box w/o No.
     */
    public void setPOBoxIsWithoutNumber( @Nullable final Boolean pOBoxIsWithoutNumber )
    {
        rememberChangedField("POBoxIsWithoutNumber", this.pOBoxIsWithoutNumber);
        this.pOBoxIsWithoutNumber = pOBoxIsWithoutNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>POBoxLobbyName</b>
     * </p>
     *
     * @param pOBoxLobbyName
     *            PO Box Lobby
     */
    public void setPOBoxLobbyName( @Nullable final String pOBoxLobbyName )
    {
        rememberChangedField("POBoxLobbyName", this.pOBoxLobbyName);
        this.pOBoxLobbyName = pOBoxLobbyName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @param pOBoxPostalCode
     *            PO Box Post Cde
     */
    public void setPOBoxPostalCode( @Nullable final String pOBoxPostalCode )
    {
        rememberChangedField("POBoxPostalCode", this.pOBoxPostalCode);
        this.pOBoxPostalCode = pOBoxPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrfrdCommMediumType</b>
     * </p>
     *
     * @param prfrdCommMediumType
     *            Comm. Method
     */
    public void setPrfrdCommMediumType( @Nullable final String prfrdCommMediumType )
    {
        rememberChangedField("PrfrdCommMediumType", this.prfrdCommMediumType);
        this.prfrdCommMediumType = prfrdCommMediumType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *            Room Number
     */
    public void setRoomNumber( @Nullable final String roomNumber )
    {
        rememberChangedField("RoomNumber", this.roomNumber);
        this.roomNumber = roomNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName</b>
     * </p>
     *
     * @param streetPrefixName
     *            Street 2
     */
    public void setStreetPrefixName( @Nullable final String streetPrefixName )
    {
        rememberChangedField("StreetPrefixName", this.streetPrefixName);
        this.streetPrefixName = streetPrefixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName</b>
     * </p>
     *
     * @param streetSuffixName
     *            Street 4
     */
    public void setStreetSuffixName( @Nullable final String streetSuffixName )
    {
        rememberChangedField("StreetSuffixName", this.streetSuffixName);
        this.streetSuffixName = streetSuffixName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @param transportZone
     *            Transport Zone
     */
    public void setTransportZone( @Nullable final String transportZone )
    {
        rememberChangedField("TransportZone", this.transportZone);
        this.transportZone = transportZone;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_OutbDeliveryAddress2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DeliveryDocument", getDeliveryDocument());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("DeliveryVersion", getDeliveryVersion());
        values.put("AdditionalStreetPrefixName", getAdditionalStreetPrefixName());
        values.put("AddressID", getAddressID());
        values.put("AdditionalStreetSuffixName", getAdditionalStreetSuffixName());
        values.put("AddressTimeZone", getAddressTimeZone());
        values.put("Building", getBuilding());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("BusinessPartnerName3", getBusinessPartnerName3());
        values.put("BusinessPartnerName4", getBusinessPartnerName4());
        values.put("PersonFamilyName", getPersonFamilyName());
        values.put("PersonGivenName", getPersonGivenName());
        values.put("CareOfName", getCareOfName());
        values.put("CityName", getCityName());
        values.put("CompanyPostalCode", getCompanyPostalCode());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("Country", getCountry());
        values.put("County", getCounty());
        values.put("DeliveryServiceNumber", getDeliveryServiceNumber());
        values.put("DeliveryServiceTypeCode", getDeliveryServiceTypeCode());
        values.put("District", getDistrict());
        values.put("EmailAddress", getEmailAddress());
        values.put("FaxNumber", getFaxNumber());
        values.put("FaxNumberExtension", getFaxNumberExtension());
        values.put("Floor", getFloor());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("HomeCityName", getHomeCityName());
        values.put("HouseNumber", getHouseNumber());
        values.put("HouseNumberSupplementText", getHouseNumberSupplementText());
        values.put("MobilePhoneNumber", getMobilePhoneNumber());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("PhoneNumberExtension", getPhoneNumberExtension());
        values.put("POBox", getPOBox());
        values.put("POBoxDeviatingCityName", getPOBoxDeviatingCityName());
        values.put("POBoxDeviatingCountry", getPOBoxDeviatingCountry());
        values.put("POBoxDeviatingRegion", getPOBoxDeviatingRegion());
        values.put("POBoxIsWithoutNumber", getPOBoxIsWithoutNumber());
        values.put("POBoxLobbyName", getPOBoxLobbyName());
        values.put("POBoxPostalCode", getPOBoxPostalCode());
        values.put("PostalCode", getPostalCode());
        values.put("PrfrdCommMediumType", getPrfrdCommMediumType());
        values.put("Region", getRegion());
        values.put("RoomNumber", getRoomNumber());
        values.put("StreetName", getStreetName());
        values.put("StreetPrefixName", getStreetPrefixName());
        values.put("StreetSuffixName", getStreetSuffixName());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("TransportZone", getTransportZone());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("DeliveryVersion") ) {
                final Object value = values.remove("DeliveryVersion");
                if( (value == null) || (!value.equals(getDeliveryVersion())) ) {
                    setDeliveryVersion(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetPrefixName") ) {
                final Object value = values.remove("AdditionalStreetPrefixName");
                if( (value == null) || (!value.equals(getAdditionalStreetPrefixName())) ) {
                    setAdditionalStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("AdditionalStreetSuffixName") ) {
                final Object value = values.remove("AdditionalStreetSuffixName");
                if( (value == null) || (!value.equals(getAdditionalStreetSuffixName())) ) {
                    setAdditionalStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("AddressTimeZone") ) {
                final Object value = values.remove("AddressTimeZone");
                if( (value == null) || (!value.equals(getAddressTimeZone())) ) {
                    setAddressTimeZone(((String) value));
                }
            }
            if( values.containsKey("Building") ) {
                final Object value = values.remove("Building");
                if( (value == null) || (!value.equals(getBuilding())) ) {
                    setBuilding(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName3") ) {
                final Object value = values.remove("BusinessPartnerName3");
                if( (value == null) || (!value.equals(getBusinessPartnerName3())) ) {
                    setBusinessPartnerName3(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName4") ) {
                final Object value = values.remove("BusinessPartnerName4");
                if( (value == null) || (!value.equals(getBusinessPartnerName4())) ) {
                    setBusinessPartnerName4(((String) value));
                }
            }
            if( values.containsKey("PersonFamilyName") ) {
                final Object value = values.remove("PersonFamilyName");
                if( (value == null) || (!value.equals(getPersonFamilyName())) ) {
                    setPersonFamilyName(((String) value));
                }
            }
            if( values.containsKey("PersonGivenName") ) {
                final Object value = values.remove("PersonGivenName");
                if( (value == null) || (!value.equals(getPersonGivenName())) ) {
                    setPersonGivenName(((String) value));
                }
            }
            if( values.containsKey("CareOfName") ) {
                final Object value = values.remove("CareOfName");
                if( (value == null) || (!value.equals(getCareOfName())) ) {
                    setCareOfName(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("CompanyPostalCode") ) {
                final Object value = values.remove("CompanyPostalCode");
                if( (value == null) || (!value.equals(getCompanyPostalCode())) ) {
                    setCompanyPostalCode(((String) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("County") ) {
                final Object value = values.remove("County");
                if( (value == null) || (!value.equals(getCounty())) ) {
                    setCounty(((String) value));
                }
            }
            if( values.containsKey("DeliveryServiceNumber") ) {
                final Object value = values.remove("DeliveryServiceNumber");
                if( (value == null) || (!value.equals(getDeliveryServiceNumber())) ) {
                    setDeliveryServiceNumber(((String) value));
                }
            }
            if( values.containsKey("DeliveryServiceTypeCode") ) {
                final Object value = values.remove("DeliveryServiceTypeCode");
                if( (value == null) || (!value.equals(getDeliveryServiceTypeCode())) ) {
                    setDeliveryServiceTypeCode(((String) value));
                }
            }
            if( values.containsKey("District") ) {
                final Object value = values.remove("District");
                if( (value == null) || (!value.equals(getDistrict())) ) {
                    setDistrict(((String) value));
                }
            }
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumberExtension") ) {
                final Object value = values.remove("FaxNumberExtension");
                if( (value == null) || (!value.equals(getFaxNumberExtension())) ) {
                    setFaxNumberExtension(((String) value));
                }
            }
            if( values.containsKey("Floor") ) {
                final Object value = values.remove("Floor");
                if( (value == null) || (!value.equals(getFloor())) ) {
                    setFloor(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("HomeCityName") ) {
                final Object value = values.remove("HomeCityName");
                if( (value == null) || (!value.equals(getHomeCityName())) ) {
                    setHomeCityName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("HouseNumberSupplementText") ) {
                final Object value = values.remove("HouseNumberSupplementText");
                if( (value == null) || (!value.equals(getHouseNumberSupplementText())) ) {
                    setHouseNumberSupplementText(((String) value));
                }
            }
            if( values.containsKey("MobilePhoneNumber") ) {
                final Object value = values.remove("MobilePhoneNumber");
                if( (value == null) || (!value.equals(getMobilePhoneNumber())) ) {
                    setMobilePhoneNumber(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("PhoneNumberExtension") ) {
                final Object value = values.remove("PhoneNumberExtension");
                if( (value == null) || (!value.equals(getPhoneNumberExtension())) ) {
                    setPhoneNumberExtension(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingCityName") ) {
                final Object value = values.remove("POBoxDeviatingCityName");
                if( (value == null) || (!value.equals(getPOBoxDeviatingCityName())) ) {
                    setPOBoxDeviatingCityName(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingCountry") ) {
                final Object value = values.remove("POBoxDeviatingCountry");
                if( (value == null) || (!value.equals(getPOBoxDeviatingCountry())) ) {
                    setPOBoxDeviatingCountry(((String) value));
                }
            }
            if( values.containsKey("POBoxDeviatingRegion") ) {
                final Object value = values.remove("POBoxDeviatingRegion");
                if( (value == null) || (!value.equals(getPOBoxDeviatingRegion())) ) {
                    setPOBoxDeviatingRegion(((String) value));
                }
            }
            if( values.containsKey("POBoxIsWithoutNumber") ) {
                final Object value = values.remove("POBoxIsWithoutNumber");
                if( (value == null) || (!value.equals(getPOBoxIsWithoutNumber())) ) {
                    setPOBoxIsWithoutNumber(((Boolean) value));
                }
            }
            if( values.containsKey("POBoxLobbyName") ) {
                final Object value = values.remove("POBoxLobbyName");
                if( (value == null) || (!value.equals(getPOBoxLobbyName())) ) {
                    setPOBoxLobbyName(((String) value));
                }
            }
            if( values.containsKey("POBoxPostalCode") ) {
                final Object value = values.remove("POBoxPostalCode");
                if( (value == null) || (!value.equals(getPOBoxPostalCode())) ) {
                    setPOBoxPostalCode(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("PrfrdCommMediumType") ) {
                final Object value = values.remove("PrfrdCommMediumType");
                if( (value == null) || (!value.equals(getPrfrdCommMediumType())) ) {
                    setPrfrdCommMediumType(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("RoomNumber") ) {
                final Object value = values.remove("RoomNumber");
                if( (value == null) || (!value.equals(getRoomNumber())) ) {
                    setRoomNumber(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName") ) {
                final Object value = values.remove("StreetPrefixName");
                if( (value == null) || (!value.equals(getStreetPrefixName())) ) {
                    setStreetPrefixName(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName") ) {
                final Object value = values.remove("StreetSuffixName");
                if( (value == null) || (!value.equals(getStreetSuffixName())) ) {
                    setStreetSuffixName(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("TransportZone") ) {
                final Object value = values.remove("TransportZone");
                if( (value == null) || (!value.equals(getTransportZone())) ) {
                    setTransportZone(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OutbDeliveryAddress2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OutbDeliveryAddress2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OutbDeliveryAddress2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OutbDeliveryAddress2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH);
    }

}
