/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.OutbDeliveryAddress2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
 * OutbDeliveryAddress2} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class OutbDeliveryAddress2ByKeyFluentHelper
    extends
    FluentHelperByKey<OutbDeliveryAddress2ByKeyFluentHelper, OutbDeliveryAddress2, OutbDeliveryAddress2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
     * OutbDeliveryAddress2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OutbDeliveryAddress2}
     * @param partnerFunction
     *            Partner Functn
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param deliveryDocument
     *            SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OutbDeliveryAddress2}
     */
    public OutbDeliveryAddress2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String deliveryDocument,
        final String partnerFunction )
    {
        super(servicePath, entityCollection);
        this.key.put("DeliveryDocument", deliveryDocument);
        this.key.put("PartnerFunction", partnerFunction);
    }

    @Override
    @Nonnull
    protected Class<OutbDeliveryAddress2> getEntityClass()
    {
        return OutbDeliveryAddress2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
