/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.OutbDeliveryDocFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow
 * OutbDeliveryDocFlow} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class OutbDeliveryDocFlowByKeyFluentHelper
    extends
    FluentHelperByKey<OutbDeliveryDocFlowByKeyFluentHelper, OutbDeliveryDocFlow, OutbDeliveryDocFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow
     * OutbDeliveryDocFlow} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code OutbDeliveryDocFlow}
     * @param precedingDocument
     *            Preceding Doc.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code OutbDeliveryDocFlow}
     * @param precedingDocumentItem
     *            Preceding Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subsequentDocumentCategory
     *            Subs.Doc.Categ.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public OutbDeliveryDocFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory )
    {
        super(servicePath, entityCollection);
        this.key.put("PrecedingDocument", precedingDocument);
        this.key.put("PrecedingDocumentItem", precedingDocumentItem);
        this.key.put("SubsequentDocumentCategory", subsequentDocumentCategory);
    }

    @Override
    @Nonnull
    protected Class<OutbDeliveryDocFlow> getEntityClass()
    {
        return OutbDeliveryDocFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
