/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.OutbDeliveryHeaderTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.OutbDeliveryHeaderTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Outbound Delivery Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_OutbDeliveryHeaderTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class OutbDeliveryHeaderText extends VdmEntity<OutbDeliveryHeaderText>
{

    /**
     * Selector for all available fields of OutbDeliveryHeaderText.
     *
     */
    public final static OutbDeliveryHeaderTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @Key
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<String> DELIVERY_DOCUMENT =
        new OutbDeliveryHeaderTextField<String>("DeliveryDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextElement</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "TextElement" )
    @JsonProperty( "TextElement" )
    @Nullable
    @ODataField( odataName = "TextElement" )
    private String textElement;
    /**
     * Use with available fluent helpers to apply the <b>TextElement</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<String> TEXT_ELEMENT =
        new OutbDeliveryHeaderTextField<String>("TextElement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<String> LANGUAGE =
        new OutbDeliveryHeaderTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TextElementDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "TextElementDescription" )
    @JsonProperty( "TextElementDescription" )
    @Nullable
    @ODataField( odataName = "TextElementDescription" )
    private String textElementDescription;
    /**
     * Use with available fluent helpers to apply the <b>TextElementDescription</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<String> TEXT_ELEMENT_DESCRIPTION =
        new OutbDeliveryHeaderTextField<String>("TextElementDescription");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TextElementText</b>
     * </p>
     *
     * @return The textElementText contained in this entity.
     */
    @SerializedName( "TextElementText" )
    @JsonProperty( "TextElementText" )
    @Nullable
    @ODataField( odataName = "TextElementText" )
    private String textElementText;
    /**
     * Use with available fluent helpers to apply the <b>TextElementText</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<String> TEXT_ELEMENT_TEXT =
        new OutbDeliveryHeaderTextField<String>("TextElementText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryLongTextIsFormatted</b>
     * </p>
     *
     * @return Truth Value
     */
    @SerializedName( "DeliveryLongTextIsFormatted" )
    @JsonProperty( "DeliveryLongTextIsFormatted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeliveryLongTextIsFormatted" )
    private Boolean deliveryLongTextIsFormatted;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryLongTextIsFormatted</b> field to query operations.
     *
     */
    public final static OutbDeliveryHeaderTextField<Boolean> DELIVERY_LONG_TEXT_IS_FORMATTED =
        new OutbDeliveryHeaderTextField<Boolean>("DeliveryLongTextIsFormatted");

    @Nonnull
    @Override
    public Class<OutbDeliveryHeaderText> getType()
    {
        return OutbDeliveryHeaderText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TextElement</b>
     * </p>
     *
     * @param textElement
     *            Text ID
     */
    public void setTextElement( @Nullable final String textElement )
    {
        rememberChangedField("TextElement", this.textElement);
        this.textElement = textElement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>TextElementDescription</b>
     * </p>
     *
     * @param textElementDescription
     *            Description
     */
    public void setTextElementDescription( @Nullable final String textElementDescription )
    {
        rememberChangedField("TextElementDescription", this.textElementDescription);
        this.textElementDescription = textElementDescription;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TextElementText</b>
     * </p>
     *
     * @param textElementText
     *            The textElementText to set.
     */
    public void setTextElementText( @Nullable final String textElementText )
    {
        rememberChangedField("TextElementText", this.textElementText);
        this.textElementText = textElementText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryLongTextIsFormatted</b>
     * </p>
     *
     * @param deliveryLongTextIsFormatted
     *            Truth Value
     */
    public void setDeliveryLongTextIsFormatted( @Nullable final Boolean deliveryLongTextIsFormatted )
    {
        rememberChangedField("DeliveryLongTextIsFormatted", this.deliveryLongTextIsFormatted);
        this.deliveryLongTextIsFormatted = deliveryLongTextIsFormatted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_OutbDeliveryHeaderText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DeliveryDocument", getDeliveryDocument());
        result.put("TextElement", getTextElement());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("TextElement", getTextElement());
        values.put("Language", getLanguage());
        values.put("TextElementDescription", getTextElementDescription());
        values.put("TextElementText", getTextElementText());
        values.put("DeliveryLongTextIsFormatted", getDeliveryLongTextIsFormatted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("TextElement") ) {
                final Object value = values.remove("TextElement");
                if( (value == null) || (!value.equals(getTextElement())) ) {
                    setTextElement(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("TextElementDescription") ) {
                final Object value = values.remove("TextElementDescription");
                if( (value == null) || (!value.equals(getTextElementDescription())) ) {
                    setTextElementDescription(((String) value));
                }
            }
            if( values.containsKey("TextElementText") ) {
                final Object value = values.remove("TextElementText");
                if( (value == null) || (!value.equals(getTextElementText())) ) {
                    setTextElementText(((String) value));
                }
            }
            if( values.containsKey("DeliveryLongTextIsFormatted") ) {
                final Object value = values.remove("DeliveryLongTextIsFormatted");
                if( (value == null) || (!value.equals(getDeliveryLongTextIsFormatted())) ) {
                    setDeliveryLongTextIsFormatted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> OutbDeliveryHeaderTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new OutbDeliveryHeaderTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> OutbDeliveryHeaderTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new OutbDeliveryHeaderTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH);
    }

}
