/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link OutboundDeliveryV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service OutboundDeliveryV2Service},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultOutboundDeliveryV2ServiceBatch
    extends
    BatchFluentHelperBasic<OutboundDeliveryV2ServiceBatch, OutboundDeliveryV2ServiceBatchChangeSet>
    implements
    OutboundDeliveryV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultOutboundDeliveryV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOutboundDeliveryV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultOutboundDeliveryV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultOutboundDeliveryV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultOutboundDeliveryV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultOutboundDeliveryV2ServiceBatchChangeSet(this, service);
    }

}
