/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText;

/**
 * Implementation of the {@link OutboundDeliveryV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service OutboundDeliveryV2Service}.
 *
 */
public class DefaultOutboundDeliveryV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<OutboundDeliveryV2ServiceBatch, OutboundDeliveryV2ServiceBatchChangeSet>
    implements
    OutboundDeliveryV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultOutboundDeliveryV2ServiceBatchChangeSet(
        @Nonnull final DefaultOutboundDeliveryV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultOutboundDeliveryV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return addRequestCreate(service::createOutbDeliveryItemText, outbDeliveryItemText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return addRequestUpdate(service::updateOutbDeliveryItemText, outbDeliveryItemText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet deleteOutbDeliveryItemText(
        @Nonnull final OutbDeliveryItemText outbDeliveryItemText )
    {
        return addRequestDelete(service::deleteOutbDeliveryItemText, outbDeliveryItemText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return addRequestCreate(service::createOutbDeliveryHeaderText, outbDeliveryHeaderText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return addRequestUpdate(service::updateOutbDeliveryHeaderText, outbDeliveryHeaderText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet deleteOutbDeliveryHeaderText(
        @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText )
    {
        return addRequestDelete(service::deleteOutbDeliveryHeaderText, outbDeliveryHeaderText);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createHandlingUnitHeaderDelivery(
        @Nonnull final HandlingUnitHeaderDelivery handlingUnitHeaderDelivery )
    {
        return addRequestCreate(service::createHandlingUnitHeaderDelivery, handlingUnitHeaderDelivery);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createHandlingUnitItemDelivery(
        @Nonnull final HandlingUnitItemDelivery handlingUnitItemDelivery )
    {
        return addRequestCreate(service::createHandlingUnitItemDelivery, handlingUnitItemDelivery);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryAddress2(
        @Nonnull final OutbDeliveryAddress2 outbDeliveryAddress2 )
    {
        return addRequestUpdate(service::updateOutbDeliveryAddress2, outbDeliveryAddress2);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createOutbDeliveryItem(
        @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return addRequestCreate(service::createOutbDeliveryItem, outbDeliveryItem);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryItem(
        @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return addRequestUpdate(service::updateOutbDeliveryItem, outbDeliveryItem);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet deleteOutbDeliveryItem(
        @Nonnull final OutbDeliveryItem outbDeliveryItem )
    {
        return addRequestDelete(service::deleteOutbDeliveryItem, outbDeliveryItem);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet createOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestCreate(service::createOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestUpdate(service::updateOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet deleteOutbDeliveryHeader(
        @Nonnull final OutbDeliveryHeader outbDeliveryHeader )
    {
        return addRequestDelete(service::deleteOutbDeliveryHeader, outbDeliveryHeader);
    }

    @Nonnull
    @Override
    public OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryDocFlow(
        @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow )
    {
        return addRequestUpdate(service::updateOutbDeliveryDocFlow, outbDeliveryDocFlow);
    }

}
