/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.OutboundDeliveryV2Service
 * OutboundDeliveryV2Service}.
 *
 */
public interface OutboundDeliveryV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<OutboundDeliveryV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<OutboundDeliveryV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     * OutbDeliveryItemText} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     *            OutbDeliveryItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        createOutbDeliveryItemText( @Nonnull final OutbDeliveryItemText outbDeliveryItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     * OutbDeliveryItemText} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     *            OutbDeliveryItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        updateOutbDeliveryItemText( @Nonnull final OutbDeliveryItemText outbDeliveryItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     * OutbDeliveryItemText} entity in the S/4HANA system.
     *
     * @param outbDeliveryItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItemText
     *            OutbDeliveryItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        deleteOutbDeliveryItemText( @Nonnull final OutbDeliveryItemText outbDeliveryItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     * OutbDeliveryHeaderText} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeaderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     *            OutbDeliveryHeaderText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        createOutbDeliveryHeaderText( @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     * OutbDeliveryHeaderText} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeaderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     *            OutbDeliveryHeaderText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        updateOutbDeliveryHeaderText( @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     * OutbDeliveryHeaderText} entity in the S/4HANA system.
     *
     * @param outbDeliveryHeaderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeaderText
     *            OutbDeliveryHeaderText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        deleteOutbDeliveryHeaderText( @Nonnull final OutbDeliveryHeaderText outbDeliveryHeaderText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery
     * HandlingUnitHeaderDelivery} entity and save it to the S/4HANA system.
     *
     * @param handlingUnitHeaderDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery
     *            HandlingUnitHeaderDelivery} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        createHandlingUnitHeaderDelivery( @Nonnull final HandlingUnitHeaderDelivery handlingUnitHeaderDelivery );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery
     * HandlingUnitItemDelivery} entity and save it to the S/4HANA system.
     *
     * @param handlingUnitItemDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery
     *            HandlingUnitItemDelivery} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        createHandlingUnitItemDelivery( @Nonnull final HandlingUnitItemDelivery handlingUnitItemDelivery );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
     * OutbDeliveryAddress2} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryAddress2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
     *            OutbDeliveryAddress2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        updateOutbDeliveryAddress2( @Nonnull final OutbDeliveryAddress2 outbDeliveryAddress2 );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem
     * OutbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem
     *            OutbDeliveryItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet createOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem
     * OutbDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem
     *            OutbDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet updateOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem OutbDeliveryItem}
     * entity in the S/4HANA system.
     *
     * @param outbDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryItem
     *            OutbDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet deleteOutbDeliveryItem( @Nonnull final OutbDeliveryItem outbDeliveryItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     * OutbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        createOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     * OutbDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        updateOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     * OutbDeliveryHeader} entity in the S/4HANA system.
     *
     * @param outbDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryHeader
     *            OutbDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        deleteOutbDeliveryHeader( @Nonnull final OutbDeliveryHeader outbDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow
     * OutbDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param outbDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryDocFlow
     *            OutbDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    OutboundDeliveryV2ServiceBatchChangeSet
        updateOutbDeliveryDocFlow( @Nonnull final OutbDeliveryDocFlow outbDeliveryDocFlow );

}
