/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable.OutbDeliveryAddress2Selectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
 * OutbDeliveryAddress2} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class OutbDeliveryAddress2Link<ObjectT extends VdmObject<?>>
    extends
    EntityLink<OutbDeliveryAddress2Link<ObjectT>, OutbDeliveryAddress2, ObjectT>
    implements
    OutbDeliveryAddress2Selectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public OutbDeliveryAddress2Link( final String fieldName )
    {
        super(fieldName);
    }

    private OutbDeliveryAddress2Link(
        final EntityLink<OutbDeliveryAddress2Link<ObjectT>, OutbDeliveryAddress2, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected OutbDeliveryAddress2Link<ObjectT> translateLinkType(
        final EntityLink<OutbDeliveryAddress2Link<ObjectT>, OutbDeliveryAddress2, ObjectT> link )
    {
        return new OutbDeliveryAddress2Link<ObjectT>(link);
    }

}
