/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery
 * HandlingUnitHeaderDelivery}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.HandlingUnitHeaderDeliveryField
 * HandlingUnitHeaderDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link.HandlingUnitHeaderDeliveryLink
 * HandlingUnitHeaderDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#GROSS_VOLUME
 * GROSS_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#GROSS_WEIGHT
 * GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_BASE_UNIT_OF_MEASURE
 * HANDLING_UNIT_BASE_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_CONTENT_DESCRIPTION
 * HANDLING_UNIT_CONTENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_EXTERNAL_ID
 * HANDLING_UNIT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_EXTERNAL_ID_TYPE
 * HANDLING_UNIT_EXTERNAL_ID_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_HEIGHT
 * HANDLING_UNIT_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_INTERNAL_ID
 * HANDLING_UNIT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_INTERNAL_STATUS
 * HANDLING_UNIT_INTERNAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_LENGTH
 * HANDLING_UNIT_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_LOWER_LEVEL_REFER
 * HANDLING_UNIT_LOWER_LEVEL_REFER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_MAX_VOLUME
 * HANDLING_UNIT_MAX_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_MAX_WEIGHT
 * HANDLING_UNIT_MAX_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_NET_VOLUME
 * HANDLING_UNIT_NET_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_SECOND_EXTERNAL_ID
 * HANDLING_UNIT_SECOND_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_TARE_VOLUME
 * HANDLING_UNIT_TARE_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_TARE_VOLUME_UNIT
 * HANDLING_UNIT_TARE_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_TARE_WEIGHT
 * HANDLING_UNIT_TARE_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_TARE_WEIGHT_UNIT
 * HANDLING_UNIT_TARE_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_UO_M_DIMENSION
 * HANDLING_UNIT_UO_M_DIMENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#HANDLING_UNIT_WIDTH
 * HANDLING_UNIT_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#NET_WEIGHT
 * NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#PACKAGING_MATERIAL
 * PACKAGING_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#PACKAGING_MATERIAL_CATEGORY
 * PACKAGING_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#PACKAGING_MATERIAL_GROUP
 * PACKAGING_MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#PACKAGING_MATERIAL_TYPE
 * PACKAGING_MATERIAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#PACKING_INSTRUCTION_NUMBER
 * PACKING_INSTRUCTION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#SHIPPING_POINT
 * SHIPPING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#WEIGHT_UNIT
 * WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitHeaderDelivery#TO_HANDLING_UNIT_ITEM_DELIVERY
 * TO_HANDLING_UNIT_ITEM_DELIVERY}</li>
 * </ul>
 *
 */
public interface HandlingUnitHeaderDeliverySelectable extends EntitySelectable<HandlingUnitHeaderDelivery>
{

}
