/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery
 * HandlingUnitItemDelivery}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.HandlingUnitItemDeliveryField
 * HandlingUnitItemDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link.HandlingUnitItemDeliveryLink
 * HandlingUnitItemDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#DELIVERY_DOCUMENT_ITEM
 * DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_EXTERNAL_ID
 * HANDLING_UNIT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_INTERNAL_ID
 * HANDLING_UNIT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_ITEM
 * HANDLING_UNIT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_NESTED_INTERNAL_ID
 * HANDLING_UNIT_NESTED_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_NR_OF_AUX_PACKG_MAT
 * HANDLING_UNIT_NR_OF_AUX_PACKG_MAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_NUMBER_OF_SERIALNUMB
 * HANDLING_UNIT_NUMBER_OF_SERIALNUMB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_QUANTITY
 * HANDLING_UNIT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_QUANTITY_UNIT
 * HANDLING_UNIT_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#HANDLING_UNIT_TYPE_OF_CONTENT
 * HANDLING_UNIT_TYPE_OF_CONTENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.HandlingUnitItemDelivery#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * </ul>
 *
 */
public interface HandlingUnitItemDeliverySelectable extends EntitySelectable<HandlingUnitItemDelivery>
{

}
