/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject
 * MaintenanceItemObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.MaintenanceItemObjectField
 * MaintenanceItemObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link.MaintenanceItemObjectLink
 * MaintenanceItemObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#MAINTENANCE_ITEM_OBJECT
 * MAINTENANCE_ITEM_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#MAINTENANCE_ITEM_OBJECT_LIST
 * MAINTENANCE_ITEM_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#MAINTENANCE_NOTIFICATION
 * MAINTENANCE_NOTIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR
 * MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.MaintenanceItemObject#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface MaintenanceItemObjectSelectable extends EntitySelectable<MaintenanceItemObject>
{

}
