/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2
 * OutbDeliveryAddress2}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.field.OutbDeliveryAddress2Field
 * OutbDeliveryAddress2Field} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.link.OutbDeliveryAddress2Link
 * OutbDeliveryAddress2Link}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#DELIVERY_VERSION
 * DELIVERY_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#ADDRESS_TIME_ZONE
 * ADDRESS_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#BUILDING
 * BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#BUSINESS_PARTNER_NAME3
 * BUSINESS_PARTNER_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#BUSINESS_PARTNER_NAME4
 * BUSINESS_PARTNER_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PERSON_FAMILY_NAME
 * PERSON_FAMILY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PERSON_GIVEN_NAME
 * PERSON_GIVEN_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#CARE_OF_NAME
 * CARE_OF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#COMPANY_POSTAL_CODE
 * COMPANY_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#COUNTY
 * COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#DELIVERY_SERVICE_NUMBER
 * DELIVERY_SERVICE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#DELIVERY_SERVICE_TYPE_CODE
 * DELIVERY_SERVICE_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#DISTRICT
 * DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#FAX_NUMBER_EXTENSION
 * FAX_NUMBER_EXTENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#FLOOR
 * FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#HOME_CITY_NAME
 * HOME_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#MOBILE_PHONE_NUMBER
 * MOBILE_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PHONE_NUMBER_EXTENSION
 * PHONE_NUMBER_EXTENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_DEVIATING_CITY_NAME
 * PO_BOX_DEVIATING_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_DEVIATING_COUNTRY
 * PO_BOX_DEVIATING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_DEVIATING_REGION
 * PO_BOX_DEVIATING_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_IS_WITHOUT_NUMBER
 * PO_BOX_IS_WITHOUT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_LOBBY_NAME
 * PO_BOX_LOBBY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#PRFRD_COMM_MEDIUM_TYPE
 * PRFRD_COMM_MEDIUM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.outbounddeliveryv2.OutbDeliveryAddress2#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * </ul>
 *
 */
public interface OutbDeliveryAddress2Selectable extends EntitySelectable<OutbDeliveryAddress2>
{

}
