/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionComponentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable.PackingInstructionComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Packing Instruction Component
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PackingInstructionComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PackingInstructionComponent extends VdmEntity<PackingInstructionComponent>
{

    /**
     * Selector for all available fields of PackingInstructionComponent.
     *
     */
    public final static PackingInstructionComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemSystUUID</b>
     * </p>
     *
     * @return Packing Instruction Component
     */
    @Key
    @SerializedName( "PackingInstructionItemSystUUID" )
    @JsonProperty( "PackingInstructionItemSystUUID" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItemSystUUID" )
    private UUID packingInstructionItemSystUUID;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItemSystUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<UUID> PACKING_INSTRUCTION_ITEM_SYST_UUID =
        new PackingInstructionComponentField<UUID>("PackingInstructionItemSystUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @return Packing Instruction Number
     */
    @SerializedName( "PackingInstructionSystemUUID" )
    @JsonProperty( "PackingInstructionSystemUUID" )
    @Nullable
    @ODataField( odataName = "PackingInstructionSystemUUID" )
    private UUID packingInstructionSystemUUID;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionSystemUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<UUID> PACKING_INSTRUCTION_SYSTEM_UUID =
        new PackingInstructionComponentField<UUID>("PackingInstructionSystemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItem</b>
     * </p>
     *
     * @return Item number
     */
    @SerializedName( "PackingInstructionItem" )
    @JsonProperty( "PackingInstructionItem" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItem" )
    private String packingInstructionItem;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItem</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> PACKING_INSTRUCTION_ITEM =
        new PackingInstructionComponentField<String>("PackingInstructionItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemCategory</b>
     * </p>
     *
     * @return Packing object item category
     */
    @SerializedName( "PackingInstructionItemCategory" )
    @JsonProperty( "PackingInstructionItemCategory" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItemCategory" )
    private String packingInstructionItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItemCategory</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> PACKING_INSTRUCTION_ITEM_CATEGORY =
        new PackingInstructionComponentField<String>("PackingInstructionItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material number of mat. to be packed or of a pack.material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> MATERIAL =
        new PackingInstructionComponentField<String>("Material");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemPackingInstructionSystUUID</b>
     * </p>
     *
     * @return Unique internal packing object number
     */
    @SerializedName( "ItemPackingInstructionSystUUID" )
    @JsonProperty( "ItemPackingInstructionSystUUID" )
    @Nullable
    @ODataField( odataName = "ItemPackingInstructionSystUUID" )
    private UUID itemPackingInstructionSystUUID;
    /**
     * Use with available fluent helpers to apply the <b>ItemPackingInstructionSystUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<UUID> ITEM_PACKING_INSTRUCTION_SYST_UUID =
        new PackingInstructionComponentField<UUID>("ItemPackingInstructionSystUUID");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItmTargetQty</b>
     * </p>
     *
     * @return Target quantity
     */
    @SerializedName( "PackingInstructionItmTargetQty" )
    @JsonProperty( "PackingInstructionItmTargetQty" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItmTargetQty" )
    private BigDecimal packingInstructionItmTargetQty;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItmTargetQty</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<BigDecimal> PACKING_INSTRUCTION_ITM_TARGET_QTY =
        new PackingInstructionComponentField<BigDecimal>("PackingInstructionItmTargetQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemMinQty</b>
     * </p>
     *
     * @return Minimum quantity
     */
    @SerializedName( "PackingInstructionItemMinQty" )
    @JsonProperty( "PackingInstructionItemMinQty" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItemMinQty" )
    private BigDecimal packingInstructionItemMinQty;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItemMinQty</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<BigDecimal> PACKING_INSTRUCTION_ITEM_MIN_QTY =
        new PackingInstructionComponentField<BigDecimal>("PackingInstructionItemMinQty");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemRndQty</b>
     * </p>
     *
     * @return Rounding qty
     */
    @SerializedName( "PackingInstructionItemRndQty" )
    @JsonProperty( "PackingInstructionItemRndQty" )
    @Nullable
    @ODataField( odataName = "PackingInstructionItemRndQty" )
    private BigDecimal packingInstructionItemRndQty;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItemRndQty</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<BigDecimal> PACKING_INSTRUCTION_ITEM_RND_QTY =
        new PackingInstructionComponentField<BigDecimal>("PackingInstructionItemRndQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitofMeasure</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnitofMeasure" )
    @JsonProperty( "BaseUnitofMeasure" )
    @Nullable
    @ODataField( odataName = "BaseUnitofMeasure" )
    private String baseUnitofMeasure;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnitofMeasure</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> BASE_UNITOF_MEASURE =
        new PackingInstructionComponentField<String>("BaseUnitofMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit of measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> UNIT_OF_MEASURE =
        new PackingInstructionComponentField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMixIsAllowed</b>
     * </p>
     *
     * @return Mixed Materials Allowed in Packing for Reference Material
     */
    @SerializedName( "MaterialMixIsAllowed" )
    @JsonProperty( "MaterialMixIsAllowed" )
    @Nullable
    @ODataField( odataName = "MaterialMixIsAllowed" )
    private String materialMixIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>MaterialMixIsAllowed</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<String> MATERIAL_MIX_IS_ALLOWED =
        new PackingInstructionComponentField<String>("MaterialMixIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchMixIsAllowed</b>
     * </p>
     *
     * @return Indicator Batch Mix Allowed
     */
    @SerializedName( "BatchMixIsAllowed" )
    @JsonProperty( "BatchMixIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BatchMixIsAllowed" )
    private Boolean batchMixIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>BatchMixIsAllowed</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<Boolean> BATCH_MIX_IS_ALLOWED =
        new PackingInstructionComponentField<Boolean>("BatchMixIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemIsDel</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "PackingInstructionItemIsDel" )
    @JsonProperty( "PackingInstructionItemIsDel" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PackingInstructionItemIsDel" )
    private Boolean packingInstructionItemIsDel;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionItemIsDel</b> field to query operations.
     *
     */
    public final static PackingInstructionComponentField<Boolean> PACKING_INSTRUCTION_ITEM_IS_DEL =
        new PackingInstructionComponentField<Boolean>("PackingInstructionItemIsDel");
    /**
     * Navigation property <b>to_PackingInstructionHeader</b> for <b>PackingInstructionComponent</b> to single
     * <b>PackingInstructionHeader</b>.
     *
     */
    @SerializedName( "to_PackingInstructionHeader" )
    @JsonProperty( "to_PackingInstructionHeader" )
    @ODataField( odataName = "to_PackingInstructionHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PackingInstructionHeader toPackingInstructionHeader;
    /**
     * Use with available fluent helpers to apply the <b>to_PackingInstructionHeader</b> navigation property to query
     * operations.
     *
     */
    public final static PackingInstructionComponentOneToOneLink<PackingInstructionHeader> TO_PACKING_INSTRUCTION_HEADER =
        new PackingInstructionComponentOneToOneLink<PackingInstructionHeader>("to_PackingInstructionHeader");

    @Nonnull
    @Override
    public Class<PackingInstructionComponent> getType()
    {
        return PackingInstructionComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemSystUUID</b>
     * </p>
     *
     * @param packingInstructionItemSystUUID
     *            Packing Instruction Component
     */
    public void setPackingInstructionItemSystUUID( @Nullable final UUID packingInstructionItemSystUUID )
    {
        rememberChangedField("PackingInstructionItemSystUUID", this.packingInstructionItemSystUUID);
        this.packingInstructionItemSystUUID = packingInstructionItemSystUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @param packingInstructionSystemUUID
     *            Packing Instruction Number
     */
    public void setPackingInstructionSystemUUID( @Nullable final UUID packingInstructionSystemUUID )
    {
        rememberChangedField("PackingInstructionSystemUUID", this.packingInstructionSystemUUID);
        this.packingInstructionSystemUUID = packingInstructionSystemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItem</b>
     * </p>
     *
     * @param packingInstructionItem
     *            Item number
     */
    public void setPackingInstructionItem( @Nullable final String packingInstructionItem )
    {
        rememberChangedField("PackingInstructionItem", this.packingInstructionItem);
        this.packingInstructionItem = packingInstructionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemCategory</b>
     * </p>
     *
     * @param packingInstructionItemCategory
     *            Packing object item category
     */
    public void setPackingInstructionItemCategory( @Nullable final String packingInstructionItemCategory )
    {
        rememberChangedField("PackingInstructionItemCategory", this.packingInstructionItemCategory);
        this.packingInstructionItemCategory = packingInstructionItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material number of mat. to be packed or of a pack.material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemPackingInstructionSystUUID</b>
     * </p>
     *
     * @param itemPackingInstructionSystUUID
     *            Unique internal packing object number
     */
    public void setItemPackingInstructionSystUUID( @Nullable final UUID itemPackingInstructionSystUUID )
    {
        rememberChangedField("ItemPackingInstructionSystUUID", this.itemPackingInstructionSystUUID);
        this.itemPackingInstructionSystUUID = itemPackingInstructionSystUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItmTargetQty</b>
     * </p>
     *
     * @param packingInstructionItmTargetQty
     *            Target quantity
     */
    public void setPackingInstructionItmTargetQty( @Nullable final BigDecimal packingInstructionItmTargetQty )
    {
        rememberChangedField("PackingInstructionItmTargetQty", this.packingInstructionItmTargetQty);
        this.packingInstructionItmTargetQty = packingInstructionItmTargetQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemMinQty</b>
     * </p>
     *
     * @param packingInstructionItemMinQty
     *            Minimum quantity
     */
    public void setPackingInstructionItemMinQty( @Nullable final BigDecimal packingInstructionItemMinQty )
    {
        rememberChangedField("PackingInstructionItemMinQty", this.packingInstructionItemMinQty);
        this.packingInstructionItemMinQty = packingInstructionItemMinQty;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemRndQty</b>
     * </p>
     *
     * @param packingInstructionItemRndQty
     *            Rounding qty
     */
    public void setPackingInstructionItemRndQty( @Nullable final BigDecimal packingInstructionItemRndQty )
    {
        rememberChangedField("PackingInstructionItemRndQty", this.packingInstructionItemRndQty);
        this.packingInstructionItemRndQty = packingInstructionItemRndQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitofMeasure</b>
     * </p>
     *
     * @param baseUnitofMeasure
     *            Base Unit of Measure
     */
    public void setBaseUnitofMeasure( @Nullable final String baseUnitofMeasure )
    {
        rememberChangedField("BaseUnitofMeasure", this.baseUnitofMeasure);
        this.baseUnitofMeasure = baseUnitofMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit of measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMixIsAllowed</b>
     * </p>
     *
     * @param materialMixIsAllowed
     *            Mixed Materials Allowed in Packing for Reference Material
     */
    public void setMaterialMixIsAllowed( @Nullable final String materialMixIsAllowed )
    {
        rememberChangedField("MaterialMixIsAllowed", this.materialMixIsAllowed);
        this.materialMixIsAllowed = materialMixIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchMixIsAllowed</b>
     * </p>
     *
     * @param batchMixIsAllowed
     *            Indicator Batch Mix Allowed
     */
    public void setBatchMixIsAllowed( @Nullable final Boolean batchMixIsAllowed )
    {
        rememberChangedField("BatchMixIsAllowed", this.batchMixIsAllowed);
        this.batchMixIsAllowed = batchMixIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionItemIsDel</b>
     * </p>
     *
     * @param packingInstructionItemIsDel
     *            Deletion Indicator
     */
    public void setPackingInstructionItemIsDel( @Nullable final Boolean packingInstructionItemIsDel )
    {
        rememberChangedField("PackingInstructionItemIsDel", this.packingInstructionItemIsDel);
        this.packingInstructionItemIsDel = packingInstructionItemIsDel;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PackingInstructionComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PackingInstructionItemSystUUID", getPackingInstructionItemSystUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PackingInstructionItemSystUUID", getPackingInstructionItemSystUUID());
        values.put("PackingInstructionSystemUUID", getPackingInstructionSystemUUID());
        values.put("PackingInstructionItem", getPackingInstructionItem());
        values.put("PackingInstructionItemCategory", getPackingInstructionItemCategory());
        values.put("Material", getMaterial());
        values.put("ItemPackingInstructionSystUUID", getItemPackingInstructionSystUUID());
        values.put("PackingInstructionItmTargetQty", getPackingInstructionItmTargetQty());
        values.put("PackingInstructionItemMinQty", getPackingInstructionItemMinQty());
        values.put("PackingInstructionItemRndQty", getPackingInstructionItemRndQty());
        values.put("BaseUnitofMeasure", getBaseUnitofMeasure());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("MaterialMixIsAllowed", getMaterialMixIsAllowed());
        values.put("BatchMixIsAllowed", getBatchMixIsAllowed());
        values.put("PackingInstructionItemIsDel", getPackingInstructionItemIsDel());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PackingInstructionItemSystUUID") ) {
                final Object value = values.remove("PackingInstructionItemSystUUID");
                if( (value == null) || (!value.equals(getPackingInstructionItemSystUUID())) ) {
                    setPackingInstructionItemSystUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionSystemUUID") ) {
                final Object value = values.remove("PackingInstructionSystemUUID");
                if( (value == null) || (!value.equals(getPackingInstructionSystemUUID())) ) {
                    setPackingInstructionSystemUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionItem") ) {
                final Object value = values.remove("PackingInstructionItem");
                if( (value == null) || (!value.equals(getPackingInstructionItem())) ) {
                    setPackingInstructionItem(((String) value));
                }
            }
            if( values.containsKey("PackingInstructionItemCategory") ) {
                final Object value = values.remove("PackingInstructionItemCategory");
                if( (value == null) || (!value.equals(getPackingInstructionItemCategory())) ) {
                    setPackingInstructionItemCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("ItemPackingInstructionSystUUID") ) {
                final Object value = values.remove("ItemPackingInstructionSystUUID");
                if( (value == null) || (!value.equals(getItemPackingInstructionSystUUID())) ) {
                    setItemPackingInstructionSystUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionItmTargetQty") ) {
                final Object value = values.remove("PackingInstructionItmTargetQty");
                if( (value == null) || (!value.equals(getPackingInstructionItmTargetQty())) ) {
                    setPackingInstructionItmTargetQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PackingInstructionItemMinQty") ) {
                final Object value = values.remove("PackingInstructionItemMinQty");
                if( (value == null) || (!value.equals(getPackingInstructionItemMinQty())) ) {
                    setPackingInstructionItemMinQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PackingInstructionItemRndQty") ) {
                final Object value = values.remove("PackingInstructionItemRndQty");
                if( (value == null) || (!value.equals(getPackingInstructionItemRndQty())) ) {
                    setPackingInstructionItemRndQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnitofMeasure") ) {
                final Object value = values.remove("BaseUnitofMeasure");
                if( (value == null) || (!value.equals(getBaseUnitofMeasure())) ) {
                    setBaseUnitofMeasure(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("MaterialMixIsAllowed") ) {
                final Object value = values.remove("MaterialMixIsAllowed");
                if( (value == null) || (!value.equals(getMaterialMixIsAllowed())) ) {
                    setMaterialMixIsAllowed(((String) value));
                }
            }
            if( values.containsKey("BatchMixIsAllowed") ) {
                final Object value = values.remove("BatchMixIsAllowed");
                if( (value == null) || (!value.equals(getBatchMixIsAllowed())) ) {
                    setBatchMixIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("PackingInstructionItemIsDel") ) {
                final Object value = values.remove("PackingInstructionItemIsDel");
                if( (value == null) || (!value.equals(getPackingInstructionItemIsDel())) ) {
                    setPackingInstructionItemIsDel(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PackingInstructionHeader") ) {
                final Object value = (values).remove("to_PackingInstructionHeader");
                if( value instanceof Map ) {
                    if( toPackingInstructionHeader == null ) {
                        toPackingInstructionHeader = new PackingInstructionHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPackingInstructionHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PackingInstructionComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PackingInstructionComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PackingInstructionComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PackingInstructionComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPackingInstructionHeader != null ) {
            (values).put("to_PackingInstructionHeader", toPackingInstructionHeader);
        }
        return values;
    }

    /**
     * Fetches the <b>PackingInstructionHeader</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PackingInstructionHeader</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PackingInstructionHeader fetchPackingInstructionHeader()
    {
        return fetchFieldAsSingle("to_PackingInstructionHeader", PackingInstructionHeader.class);
    }

    /**
     * Retrieval of associated <b>PackingInstructionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionHeader</b> of a queried <b>PackingInstructionComponent</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PackingInstructionHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PackingInstructionHeader getPackingInstructionHeaderOrFetch()
    {
        if( toPackingInstructionHeader == null ) {
            toPackingInstructionHeader = fetchPackingInstructionHeader();
        }
        return toPackingInstructionHeader;
    }

    /**
     * Retrieval of associated <b>PackingInstructionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * If the navigation property for an entity <b>PackingInstructionComponent</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PackingInstructionHeader</b> is already loaded, the
     *         result will contain the <b>PackingInstructionHeader</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PackingInstructionHeader> getPackingInstructionHeaderIfPresent()
    {
        return Option.of(toPackingInstructionHeader);
    }

    /**
     * Overwrites the associated <b>PackingInstructionHeader</b> entity for the loaded navigation property
     * <b>to_PackingInstructionHeader</b>.
     *
     * @param value
     *            New <b>PackingInstructionHeader</b> entity.
     */
    public void setPackingInstructionHeader( final PackingInstructionHeader value )
    {
        toPackingInstructionHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of PackingInstructionComponent instances.
     *
     */
    public final static class PackingInstructionComponentBuilder
    {

        private PackingInstructionHeader toPackingInstructionHeader;

        private PackingInstructionComponent.PackingInstructionComponentBuilder toPackingInstructionHeader(
            final PackingInstructionHeader value )
        {
            toPackingInstructionHeader = value;
            return this;
        }

        /**
         * Navigation property <b>to_PackingInstructionHeader</b> for <b>PackingInstructionComponent</b> to single
         * <b>PackingInstructionHeader</b>.
         *
         * @param value
         *            The PackingInstructionHeader to build this PackingInstructionComponent with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PackingInstructionComponent.PackingInstructionComponentBuilder packingInstructionHeader(
            final PackingInstructionHeader value )
        {
            return toPackingInstructionHeader(value);
        }

    }

}
