/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable.PackingInstructionHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Packing Instruction Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PackingInstructionHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PackingInstructionHeader extends VdmEntity<PackingInstructionHeader>
{

    /**
     * Selector for all available fields of PackingInstructionHeader.
     *
     */
    public final static PackingInstructionHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @return Unique internal packing object number
     */
    @Key
    @SerializedName( "PackingInstructionSystemUUID" )
    @JsonProperty( "PackingInstructionSystemUUID" )
    @Nullable
    @ODataField( odataName = "PackingInstructionSystemUUID" )
    private UUID packingInstructionSystemUUID;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionSystemUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<UUID> PACKING_INSTRUCTION_SYSTEM_UUID =
        new PackingInstructionHeaderField<UUID>("PackingInstructionSystemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionNumber</b>
     * </p>
     *
     * @return Identification number of packing object
     */
    @SerializedName( "PackingInstructionNumber" )
    @JsonProperty( "PackingInstructionNumber" )
    @Nullable
    @ODataField( odataName = "PackingInstructionNumber" )
    private String packingInstructionNumber;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionNumber</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> PACKING_INSTRUCTION_NUMBER =
        new PackingInstructionHeaderField<String>("PackingInstructionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionExternalName</b>
     * </p>
     *
     * @return External name for packing instruction
     */
    @SerializedName( "PackingInstructionExternalName" )
    @JsonProperty( "PackingInstructionExternalName" )
    @Nullable
    @ODataField( odataName = "PackingInstructionExternalName" )
    private String packingInstructionExternalName;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionExternalName</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> PACKING_INSTRUCTION_EXTERNAL_NAME =
        new PackingInstructionHeaderField<String>("PackingInstructionExternalName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @return Height
     */
    @SerializedName( "HandlingUnitHeight" )
    @JsonProperty( "HandlingUnitHeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitHeight" )
    private BigDecimal handlingUnitHeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitHeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_HEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitHeight");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @return Width
     */
    @SerializedName( "HandlingUnitWidth" )
    @JsonProperty( "HandlingUnitWidth" )
    @Nullable
    @ODataField( odataName = "HandlingUnitWidth" )
    private BigDecimal handlingUnitWidth;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitWidth</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_WIDTH =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @return Length
     */
    @SerializedName( "HandlingUnitLength" )
    @JsonProperty( "HandlingUnitLength" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLength" )
    private BigDecimal handlingUnitLength;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLength</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_LENGTH =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitLength");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerHeight</b>
     * </p>
     *
     * @return Height of inside dimensions
     */
    @SerializedName( "HandlingUnitInnerHeight" )
    @JsonProperty( "HandlingUnitInnerHeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInnerHeight" )
    private BigDecimal handlingUnitInnerHeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInnerHeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_INNER_HEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitInnerHeight");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerWidth</b>
     * </p>
     *
     * @return Width of inside measurements
     */
    @SerializedName( "HandlingUnitInnerWidth" )
    @JsonProperty( "HandlingUnitInnerWidth" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInnerWidth" )
    private BigDecimal handlingUnitInnerWidth;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInnerWidth</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_INNER_WIDTH =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitInnerWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerLength</b>
     * </p>
     *
     * @return Length of inside measurements
     */
    @SerializedName( "HandlingUnitInnerLength" )
    @JsonProperty( "HandlingUnitInnerLength" )
    @Nullable
    @ODataField( odataName = "HandlingUnitInnerLength" )
    private BigDecimal handlingUnitInnerLength;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitInnerLength</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_INNER_LENGTH =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitInnerLength");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitUoMDimension</b>
     * </p>
     *
     * @return Unit of dimension for length/width/height
     */
    @SerializedName( "HandlingUnitUoMDimension" )
    @JsonProperty( "HandlingUnitUoMDimension" )
    @Nullable
    @ODataField( odataName = "HandlingUnitUoMDimension" )
    private String handlingUnitUoMDimension;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitUoMDimension</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_UO_M_DIMENSION =
        new PackingInstructionHeaderField<String>("HandlingUnitUoMDimension");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMeasuresAreFixed</b>
     * </p>
     *
     * @return Measurements fix
     */
    @SerializedName( "HandlingUnitMeasuresAreFixed" )
    @JsonProperty( "HandlingUnitMeasuresAreFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HandlingUnitMeasuresAreFixed" )
    private Boolean handlingUnitMeasuresAreFixed;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitMeasuresAreFixed</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Boolean> HANDLING_UNIT_MEASURES_ARE_FIXED =
        new PackingInstructionHeaderField<Boolean>("HandlingUnitMeasuresAreFixed");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGrossVolume</b>
     * </p>
     *
     * @return Total volume of handling unit
     */
    @SerializedName( "HandlingUnitGrossVolume" )
    @JsonProperty( "HandlingUnitGrossVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitGrossVolume" )
    private BigDecimal handlingUnitGrossVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitGrossVolume</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_GROSS_VOLUME =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitGrossVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLoadVolume</b>
     * </p>
     *
     * @return Loading volume of goods to be packed
     */
    @SerializedName( "HandlingUnitLoadVolume" )
    @JsonProperty( "HandlingUnitLoadVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLoadVolume" )
    private BigDecimal handlingUnitLoadVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLoadVolume</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_LOAD_VOLUME =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitLoadVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAllowedLoadVolume</b>
     * </p>
     *
     * @return Allowed loading volume for materials to be packed
     */
    @SerializedName( "HandlingUnitAllowedLoadVolume" )
    @JsonProperty( "HandlingUnitAllowedLoadVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitAllowedLoadVolume" )
    private BigDecimal handlingUnitAllowedLoadVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitAllowedLoadVolume</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_ALLOWED_LOAD_VOLUME =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitAllowedLoadVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitVolumeUnit</b>
     * </p>
     *
     * @return Volume unit
     */
    @SerializedName( "HandlingUnitVolumeUnit" )
    @JsonProperty( "HandlingUnitVolumeUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitVolumeUnit" )
    private String handlingUnitVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitVolumeUnit</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_VOLUME_UNIT =
        new PackingInstructionHeaderField<String>("HandlingUnitVolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @return Tare volume of packaging materials
     */
    @SerializedName( "HandlingUnitTareVolume" )
    @JsonProperty( "HandlingUnitTareVolume" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolume" )
    private BigDecimal handlingUnitTareVolume;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolume</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_TARE_VOLUME =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitTareVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @return Volume unit
     */
    @SerializedName( "HandlingUnitTareVolumeUnit" )
    @JsonProperty( "HandlingUnitTareVolumeUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareVolumeUnit" )
    private String handlingUnitTareVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareVolumeUnit</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_TARE_VOLUME_UNIT =
        new PackingInstructionHeaderField<String>("HandlingUnitTareVolumeUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitVolumesAreFixed</b>
     * </p>
     *
     * @return Volume fix
     */
    @SerializedName( "HandlingUnitVolumesAreFixed" )
    @JsonProperty( "HandlingUnitVolumesAreFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HandlingUnitVolumesAreFixed" )
    private Boolean handlingUnitVolumesAreFixed;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitVolumesAreFixed</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Boolean> HANDLING_UNIT_VOLUMES_ARE_FIXED =
        new PackingInstructionHeaderField<Boolean>("HandlingUnitVolumesAreFixed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExcessVolumeToleranceValue</b>
     * </p>
     *
     * @return Excess Volume Tolerance of the Handling Unit
     */
    @SerializedName( "ExcessVolumeToleranceValue" )
    @JsonProperty( "ExcessVolumeToleranceValue" )
    @Nullable
    @ODataField( odataName = "ExcessVolumeToleranceValue" )
    private BigDecimal excessVolumeToleranceValue;
    /**
     * Use with available fluent helpers to apply the <b>ExcessVolumeToleranceValue</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> EXCESS_VOLUME_TOLERANCE_VALUE =
        new PackingInstructionHeaderField<BigDecimal>("ExcessVolumeToleranceValue");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGrossWeight</b>
     * </p>
     *
     * @return Total weight of handling unit
     */
    @SerializedName( "HandlingUnitGrossWeight" )
    @JsonProperty( "HandlingUnitGrossWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitGrossWeight" )
    private BigDecimal handlingUnitGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitGrossWeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_GROSS_WEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLoadWeight</b>
     * </p>
     *
     * @return Loading Weight of Goods to Be Packed
     */
    @SerializedName( "HandlingUnitLoadWeight" )
    @JsonProperty( "HandlingUnitLoadWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitLoadWeight" )
    private BigDecimal handlingUnitLoadWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitLoadWeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_LOAD_WEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitLoadWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAllowedLoadWeight</b>
     * </p>
     *
     * @return Allowed Loading Weight
     */
    @SerializedName( "HandlingUnitAllowedLoadWeight" )
    @JsonProperty( "HandlingUnitAllowedLoadWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitAllowedLoadWeight" )
    private BigDecimal handlingUnitAllowedLoadWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitAllowedLoadWeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_ALLOWED_LOAD_WEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitAllowedLoadWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWeightUnit</b>
     * </p>
     *
     * @return Unit of weight
     */
    @SerializedName( "HandlingUnitWeightUnit" )
    @JsonProperty( "HandlingUnitWeightUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitWeightUnit" )
    private String handlingUnitWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitWeightUnit</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_WEIGHT_UNIT =
        new PackingInstructionHeaderField<String>("HandlingUnitWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @return Tare weight of packaging materials
     */
    @SerializedName( "HandlingUnitTareWeight" )
    @JsonProperty( "HandlingUnitTareWeight" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeight" )
    private BigDecimal handlingUnitTareWeight;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeight</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> HANDLING_UNIT_TARE_WEIGHT =
        new PackingInstructionHeaderField<BigDecimal>("HandlingUnitTareWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @return Unit of weight
     */
    @SerializedName( "HandlingUnitTareWeightUnit" )
    @JsonProperty( "HandlingUnitTareWeightUnit" )
    @Nullable
    @ODataField( odataName = "HandlingUnitTareWeightUnit" )
    private String handlingUnitTareWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitTareWeightUnit</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_TARE_WEIGHT_UNIT =
        new PackingInstructionHeaderField<String>("HandlingUnitTareWeightUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWeightsAreFixed</b>
     * </p>
     *
     * @return Weights fix
     */
    @SerializedName( "HandlingUnitWeightsAreFixed" )
    @JsonProperty( "HandlingUnitWeightsAreFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HandlingUnitWeightsAreFixed" )
    private Boolean handlingUnitWeightsAreFixed;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitWeightsAreFixed</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Boolean> HANDLING_UNIT_WEIGHTS_ARE_FIXED =
        new PackingInstructionHeaderField<Boolean>("HandlingUnitWeightsAreFixed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExcessWeightToleranceValue</b>
     * </p>
     *
     * @return Excess Weight Tolerance for Handling unit
     */
    @SerializedName( "ExcessWeightToleranceValue" )
    @JsonProperty( "ExcessWeightToleranceValue" )
    @Nullable
    @ODataField( odataName = "ExcessWeightToleranceValue" )
    private BigDecimal excessWeightToleranceValue;
    /**
     * Use with available fluent helpers to apply the <b>ExcessWeightToleranceValue</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> EXCESS_WEIGHT_TOLERANCE_VALUE =
        new PackingInstructionHeaderField<BigDecimal>("ExcessWeightToleranceValue");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionAllwdLoadQty</b>
     * </p>
     *
     * @return Allowed Load
     */
    @SerializedName( "PackingInstructionAllwdLoadQty" )
    @JsonProperty( "PackingInstructionAllwdLoadQty" )
    @Nullable
    @ODataField( odataName = "PackingInstructionAllwdLoadQty" )
    private BigDecimal packingInstructionAllwdLoadQty;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionAllwdLoadQty</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<BigDecimal> PACKING_INSTRUCTION_ALLWD_LOAD_QTY =
        new PackingInstructionHeaderField<BigDecimal>("PackingInstructionAllwdLoadQty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitIsClosed</b>
     * </p>
     *
     * @return Indicator: packaging closed
     */
    @SerializedName( "HandlingUnitIsClosed" )
    @JsonProperty( "HandlingUnitIsClosed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "HandlingUnitIsClosed" )
    private Boolean handlingUnitIsClosed;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitIsClosed</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Boolean> HANDLING_UNIT_IS_CLOSED =
        new PackingInstructionHeaderField<Boolean>("HandlingUnitIsClosed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LoadCarrierSystUUID</b>
     * </p>
     *
     * @return Packing Instruction Component
     */
    @SerializedName( "LoadCarrierSystUUID" )
    @JsonProperty( "LoadCarrierSystUUID" )
    @Nullable
    @ODataField( odataName = "LoadCarrierSystUUID" )
    private UUID loadCarrierSystUUID;
    /**
     * Use with available fluent helpers to apply the <b>LoadCarrierSystUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<UUID> LOAD_CARRIER_SYST_UUID =
        new PackingInstructionHeaderField<UUID>("LoadCarrierSystUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "PackingInstructionIsDeleted" )
    @JsonProperty( "PackingInstructionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PackingInstructionIsDeleted" )
    private Boolean packingInstructionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionIsDeleted</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Boolean> PACKING_INSTRUCTION_IS_DELETED =
        new PackingInstructionHeaderField<Boolean>("PackingInstructionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionCheckProfSts</b>
     * </p>
     *
     * @return Packing status check profile
     */
    @SerializedName( "PackingInstructionCheckProfSts" )
    @JsonProperty( "PackingInstructionCheckProfSts" )
    @Nullable
    @ODataField( odataName = "PackingInstructionCheckProfSts" )
    private String packingInstructionCheckProfSts;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionCheckProfSts</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> PACKING_INSTRUCTION_CHECK_PROF_STS =
        new PackingInstructionHeaderField<String>("PackingInstructionCheckProfSts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StackingFactor</b>
     * </p>
     *
     * @return Stacking factor
     */
    @SerializedName( "StackingFactor" )
    @JsonProperty( "StackingFactor" )
    @Nullable
    @ODataField( odataName = "StackingFactor" )
    private Short stackingFactor;
    /**
     * Use with available fluent helpers to apply the <b>StackingFactor</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<Short> STACKING_FACTOR =
        new PackingInstructionHeaderField<Short>("StackingFactor");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @return Handling Unit Type
     */
    @SerializedName( "HandlingUnitType" )
    @JsonProperty( "HandlingUnitType" )
    @Nullable
    @ODataField( odataName = "HandlingUnitType" )
    private String handlingUnitType;
    /**
     * Use with available fluent helpers to apply the <b>HandlingUnitType</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> HANDLING_UNIT_TYPE =
        new PackingInstructionHeaderField<String>("HandlingUnitType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Person responsible, create
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> CREATED_BY_USER =
        new PackingInstructionHeaderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created on
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<LocalDateTime> CREATION_DATE =
        new PackingInstructionHeaderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Person responsible, change
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<String> LAST_CHANGED_BY_USER =
        new PackingInstructionHeaderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date of last change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<LocalDateTime> LAST_CHANGE_DATE =
        new PackingInstructionHeaderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time last change was made
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static PackingInstructionHeaderField<LocalTime> LAST_CHANGE_TIME =
        new PackingInstructionHeaderField<LocalTime>("LastChangeTime");
    /**
     * Navigation property <b>to_PackingInstructionComponent</b> for <b>PackingInstructionHeader</b> to multiple
     * <b>PackingInstructionComponent</b>.
     *
     */
    @SerializedName( "to_PackingInstructionComponent" )
    @JsonProperty( "to_PackingInstructionComponent" )
    @ODataField( odataName = "to_PackingInstructionComponent" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PackingInstructionComponent> toPackingInstructionComponent;
    /**
     * Navigation property <b>to_PackingInstructionText</b> for <b>PackingInstructionHeader</b> to multiple
     * <b>PackingInstructionText</b>.
     *
     */
    @SerializedName( "to_PackingInstructionText" )
    @JsonProperty( "to_PackingInstructionText" )
    @ODataField( odataName = "to_PackingInstructionText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PackingInstructionText> toPackingInstructionText;
    /**
     * Use with available fluent helpers to apply the <b>to_PackingInstructionComponent</b> navigation property to query
     * operations.
     *
     */
    public final static PackingInstructionHeaderLink<PackingInstructionComponent> TO_PACKING_INSTRUCTION_COMPONENT =
        new PackingInstructionHeaderLink<PackingInstructionComponent>("to_PackingInstructionComponent");
    /**
     * Use with available fluent helpers to apply the <b>to_PackingInstructionText</b> navigation property to query
     * operations.
     *
     */
    public final static PackingInstructionHeaderLink<PackingInstructionText> TO_PACKING_INSTRUCTION_TEXT =
        new PackingInstructionHeaderLink<PackingInstructionText>("to_PackingInstructionText");

    @Nonnull
    @Override
    public Class<PackingInstructionHeader> getType()
    {
        return PackingInstructionHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @param packingInstructionSystemUUID
     *            Unique internal packing object number
     */
    public void setPackingInstructionSystemUUID( @Nullable final UUID packingInstructionSystemUUID )
    {
        rememberChangedField("PackingInstructionSystemUUID", this.packingInstructionSystemUUID);
        this.packingInstructionSystemUUID = packingInstructionSystemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionNumber</b>
     * </p>
     *
     * @param packingInstructionNumber
     *            Identification number of packing object
     */
    public void setPackingInstructionNumber( @Nullable final String packingInstructionNumber )
    {
        rememberChangedField("PackingInstructionNumber", this.packingInstructionNumber);
        this.packingInstructionNumber = packingInstructionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionExternalName</b>
     * </p>
     *
     * @param packingInstructionExternalName
     *            External name for packing instruction
     */
    public void setPackingInstructionExternalName( @Nullable final String packingInstructionExternalName )
    {
        rememberChangedField("PackingInstructionExternalName", this.packingInstructionExternalName);
        this.packingInstructionExternalName = packingInstructionExternalName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     *
     * @param handlingUnitHeight
     *            Height
     */
    public void setHandlingUnitHeight( @Nullable final BigDecimal handlingUnitHeight )
    {
        rememberChangedField("HandlingUnitHeight", this.handlingUnitHeight);
        this.handlingUnitHeight = handlingUnitHeight;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     *
     * @param handlingUnitWidth
     *            Width
     */
    public void setHandlingUnitWidth( @Nullable final BigDecimal handlingUnitWidth )
    {
        rememberChangedField("HandlingUnitWidth", this.handlingUnitWidth);
        this.handlingUnitWidth = handlingUnitWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     *
     * @param handlingUnitLength
     *            Length
     */
    public void setHandlingUnitLength( @Nullable final BigDecimal handlingUnitLength )
    {
        rememberChangedField("HandlingUnitLength", this.handlingUnitLength);
        this.handlingUnitLength = handlingUnitLength;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerHeight</b>
     * </p>
     *
     * @param handlingUnitInnerHeight
     *            Height of inside dimensions
     */
    public void setHandlingUnitInnerHeight( @Nullable final BigDecimal handlingUnitInnerHeight )
    {
        rememberChangedField("HandlingUnitInnerHeight", this.handlingUnitInnerHeight);
        this.handlingUnitInnerHeight = handlingUnitInnerHeight;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerWidth</b>
     * </p>
     *
     * @param handlingUnitInnerWidth
     *            Width of inside measurements
     */
    public void setHandlingUnitInnerWidth( @Nullable final BigDecimal handlingUnitInnerWidth )
    {
        rememberChangedField("HandlingUnitInnerWidth", this.handlingUnitInnerWidth);
        this.handlingUnitInnerWidth = handlingUnitInnerWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInnerLength</b>
     * </p>
     *
     * @param handlingUnitInnerLength
     *            Length of inside measurements
     */
    public void setHandlingUnitInnerLength( @Nullable final BigDecimal handlingUnitInnerLength )
    {
        rememberChangedField("HandlingUnitInnerLength", this.handlingUnitInnerLength);
        this.handlingUnitInnerLength = handlingUnitInnerLength;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitUoMDimension</b>
     * </p>
     *
     * @param handlingUnitUoMDimension
     *            Unit of dimension for length/width/height
     */
    public void setHandlingUnitUoMDimension( @Nullable final String handlingUnitUoMDimension )
    {
        rememberChangedField("HandlingUnitUoMDimension", this.handlingUnitUoMDimension);
        this.handlingUnitUoMDimension = handlingUnitUoMDimension;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMeasuresAreFixed</b>
     * </p>
     *
     * @param handlingUnitMeasuresAreFixed
     *            Measurements fix
     */
    public void setHandlingUnitMeasuresAreFixed( @Nullable final Boolean handlingUnitMeasuresAreFixed )
    {
        rememberChangedField("HandlingUnitMeasuresAreFixed", this.handlingUnitMeasuresAreFixed);
        this.handlingUnitMeasuresAreFixed = handlingUnitMeasuresAreFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGrossVolume</b>
     * </p>
     *
     * @param handlingUnitGrossVolume
     *            Total volume of handling unit
     */
    public void setHandlingUnitGrossVolume( @Nullable final BigDecimal handlingUnitGrossVolume )
    {
        rememberChangedField("HandlingUnitGrossVolume", this.handlingUnitGrossVolume);
        this.handlingUnitGrossVolume = handlingUnitGrossVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLoadVolume</b>
     * </p>
     *
     * @param handlingUnitLoadVolume
     *            Loading volume of goods to be packed
     */
    public void setHandlingUnitLoadVolume( @Nullable final BigDecimal handlingUnitLoadVolume )
    {
        rememberChangedField("HandlingUnitLoadVolume", this.handlingUnitLoadVolume);
        this.handlingUnitLoadVolume = handlingUnitLoadVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAllowedLoadVolume</b>
     * </p>
     *
     * @param handlingUnitAllowedLoadVolume
     *            Allowed loading volume for materials to be packed
     */
    public void setHandlingUnitAllowedLoadVolume( @Nullable final BigDecimal handlingUnitAllowedLoadVolume )
    {
        rememberChangedField("HandlingUnitAllowedLoadVolume", this.handlingUnitAllowedLoadVolume);
        this.handlingUnitAllowedLoadVolume = handlingUnitAllowedLoadVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitVolumeUnit</b>
     * </p>
     *
     * @param handlingUnitVolumeUnit
     *            Volume unit
     */
    public void setHandlingUnitVolumeUnit( @Nullable final String handlingUnitVolumeUnit )
    {
        rememberChangedField("HandlingUnitVolumeUnit", this.handlingUnitVolumeUnit);
        this.handlingUnitVolumeUnit = handlingUnitVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     *
     * @param handlingUnitTareVolume
     *            Tare volume of packaging materials
     */
    public void setHandlingUnitTareVolume( @Nullable final BigDecimal handlingUnitTareVolume )
    {
        rememberChangedField("HandlingUnitTareVolume", this.handlingUnitTareVolume);
        this.handlingUnitTareVolume = handlingUnitTareVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     *
     * @param handlingUnitTareVolumeUnit
     *            Volume unit
     */
    public void setHandlingUnitTareVolumeUnit( @Nullable final String handlingUnitTareVolumeUnit )
    {
        rememberChangedField("HandlingUnitTareVolumeUnit", this.handlingUnitTareVolumeUnit);
        this.handlingUnitTareVolumeUnit = handlingUnitTareVolumeUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitVolumesAreFixed</b>
     * </p>
     *
     * @param handlingUnitVolumesAreFixed
     *            Volume fix
     */
    public void setHandlingUnitVolumesAreFixed( @Nullable final Boolean handlingUnitVolumesAreFixed )
    {
        rememberChangedField("HandlingUnitVolumesAreFixed", this.handlingUnitVolumesAreFixed);
        this.handlingUnitVolumesAreFixed = handlingUnitVolumesAreFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExcessVolumeToleranceValue</b>
     * </p>
     *
     * @param excessVolumeToleranceValue
     *            Excess Volume Tolerance of the Handling Unit
     */
    public void setExcessVolumeToleranceValue( @Nullable final BigDecimal excessVolumeToleranceValue )
    {
        rememberChangedField("ExcessVolumeToleranceValue", this.excessVolumeToleranceValue);
        this.excessVolumeToleranceValue = excessVolumeToleranceValue;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitGrossWeight</b>
     * </p>
     *
     * @param handlingUnitGrossWeight
     *            Total weight of handling unit
     */
    public void setHandlingUnitGrossWeight( @Nullable final BigDecimal handlingUnitGrossWeight )
    {
        rememberChangedField("HandlingUnitGrossWeight", this.handlingUnitGrossWeight);
        this.handlingUnitGrossWeight = handlingUnitGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLoadWeight</b>
     * </p>
     *
     * @param handlingUnitLoadWeight
     *            Loading Weight of Goods to Be Packed
     */
    public void setHandlingUnitLoadWeight( @Nullable final BigDecimal handlingUnitLoadWeight )
    {
        rememberChangedField("HandlingUnitLoadWeight", this.handlingUnitLoadWeight);
        this.handlingUnitLoadWeight = handlingUnitLoadWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAllowedLoadWeight</b>
     * </p>
     *
     * @param handlingUnitAllowedLoadWeight
     *            Allowed Loading Weight
     */
    public void setHandlingUnitAllowedLoadWeight( @Nullable final BigDecimal handlingUnitAllowedLoadWeight )
    {
        rememberChangedField("HandlingUnitAllowedLoadWeight", this.handlingUnitAllowedLoadWeight);
        this.handlingUnitAllowedLoadWeight = handlingUnitAllowedLoadWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWeightUnit</b>
     * </p>
     *
     * @param handlingUnitWeightUnit
     *            Unit of weight
     */
    public void setHandlingUnitWeightUnit( @Nullable final String handlingUnitWeightUnit )
    {
        rememberChangedField("HandlingUnitWeightUnit", this.handlingUnitWeightUnit);
        this.handlingUnitWeightUnit = handlingUnitWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     *
     * @param handlingUnitTareWeight
     *            Tare weight of packaging materials
     */
    public void setHandlingUnitTareWeight( @Nullable final BigDecimal handlingUnitTareWeight )
    {
        rememberChangedField("HandlingUnitTareWeight", this.handlingUnitTareWeight);
        this.handlingUnitTareWeight = handlingUnitTareWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     *
     * @param handlingUnitTareWeightUnit
     *            Unit of weight
     */
    public void setHandlingUnitTareWeightUnit( @Nullable final String handlingUnitTareWeightUnit )
    {
        rememberChangedField("HandlingUnitTareWeightUnit", this.handlingUnitTareWeightUnit);
        this.handlingUnitTareWeightUnit = handlingUnitTareWeightUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWeightsAreFixed</b>
     * </p>
     *
     * @param handlingUnitWeightsAreFixed
     *            Weights fix
     */
    public void setHandlingUnitWeightsAreFixed( @Nullable final Boolean handlingUnitWeightsAreFixed )
    {
        rememberChangedField("HandlingUnitWeightsAreFixed", this.handlingUnitWeightsAreFixed);
        this.handlingUnitWeightsAreFixed = handlingUnitWeightsAreFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExcessWeightToleranceValue</b>
     * </p>
     *
     * @param excessWeightToleranceValue
     *            Excess Weight Tolerance for Handling unit
     */
    public void setExcessWeightToleranceValue( @Nullable final BigDecimal excessWeightToleranceValue )
    {
        rememberChangedField("ExcessWeightToleranceValue", this.excessWeightToleranceValue);
        this.excessWeightToleranceValue = excessWeightToleranceValue;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionAllwdLoadQty</b>
     * </p>
     *
     * @param packingInstructionAllwdLoadQty
     *            Allowed Load
     */
    public void setPackingInstructionAllwdLoadQty( @Nullable final BigDecimal packingInstructionAllwdLoadQty )
    {
        rememberChangedField("PackingInstructionAllwdLoadQty", this.packingInstructionAllwdLoadQty);
        this.packingInstructionAllwdLoadQty = packingInstructionAllwdLoadQty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitIsClosed</b>
     * </p>
     *
     * @param handlingUnitIsClosed
     *            Indicator: packaging closed
     */
    public void setHandlingUnitIsClosed( @Nullable final Boolean handlingUnitIsClosed )
    {
        rememberChangedField("HandlingUnitIsClosed", this.handlingUnitIsClosed);
        this.handlingUnitIsClosed = handlingUnitIsClosed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LoadCarrierSystUUID</b>
     * </p>
     *
     * @param loadCarrierSystUUID
     *            Packing Instruction Component
     */
    public void setLoadCarrierSystUUID( @Nullable final UUID loadCarrierSystUUID )
    {
        rememberChangedField("LoadCarrierSystUUID", this.loadCarrierSystUUID);
        this.loadCarrierSystUUID = loadCarrierSystUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionIsDeleted</b>
     * </p>
     *
     * @param packingInstructionIsDeleted
     *            Deletion Indicator
     */
    public void setPackingInstructionIsDeleted( @Nullable final Boolean packingInstructionIsDeleted )
    {
        rememberChangedField("PackingInstructionIsDeleted", this.packingInstructionIsDeleted);
        this.packingInstructionIsDeleted = packingInstructionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionCheckProfSts</b>
     * </p>
     *
     * @param packingInstructionCheckProfSts
     *            Packing status check profile
     */
    public void setPackingInstructionCheckProfSts( @Nullable final String packingInstructionCheckProfSts )
    {
        rememberChangedField("PackingInstructionCheckProfSts", this.packingInstructionCheckProfSts);
        this.packingInstructionCheckProfSts = packingInstructionCheckProfSts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StackingFactor</b>
     * </p>
     *
     * @param stackingFactor
     *            Stacking factor
     */
    public void setStackingFactor( @Nullable final Short stackingFactor )
    {
        rememberChangedField("StackingFactor", this.stackingFactor);
        this.stackingFactor = stackingFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitType</b>
     * </p>
     *
     * @param handlingUnitType
     *            Handling Unit Type
     */
    public void setHandlingUnitType( @Nullable final String handlingUnitType )
    {
        rememberChangedField("HandlingUnitType", this.handlingUnitType);
        this.handlingUnitType = handlingUnitType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Person responsible, create
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created on
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Person responsible, change
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date of last change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time last change was made
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PackingInstructionHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PackingInstructionSystemUUID", getPackingInstructionSystemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PackingInstructionSystemUUID", getPackingInstructionSystemUUID());
        values.put("PackingInstructionNumber", getPackingInstructionNumber());
        values.put("PackingInstructionExternalName", getPackingInstructionExternalName());
        values.put("HandlingUnitHeight", getHandlingUnitHeight());
        values.put("HandlingUnitWidth", getHandlingUnitWidth());
        values.put("HandlingUnitLength", getHandlingUnitLength());
        values.put("HandlingUnitInnerHeight", getHandlingUnitInnerHeight());
        values.put("HandlingUnitInnerWidth", getHandlingUnitInnerWidth());
        values.put("HandlingUnitInnerLength", getHandlingUnitInnerLength());
        values.put("HandlingUnitUoMDimension", getHandlingUnitUoMDimension());
        values.put("HandlingUnitMeasuresAreFixed", getHandlingUnitMeasuresAreFixed());
        values.put("HandlingUnitGrossVolume", getHandlingUnitGrossVolume());
        values.put("HandlingUnitLoadVolume", getHandlingUnitLoadVolume());
        values.put("HandlingUnitAllowedLoadVolume", getHandlingUnitAllowedLoadVolume());
        values.put("HandlingUnitVolumeUnit", getHandlingUnitVolumeUnit());
        values.put("HandlingUnitTareVolume", getHandlingUnitTareVolume());
        values.put("HandlingUnitTareVolumeUnit", getHandlingUnitTareVolumeUnit());
        values.put("HandlingUnitVolumesAreFixed", getHandlingUnitVolumesAreFixed());
        values.put("ExcessVolumeToleranceValue", getExcessVolumeToleranceValue());
        values.put("HandlingUnitGrossWeight", getHandlingUnitGrossWeight());
        values.put("HandlingUnitLoadWeight", getHandlingUnitLoadWeight());
        values.put("HandlingUnitAllowedLoadWeight", getHandlingUnitAllowedLoadWeight());
        values.put("HandlingUnitWeightUnit", getHandlingUnitWeightUnit());
        values.put("HandlingUnitTareWeight", getHandlingUnitTareWeight());
        values.put("HandlingUnitTareWeightUnit", getHandlingUnitTareWeightUnit());
        values.put("HandlingUnitWeightsAreFixed", getHandlingUnitWeightsAreFixed());
        values.put("ExcessWeightToleranceValue", getExcessWeightToleranceValue());
        values.put("PackingInstructionAllwdLoadQty", getPackingInstructionAllwdLoadQty());
        values.put("HandlingUnitIsClosed", getHandlingUnitIsClosed());
        values.put("LoadCarrierSystUUID", getLoadCarrierSystUUID());
        values.put("PackingInstructionIsDeleted", getPackingInstructionIsDeleted());
        values.put("PackingInstructionCheckProfSts", getPackingInstructionCheckProfSts());
        values.put("StackingFactor", getStackingFactor());
        values.put("HandlingUnitType", getHandlingUnitType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PackingInstructionSystemUUID") ) {
                final Object value = values.remove("PackingInstructionSystemUUID");
                if( (value == null) || (!value.equals(getPackingInstructionSystemUUID())) ) {
                    setPackingInstructionSystemUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionNumber") ) {
                final Object value = values.remove("PackingInstructionNumber");
                if( (value == null) || (!value.equals(getPackingInstructionNumber())) ) {
                    setPackingInstructionNumber(((String) value));
                }
            }
            if( values.containsKey("PackingInstructionExternalName") ) {
                final Object value = values.remove("PackingInstructionExternalName");
                if( (value == null) || (!value.equals(getPackingInstructionExternalName())) ) {
                    setPackingInstructionExternalName(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitHeight") ) {
                final Object value = values.remove("HandlingUnitHeight");
                if( (value == null) || (!value.equals(getHandlingUnitHeight())) ) {
                    setHandlingUnitHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitWidth") ) {
                final Object value = values.remove("HandlingUnitWidth");
                if( (value == null) || (!value.equals(getHandlingUnitWidth())) ) {
                    setHandlingUnitWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitLength") ) {
                final Object value = values.remove("HandlingUnitLength");
                if( (value == null) || (!value.equals(getHandlingUnitLength())) ) {
                    setHandlingUnitLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitInnerHeight") ) {
                final Object value = values.remove("HandlingUnitInnerHeight");
                if( (value == null) || (!value.equals(getHandlingUnitInnerHeight())) ) {
                    setHandlingUnitInnerHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitInnerWidth") ) {
                final Object value = values.remove("HandlingUnitInnerWidth");
                if( (value == null) || (!value.equals(getHandlingUnitInnerWidth())) ) {
                    setHandlingUnitInnerWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitInnerLength") ) {
                final Object value = values.remove("HandlingUnitInnerLength");
                if( (value == null) || (!value.equals(getHandlingUnitInnerLength())) ) {
                    setHandlingUnitInnerLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitUoMDimension") ) {
                final Object value = values.remove("HandlingUnitUoMDimension");
                if( (value == null) || (!value.equals(getHandlingUnitUoMDimension())) ) {
                    setHandlingUnitUoMDimension(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitMeasuresAreFixed") ) {
                final Object value = values.remove("HandlingUnitMeasuresAreFixed");
                if( (value == null) || (!value.equals(getHandlingUnitMeasuresAreFixed())) ) {
                    setHandlingUnitMeasuresAreFixed(((Boolean) value));
                }
            }
            if( values.containsKey("HandlingUnitGrossVolume") ) {
                final Object value = values.remove("HandlingUnitGrossVolume");
                if( (value == null) || (!value.equals(getHandlingUnitGrossVolume())) ) {
                    setHandlingUnitGrossVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitLoadVolume") ) {
                final Object value = values.remove("HandlingUnitLoadVolume");
                if( (value == null) || (!value.equals(getHandlingUnitLoadVolume())) ) {
                    setHandlingUnitLoadVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitAllowedLoadVolume") ) {
                final Object value = values.remove("HandlingUnitAllowedLoadVolume");
                if( (value == null) || (!value.equals(getHandlingUnitAllowedLoadVolume())) ) {
                    setHandlingUnitAllowedLoadVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitVolumeUnit") ) {
                final Object value = values.remove("HandlingUnitVolumeUnit");
                if( (value == null) || (!value.equals(getHandlingUnitVolumeUnit())) ) {
                    setHandlingUnitVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolume") ) {
                final Object value = values.remove("HandlingUnitTareVolume");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolume())) ) {
                    setHandlingUnitTareVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolumeUnit") ) {
                final Object value = values.remove("HandlingUnitTareVolumeUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolumeUnit())) ) {
                    setHandlingUnitTareVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitVolumesAreFixed") ) {
                final Object value = values.remove("HandlingUnitVolumesAreFixed");
                if( (value == null) || (!value.equals(getHandlingUnitVolumesAreFixed())) ) {
                    setHandlingUnitVolumesAreFixed(((Boolean) value));
                }
            }
            if( values.containsKey("ExcessVolumeToleranceValue") ) {
                final Object value = values.remove("ExcessVolumeToleranceValue");
                if( (value == null) || (!value.equals(getExcessVolumeToleranceValue())) ) {
                    setExcessVolumeToleranceValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitGrossWeight") ) {
                final Object value = values.remove("HandlingUnitGrossWeight");
                if( (value == null) || (!value.equals(getHandlingUnitGrossWeight())) ) {
                    setHandlingUnitGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitLoadWeight") ) {
                final Object value = values.remove("HandlingUnitLoadWeight");
                if( (value == null) || (!value.equals(getHandlingUnitLoadWeight())) ) {
                    setHandlingUnitLoadWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitAllowedLoadWeight") ) {
                final Object value = values.remove("HandlingUnitAllowedLoadWeight");
                if( (value == null) || (!value.equals(getHandlingUnitAllowedLoadWeight())) ) {
                    setHandlingUnitAllowedLoadWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitWeightUnit") ) {
                final Object value = values.remove("HandlingUnitWeightUnit");
                if( (value == null) || (!value.equals(getHandlingUnitWeightUnit())) ) {
                    setHandlingUnitWeightUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeight") ) {
                final Object value = values.remove("HandlingUnitTareWeight");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeight())) ) {
                    setHandlingUnitTareWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeightUnit") ) {
                final Object value = values.remove("HandlingUnitTareWeightUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeightUnit())) ) {
                    setHandlingUnitTareWeightUnit(((String) value));
                }
            }
            if( values.containsKey("HandlingUnitWeightsAreFixed") ) {
                final Object value = values.remove("HandlingUnitWeightsAreFixed");
                if( (value == null) || (!value.equals(getHandlingUnitWeightsAreFixed())) ) {
                    setHandlingUnitWeightsAreFixed(((Boolean) value));
                }
            }
            if( values.containsKey("ExcessWeightToleranceValue") ) {
                final Object value = values.remove("ExcessWeightToleranceValue");
                if( (value == null) || (!value.equals(getExcessWeightToleranceValue())) ) {
                    setExcessWeightToleranceValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("PackingInstructionAllwdLoadQty") ) {
                final Object value = values.remove("PackingInstructionAllwdLoadQty");
                if( (value == null) || (!value.equals(getPackingInstructionAllwdLoadQty())) ) {
                    setPackingInstructionAllwdLoadQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitIsClosed") ) {
                final Object value = values.remove("HandlingUnitIsClosed");
                if( (value == null) || (!value.equals(getHandlingUnitIsClosed())) ) {
                    setHandlingUnitIsClosed(((Boolean) value));
                }
            }
            if( values.containsKey("LoadCarrierSystUUID") ) {
                final Object value = values.remove("LoadCarrierSystUUID");
                if( (value == null) || (!value.equals(getLoadCarrierSystUUID())) ) {
                    setLoadCarrierSystUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionIsDeleted") ) {
                final Object value = values.remove("PackingInstructionIsDeleted");
                if( (value == null) || (!value.equals(getPackingInstructionIsDeleted())) ) {
                    setPackingInstructionIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PackingInstructionCheckProfSts") ) {
                final Object value = values.remove("PackingInstructionCheckProfSts");
                if( (value == null) || (!value.equals(getPackingInstructionCheckProfSts())) ) {
                    setPackingInstructionCheckProfSts(((String) value));
                }
            }
            if( values.containsKey("StackingFactor") ) {
                final Object value = values.remove("StackingFactor");
                if( (value == null) || (!value.equals(getStackingFactor())) ) {
                    setStackingFactor(((Short) value));
                }
            }
            if( values.containsKey("HandlingUnitType") ) {
                final Object value = values.remove("HandlingUnitType");
                if( (value == null) || (!value.equals(getHandlingUnitType())) ) {
                    setHandlingUnitType(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PackingInstructionComponent") ) {
                final Object value = (values).remove("to_PackingInstructionComponent");
                if( value instanceof Iterable ) {
                    if( toPackingInstructionComponent == null ) {
                        toPackingInstructionComponent = Lists.newArrayList();
                    } else {
                        toPackingInstructionComponent = Lists.newArrayList(toPackingInstructionComponent);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PackingInstructionComponent entity;
                        if( toPackingInstructionComponent.size() > i ) {
                            entity = toPackingInstructionComponent.get(i);
                        } else {
                            entity = new PackingInstructionComponent();
                            toPackingInstructionComponent.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PackingInstructionText") ) {
                final Object value = (values).remove("to_PackingInstructionText");
                if( value instanceof Iterable ) {
                    if( toPackingInstructionText == null ) {
                        toPackingInstructionText = Lists.newArrayList();
                    } else {
                        toPackingInstructionText = Lists.newArrayList(toPackingInstructionText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PackingInstructionText entity;
                        if( toPackingInstructionText.size() > i ) {
                            entity = toPackingInstructionText.get(i);
                        } else {
                            entity = new PackingInstructionText();
                            toPackingInstructionText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PackingInstructionHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PackingInstructionHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PackingInstructionHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PackingInstructionHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPackingInstructionComponent != null ) {
            (values).put("to_PackingInstructionComponent", toPackingInstructionComponent);
        }
        if( toPackingInstructionText != null ) {
            (values).put("to_PackingInstructionText", toPackingInstructionText);
        }
        return values;
    }

    /**
     * Fetches the <b>PackingInstructionComponent</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PackingInstructionComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PackingInstructionComponent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PackingInstructionComponent> fetchPackingInstructionComponent()
    {
        return fetchFieldAsList("to_PackingInstructionComponent", PackingInstructionComponent.class);
    }

    /**
     * Retrieval of associated <b>PackingInstructionComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PackingInstructionComponent</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionComponent</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PackingInstructionComponent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PackingInstructionComponent> getPackingInstructionComponentOrFetch()
    {
        if( toPackingInstructionComponent == null ) {
            toPackingInstructionComponent = fetchPackingInstructionComponent();
        }
        return toPackingInstructionComponent;
    }

    /**
     * Retrieval of associated <b>PackingInstructionComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PackingInstructionComponent</b>.
     * <p>
     * If the navigation property for an entity <b>PackingInstructionHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PackingInstructionComponent</b> is already loaded, the
     *         result will contain the <b>PackingInstructionComponent</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PackingInstructionComponent>> getPackingInstructionComponentIfPresent()
    {
        return Option.of(toPackingInstructionComponent);
    }

    /**
     * Overwrites the list of associated <b>PackingInstructionComponent</b> entities for the loaded navigation property
     * <b>to_PackingInstructionComponent</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionComponent</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PackingInstructionComponent</b> entities.
     */
    public void setPackingInstructionComponent( @Nonnull final List<PackingInstructionComponent> value )
    {
        if( toPackingInstructionComponent == null ) {
            toPackingInstructionComponent = Lists.newArrayList();
        }
        toPackingInstructionComponent.clear();
        toPackingInstructionComponent.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PackingInstructionComponent</b> entities. This corresponds to the
     * OData navigation property <b>to_PackingInstructionComponent</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionComponent</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PackingInstructionComponent</b> entities.
     */
    public void addPackingInstructionComponent( PackingInstructionComponent... entity )
    {
        if( toPackingInstructionComponent == null ) {
            toPackingInstructionComponent = Lists.newArrayList();
        }
        toPackingInstructionComponent.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PackingInstructionText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PackingInstructionText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PackingInstructionText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PackingInstructionText> fetchPackingInstructionText()
    {
        return fetchFieldAsList("to_PackingInstructionText", PackingInstructionText.class);
    }

    /**
     * Retrieval of associated <b>PackingInstructionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PackingInstructionText</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionText</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PackingInstructionText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PackingInstructionText> getPackingInstructionTextOrFetch()
    {
        if( toPackingInstructionText == null ) {
            toPackingInstructionText = fetchPackingInstructionText();
        }
        return toPackingInstructionText;
    }

    /**
     * Retrieval of associated <b>PackingInstructionText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PackingInstructionText</b>.
     * <p>
     * If the navigation property for an entity <b>PackingInstructionHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PackingInstructionText</b> is already loaded, the result
     *         will contain the <b>PackingInstructionText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PackingInstructionText>> getPackingInstructionTextIfPresent()
    {
        return Option.of(toPackingInstructionText);
    }

    /**
     * Overwrites the list of associated <b>PackingInstructionText</b> entities for the loaded navigation property
     * <b>to_PackingInstructionText</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionText</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PackingInstructionText</b> entities.
     */
    public void setPackingInstructionText( @Nonnull final List<PackingInstructionText> value )
    {
        if( toPackingInstructionText == null ) {
            toPackingInstructionText = Lists.newArrayList();
        }
        toPackingInstructionText.clear();
        toPackingInstructionText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PackingInstructionText</b> entities. This corresponds to the OData
     * navigation property <b>to_PackingInstructionText</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionText</b> of a queried <b>PackingInstructionHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PackingInstructionText</b> entities.
     */
    public void addPackingInstructionText( PackingInstructionText... entity )
    {
        if( toPackingInstructionText == null ) {
            toPackingInstructionText = Lists.newArrayList();
        }
        toPackingInstructionText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PackingInstructionHeader instances.
     *
     */
    public final static class PackingInstructionHeaderBuilder
    {

        private List<PackingInstructionComponent> toPackingInstructionComponent = Lists.newArrayList();
        private List<PackingInstructionText> toPackingInstructionText = Lists.newArrayList();

        private PackingInstructionHeader.PackingInstructionHeaderBuilder toPackingInstructionComponent(
            final List<PackingInstructionComponent> value )
        {
            toPackingInstructionComponent.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PackingInstructionComponent</b> for <b>PackingInstructionHeader</b> to multiple
         * <b>PackingInstructionComponent</b>.
         *
         * @param value
         *            The PackingInstructionComponents to build this PackingInstructionHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PackingInstructionHeader.PackingInstructionHeaderBuilder packingInstructionComponent(
            PackingInstructionComponent... value )
        {
            return toPackingInstructionComponent(Lists.newArrayList(value));
        }

        private PackingInstructionHeader.PackingInstructionHeaderBuilder toPackingInstructionText(
            final List<PackingInstructionText> value )
        {
            toPackingInstructionText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PackingInstructionText</b> for <b>PackingInstructionHeader</b> to multiple
         * <b>PackingInstructionText</b>.
         *
         * @param value
         *            The PackingInstructionTexts to build this PackingInstructionHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PackingInstructionHeader.PackingInstructionHeaderBuilder packingInstructionText(
            PackingInstructionText... value )
        {
            return toPackingInstructionText(Lists.newArrayList(value));
        }

    }

}
