/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable.PackingInstructionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Packing Instruction Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PackingInstructionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PackingInstructionText extends VdmEntity<PackingInstructionText>
{

    /**
     * Selector for all available fields of PackingInstructionText.
     *
     */
    public final static PackingInstructionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PackingInstructionTextField<String> LANGUAGE =
        new PackingInstructionTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @return Packing Instruction Number
     */
    @Key
    @SerializedName( "PackingInstructionSystemUUID" )
    @JsonProperty( "PackingInstructionSystemUUID" )
    @Nullable
    @ODataField( odataName = "PackingInstructionSystemUUID" )
    private UUID packingInstructionSystemUUID;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionSystemUUID</b> field to query operations.
     *
     */
    public final static PackingInstructionTextField<UUID> PACKING_INSTRUCTION_SYSTEM_UUID =
        new PackingInstructionTextField<UUID>("PackingInstructionSystemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionText</b>
     * </p>
     *
     * @return Short text of packing object
     */
    @SerializedName( "PackingInstructionText" )
    @JsonProperty( "PackingInstructionText" )
    @Nullable
    @ODataField( odataName = "PackingInstructionText" )
    private String packingInstructionText;
    /**
     * Use with available fluent helpers to apply the <b>PackingInstructionText</b> field to query operations.
     *
     */
    public final static PackingInstructionTextField<String> PACKING_INSTRUCTION_TEXT =
        new PackingInstructionTextField<String>("PackingInstructionText");
    /**
     * Navigation property <b>to_PackingInstructionHeader</b> for <b>PackingInstructionText</b> to single
     * <b>PackingInstructionHeader</b>.
     *
     */
    @SerializedName( "to_PackingInstructionHeader" )
    @JsonProperty( "to_PackingInstructionHeader" )
    @ODataField( odataName = "to_PackingInstructionHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PackingInstructionHeader toPackingInstructionHeader;
    /**
     * Use with available fluent helpers to apply the <b>to_PackingInstructionHeader</b> navigation property to query
     * operations.
     *
     */
    public final static PackingInstructionTextOneToOneLink<PackingInstructionHeader> TO_PACKING_INSTRUCTION_HEADER =
        new PackingInstructionTextOneToOneLink<PackingInstructionHeader>("to_PackingInstructionHeader");

    @Nonnull
    @Override
    public Class<PackingInstructionText> getType()
    {
        return PackingInstructionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionSystemUUID</b>
     * </p>
     *
     * @param packingInstructionSystemUUID
     *            Packing Instruction Number
     */
    public void setPackingInstructionSystemUUID( @Nullable final UUID packingInstructionSystemUUID )
    {
        rememberChangedField("PackingInstructionSystemUUID", this.packingInstructionSystemUUID);
        this.packingInstructionSystemUUID = packingInstructionSystemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstructionText</b>
     * </p>
     *
     * @param packingInstructionText
     *            Short text of packing object
     */
    public void setPackingInstructionText( @Nullable final String packingInstructionText )
    {
        rememberChangedField("PackingInstructionText", this.packingInstructionText);
        this.packingInstructionText = packingInstructionText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PackingInstructionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("PackingInstructionSystemUUID", getPackingInstructionSystemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("PackingInstructionSystemUUID", getPackingInstructionSystemUUID());
        values.put("PackingInstructionText", getPackingInstructionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PackingInstructionSystemUUID") ) {
                final Object value = values.remove("PackingInstructionSystemUUID");
                if( (value == null) || (!value.equals(getPackingInstructionSystemUUID())) ) {
                    setPackingInstructionSystemUUID(((UUID) value));
                }
            }
            if( values.containsKey("PackingInstructionText") ) {
                final Object value = values.remove("PackingInstructionText");
                if( (value == null) || (!value.equals(getPackingInstructionText())) ) {
                    setPackingInstructionText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PackingInstructionHeader") ) {
                final Object value = (values).remove("to_PackingInstructionHeader");
                if( value instanceof Map ) {
                    if( toPackingInstructionHeader == null ) {
                        toPackingInstructionHeader = new PackingInstructionHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPackingInstructionHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PackingInstructionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PackingInstructionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PackingInstructionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PackingInstructionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPackingInstructionHeader != null ) {
            (values).put("to_PackingInstructionHeader", toPackingInstructionHeader);
        }
        return values;
    }

    /**
     * Fetches the <b>PackingInstructionHeader</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PackingInstructionHeader</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PackingInstructionHeader fetchPackingInstructionHeader()
    {
        return fetchFieldAsSingle("to_PackingInstructionHeader", PackingInstructionHeader.class);
    }

    /**
     * Retrieval of associated <b>PackingInstructionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * If the navigation property <b>to_PackingInstructionHeader</b> of a queried <b>PackingInstructionText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PackingInstructionHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PackingInstructionHeader getPackingInstructionHeaderOrFetch()
    {
        if( toPackingInstructionHeader == null ) {
            toPackingInstructionHeader = fetchPackingInstructionHeader();
        }
        return toPackingInstructionHeader;
    }

    /**
     * Retrieval of associated <b>PackingInstructionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PackingInstructionHeader</b>.
     * <p>
     * If the navigation property for an entity <b>PackingInstructionText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PackingInstructionHeader</b> is already loaded, the
     *         result will contain the <b>PackingInstructionHeader</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PackingInstructionHeader> getPackingInstructionHeaderIfPresent()
    {
        return Option.of(toPackingInstructionHeader);
    }

    /**
     * Overwrites the associated <b>PackingInstructionHeader</b> entity for the loaded navigation property
     * <b>to_PackingInstructionHeader</b>.
     *
     * @param value
     *            New <b>PackingInstructionHeader</b> entity.
     */
    public void setPackingInstructionHeader( final PackingInstructionHeader value )
    {
        toPackingInstructionHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of PackingInstructionText instances.
     *
     */
    public final static class PackingInstructionTextBuilder
    {

        private PackingInstructionHeader toPackingInstructionHeader;

        private PackingInstructionText.PackingInstructionTextBuilder toPackingInstructionHeader(
            final PackingInstructionHeader value )
        {
            toPackingInstructionHeader = value;
            return this;
        }

        /**
         * Navigation property <b>to_PackingInstructionHeader</b> for <b>PackingInstructionText</b> to single
         * <b>PackingInstructionHeader</b>.
         *
         * @param value
         *            The PackingInstructionHeader to build this PackingInstructionText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PackingInstructionText.PackingInstructionTextBuilder packingInstructionHeader(
            final PackingInstructionHeader value )
        {
            return toPackingInstructionHeader(value);
        }

    }

}
