/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable.PackingInstructionTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
 * PackingInstructionText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PackingInstructionTextByKeyFluentHelper
    extends
    FluentHelperByKey<PackingInstructionTextByKeyFluentHelper, PackingInstructionText, PackingInstructionTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
     * PackingInstructionText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PackingInstructionText}
     * @param packingInstructionSystemUUID
     *            Packing Instruction Number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PackingInstructionText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public PackingInstructionTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final UUID packingInstructionSystemUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("PackingInstructionSystemUUID", packingInstructionSystemUUID);
    }

    @Override
    @Nonnull
    protected Class<PackingInstructionText> getEntityClass()
    {
        return PackingInstructionText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
