/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PackingInstructionServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService PackingInstructionService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPackingInstructionServiceBatch
    extends
    BatchFluentHelperBasic<PackingInstructionServiceBatch, PackingInstructionServiceBatchChangeSet>
    implements
    PackingInstructionServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPackingInstructionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPackingInstructionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPackingInstructionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPackingInstructionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPackingInstructionServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PackingInstructionServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPackingInstructionServiceBatchChangeSet(this, service);
    }

}
