/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader;

/**
 * Implementation of the {@link PackingInstructionServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService PackingInstructionService}.
 *
 */
public class DefaultPackingInstructionServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PackingInstructionServiceBatch, PackingInstructionServiceBatchChangeSet>
    implements
    PackingInstructionServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService service;

    @SuppressWarnings( "deprecation" )
    DefaultPackingInstructionServiceBatchChangeSet(
        @Nonnull final DefaultPackingInstructionServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PackingInstructionService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPackingInstructionServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PackingInstructionServiceBatchChangeSet createPackingInstructionHeader(
        @Nonnull final PackingInstructionHeader packingInstructionHeader )
    {
        return addRequestCreate(service::createPackingInstructionHeader, packingInstructionHeader);
    }

}
