/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent
 * PackingInstructionComponent}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionComponentField
 * PackingInstructionComponentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionComponentLink
 * PackingInstructionComponentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM_SYST_UUID
 * PACKING_INSTRUCTION_ITEM_SYST_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_SYSTEM_UUID
 * PACKING_INSTRUCTION_SYSTEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM
 * PACKING_INSTRUCTION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM_CATEGORY
 * PACKING_INSTRUCTION_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#ITEM_PACKING_INSTRUCTION_SYST_UUID
 * ITEM_PACKING_INSTRUCTION_SYST_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITM_TARGET_QTY
 * PACKING_INSTRUCTION_ITM_TARGET_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM_MIN_QTY
 * PACKING_INSTRUCTION_ITEM_MIN_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM_RND_QTY
 * PACKING_INSTRUCTION_ITEM_RND_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#BASE_UNITOF_MEASURE
 * BASE_UNITOF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#UNIT_OF_MEASURE
 * UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#MATERIAL_MIX_IS_ALLOWED
 * MATERIAL_MIX_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#BATCH_MIX_IS_ALLOWED
 * BATCH_MIX_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#PACKING_INSTRUCTION_ITEM_IS_DEL
 * PACKING_INSTRUCTION_ITEM_IS_DEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionComponent#TO_PACKING_INSTRUCTION_HEADER
 * TO_PACKING_INSTRUCTION_HEADER}</li>
 * </ul>
 *
 */
public interface PackingInstructionComponentSelectable extends EntitySelectable<PackingInstructionComponent>
{

}
