/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader
 * PackingInstructionHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionHeaderField
 * PackingInstructionHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionHeaderLink
 * PackingInstructionHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_SYSTEM_UUID
 * PACKING_INSTRUCTION_SYSTEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_NUMBER
 * PACKING_INSTRUCTION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_EXTERNAL_NAME
 * PACKING_INSTRUCTION_EXTERNAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_HEIGHT
 * HANDLING_UNIT_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_WIDTH
 * HANDLING_UNIT_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_LENGTH
 * HANDLING_UNIT_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_INNER_HEIGHT
 * HANDLING_UNIT_INNER_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_INNER_WIDTH
 * HANDLING_UNIT_INNER_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_INNER_LENGTH
 * HANDLING_UNIT_INNER_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_UO_M_DIMENSION
 * HANDLING_UNIT_UO_M_DIMENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_MEASURES_ARE_FIXED
 * HANDLING_UNIT_MEASURES_ARE_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_GROSS_VOLUME
 * HANDLING_UNIT_GROSS_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_LOAD_VOLUME
 * HANDLING_UNIT_LOAD_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_ALLOWED_LOAD_VOLUME
 * HANDLING_UNIT_ALLOWED_LOAD_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_VOLUME_UNIT
 * HANDLING_UNIT_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_TARE_VOLUME
 * HANDLING_UNIT_TARE_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_TARE_VOLUME_UNIT
 * HANDLING_UNIT_TARE_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_VOLUMES_ARE_FIXED
 * HANDLING_UNIT_VOLUMES_ARE_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#EXCESS_VOLUME_TOLERANCE_VALUE
 * EXCESS_VOLUME_TOLERANCE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_GROSS_WEIGHT
 * HANDLING_UNIT_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_LOAD_WEIGHT
 * HANDLING_UNIT_LOAD_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_ALLOWED_LOAD_WEIGHT
 * HANDLING_UNIT_ALLOWED_LOAD_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_WEIGHT_UNIT
 * HANDLING_UNIT_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_TARE_WEIGHT
 * HANDLING_UNIT_TARE_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_TARE_WEIGHT_UNIT
 * HANDLING_UNIT_TARE_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_WEIGHTS_ARE_FIXED
 * HANDLING_UNIT_WEIGHTS_ARE_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#EXCESS_WEIGHT_TOLERANCE_VALUE
 * EXCESS_WEIGHT_TOLERANCE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_ALLWD_LOAD_QTY
 * PACKING_INSTRUCTION_ALLWD_LOAD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_IS_CLOSED
 * HANDLING_UNIT_IS_CLOSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#LOAD_CARRIER_SYST_UUID
 * LOAD_CARRIER_SYST_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_IS_DELETED
 * PACKING_INSTRUCTION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#PACKING_INSTRUCTION_CHECK_PROF_STS
 * PACKING_INSTRUCTION_CHECK_PROF_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#STACKING_FACTOR
 * STACKING_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#HANDLING_UNIT_TYPE
 * HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#TO_PACKING_INSTRUCTION_COMPONENT
 * TO_PACKING_INSTRUCTION_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionHeader#TO_PACKING_INSTRUCTION_TEXT
 * TO_PACKING_INSTRUCTION_TEXT}</li>
 * </ul>
 *
 */
public interface PackingInstructionHeaderSelectable extends EntitySelectable<PackingInstructionHeader>
{

}
