/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText
 * PackingInstructionText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.field.PackingInstructionTextField
 * PackingInstructionTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.link.PackingInstructionTextLink
 * PackingInstructionTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText#PACKING_INSTRUCTION_SYSTEM_UUID
 * PACKING_INSTRUCTION_SYSTEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText#PACKING_INSTRUCTION_TEXT
 * PACKING_INSTRUCTION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.packinginstruction.PackingInstructionText#TO_PACKING_INSTRUCTION_HEADER
 * TO_PACKING_INSTRUCTION_HEADER}</li>
 * </ul>
 *
 */
public interface PackingInstructionTextSelectable extends EntitySelectable<PackingInstructionText>
{

}
