/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.field.PaymentAdviceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.link.PaymentAdviceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.selectable.PaymentAdviceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Payment Advice
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PaymentAdviceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PaymentAdvice extends VdmEntity<PaymentAdvice>
{

    /**
     * Selector for all available fields of PaymentAdvice.
     *
     */
    public final static PaymentAdviceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> COMPANY_CODE = new PaymentAdviceField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @return Payment Advice Account Type
     */
    @Key
    @SerializedName( "PaymentAdviceAccountType" )
    @JsonProperty( "PaymentAdviceAccountType" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccountType" )
    private String paymentAdviceAccountType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccountType</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_ACCOUNT_TYPE =
        new PaymentAdviceField<String>("PaymentAdviceAccountType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @return Account Number
     */
    @Key
    @SerializedName( "PaymentAdviceAccount" )
    @JsonProperty( "PaymentAdviceAccount" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccount" )
    private String paymentAdviceAccount;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccount</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_ACCOUNT =
        new PaymentAdviceField<String>("PaymentAdviceAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @return Payment Advice Number
     */
    @Key
    @SerializedName( "PaymentAdvice" )
    @JsonProperty( "PaymentAdvice" )
    @Nullable
    @ODataField( odataName = "PaymentAdvice" )
    private String paymentAdvice;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdvice</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE = new PaymentAdviceField<String>("PaymentAdvice");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDocument</b>
     * </p>
     *
     * @return Payment Document Number
     */
    @SerializedName( "PaymentDocument" )
    @JsonProperty( "PaymentDocument" )
    @Nullable
    @ODataField( odataName = "PaymentDocument" )
    private String paymentDocument;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDocument</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_DOCUMENT = new PaymentAdviceField<String>("PaymentDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountByShipper</b>
     * </p>
     *
     * @return Payee's Account at the Customer
     */
    @SerializedName( "AccountByShipper" )
    @JsonProperty( "AccountByShipper" )
    @Nullable
    @ODataField( odataName = "AccountByShipper" )
    private String accountByShipper;
    /**
     * Use with available fluent helpers to apply the <b>AccountByShipper</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> ACCOUNT_BY_SHIPPER =
        new PaymentAdviceField<String>("AccountByShipper");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     *
     * @return Payment Currency Key
     */
    @SerializedName( "PaymentCurrency" )
    @JsonProperty( "PaymentCurrency" )
    @Nullable
    @ODataField( odataName = "PaymentCurrency" )
    private String paymentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PaymentCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_CURRENCY = new PaymentAdviceField<String>("PaymentCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDate</b>
     * </p>
     *
     * @return Payment Date
     */
    @SerializedName( "PaymentDate" )
    @JsonProperty( "PaymentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PaymentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime paymentDate;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<LocalDateTime> PAYMENT_DATE =
        new PaymentAdviceField<LocalDateTime>("PaymentDate");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaidAmountInPaytCurrency</b>
     * </p>
     *
     * @return Payment Amount from the Payment Advice Header
     */
    @SerializedName( "PaidAmountInPaytCurrency" )
    @JsonProperty( "PaidAmountInPaytCurrency" )
    @Nullable
    @ODataField( odataName = "PaidAmountInPaytCurrency" )
    private BigDecimal paidAmountInPaytCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PaidAmountInPaytCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<BigDecimal> PAID_AMOUNT_IN_PAYT_CURRENCY =
        new PaymentAdviceField<BigDecimal>("PaidAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInPaytCrcy</b>
     * </p>
     *
     * @return Cash Discount Amount
     */
    @SerializedName( "CashDiscountAmountInPaytCrcy" )
    @JsonProperty( "CashDiscountAmountInPaytCrcy" )
    @Nullable
    @ODataField( odataName = "CashDiscountAmountInPaytCrcy" )
    private BigDecimal cashDiscountAmountInPaytCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountAmountInPaytCrcy</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<BigDecimal> CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY =
        new PaymentAdviceField<BigDecimal>("CashDiscountAmountInPaytCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankCountry</b>
     * </p>
     *
     * @return Country/Region Key of Partner Bank
     */
    @SerializedName( "PartnerBankCountry" )
    @JsonProperty( "PartnerBankCountry" )
    @Nullable
    @ODataField( odataName = "PartnerBankCountry" )
    private String partnerBankCountry;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBankCountry</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PARTNER_BANK_COUNTRY =
        new PaymentAdviceField<String>("PartnerBankCountry");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankSWIFTCode</b>
     * </p>
     *
     * @return SWIFT code of partner bank
     */
    @SerializedName( "PartnerBankSWIFTCode" )
    @JsonProperty( "PartnerBankSWIFTCode" )
    @Nullable
    @ODataField( odataName = "PartnerBankSWIFTCode" )
    private String partnerBankSWIFTCode;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBankSWIFTCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PARTNER_BANK_SWIFT_CODE =
        new PaymentAdviceField<String>("PartnerBankSWIFTCode");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> CREATED_BY_USER = new PaymentAdviceField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<LocalDateTime> CREATION_DATE =
        new PaymentAdviceField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time of Entry
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<LocalTime> CREATION_TIME = new PaymentAdviceField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<LocalDateTime> LAST_CHANGE_DATE =
        new PaymentAdviceField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> LAST_CHANGED_BY_USER =
        new PaymentAdviceField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceHeaderText</b>
     * </p>
     *
     * @return Payment Advice Header Text
     */
    @SerializedName( "PaymentAdviceHeaderText" )
    @JsonProperty( "PaymentAdviceHeaderText" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceHeaderText" )
    private String paymentAdviceHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceHeaderText</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_HEADER_TEXT =
        new PaymentAdviceField<String>("PaymentAdviceHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceType</b>
     * </p>
     *
     * @return Payment Advice Type
     */
    @SerializedName( "PaymentAdviceType" )
    @JsonProperty( "PaymentAdviceType" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceType" )
    private String paymentAdviceType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceType</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_TYPE =
        new PaymentAdviceField<String>("PaymentAdviceType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceStatus</b>
     * </p>
     *
     * @return Payment Advice Status
     */
    @SerializedName( "PaymentAdviceStatus" )
    @JsonProperty( "PaymentAdviceStatus" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceStatus" )
    private String paymentAdviceStatus;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceStatus</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_STATUS =
        new PaymentAdviceField<String>("PaymentAdviceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaytAdvcDiffDeterminationRule</b>
     * </p>
     *
     * @return Reason Code Conversion Version
     */
    @SerializedName( "PaytAdvcDiffDeterminationRule" )
    @JsonProperty( "PaytAdvcDiffDeterminationRule" )
    @Nullable
    @ODataField( odataName = "PaytAdvcDiffDeterminationRule" )
    private String paytAdvcDiffDeterminationRule;
    /**
     * Use with available fluent helpers to apply the <b>PaytAdvcDiffDeterminationRule</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYT_ADVC_DIFF_DETERMINATION_RULE =
        new PaymentAdviceField<String>("PaytAdvcDiffDeterminationRule");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionRule</b>
     * </p>
     *
     * @return Selection Rule for Payment Advices
     */
    @SerializedName( "PaymentAdviceSelectionRule" )
    @JsonProperty( "PaymentAdviceSelectionRule" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceSelectionRule" )
    private String paymentAdviceSelectionRule;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceSelectionRule</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_ADVICE_SELECTION_RULE =
        new PaymentAdviceField<String>("PaymentAdviceSelectionRule");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     *
     * @return Reference Key
     */
    @SerializedName( "OriginalReferenceDocument" )
    @JsonProperty( "OriginalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "OriginalReferenceDocument" )
    private String originalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>OriginalReferenceDocument</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> ORIGINAL_REFERENCE_DOCUMENT =
        new PaymentAdviceField<String>("OriginalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Transaction
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> REFERENCE_DOCUMENT_TYPE =
        new PaymentAdviceField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FeeAmountInTransactionCrcy</b>
     * </p>
     *
     * @return Fees in Account Currency
     */
    @SerializedName( "FeeAmountInTransactionCrcy" )
    @JsonProperty( "FeeAmountInTransactionCrcy" )
    @Nullable
    @ODataField( odataName = "FeeAmountInTransactionCrcy" )
    private BigDecimal feeAmountInTransactionCrcy;
    /**
     * Use with available fluent helpers to apply the <b>FeeAmountInTransactionCrcy</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<BigDecimal> FEE_AMOUNT_IN_TRANSACTION_CRCY =
        new PaymentAdviceField<BigDecimal>("FeeAmountInTransactionCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTransaction</b>
     * </p>
     *
     * @return Business transaction code
     */
    @SerializedName( "PaymentTransaction" )
    @JsonProperty( "PaymentTransaction" )
    @Nullable
    @ODataField( odataName = "PaymentTransaction" )
    private String paymentTransaction;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTransaction</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> PAYMENT_TRANSACTION =
        new PaymentAdviceField<String>("PaymentTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return Accounting Exchange Rate
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> EXCHANGE_RATE = new PaymentAdviceField<String>("ExchangeRate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillOfExchangeFailureDate</b>
     * </p>
     *
     * @return Date of failed bills of exchange in Japan
     */
    @SerializedName( "BillOfExchangeFailureDate" )
    @JsonProperty( "BillOfExchangeFailureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillOfExchangeFailureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billOfExchangeFailureDate;
    /**
     * Use with available fluent helpers to apply the <b>BillOfExchangeFailureDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<LocalDateTime> BILL_OF_EXCHANGE_FAILURE_DATE =
        new PaymentAdviceField<LocalDateTime>("BillOfExchangeFailureDate");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BankReference</b>
     * </p>
     *
     * @return Bank Reference Number
     */
    @SerializedName( "BankReference" )
    @JsonProperty( "BankReference" )
    @Nullable
    @ODataField( odataName = "BankReference" )
    private String bankReference;
    /**
     * Use with available fluent helpers to apply the <b>BankReference</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> BANK_REFERENCE = new PaymentAdviceField<String>("BankReference");
    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @return Business Partner
     */
    @SerializedName( "BusinessPartnerName" )
    @JsonProperty( "BusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName" )
    private String businessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName</b> field to query operations.
     *
     */
    public final static PaymentAdviceField<String> BUSINESS_PARTNER_NAME =
        new PaymentAdviceField<String>("BusinessPartnerName");
    /**
     * Navigation property <b>to_PaymentAdviceItem</b> for <b>PaymentAdvice</b> to multiple <b>PaymentAdviceItem</b>.
     *
     */
    @SerializedName( "to_PaymentAdviceItem" )
    @JsonProperty( "to_PaymentAdviceItem" )
    @ODataField( odataName = "to_PaymentAdviceItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PaymentAdviceItem> toPaymentAdviceItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PaymentAdviceItem</b> navigation property to query
     * operations.
     *
     */
    public final static PaymentAdviceLink<PaymentAdviceItem> TO_PAYMENT_ADVICE_ITEM =
        new PaymentAdviceLink<PaymentAdviceItem>("to_PaymentAdviceItem");

    @Nonnull
    @Override
    public Class<PaymentAdvice> getType()
    {
        return PaymentAdvice.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     */
    public void setPaymentAdviceAccountType( @Nullable final String paymentAdviceAccountType )
    {
        rememberChangedField("PaymentAdviceAccountType", this.paymentAdviceAccountType);
        this.paymentAdviceAccountType = paymentAdviceAccountType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @param paymentAdviceAccount
     *            Account Number
     */
    public void setPaymentAdviceAccount( @Nullable final String paymentAdviceAccount )
    {
        rememberChangedField("PaymentAdviceAccount", this.paymentAdviceAccount);
        this.paymentAdviceAccount = paymentAdviceAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @param paymentAdvice
     *            Payment Advice Number
     */
    public void setPaymentAdvice( @Nullable final String paymentAdvice )
    {
        rememberChangedField("PaymentAdvice", this.paymentAdvice);
        this.paymentAdvice = paymentAdvice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDocument</b>
     * </p>
     *
     * @param paymentDocument
     *            Payment Document Number
     */
    public void setPaymentDocument( @Nullable final String paymentDocument )
    {
        rememberChangedField("PaymentDocument", this.paymentDocument);
        this.paymentDocument = paymentDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountByShipper</b>
     * </p>
     *
     * @param accountByShipper
     *            Payee's Account at the Customer
     */
    public void setAccountByShipper( @Nullable final String accountByShipper )
    {
        rememberChangedField("AccountByShipper", this.accountByShipper);
        this.accountByShipper = accountByShipper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     *
     * @param paymentCurrency
     *            Payment Currency Key
     */
    public void setPaymentCurrency( @Nullable final String paymentCurrency )
    {
        rememberChangedField("PaymentCurrency", this.paymentCurrency);
        this.paymentCurrency = paymentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDate</b>
     * </p>
     *
     * @param paymentDate
     *            Payment Date
     */
    public void setPaymentDate( @Nullable final LocalDateTime paymentDate )
    {
        rememberChangedField("PaymentDate", this.paymentDate);
        this.paymentDate = paymentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaidAmountInPaytCurrency</b>
     * </p>
     *
     * @param paidAmountInPaytCurrency
     *            Payment Amount from the Payment Advice Header
     */
    public void setPaidAmountInPaytCurrency( @Nullable final BigDecimal paidAmountInPaytCurrency )
    {
        rememberChangedField("PaidAmountInPaytCurrency", this.paidAmountInPaytCurrency);
        this.paidAmountInPaytCurrency = paidAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInPaytCrcy</b>
     * </p>
     *
     * @param cashDiscountAmountInPaytCrcy
     *            Cash Discount Amount
     */
    public void setCashDiscountAmountInPaytCrcy( @Nullable final BigDecimal cashDiscountAmountInPaytCrcy )
    {
        rememberChangedField("CashDiscountAmountInPaytCrcy", this.cashDiscountAmountInPaytCrcy);
        this.cashDiscountAmountInPaytCrcy = cashDiscountAmountInPaytCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankCountry</b>
     * </p>
     *
     * @param partnerBankCountry
     *            Country/Region Key of Partner Bank
     */
    public void setPartnerBankCountry( @Nullable final String partnerBankCountry )
    {
        rememberChangedField("PartnerBankCountry", this.partnerBankCountry);
        this.partnerBankCountry = partnerBankCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankSWIFTCode</b>
     * </p>
     *
     * @param partnerBankSWIFTCode
     *            SWIFT code of partner bank
     */
    public void setPartnerBankSWIFTCode( @Nullable final String partnerBankSWIFTCode )
    {
        rememberChangedField("PartnerBankSWIFTCode", this.partnerBankSWIFTCode);
        this.partnerBankSWIFTCode = partnerBankSWIFTCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceHeaderText</b>
     * </p>
     *
     * @param paymentAdviceHeaderText
     *            Payment Advice Header Text
     */
    public void setPaymentAdviceHeaderText( @Nullable final String paymentAdviceHeaderText )
    {
        rememberChangedField("PaymentAdviceHeaderText", this.paymentAdviceHeaderText);
        this.paymentAdviceHeaderText = paymentAdviceHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceType</b>
     * </p>
     *
     * @param paymentAdviceType
     *            Payment Advice Type
     */
    public void setPaymentAdviceType( @Nullable final String paymentAdviceType )
    {
        rememberChangedField("PaymentAdviceType", this.paymentAdviceType);
        this.paymentAdviceType = paymentAdviceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceStatus</b>
     * </p>
     *
     * @param paymentAdviceStatus
     *            Payment Advice Status
     */
    public void setPaymentAdviceStatus( @Nullable final String paymentAdviceStatus )
    {
        rememberChangedField("PaymentAdviceStatus", this.paymentAdviceStatus);
        this.paymentAdviceStatus = paymentAdviceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaytAdvcDiffDeterminationRule</b>
     * </p>
     *
     * @param paytAdvcDiffDeterminationRule
     *            Reason Code Conversion Version
     */
    public void setPaytAdvcDiffDeterminationRule( @Nullable final String paytAdvcDiffDeterminationRule )
    {
        rememberChangedField("PaytAdvcDiffDeterminationRule", this.paytAdvcDiffDeterminationRule);
        this.paytAdvcDiffDeterminationRule = paytAdvcDiffDeterminationRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionRule</b>
     * </p>
     *
     * @param paymentAdviceSelectionRule
     *            Selection Rule for Payment Advices
     */
    public void setPaymentAdviceSelectionRule( @Nullable final String paymentAdviceSelectionRule )
    {
        rememberChangedField("PaymentAdviceSelectionRule", this.paymentAdviceSelectionRule);
        this.paymentAdviceSelectionRule = paymentAdviceSelectionRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     *
     * @param originalReferenceDocument
     *            Reference Key
     */
    public void setOriginalReferenceDocument( @Nullable final String originalReferenceDocument )
    {
        rememberChangedField("OriginalReferenceDocument", this.originalReferenceDocument);
        this.originalReferenceDocument = originalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Transaction
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FeeAmountInTransactionCrcy</b>
     * </p>
     *
     * @param feeAmountInTransactionCrcy
     *            Fees in Account Currency
     */
    public void setFeeAmountInTransactionCrcy( @Nullable final BigDecimal feeAmountInTransactionCrcy )
    {
        rememberChangedField("FeeAmountInTransactionCrcy", this.feeAmountInTransactionCrcy);
        this.feeAmountInTransactionCrcy = feeAmountInTransactionCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTransaction</b>
     * </p>
     *
     * @param paymentTransaction
     *            Business transaction code
     */
    public void setPaymentTransaction( @Nullable final String paymentTransaction )
    {
        rememberChangedField("PaymentTransaction", this.paymentTransaction);
        this.paymentTransaction = paymentTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            Accounting Exchange Rate
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillOfExchangeFailureDate</b>
     * </p>
     *
     * @param billOfExchangeFailureDate
     *            Date of failed bills of exchange in Japan
     */
    public void setBillOfExchangeFailureDate( @Nullable final LocalDateTime billOfExchangeFailureDate )
    {
        rememberChangedField("BillOfExchangeFailureDate", this.billOfExchangeFailureDate);
        this.billOfExchangeFailureDate = billOfExchangeFailureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BankReference</b>
     * </p>
     *
     * @param bankReference
     *            Bank Reference Number
     */
    public void setBankReference( @Nullable final String bankReference )
    {
        rememberChangedField("BankReference", this.bankReference);
        this.bankReference = bankReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @param businessPartnerName
     *            Business Partner
     */
    public void setBusinessPartnerName( @Nullable final String businessPartnerName )
    {
        rememberChangedField("BusinessPartnerName", this.businessPartnerName);
        this.businessPartnerName = businessPartnerName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PaymentAdvice";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        result.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        result.put("PaymentAdvice", getPaymentAdvice());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        values.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        values.put("PaymentAdvice", getPaymentAdvice());
        values.put("PaymentDocument", getPaymentDocument());
        values.put("AccountByShipper", getAccountByShipper());
        values.put("PaymentCurrency", getPaymentCurrency());
        values.put("PaymentDate", getPaymentDate());
        values.put("PaidAmountInPaytCurrency", getPaidAmountInPaytCurrency());
        values.put("CashDiscountAmountInPaytCrcy", getCashDiscountAmountInPaytCrcy());
        values.put("PartnerBankCountry", getPartnerBankCountry());
        values.put("PartnerBankSWIFTCode", getPartnerBankSWIFTCode());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("PaymentAdviceHeaderText", getPaymentAdviceHeaderText());
        values.put("PaymentAdviceType", getPaymentAdviceType());
        values.put("PaymentAdviceStatus", getPaymentAdviceStatus());
        values.put("PaytAdvcDiffDeterminationRule", getPaytAdvcDiffDeterminationRule());
        values.put("PaymentAdviceSelectionRule", getPaymentAdviceSelectionRule());
        values.put("OriginalReferenceDocument", getOriginalReferenceDocument());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("FeeAmountInTransactionCrcy", getFeeAmountInTransactionCrcy());
        values.put("PaymentTransaction", getPaymentTransaction());
        values.put("ExchangeRate", getExchangeRate());
        values.put("BillOfExchangeFailureDate", getBillOfExchangeFailureDate());
        values.put("BankReference", getBankReference());
        values.put("BusinessPartnerName", getBusinessPartnerName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccountType") ) {
                final Object value = values.remove("PaymentAdviceAccountType");
                if( (value == null) || (!value.equals(getPaymentAdviceAccountType())) ) {
                    setPaymentAdviceAccountType(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccount") ) {
                final Object value = values.remove("PaymentAdviceAccount");
                if( (value == null) || (!value.equals(getPaymentAdviceAccount())) ) {
                    setPaymentAdviceAccount(((String) value));
                }
            }
            if( values.containsKey("PaymentAdvice") ) {
                final Object value = values.remove("PaymentAdvice");
                if( (value == null) || (!value.equals(getPaymentAdvice())) ) {
                    setPaymentAdvice(((String) value));
                }
            }
            if( values.containsKey("PaymentDocument") ) {
                final Object value = values.remove("PaymentDocument");
                if( (value == null) || (!value.equals(getPaymentDocument())) ) {
                    setPaymentDocument(((String) value));
                }
            }
            if( values.containsKey("AccountByShipper") ) {
                final Object value = values.remove("AccountByShipper");
                if( (value == null) || (!value.equals(getAccountByShipper())) ) {
                    setAccountByShipper(((String) value));
                }
            }
            if( values.containsKey("PaymentCurrency") ) {
                final Object value = values.remove("PaymentCurrency");
                if( (value == null) || (!value.equals(getPaymentCurrency())) ) {
                    setPaymentCurrency(((String) value));
                }
            }
            if( values.containsKey("PaymentDate") ) {
                final Object value = values.remove("PaymentDate");
                if( (value == null) || (!value.equals(getPaymentDate())) ) {
                    setPaymentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaidAmountInPaytCurrency") ) {
                final Object value = values.remove("PaidAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getPaidAmountInPaytCurrency())) ) {
                    setPaidAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmountInPaytCrcy") ) {
                final Object value = values.remove("CashDiscountAmountInPaytCrcy");
                if( (value == null) || (!value.equals(getCashDiscountAmountInPaytCrcy())) ) {
                    setCashDiscountAmountInPaytCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PartnerBankCountry") ) {
                final Object value = values.remove("PartnerBankCountry");
                if( (value == null) || (!value.equals(getPartnerBankCountry())) ) {
                    setPartnerBankCountry(((String) value));
                }
            }
            if( values.containsKey("PartnerBankSWIFTCode") ) {
                final Object value = values.remove("PartnerBankSWIFTCode");
                if( (value == null) || (!value.equals(getPartnerBankSWIFTCode())) ) {
                    setPartnerBankSWIFTCode(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceHeaderText") ) {
                final Object value = values.remove("PaymentAdviceHeaderText");
                if( (value == null) || (!value.equals(getPaymentAdviceHeaderText())) ) {
                    setPaymentAdviceHeaderText(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceType") ) {
                final Object value = values.remove("PaymentAdviceType");
                if( (value == null) || (!value.equals(getPaymentAdviceType())) ) {
                    setPaymentAdviceType(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceStatus") ) {
                final Object value = values.remove("PaymentAdviceStatus");
                if( (value == null) || (!value.equals(getPaymentAdviceStatus())) ) {
                    setPaymentAdviceStatus(((String) value));
                }
            }
            if( values.containsKey("PaytAdvcDiffDeterminationRule") ) {
                final Object value = values.remove("PaytAdvcDiffDeterminationRule");
                if( (value == null) || (!value.equals(getPaytAdvcDiffDeterminationRule())) ) {
                    setPaytAdvcDiffDeterminationRule(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceSelectionRule") ) {
                final Object value = values.remove("PaymentAdviceSelectionRule");
                if( (value == null) || (!value.equals(getPaymentAdviceSelectionRule())) ) {
                    setPaymentAdviceSelectionRule(((String) value));
                }
            }
            if( values.containsKey("OriginalReferenceDocument") ) {
                final Object value = values.remove("OriginalReferenceDocument");
                if( (value == null) || (!value.equals(getOriginalReferenceDocument())) ) {
                    setOriginalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("FeeAmountInTransactionCrcy") ) {
                final Object value = values.remove("FeeAmountInTransactionCrcy");
                if( (value == null) || (!value.equals(getFeeAmountInTransactionCrcy())) ) {
                    setFeeAmountInTransactionCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentTransaction") ) {
                final Object value = values.remove("PaymentTransaction");
                if( (value == null) || (!value.equals(getPaymentTransaction())) ) {
                    setPaymentTransaction(((String) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("BillOfExchangeFailureDate") ) {
                final Object value = values.remove("BillOfExchangeFailureDate");
                if( (value == null) || (!value.equals(getBillOfExchangeFailureDate())) ) {
                    setBillOfExchangeFailureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BankReference") ) {
                final Object value = values.remove("BankReference");
                if( (value == null) || (!value.equals(getBankReference())) ) {
                    setBankReference(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName") ) {
                final Object value = values.remove("BusinessPartnerName");
                if( (value == null) || (!value.equals(getBusinessPartnerName())) ) {
                    setBusinessPartnerName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PaymentAdviceItem") ) {
                final Object value = (values).remove("to_PaymentAdviceItem");
                if( value instanceof Iterable ) {
                    if( toPaymentAdviceItem == null ) {
                        toPaymentAdviceItem = Lists.newArrayList();
                    } else {
                        toPaymentAdviceItem = Lists.newArrayList(toPaymentAdviceItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PaymentAdviceItem entity;
                        if( toPaymentAdviceItem.size() > i ) {
                            entity = toPaymentAdviceItem.get(i);
                        } else {
                            entity = new PaymentAdviceItem();
                            toPaymentAdviceItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PaymentAdviceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PaymentAdviceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PaymentAdviceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PaymentAdviceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPaymentAdviceItem != null ) {
            (values).put("to_PaymentAdviceItem", toPaymentAdviceItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PaymentAdviceItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PaymentAdviceItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PaymentAdviceItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PaymentAdviceItem> fetchPaymentAdviceItem()
    {
        return fetchFieldAsList("to_PaymentAdviceItem", PaymentAdviceItem.class);
    }

    /**
     * Retrieval of associated <b>PaymentAdviceItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PaymentAdviceItem</b>.
     * <p>
     * If the navigation property <b>to_PaymentAdviceItem</b> of a queried <b>PaymentAdvice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PaymentAdviceItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PaymentAdviceItem> getPaymentAdviceItemOrFetch()
    {
        if( toPaymentAdviceItem == null ) {
            toPaymentAdviceItem = fetchPaymentAdviceItem();
        }
        return toPaymentAdviceItem;
    }

    /**
     * Retrieval of associated <b>PaymentAdviceItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PaymentAdviceItem</b>.
     * <p>
     * If the navigation property for an entity <b>PaymentAdvice</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PaymentAdviceItem</b> is already loaded, the result will
     *         contain the <b>PaymentAdviceItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PaymentAdviceItem>> getPaymentAdviceItemIfPresent()
    {
        return Option.of(toPaymentAdviceItem);
    }

    /**
     * Overwrites the list of associated <b>PaymentAdviceItem</b> entities for the loaded navigation property
     * <b>to_PaymentAdviceItem</b>.
     * <p>
     * If the navigation property <b>to_PaymentAdviceItem</b> of a queried <b>PaymentAdvice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PaymentAdviceItem</b> entities.
     */
    public void setPaymentAdviceItem( @Nonnull final List<PaymentAdviceItem> value )
    {
        if( toPaymentAdviceItem == null ) {
            toPaymentAdviceItem = Lists.newArrayList();
        }
        toPaymentAdviceItem.clear();
        toPaymentAdviceItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PaymentAdviceItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PaymentAdviceItem</b>.
     * <p>
     * If the navigation property <b>to_PaymentAdviceItem</b> of a queried <b>PaymentAdvice</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PaymentAdviceItem</b> entities.
     */
    public void addPaymentAdviceItem( PaymentAdviceItem... entity )
    {
        if( toPaymentAdviceItem == null ) {
            toPaymentAdviceItem = Lists.newArrayList();
        }
        toPaymentAdviceItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PaymentAdvice instances.
     *
     */
    public final static class PaymentAdviceBuilder
    {

        private List<PaymentAdviceItem> toPaymentAdviceItem = Lists.newArrayList();

        private PaymentAdvice.PaymentAdviceBuilder toPaymentAdviceItem( final List<PaymentAdviceItem> value )
        {
            toPaymentAdviceItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PaymentAdviceItem</b> for <b>PaymentAdvice</b> to multiple
         * <b>PaymentAdviceItem</b>.
         *
         * @param value
         *            The PaymentAdviceItems to build this PaymentAdvice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PaymentAdvice.PaymentAdviceBuilder paymentAdviceItem( PaymentAdviceItem... value )
        {
            return toPaymentAdviceItem(Lists.newArrayList(value));
        }

    }

}
