/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.field.PaymentAdviceItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.selectable.PaymentAdviceItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Payment Advice Line Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PaymentAdviceItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PaymentAdviceItem extends VdmEntity<PaymentAdviceItem>
{

    /**
     * Selector for all available fields of PaymentAdviceItem.
     *
     */
    public final static PaymentAdviceItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> COMPANY_CODE = new PaymentAdviceItemField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @return Payment Advice Account Type
     */
    @Key
    @SerializedName( "PaymentAdviceAccountType" )
    @JsonProperty( "PaymentAdviceAccountType" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccountType" )
    private String paymentAdviceAccountType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccountType</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_ACCOUNT_TYPE =
        new PaymentAdviceItemField<String>("PaymentAdviceAccountType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @return Account Number
     */
    @Key
    @SerializedName( "PaymentAdviceAccount" )
    @JsonProperty( "PaymentAdviceAccount" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccount" )
    private String paymentAdviceAccount;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccount</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_ACCOUNT =
        new PaymentAdviceItemField<String>("PaymentAdviceAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @return Payment Advice Number
     */
    @Key
    @SerializedName( "PaymentAdvice" )
    @JsonProperty( "PaymentAdvice" )
    @Nullable
    @ODataField( odataName = "PaymentAdvice" )
    private String paymentAdvice;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdvice</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE =
        new PaymentAdviceItemField<String>("PaymentAdvice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceItem</b>
     * </p>
     *
     * @return Payment Advice Line Item
     */
    @Key
    @SerializedName( "PaymentAdviceItem" )
    @JsonProperty( "PaymentAdviceItem" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceItem" )
    private String paymentAdviceItem;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceItem</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_ITEM =
        new PaymentAdviceItemField<String>("PaymentAdviceItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAltvAccount</b>
     * </p>
     *
     * @return Alternative Account (Payment Advice Management)
     */
    @SerializedName( "PaymentAdviceAltvAccount" )
    @JsonProperty( "PaymentAdviceAltvAccount" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAltvAccount" )
    private String paymentAdviceAltvAccount;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAltvAccount</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_ALTV_ACCOUNT =
        new PaymentAdviceItemField<String>("PaymentAdviceAltvAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeCompanyCode</b>
     * </p>
     *
     * @return Alternative Company Code (Payment Advice Management)
     */
    @SerializedName( "AlternativeCompanyCode" )
    @JsonProperty( "AlternativeCompanyCode" )
    @Nullable
    @ODataField( odataName = "AlternativeCompanyCode" )
    private String alternativeCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeCompanyCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ALTERNATIVE_COMPANY_CODE =
        new PaymentAdviceItemField<String>("AlternativeCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ACCOUNTING_DOCUMENT =
        new PaymentAdviceItemField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Reference Document
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> DOCUMENT_REFERENCE_ID =
        new PaymentAdviceItemField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @return Billing Document
     */
    @SerializedName( "BillingDocument" )
    @JsonProperty( "BillingDocument" )
    @Nullable
    @ODataField( odataName = "BillingDocument" )
    private String billingDocument;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocument</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> BILLING_DOCUMENT =
        new PaymentAdviceItemField<String>("BillingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BranchAccount</b>
     * </p>
     *
     * @return Account Number of the Branch
     */
    @SerializedName( "BranchAccount" )
    @JsonProperty( "BranchAccount" )
    @Nullable
    @ODataField( odataName = "BranchAccount" )
    private String branchAccount;
    /**
     * Use with available fluent helpers to apply the <b>BranchAccount</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> BRANCH_ACCOUNT =
        new PaymentAdviceItemField<String>("BranchAccount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @return Accounting Document Entry Date
     */
    @SerializedName( "AccountingDocumentCreationDate" )
    @JsonProperty( "AccountingDocumentCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AccountingDocumentCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime accountingDocumentCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCreationDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<LocalDateTime> ACCOUNTING_DOCUMENT_CREATION_DATE =
        new PaymentAdviceItemField<LocalDateTime>("AccountingDocumentCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> BUSINESS_AREA =
        new PaymentAdviceItemField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ASSIGNMENT_REFERENCE =
        new PaymentAdviceItemField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaytDifferenceReasonExtCode</b>
     * </p>
     *
     * @return External Reason Code for Payment Differences
     */
    @SerializedName( "PaytDifferenceReasonExtCode" )
    @JsonProperty( "PaytDifferenceReasonExtCode" )
    @Nullable
    @ODataField( odataName = "PaytDifferenceReasonExtCode" )
    private String paytDifferenceReasonExtCode;
    /**
     * Use with available fluent helpers to apply the <b>PaytDifferenceReasonExtCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYT_DIFFERENCE_REASON_EXT_CODE =
        new PaymentAdviceItemField<String>("PaytDifferenceReasonExtCode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> DOCUMENT_ITEM_TEXT =
        new PaymentAdviceItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Tax Amount in Local Currency
     */
    @SerializedName( "TaxAmountInCoCodeCrcy" )
    @JsonProperty( "TaxAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "TaxAmountInCoCodeCrcy" )
    private BigDecimal taxAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> TAX_AMOUNT_IN_CO_CODE_CRCY =
        new PaymentAdviceItemField<BigDecimal>("TaxAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> TAX_CODE = new PaymentAdviceItemField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmountInPaymentCurrency</b>
     * </p>
     *
     * @return Gross Amount
     */
    @SerializedName( "GrossAmountInPaymentCurrency" )
    @JsonProperty( "GrossAmountInPaymentCurrency" )
    @Nullable
    @ODataField( odataName = "GrossAmountInPaymentCurrency" )
    private BigDecimal grossAmountInPaymentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GrossAmountInPaymentCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> GROSS_AMOUNT_IN_PAYMENT_CURRENCY =
        new PaymentAdviceItemField<BigDecimal>("GrossAmountInPaymentCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmountInPaytCurrency</b>
     * </p>
     *
     * @return Net Payment Amount with +/- Sign
     */
    @SerializedName( "NetPaymentAmountInPaytCurrency" )
    @JsonProperty( "NetPaymentAmountInPaytCurrency" )
    @Nullable
    @ODataField( odataName = "NetPaymentAmountInPaytCurrency" )
    private BigDecimal netPaymentAmountInPaytCurrency;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentAmountInPaytCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY =
        new PaymentAdviceItemField<BigDecimal>("NetPaymentAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInPaytCrcy</b>
     * </p>
     *
     * @return Cash Discount Amount with +/- Sign
     */
    @SerializedName( "CashDiscountAmountInPaytCrcy" )
    @JsonProperty( "CashDiscountAmountInPaytCrcy" )
    @Nullable
    @ODataField( odataName = "CashDiscountAmountInPaytCrcy" )
    private BigDecimal cashDiscountAmountInPaytCrcy;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountAmountInPaytCrcy</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY =
        new PaymentAdviceItemField<BigDecimal>("CashDiscountAmountInPaytCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> FISCAL_YEAR = new PaymentAdviceItemField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @return Posting View Item
     */
    @SerializedName( "AccountingDocumentItem" )
    @JsonProperty( "AccountingDocumentItem" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentItem" )
    private String accountingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentItem</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ACCOUNTING_DOCUMENT_ITEM =
        new PaymentAdviceItemField<String>("AccountingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAltvAccountType</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "PaymentAdviceAltvAccountType" )
    @JsonProperty( "PaymentAdviceAltvAccountType" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAltvAccountType" )
    private String paymentAdviceAltvAccountType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAltvAccountType</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_ALTV_ACCOUNT_TYPE =
        new PaymentAdviceItemField<String>("PaymentAdviceAltvAccountType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountPercent</b>
     * </p>
     *
     * @return Selected Cash Discount Percentage Rate
     */
    @SerializedName( "CashDiscountPercent" )
    @JsonProperty( "CashDiscountPercent" )
    @Nullable
    @ODataField( odataName = "CashDiscountPercent" )
    private BigDecimal cashDiscountPercent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountPercent</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> CASH_DISCOUNT_PERCENT =
        new PaymentAdviceItemField<BigDecimal>("CashDiscountPercent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountDays</b>
     * </p>
     *
     * @return Selected Cash Discount Days
     */
    @SerializedName( "CashDiscountDays" )
    @JsonProperty( "CashDiscountDays" )
    @Nullable
    @ODataField( odataName = "CashDiscountDays" )
    private BigDecimal cashDiscountDays;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountDays</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> CASH_DISCOUNT_DAYS =
        new PaymentAdviceItemField<BigDecimal>("CashDiscountDays");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Amount Difference in Local Currency
     */
    @SerializedName( "DifferenceAmountInCoCodeCrcy" )
    @JsonProperty( "DifferenceAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "DifferenceAmountInCoCodeCrcy" )
    private BigDecimal differenceAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DifferenceAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY =
        new PaymentAdviceItemField<BigDecimal>("DifferenceAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmount</b>
     * </p>
     *
     * @return Amount Difference in Foreign Currency
     */
    @SerializedName( "DifferenceAmount" )
    @JsonProperty( "DifferenceAmount" )
    @Nullable
    @ODataField( odataName = "DifferenceAmount" )
    private BigDecimal differenceAmount;
    /**
     * Use with available fluent helpers to apply the <b>DifferenceAmount</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> DIFFERENCE_AMOUNT =
        new PaymentAdviceItemField<BigDecimal>("DifferenceAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DiffAmtInAdditionalCurrency1</b>
     * </p>
     *
     * @return Amount Difference in Second Local Currency
     */
    @SerializedName( "DiffAmtInAdditionalCurrency1" )
    @JsonProperty( "DiffAmtInAdditionalCurrency1" )
    @Nullable
    @ODataField( odataName = "DiffAmtInAdditionalCurrency1" )
    private BigDecimal diffAmtInAdditionalCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>DiffAmtInAdditionalCurrency1</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> DIFF_AMT_IN_ADDITIONAL_CURRENCY1 =
        new PaymentAdviceItemField<BigDecimal>("DiffAmtInAdditionalCurrency1");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DiffAmtInAdditionalCurrency2</b>
     * </p>
     *
     * @return Amount Difference in Third Local Currency
     */
    @SerializedName( "DiffAmtInAdditionalCurrency2" )
    @JsonProperty( "DiffAmtInAdditionalCurrency2" )
    @Nullable
    @ODataField( odataName = "DiffAmtInAdditionalCurrency2" )
    private BigDecimal diffAmtInAdditionalCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>DiffAmtInAdditionalCurrency2</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> DIFF_AMT_IN_ADDITIONAL_CURRENCY2 =
        new PaymentAdviceItemField<BigDecimal>("DiffAmtInAdditionalCurrency2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsActivated</b>
     * </p>
     *
     * @return Indicator: Items Activated?
     */
    @SerializedName( "ItemIsActivated" )
    @JsonProperty( "ItemIsActivated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ItemIsActivated" )
    private Boolean itemIsActivated;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsActivated</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<Boolean> ITEM_IS_ACTIVATED =
        new PaymentAdviceItemField<Boolean>("ItemIsActivated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsActivated</b>
     * </p>
     *
     * @return Flag whether Cash Discount is Active
     */
    @SerializedName( "CashDiscountIsActivated" )
    @JsonProperty( "CashDiscountIsActivated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CashDiscountIsActivated" )
    private Boolean cashDiscountIsActivated;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscountIsActivated</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<Boolean> CASH_DISCOUNT_IS_ACTIVATED =
        new PaymentAdviceItemField<Boolean>("CashDiscountIsActivated");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPartialPayment</b>
     * </p>
     *
     * @return Indicator: Partial Payments
     */
    @SerializedName( "IsPartialPayment" )
    @JsonProperty( "IsPartialPayment" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPartialPayment" )
    private Boolean isPartialPayment;
    /**
     * Use with available fluent helpers to apply the <b>IsPartialPayment</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<Boolean> IS_PARTIAL_PAYMENT =
        new PaymentAdviceItemField<Boolean>("IsPartialPayment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PaytDiffRsdlBalIsCarriedFwd</b>
     * </p>
     *
     * @return Indicator: Carryforward Residual Bal. for Payt Difference?
     */
    @SerializedName( "PaytDiffRsdlBalIsCarriedFwd" )
    @JsonProperty( "PaytDiffRsdlBalIsCarriedFwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PaytDiffRsdlBalIsCarriedFwd" )
    private Boolean paytDiffRsdlBalIsCarriedFwd;
    /**
     * Use with available fluent helpers to apply the <b>PaytDiffRsdlBalIsCarriedFwd</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<Boolean> PAYT_DIFF_RSDL_BAL_IS_CARRIED_FWD =
        new PaymentAdviceItemField<Boolean>("PaytDiffRsdlBalIsCarriedFwd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @return Reason Code for Payments
     */
    @SerializedName( "PaymentDifferenceReason" )
    @JsonProperty( "PaymentDifferenceReason" )
    @Nullable
    @ODataField( odataName = "PaymentDifferenceReason" )
    private String paymentDifferenceReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDifferenceReason</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_DIFFERENCE_REASON =
        new PaymentAdviceItemField<String>("PaymentDifferenceReason");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> CURRENCY = new PaymentAdviceItemField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1IDByBusinessPartner</b>
     * </p>
     *
     * @return Business Partner Reference Key 1
     */
    @SerializedName( "Reference1IDByBusinessPartner" )
    @JsonProperty( "Reference1IDByBusinessPartner" )
    @Nullable
    @ODataField( odataName = "Reference1IDByBusinessPartner" )
    private String reference1IDByBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference1IDByBusinessPartner</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> REFERENCE1_I_D_BY_BUSINESS_PARTNER =
        new PaymentAdviceItemField<String>("Reference1IDByBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2IDByBusinessPartner</b>
     * </p>
     *
     * @return Business Partner Reference Key 2
     */
    @SerializedName( "Reference2IDByBusinessPartner" )
    @JsonProperty( "Reference2IDByBusinessPartner" )
    @Nullable
    @ODataField( odataName = "Reference2IDByBusinessPartner" )
    private String reference2IDByBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference2IDByBusinessPartner</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> REFERENCE2_I_D_BY_BUSINESS_PARTNER =
        new PaymentAdviceItemField<String>("Reference2IDByBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @return Delivery
     */
    @SerializedName( "DeliveryDocument" )
    @JsonProperty( "DeliveryDocument" )
    @Nullable
    @ODataField( odataName = "DeliveryDocument" )
    private String deliveryDocument;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDocument</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> DELIVERY_DOCUMENT =
        new PaymentAdviceItemField<String>("DeliveryDocument");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceDate</b>
     * </p>
     *
     * @return Document Date
     */
    @SerializedName( "InvoiceDate" )
    @JsonProperty( "InvoiceDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "InvoiceDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime invoiceDate;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceDate</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<LocalDateTime> INVOICE_DATE =
        new PaymentAdviceItemField<LocalDateTime>("InvoiceDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocReferenceByCust</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchasingDocReferenceByCust" )
    @JsonProperty( "PurchasingDocReferenceByCust" )
    @Nullable
    @ODataField( odataName = "PurchasingDocReferenceByCust" )
    private String purchasingDocReferenceByCust;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocReferenceByCust</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PURCHASING_DOC_REFERENCE_BY_CUST =
        new PaymentAdviceItemField<String>("PurchasingDocReferenceByCust");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPostedOnAccount</b>
     * </p>
     *
     * @return Indicator: Posting on account
     */
    @SerializedName( "IsPostedOnAccount" )
    @JsonProperty( "IsPostedOnAccount" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPostedOnAccount" )
    private Boolean isPostedOnAccount;
    /**
     * Use with available fluent helpers to apply the <b>IsPostedOnAccount</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<Boolean> IS_POSTED_ON_ACCOUNT =
        new PaymentAdviceItemField<Boolean>("IsPostedOnAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceStatus</b>
     * </p>
     *
     * @return Payment Advice Status
     */
    @SerializedName( "PaymentAdviceStatus" )
    @JsonProperty( "PaymentAdviceStatus" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceStatus" )
    private String paymentAdviceStatus;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceStatus</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_STATUS =
        new PaymentAdviceItemField<String>("PaymentAdviceStatus");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeductionAmountInPaytCurrency</b>
     * </p>
     *
     * @return Deduction Amount
     */
    @SerializedName( "DeductionAmountInPaytCurrency" )
    @JsonProperty( "DeductionAmountInPaytCurrency" )
    @Nullable
    @ODataField( odataName = "DeductionAmountInPaytCurrency" )
    private BigDecimal deductionAmountInPaytCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DeductionAmountInPaytCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<BigDecimal> DEDUCTION_AMOUNT_IN_PAYT_CURRENCY =
        new PaymentAdviceItemField<BigDecimal>("DeductionAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_REFERENCE =
        new PaymentAdviceItemField<String>("PaymentReference");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionField</b>
     * </p>
     *
     * @return Name of Selection Field
     */
    @SerializedName( "PaymentAdviceSelectionField" )
    @JsonProperty( "PaymentAdviceSelectionField" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceSelectionField" )
    private String paymentAdviceSelectionField;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceSelectionField</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_SELECTION_FIELD =
        new PaymentAdviceItemField<String>("PaymentAdviceSelectionField");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionValue</b>
     * </p>
     *
     * @return Selection Value (Payment Advice Management)
     */
    @SerializedName( "PaymentAdviceSelectionValue" )
    @JsonProperty( "PaymentAdviceSelectionValue" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceSelectionValue" )
    private String paymentAdviceSelectionValue;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceSelectionValue</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYMENT_ADVICE_SELECTION_VALUE =
        new PaymentAdviceItemField<String>("PaymentAdviceSelectionValue");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaytAdvcExternalSelectionField</b>
     * </p>
     *
     * @return Name of External Selection Field Specified
     */
    @SerializedName( "PaytAdvcExternalSelectionField" )
    @JsonProperty( "PaytAdvcExternalSelectionField" )
    @Nullable
    @ODataField( odataName = "PaytAdvcExternalSelectionField" )
    private String paytAdvcExternalSelectionField;
    /**
     * Use with available fluent helpers to apply the <b>PaytAdvcExternalSelectionField</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> PAYT_ADVC_EXTERNAL_SELECTION_FIELD =
        new PaymentAdviceItemField<String>("PaytAdvcExternalSelectionField");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @SerializedName( "TaxCalculationProcedure" )
    @JsonProperty( "TaxCalculationProcedure" )
    @Nullable
    @ODataField( odataName = "TaxCalculationProcedure" )
    private String taxCalculationProcedure;
    /**
     * Use with available fluent helpers to apply the <b>TaxCalculationProcedure</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> TAX_CALCULATION_PROCEDURE =
        new PaymentAdviceItemField<String>("TaxCalculationProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     *
     * @return Additional Currency 1
     */
    @SerializedName( "AdditionalCurrency1" )
    @JsonProperty( "AdditionalCurrency1" )
    @Nullable
    @ODataField( odataName = "AdditionalCurrency1" )
    private String additionalCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCurrency1</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ADDITIONAL_CURRENCY1 =
        new PaymentAdviceItemField<String>("AdditionalCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     *
     * @return Additional Currency 2
     */
    @SerializedName( "AdditionalCurrency2" )
    @JsonProperty( "AdditionalCurrency2" )
    @Nullable
    @ODataField( odataName = "AdditionalCurrency2" )
    private String additionalCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCurrency2</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> ADDITIONAL_CURRENCY2 =
        new PaymentAdviceItemField<String>("AdditionalCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static PaymentAdviceItemField<String> COMPANY_CODE_CURRENCY =
        new PaymentAdviceItemField<String>("CompanyCodeCurrency");

    @Nonnull
    @Override
    public Class<PaymentAdviceItem> getType()
    {
        return PaymentAdviceItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     */
    public void setPaymentAdviceAccountType( @Nullable final String paymentAdviceAccountType )
    {
        rememberChangedField("PaymentAdviceAccountType", this.paymentAdviceAccountType);
        this.paymentAdviceAccountType = paymentAdviceAccountType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @param paymentAdviceAccount
     *            Account Number
     */
    public void setPaymentAdviceAccount( @Nullable final String paymentAdviceAccount )
    {
        rememberChangedField("PaymentAdviceAccount", this.paymentAdviceAccount);
        this.paymentAdviceAccount = paymentAdviceAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @param paymentAdvice
     *            Payment Advice Number
     */
    public void setPaymentAdvice( @Nullable final String paymentAdvice )
    {
        rememberChangedField("PaymentAdvice", this.paymentAdvice);
        this.paymentAdvice = paymentAdvice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceItem</b>
     * </p>
     *
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     */
    public void setPaymentAdviceItem( @Nullable final String paymentAdviceItem )
    {
        rememberChangedField("PaymentAdviceItem", this.paymentAdviceItem);
        this.paymentAdviceItem = paymentAdviceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAltvAccount</b>
     * </p>
     *
     * @param paymentAdviceAltvAccount
     *            Alternative Account (Payment Advice Management)
     */
    public void setPaymentAdviceAltvAccount( @Nullable final String paymentAdviceAltvAccount )
    {
        rememberChangedField("PaymentAdviceAltvAccount", this.paymentAdviceAltvAccount);
        this.paymentAdviceAltvAccount = paymentAdviceAltvAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeCompanyCode</b>
     * </p>
     *
     * @param alternativeCompanyCode
     *            Alternative Company Code (Payment Advice Management)
     */
    public void setAlternativeCompanyCode( @Nullable final String alternativeCompanyCode )
    {
        rememberChangedField("AlternativeCompanyCode", this.alternativeCompanyCode);
        this.alternativeCompanyCode = alternativeCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Document Number of an Accounting Document
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Reference Document
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocument</b>
     * </p>
     *
     * @param billingDocument
     *            Billing Document
     */
    public void setBillingDocument( @Nullable final String billingDocument )
    {
        rememberChangedField("BillingDocument", this.billingDocument);
        this.billingDocument = billingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BranchAccount</b>
     * </p>
     *
     * @param branchAccount
     *            Account Number of the Branch
     */
    public void setBranchAccount( @Nullable final String branchAccount )
    {
        rememberChangedField("BranchAccount", this.branchAccount);
        this.branchAccount = branchAccount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @param accountingDocumentCreationDate
     *            Accounting Document Entry Date
     */
    public void setAccountingDocumentCreationDate( @Nullable final LocalDateTime accountingDocumentCreationDate )
    {
        rememberChangedField("AccountingDocumentCreationDate", this.accountingDocumentCreationDate);
        this.accountingDocumentCreationDate = accountingDocumentCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaytDifferenceReasonExtCode</b>
     * </p>
     *
     * @param paytDifferenceReasonExtCode
     *            External Reason Code for Payment Differences
     */
    public void setPaytDifferenceReasonExtCode( @Nullable final String paytDifferenceReasonExtCode )
    {
        rememberChangedField("PaytDifferenceReasonExtCode", this.paytDifferenceReasonExtCode);
        this.paytDifferenceReasonExtCode = paytDifferenceReasonExtCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param taxAmountInCoCodeCrcy
     *            Tax Amount in Local Currency
     */
    public void setTaxAmountInCoCodeCrcy( @Nullable final BigDecimal taxAmountInCoCodeCrcy )
    {
        rememberChangedField("TaxAmountInCoCodeCrcy", this.taxAmountInCoCodeCrcy);
        this.taxAmountInCoCodeCrcy = taxAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossAmountInPaymentCurrency</b>
     * </p>
     *
     * @param grossAmountInPaymentCurrency
     *            Gross Amount
     */
    public void setGrossAmountInPaymentCurrency( @Nullable final BigDecimal grossAmountInPaymentCurrency )
    {
        rememberChangedField("GrossAmountInPaymentCurrency", this.grossAmountInPaymentCurrency);
        this.grossAmountInPaymentCurrency = grossAmountInPaymentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmountInPaytCurrency</b>
     * </p>
     *
     * @param netPaymentAmountInPaytCurrency
     *            Net Payment Amount with +/- Sign
     */
    public void setNetPaymentAmountInPaytCurrency( @Nullable final BigDecimal netPaymentAmountInPaytCurrency )
    {
        rememberChangedField("NetPaymentAmountInPaytCurrency", this.netPaymentAmountInPaytCurrency);
        this.netPaymentAmountInPaytCurrency = netPaymentAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInPaytCrcy</b>
     * </p>
     *
     * @param cashDiscountAmountInPaytCrcy
     *            Cash Discount Amount with +/- Sign
     */
    public void setCashDiscountAmountInPaytCrcy( @Nullable final BigDecimal cashDiscountAmountInPaytCrcy )
    {
        rememberChangedField("CashDiscountAmountInPaytCrcy", this.cashDiscountAmountInPaytCrcy);
        this.cashDiscountAmountInPaytCrcy = cashDiscountAmountInPaytCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentItem</b>
     * </p>
     *
     * @param accountingDocumentItem
     *            Posting View Item
     */
    public void setAccountingDocumentItem( @Nullable final String accountingDocumentItem )
    {
        rememberChangedField("AccountingDocumentItem", this.accountingDocumentItem);
        this.accountingDocumentItem = accountingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAltvAccountType</b>
     * </p>
     *
     * @param paymentAdviceAltvAccountType
     *            Account Type
     */
    public void setPaymentAdviceAltvAccountType( @Nullable final String paymentAdviceAltvAccountType )
    {
        rememberChangedField("PaymentAdviceAltvAccountType", this.paymentAdviceAltvAccountType);
        this.paymentAdviceAltvAccountType = paymentAdviceAltvAccountType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountPercent</b>
     * </p>
     *
     * @param cashDiscountPercent
     *            Selected Cash Discount Percentage Rate
     */
    public void setCashDiscountPercent( @Nullable final BigDecimal cashDiscountPercent )
    {
        rememberChangedField("CashDiscountPercent", this.cashDiscountPercent);
        this.cashDiscountPercent = cashDiscountPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountDays</b>
     * </p>
     *
     * @param cashDiscountDays
     *            Selected Cash Discount Days
     */
    public void setCashDiscountDays( @Nullable final BigDecimal cashDiscountDays )
    {
        rememberChangedField("CashDiscountDays", this.cashDiscountDays);
        this.cashDiscountDays = cashDiscountDays;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param differenceAmountInCoCodeCrcy
     *            Amount Difference in Local Currency
     */
    public void setDifferenceAmountInCoCodeCrcy( @Nullable final BigDecimal differenceAmountInCoCodeCrcy )
    {
        rememberChangedField("DifferenceAmountInCoCodeCrcy", this.differenceAmountInCoCodeCrcy);
        this.differenceAmountInCoCodeCrcy = differenceAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmount</b>
     * </p>
     *
     * @param differenceAmount
     *            Amount Difference in Foreign Currency
     */
    public void setDifferenceAmount( @Nullable final BigDecimal differenceAmount )
    {
        rememberChangedField("DifferenceAmount", this.differenceAmount);
        this.differenceAmount = differenceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DiffAmtInAdditionalCurrency1</b>
     * </p>
     *
     * @param diffAmtInAdditionalCurrency1
     *            Amount Difference in Second Local Currency
     */
    public void setDiffAmtInAdditionalCurrency1( @Nullable final BigDecimal diffAmtInAdditionalCurrency1 )
    {
        rememberChangedField("DiffAmtInAdditionalCurrency1", this.diffAmtInAdditionalCurrency1);
        this.diffAmtInAdditionalCurrency1 = diffAmtInAdditionalCurrency1;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DiffAmtInAdditionalCurrency2</b>
     * </p>
     *
     * @param diffAmtInAdditionalCurrency2
     *            Amount Difference in Third Local Currency
     */
    public void setDiffAmtInAdditionalCurrency2( @Nullable final BigDecimal diffAmtInAdditionalCurrency2 )
    {
        rememberChangedField("DiffAmtInAdditionalCurrency2", this.diffAmtInAdditionalCurrency2);
        this.diffAmtInAdditionalCurrency2 = diffAmtInAdditionalCurrency2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsActivated</b>
     * </p>
     *
     * @param itemIsActivated
     *            Indicator: Items Activated?
     */
    public void setItemIsActivated( @Nullable final Boolean itemIsActivated )
    {
        rememberChangedField("ItemIsActivated", this.itemIsActivated);
        this.itemIsActivated = itemIsActivated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsActivated</b>
     * </p>
     *
     * @param cashDiscountIsActivated
     *            Flag whether Cash Discount is Active
     */
    public void setCashDiscountIsActivated( @Nullable final Boolean cashDiscountIsActivated )
    {
        rememberChangedField("CashDiscountIsActivated", this.cashDiscountIsActivated);
        this.cashDiscountIsActivated = cashDiscountIsActivated;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPartialPayment</b>
     * </p>
     *
     * @param isPartialPayment
     *            Indicator: Partial Payments
     */
    public void setIsPartialPayment( @Nullable final Boolean isPartialPayment )
    {
        rememberChangedField("IsPartialPayment", this.isPartialPayment);
        this.isPartialPayment = isPartialPayment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PaytDiffRsdlBalIsCarriedFwd</b>
     * </p>
     *
     * @param paytDiffRsdlBalIsCarriedFwd
     *            Indicator: Carryforward Residual Bal. for Payt Difference?
     */
    public void setPaytDiffRsdlBalIsCarriedFwd( @Nullable final Boolean paytDiffRsdlBalIsCarriedFwd )
    {
        rememberChangedField("PaytDiffRsdlBalIsCarriedFwd", this.paytDiffRsdlBalIsCarriedFwd);
        this.paytDiffRsdlBalIsCarriedFwd = paytDiffRsdlBalIsCarriedFwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @param paymentDifferenceReason
     *            Reason Code for Payments
     */
    public void setPaymentDifferenceReason( @Nullable final String paymentDifferenceReason )
    {
        rememberChangedField("PaymentDifferenceReason", this.paymentDifferenceReason);
        this.paymentDifferenceReason = paymentDifferenceReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1IDByBusinessPartner</b>
     * </p>
     *
     * @param reference1IDByBusinessPartner
     *            Business Partner Reference Key 1
     */
    public void setReference1IDByBusinessPartner( @Nullable final String reference1IDByBusinessPartner )
    {
        rememberChangedField("Reference1IDByBusinessPartner", this.reference1IDByBusinessPartner);
        this.reference1IDByBusinessPartner = reference1IDByBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2IDByBusinessPartner</b>
     * </p>
     *
     * @param reference2IDByBusinessPartner
     *            Business Partner Reference Key 2
     */
    public void setReference2IDByBusinessPartner( @Nullable final String reference2IDByBusinessPartner )
    {
        rememberChangedField("Reference2IDByBusinessPartner", this.reference2IDByBusinessPartner);
        this.reference2IDByBusinessPartner = reference2IDByBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDocument</b>
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     */
    public void setDeliveryDocument( @Nullable final String deliveryDocument )
    {
        rememberChangedField("DeliveryDocument", this.deliveryDocument);
        this.deliveryDocument = deliveryDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceDate</b>
     * </p>
     *
     * @param invoiceDate
     *            Document Date
     */
    public void setInvoiceDate( @Nullable final LocalDateTime invoiceDate )
    {
        rememberChangedField("InvoiceDate", this.invoiceDate);
        this.invoiceDate = invoiceDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocReferenceByCust</b>
     * </p>
     *
     * @param purchasingDocReferenceByCust
     *            Customer Reference
     */
    public void setPurchasingDocReferenceByCust( @Nullable final String purchasingDocReferenceByCust )
    {
        rememberChangedField("PurchasingDocReferenceByCust", this.purchasingDocReferenceByCust);
        this.purchasingDocReferenceByCust = purchasingDocReferenceByCust;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPostedOnAccount</b>
     * </p>
     *
     * @param isPostedOnAccount
     *            Indicator: Posting on account
     */
    public void setIsPostedOnAccount( @Nullable final Boolean isPostedOnAccount )
    {
        rememberChangedField("IsPostedOnAccount", this.isPostedOnAccount);
        this.isPostedOnAccount = isPostedOnAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceStatus</b>
     * </p>
     *
     * @param paymentAdviceStatus
     *            Payment Advice Status
     */
    public void setPaymentAdviceStatus( @Nullable final String paymentAdviceStatus )
    {
        rememberChangedField("PaymentAdviceStatus", this.paymentAdviceStatus);
        this.paymentAdviceStatus = paymentAdviceStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeductionAmountInPaytCurrency</b>
     * </p>
     *
     * @param deductionAmountInPaytCurrency
     *            Deduction Amount
     */
    public void setDeductionAmountInPaytCurrency( @Nullable final BigDecimal deductionAmountInPaytCurrency )
    {
        rememberChangedField("DeductionAmountInPaytCurrency", this.deductionAmountInPaytCurrency);
        this.deductionAmountInPaytCurrency = deductionAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionField</b>
     * </p>
     *
     * @param paymentAdviceSelectionField
     *            Name of Selection Field
     */
    public void setPaymentAdviceSelectionField( @Nullable final String paymentAdviceSelectionField )
    {
        rememberChangedField("PaymentAdviceSelectionField", this.paymentAdviceSelectionField);
        this.paymentAdviceSelectionField = paymentAdviceSelectionField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceSelectionValue</b>
     * </p>
     *
     * @param paymentAdviceSelectionValue
     *            Selection Value (Payment Advice Management)
     */
    public void setPaymentAdviceSelectionValue( @Nullable final String paymentAdviceSelectionValue )
    {
        rememberChangedField("PaymentAdviceSelectionValue", this.paymentAdviceSelectionValue);
        this.paymentAdviceSelectionValue = paymentAdviceSelectionValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaytAdvcExternalSelectionField</b>
     * </p>
     *
     * @param paytAdvcExternalSelectionField
     *            Name of External Selection Field Specified
     */
    public void setPaytAdvcExternalSelectionField( @Nullable final String paytAdvcExternalSelectionField )
    {
        rememberChangedField("PaytAdvcExternalSelectionField", this.paytAdvcExternalSelectionField);
        this.paytAdvcExternalSelectionField = paytAdvcExternalSelectionField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     *
     * @param taxCalculationProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setTaxCalculationProcedure( @Nullable final String taxCalculationProcedure )
    {
        rememberChangedField("TaxCalculationProcedure", this.taxCalculationProcedure);
        this.taxCalculationProcedure = taxCalculationProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     *
     * @param additionalCurrency1
     *            Additional Currency 1
     */
    public void setAdditionalCurrency1( @Nullable final String additionalCurrency1 )
    {
        rememberChangedField("AdditionalCurrency1", this.additionalCurrency1);
        this.additionalCurrency1 = additionalCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     *
     * @param additionalCurrency2
     *            Additional Currency 2
     */
    public void setAdditionalCurrency2( @Nullable final String additionalCurrency2 )
    {
        rememberChangedField("AdditionalCurrency2", this.additionalCurrency2);
        this.additionalCurrency2 = additionalCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Currency Key
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PaymentAdviceItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        result.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        result.put("PaymentAdvice", getPaymentAdvice());
        result.put("PaymentAdviceItem", getPaymentAdviceItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        values.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        values.put("PaymentAdvice", getPaymentAdvice());
        values.put("PaymentAdviceItem", getPaymentAdviceItem());
        values.put("PaymentAdviceAltvAccount", getPaymentAdviceAltvAccount());
        values.put("AlternativeCompanyCode", getAlternativeCompanyCode());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("BillingDocument", getBillingDocument());
        values.put("BranchAccount", getBranchAccount());
        values.put("AccountingDocumentCreationDate", getAccountingDocumentCreationDate());
        values.put("BusinessArea", getBusinessArea());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("PaytDifferenceReasonExtCode", getPaytDifferenceReasonExtCode());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("TaxAmountInCoCodeCrcy", getTaxAmountInCoCodeCrcy());
        values.put("TaxCode", getTaxCode());
        values.put("GrossAmountInPaymentCurrency", getGrossAmountInPaymentCurrency());
        values.put("NetPaymentAmountInPaytCurrency", getNetPaymentAmountInPaytCurrency());
        values.put("CashDiscountAmountInPaytCrcy", getCashDiscountAmountInPaytCrcy());
        values.put("FiscalYear", getFiscalYear());
        values.put("AccountingDocumentItem", getAccountingDocumentItem());
        values.put("PaymentAdviceAltvAccountType", getPaymentAdviceAltvAccountType());
        values.put("CashDiscountPercent", getCashDiscountPercent());
        values.put("CashDiscountDays", getCashDiscountDays());
        values.put("DifferenceAmountInCoCodeCrcy", getDifferenceAmountInCoCodeCrcy());
        values.put("DifferenceAmount", getDifferenceAmount());
        values.put("DiffAmtInAdditionalCurrency1", getDiffAmtInAdditionalCurrency1());
        values.put("DiffAmtInAdditionalCurrency2", getDiffAmtInAdditionalCurrency2());
        values.put("ItemIsActivated", getItemIsActivated());
        values.put("CashDiscountIsActivated", getCashDiscountIsActivated());
        values.put("IsPartialPayment", getIsPartialPayment());
        values.put("PaytDiffRsdlBalIsCarriedFwd", getPaytDiffRsdlBalIsCarriedFwd());
        values.put("PaymentDifferenceReason", getPaymentDifferenceReason());
        values.put("Currency", getCurrency());
        values.put("Reference1IDByBusinessPartner", getReference1IDByBusinessPartner());
        values.put("Reference2IDByBusinessPartner", getReference2IDByBusinessPartner());
        values.put("DeliveryDocument", getDeliveryDocument());
        values.put("InvoiceDate", getInvoiceDate());
        values.put("PurchasingDocReferenceByCust", getPurchasingDocReferenceByCust());
        values.put("IsPostedOnAccount", getIsPostedOnAccount());
        values.put("PaymentAdviceStatus", getPaymentAdviceStatus());
        values.put("DeductionAmountInPaytCurrency", getDeductionAmountInPaytCurrency());
        values.put("PaymentReference", getPaymentReference());
        values.put("PaymentAdviceSelectionField", getPaymentAdviceSelectionField());
        values.put("PaymentAdviceSelectionValue", getPaymentAdviceSelectionValue());
        values.put("PaytAdvcExternalSelectionField", getPaytAdvcExternalSelectionField());
        values.put("TaxCalculationProcedure", getTaxCalculationProcedure());
        values.put("AdditionalCurrency1", getAdditionalCurrency1());
        values.put("AdditionalCurrency2", getAdditionalCurrency2());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccountType") ) {
                final Object value = values.remove("PaymentAdviceAccountType");
                if( (value == null) || (!value.equals(getPaymentAdviceAccountType())) ) {
                    setPaymentAdviceAccountType(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccount") ) {
                final Object value = values.remove("PaymentAdviceAccount");
                if( (value == null) || (!value.equals(getPaymentAdviceAccount())) ) {
                    setPaymentAdviceAccount(((String) value));
                }
            }
            if( values.containsKey("PaymentAdvice") ) {
                final Object value = values.remove("PaymentAdvice");
                if( (value == null) || (!value.equals(getPaymentAdvice())) ) {
                    setPaymentAdvice(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceItem") ) {
                final Object value = values.remove("PaymentAdviceItem");
                if( (value == null) || (!value.equals(getPaymentAdviceItem())) ) {
                    setPaymentAdviceItem(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAltvAccount") ) {
                final Object value = values.remove("PaymentAdviceAltvAccount");
                if( (value == null) || (!value.equals(getPaymentAdviceAltvAccount())) ) {
                    setPaymentAdviceAltvAccount(((String) value));
                }
            }
            if( values.containsKey("AlternativeCompanyCode") ) {
                final Object value = values.remove("AlternativeCompanyCode");
                if( (value == null) || (!value.equals(getAlternativeCompanyCode())) ) {
                    setAlternativeCompanyCode(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("BillingDocument") ) {
                final Object value = values.remove("BillingDocument");
                if( (value == null) || (!value.equals(getBillingDocument())) ) {
                    setBillingDocument(((String) value));
                }
            }
            if( values.containsKey("BranchAccount") ) {
                final Object value = values.remove("BranchAccount");
                if( (value == null) || (!value.equals(getBranchAccount())) ) {
                    setBranchAccount(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCreationDate") ) {
                final Object value = values.remove("AccountingDocumentCreationDate");
                if( (value == null) || (!value.equals(getAccountingDocumentCreationDate())) ) {
                    setAccountingDocumentCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("PaytDifferenceReasonExtCode") ) {
                final Object value = values.remove("PaytDifferenceReasonExtCode");
                if( (value == null) || (!value.equals(getPaytDifferenceReasonExtCode())) ) {
                    setPaytDifferenceReasonExtCode(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("TaxAmountInCoCodeCrcy") ) {
                final Object value = values.remove("TaxAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getTaxAmountInCoCodeCrcy())) ) {
                    setTaxAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("GrossAmountInPaymentCurrency") ) {
                final Object value = values.remove("GrossAmountInPaymentCurrency");
                if( (value == null) || (!value.equals(getGrossAmountInPaymentCurrency())) ) {
                    setGrossAmountInPaymentCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentAmountInPaytCurrency") ) {
                final Object value = values.remove("NetPaymentAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getNetPaymentAmountInPaytCurrency())) ) {
                    setNetPaymentAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmountInPaytCrcy") ) {
                final Object value = values.remove("CashDiscountAmountInPaytCrcy");
                if( (value == null) || (!value.equals(getCashDiscountAmountInPaytCrcy())) ) {
                    setCashDiscountAmountInPaytCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentItem") ) {
                final Object value = values.remove("AccountingDocumentItem");
                if( (value == null) || (!value.equals(getAccountingDocumentItem())) ) {
                    setAccountingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAltvAccountType") ) {
                final Object value = values.remove("PaymentAdviceAltvAccountType");
                if( (value == null) || (!value.equals(getPaymentAdviceAltvAccountType())) ) {
                    setPaymentAdviceAltvAccountType(((String) value));
                }
            }
            if( values.containsKey("CashDiscountPercent") ) {
                final Object value = values.remove("CashDiscountPercent");
                if( (value == null) || (!value.equals(getCashDiscountPercent())) ) {
                    setCashDiscountPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountDays") ) {
                final Object value = values.remove("CashDiscountDays");
                if( (value == null) || (!value.equals(getCashDiscountDays())) ) {
                    setCashDiscountDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("DifferenceAmountInCoCodeCrcy") ) {
                final Object value = values.remove("DifferenceAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getDifferenceAmountInCoCodeCrcy())) ) {
                    setDifferenceAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("DifferenceAmount") ) {
                final Object value = values.remove("DifferenceAmount");
                if( (value == null) || (!value.equals(getDifferenceAmount())) ) {
                    setDifferenceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DiffAmtInAdditionalCurrency1") ) {
                final Object value = values.remove("DiffAmtInAdditionalCurrency1");
                if( (value == null) || (!value.equals(getDiffAmtInAdditionalCurrency1())) ) {
                    setDiffAmtInAdditionalCurrency1(((BigDecimal) value));
                }
            }
            if( values.containsKey("DiffAmtInAdditionalCurrency2") ) {
                final Object value = values.remove("DiffAmtInAdditionalCurrency2");
                if( (value == null) || (!value.equals(getDiffAmtInAdditionalCurrency2())) ) {
                    setDiffAmtInAdditionalCurrency2(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemIsActivated") ) {
                final Object value = values.remove("ItemIsActivated");
                if( (value == null) || (!value.equals(getItemIsActivated())) ) {
                    setItemIsActivated(((Boolean) value));
                }
            }
            if( values.containsKey("CashDiscountIsActivated") ) {
                final Object value = values.remove("CashDiscountIsActivated");
                if( (value == null) || (!value.equals(getCashDiscountIsActivated())) ) {
                    setCashDiscountIsActivated(((Boolean) value));
                }
            }
            if( values.containsKey("IsPartialPayment") ) {
                final Object value = values.remove("IsPartialPayment");
                if( (value == null) || (!value.equals(getIsPartialPayment())) ) {
                    setIsPartialPayment(((Boolean) value));
                }
            }
            if( values.containsKey("PaytDiffRsdlBalIsCarriedFwd") ) {
                final Object value = values.remove("PaytDiffRsdlBalIsCarriedFwd");
                if( (value == null) || (!value.equals(getPaytDiffRsdlBalIsCarriedFwd())) ) {
                    setPaytDiffRsdlBalIsCarriedFwd(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentDifferenceReason") ) {
                final Object value = values.remove("PaymentDifferenceReason");
                if( (value == null) || (!value.equals(getPaymentDifferenceReason())) ) {
                    setPaymentDifferenceReason(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Reference1IDByBusinessPartner") ) {
                final Object value = values.remove("Reference1IDByBusinessPartner");
                if( (value == null) || (!value.equals(getReference1IDByBusinessPartner())) ) {
                    setReference1IDByBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("Reference2IDByBusinessPartner") ) {
                final Object value = values.remove("Reference2IDByBusinessPartner");
                if( (value == null) || (!value.equals(getReference2IDByBusinessPartner())) ) {
                    setReference2IDByBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("DeliveryDocument") ) {
                final Object value = values.remove("DeliveryDocument");
                if( (value == null) || (!value.equals(getDeliveryDocument())) ) {
                    setDeliveryDocument(((String) value));
                }
            }
            if( values.containsKey("InvoiceDate") ) {
                final Object value = values.remove("InvoiceDate");
                if( (value == null) || (!value.equals(getInvoiceDate())) ) {
                    setInvoiceDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchasingDocReferenceByCust") ) {
                final Object value = values.remove("PurchasingDocReferenceByCust");
                if( (value == null) || (!value.equals(getPurchasingDocReferenceByCust())) ) {
                    setPurchasingDocReferenceByCust(((String) value));
                }
            }
            if( values.containsKey("IsPostedOnAccount") ) {
                final Object value = values.remove("IsPostedOnAccount");
                if( (value == null) || (!value.equals(getIsPostedOnAccount())) ) {
                    setIsPostedOnAccount(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentAdviceStatus") ) {
                final Object value = values.remove("PaymentAdviceStatus");
                if( (value == null) || (!value.equals(getPaymentAdviceStatus())) ) {
                    setPaymentAdviceStatus(((String) value));
                }
            }
            if( values.containsKey("DeductionAmountInPaytCurrency") ) {
                final Object value = values.remove("DeductionAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getDeductionAmountInPaytCurrency())) ) {
                    setDeductionAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceSelectionField") ) {
                final Object value = values.remove("PaymentAdviceSelectionField");
                if( (value == null) || (!value.equals(getPaymentAdviceSelectionField())) ) {
                    setPaymentAdviceSelectionField(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceSelectionValue") ) {
                final Object value = values.remove("PaymentAdviceSelectionValue");
                if( (value == null) || (!value.equals(getPaymentAdviceSelectionValue())) ) {
                    setPaymentAdviceSelectionValue(((String) value));
                }
            }
            if( values.containsKey("PaytAdvcExternalSelectionField") ) {
                final Object value = values.remove("PaytAdvcExternalSelectionField");
                if( (value == null) || (!value.equals(getPaytAdvcExternalSelectionField())) ) {
                    setPaytAdvcExternalSelectionField(((String) value));
                }
            }
            if( values.containsKey("TaxCalculationProcedure") ) {
                final Object value = values.remove("TaxCalculationProcedure");
                if( (value == null) || (!value.equals(getTaxCalculationProcedure())) ) {
                    setTaxCalculationProcedure(((String) value));
                }
            }
            if( values.containsKey("AdditionalCurrency1") ) {
                final Object value = values.remove("AdditionalCurrency1");
                if( (value == null) || (!value.equals(getAdditionalCurrency1())) ) {
                    setAdditionalCurrency1(((String) value));
                }
            }
            if( values.containsKey("AdditionalCurrency2") ) {
                final Object value = values.remove("AdditionalCurrency2");
                if( (value == null) || (!value.equals(getAdditionalCurrency2())) ) {
                    setAdditionalCurrency2(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PaymentAdviceItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PaymentAdviceItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PaymentAdviceItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PaymentAdviceItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService.DEFAULT_SERVICE_PATH);
    }

}
