/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.selectable.PaymentAdviceItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem PaymentAdviceItem} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class PaymentAdviceItemByKeyFluentHelper
    extends
    FluentHelperByKey<PaymentAdviceItemByKeyFluentHelper, PaymentAdviceItem, PaymentAdviceItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem PaymentAdviceItem}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PaymentAdviceItem}
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PaymentAdviceItem}
     * @param paymentAdvice
     *            Payment Advice Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param paymentAdviceAccount
     *            Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public PaymentAdviceItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String companyCode,
        final String paymentAdviceAccountType,
        final String paymentAdviceAccount,
        final String paymentAdvice,
        final String paymentAdviceItem )
    {
        super(servicePath, entityCollection);
        this.key.put("CompanyCode", companyCode);
        this.key.put("PaymentAdviceAccountType", paymentAdviceAccountType);
        this.key.put("PaymentAdviceAccount", paymentAdviceAccount);
        this.key.put("PaymentAdvice", paymentAdvice);
        this.key.put("PaymentAdviceItem", paymentAdviceItem);
    }

    @Override
    @Nonnull
    protected Class<PaymentAdviceItem> getEntityClass()
    {
        return PaymentAdviceItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
