/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PaymentAdviceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService PaymentAdviceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPaymentAdviceServiceBatch
    extends
    BatchFluentHelperBasic<PaymentAdviceServiceBatch, PaymentAdviceServiceBatchChangeSet>
    implements
    PaymentAdviceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPaymentAdviceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPaymentAdviceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPaymentAdviceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPaymentAdviceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPaymentAdviceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPaymentAdviceServiceBatchChangeSet(this, service);
    }

}
