/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem;

/**
 * Implementation of the {@link PaymentAdviceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService PaymentAdviceService}.
 *
 */
public class DefaultPaymentAdviceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PaymentAdviceServiceBatch, PaymentAdviceServiceBatchChangeSet>
    implements
    PaymentAdviceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService service;

    @SuppressWarnings( "deprecation" )
    DefaultPaymentAdviceServiceBatchChangeSet(
        @Nonnull final DefaultPaymentAdviceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPaymentAdviceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet createPaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return addRequestCreate(service::createPaymentAdvice, paymentAdvice);
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet updatePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return addRequestUpdate(service::updatePaymentAdvice, paymentAdvice);
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet deletePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice )
    {
        return addRequestDelete(service::deletePaymentAdvice, paymentAdvice);
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet createPaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return addRequestCreate(service::createPaymentAdviceItem, paymentAdviceItem);
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet updatePaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return addRequestUpdate(service::updatePaymentAdviceItem, paymentAdviceItem);
    }

    @Nonnull
    @Override
    public PaymentAdviceServiceBatchChangeSet deletePaymentAdviceItem(
        @Nonnull final PaymentAdviceItem paymentAdviceItem )
    {
        return addRequestDelete(service::deletePaymentAdviceItem, paymentAdviceItem);
    }

}
