/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentAdviceService PaymentAdviceService}.
 *
 */
public interface PaymentAdviceServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PaymentAdviceServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PaymentAdviceServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity and save it to the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet createPaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity and save it to the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet updatePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice
     * PaymentAdvice} entity in the S/4HANA system.
     *
     * @param paymentAdvice
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet deletePaymentAdvice( @Nonnull final PaymentAdvice paymentAdvice );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity and save it to the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet createPaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity and save it to the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet updatePaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     * PaymentAdviceItem} entity in the S/4HANA system.
     *
     * @param paymentAdviceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem
     *            PaymentAdviceItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentAdviceServiceBatchChangeSet deletePaymentAdviceItem( @Nonnull final PaymentAdviceItem paymentAdviceItem );

}
