/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem PaymentAdviceItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.field.PaymentAdviceItemField
 * PaymentAdviceItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.link.PaymentAdviceItemLink
 * PaymentAdviceItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_ACCOUNT_TYPE
 * PAYMENT_ADVICE_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_ACCOUNT
 * PAYMENT_ADVICE_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE
 * PAYMENT_ADVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_ITEM
 * PAYMENT_ADVICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_ALTV_ACCOUNT
 * PAYMENT_ADVICE_ALTV_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ALTERNATIVE_COMPANY_CODE
 * ALTERNATIVE_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ACCOUNTING_DOCUMENT
 * ACCOUNTING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DOCUMENT_REFERENCE_ID
 * DOCUMENT_REFERENCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#BILLING_DOCUMENT
 * BILLING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#BRANCH_ACCOUNT
 * BRANCH_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ACCOUNTING_DOCUMENT_CREATION_DATE
 * ACCOUNTING_DOCUMENT_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYT_DIFFERENCE_REASON_EXT_CODE
 * PAYT_DIFFERENCE_REASON_EXT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#TAX_AMOUNT_IN_CO_CODE_CRCY
 * TAX_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#GROSS_AMOUNT_IN_PAYMENT_CURRENCY
 * GROSS_AMOUNT_IN_PAYMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY
 * NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY
 * CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ACCOUNTING_DOCUMENT_ITEM
 * ACCOUNTING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_ALTV_ACCOUNT_TYPE
 * PAYMENT_ADVICE_ALTV_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#CASH_DISCOUNT_PERCENT
 * CASH_DISCOUNT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#CASH_DISCOUNT_DAYS
 * CASH_DISCOUNT_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY
 * DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DIFFERENCE_AMOUNT
 * DIFFERENCE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DIFF_AMT_IN_ADDITIONAL_CURRENCY1
 * DIFF_AMT_IN_ADDITIONAL_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DIFF_AMT_IN_ADDITIONAL_CURRENCY2
 * DIFF_AMT_IN_ADDITIONAL_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ITEM_IS_ACTIVATED
 * ITEM_IS_ACTIVATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#CASH_DISCOUNT_IS_ACTIVATED
 * CASH_DISCOUNT_IS_ACTIVATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#IS_PARTIAL_PAYMENT
 * IS_PARTIAL_PAYMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYT_DIFF_RSDL_BAL_IS_CARRIED_FWD
 * PAYT_DIFF_RSDL_BAL_IS_CARRIED_FWD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_DIFFERENCE_REASON
 * PAYMENT_DIFFERENCE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#REFERENCE1_I_D_BY_BUSINESS_PARTNER
 * REFERENCE1_I_D_BY_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#REFERENCE2_I_D_BY_BUSINESS_PARTNER
 * REFERENCE2_I_D_BY_BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#INVOICE_DATE
 * INVOICE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PURCHASING_DOC_REFERENCE_BY_CUST
 * PURCHASING_DOC_REFERENCE_BY_CUST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#IS_POSTED_ON_ACCOUNT
 * IS_POSTED_ON_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_STATUS
 * PAYMENT_ADVICE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#DEDUCTION_AMOUNT_IN_PAYT_CURRENCY
 * DEDUCTION_AMOUNT_IN_PAYT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_REFERENCE
 * PAYMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_SELECTION_FIELD
 * PAYMENT_ADVICE_SELECTION_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYMENT_ADVICE_SELECTION_VALUE
 * PAYMENT_ADVICE_SELECTION_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#PAYT_ADVC_EXTERNAL_SELECTION_FIELD
 * PAYT_ADVC_EXTERNAL_SELECTION_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#TAX_CALCULATION_PROCEDURE
 * TAX_CALCULATION_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ADDITIONAL_CURRENCY1
 * ADDITIONAL_CURRENCY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#ADDITIONAL_CURRENCY2
 * ADDITIONAL_CURRENCY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdviceItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * </ul>
 *
 */
public interface PaymentAdviceItemSelectable extends EntitySelectable<PaymentAdviceItem>
{

}
