/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice PaymentAdvice}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.field.PaymentAdviceField
 * PaymentAdviceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.link.PaymentAdviceLink PaymentAdviceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_ACCOUNT_TYPE
 * PAYMENT_ADVICE_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_ACCOUNT
 * PAYMENT_ADVICE_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE
 * PAYMENT_ADVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_DOCUMENT
 * PAYMENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#ACCOUNT_BY_SHIPPER
 * ACCOUNT_BY_SHIPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_CURRENCY
 * PAYMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_DATE
 * PAYMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAID_AMOUNT_IN_PAYT_CURRENCY
 * PAID_AMOUNT_IN_PAYT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY
 * CASH_DISCOUNT_AMOUNT_IN_PAYT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PARTNER_BANK_COUNTRY
 * PARTNER_BANK_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PARTNER_BANK_SWIFT_CODE
 * PARTNER_BANK_SWIFT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_HEADER_TEXT
 * PAYMENT_ADVICE_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_TYPE
 * PAYMENT_ADVICE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_STATUS
 * PAYMENT_ADVICE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYT_ADVC_DIFF_DETERMINATION_RULE
 * PAYT_ADVC_DIFF_DETERMINATION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_ADVICE_SELECTION_RULE
 * PAYMENT_ADVICE_SELECTION_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#ORIGINAL_REFERENCE_DOCUMENT
 * ORIGINAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#FEE_AMOUNT_IN_TRANSACTION_CRCY
 * FEE_AMOUNT_IN_TRANSACTION_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#PAYMENT_TRANSACTION
 * PAYMENT_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#EXCHANGE_RATE
 * EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#BILL_OF_EXCHANGE_FAILURE_DATE
 * BILL_OF_EXCHANGE_FAILURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#BANK_REFERENCE
 * BANK_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#BUSINESS_PARTNER_NAME
 * BUSINESS_PARTNER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentadvice.PaymentAdvice#TO_PAYMENT_ADVICE_ITEM
 * TO_PAYMENT_ADVICE_ITEM}</li>
 * </ul>
 *
 */
public interface PaymentAdviceSelectable extends EntitySelectable<PaymentAdvice>
{

}
