/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.field.PaymentReleaseListHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.link.PaymentReleaseListHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable.PaymentReleaseListHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Payment Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PaymentReleaseListHeader</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PaymentReleaseListHeader extends VdmEntity<PaymentReleaseListHeader>
{

    /**
     * Selector for all available fields of PaymentReleaseListHeader.
     *
     */
    public final static PaymentReleaseListHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselist</b>
     * </p>
     *
     * @return List ID
     */
    @Key
    @SerializedName( "Paymentreleaselist" )
    @JsonProperty( "Paymentreleaselist" )
    @Nullable
    @ODataField( odataName = "Paymentreleaselist" )
    private String paymentreleaselist;
    /**
     * Use with available fluent helpers to apply the <b>Paymentreleaselist</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<String> PAYMENTRELEASELIST =
        new PaymentReleaseListHeaderField<String>("Paymentreleaselist");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Totactualamtindisplaycurrency</b>
     * </p>
     *
     * @return TOTACTUALAMTINDISPLAYCURRENCY
     */
    @SerializedName( "Totactualamtindisplaycurrency" )
    @JsonProperty( "Totactualamtindisplaycurrency" )
    @Nullable
    @ODataField( odataName = "Totactualamtindisplaycurrency" )
    private BigDecimal totactualamtindisplaycurrency;
    /**
     * Use with available fluent helpers to apply the <b>Totactualamtindisplaycurrency</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<BigDecimal> TOTACTUALAMTINDISPLAYCURRENCY =
        new PaymentReleaseListHeaderField<BigDecimal>("Totactualamtindisplaycurrency");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuserfullname</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "Createdbyuserfullname" )
    @JsonProperty( "Createdbyuserfullname" )
    @Nullable
    @ODataField( odataName = "Createdbyuserfullname" )
    private String createdbyuserfullname;
    /**
     * Use with available fluent helpers to apply the <b>Createdbyuserfullname</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<String> CREATEDBYUSERFULLNAME =
        new PaymentReleaseListHeaderField<String>("Createdbyuserfullname");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Incgpaytfiletotalnumberofitems</b>
     * </p>
     *
     * @return INCGPAYTFILETOTALNUMBEROFITEMS
     */
    @SerializedName( "Incgpaytfiletotalnumberofitems" )
    @JsonProperty( "Incgpaytfiletotalnumberofitems" )
    @Nullable
    @ODataField( odataName = "Incgpaytfiletotalnumberofitems" )
    private String incgpaytfiletotalnumberofitems;
    /**
     * Use with available fluent helpers to apply the <b>Incgpaytfiletotalnumberofitems</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<String> INCGPAYTFILETOTALNUMBEROFITEMS =
        new PaymentReleaseListHeaderField<String>("Incgpaytfiletotalnumberofitems");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "Createdbyuser" )
    @JsonProperty( "Createdbyuser" )
    @Nullable
    @ODataField( odataName = "Createdbyuser" )
    private String createdbyuser;
    /**
     * Use with available fluent helpers to apply the <b>Createdbyuser</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<String> CREATEDBYUSER =
        new PaymentReleaseListHeaderField<String>("Createdbyuser");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "Companycode" )
    @JsonProperty( "Companycode" )
    @Nullable
    @ODataField( odataName = "Companycode" )
    private String companycode;
    /**
     * Use with available fluent helpers to apply the <b>Companycode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListHeaderField<String> COMPANYCODE =
        new PaymentReleaseListHeaderField<String>("Companycode");
    /**
     * Navigation property <b>PaymentReleaseListHeadertoItem</b> for <b>PaymentReleaseListHeader</b> to multiple
     * <b>PaymentReleaseListItem</b>.
     *
     */
    @SerializedName( "PaymentReleaseListHeadertoItem" )
    @JsonProperty( "PaymentReleaseListHeadertoItem" )
    @ODataField( odataName = "PaymentReleaseListHeadertoItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PaymentReleaseListItem> toPaymentReleaseListHeadertoItem;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReleaseListHeadertoItem</b> navigation property to query
     * operations.
     *
     */
    public final static PaymentReleaseListHeaderLink<PaymentReleaseListItem> TO_PAYMENT_RELEASE_LIST_HEADERTO_ITEM =
        new PaymentReleaseListHeaderLink<PaymentReleaseListItem>("PaymentReleaseListHeadertoItem");

    @Nonnull
    @Override
    public Class<PaymentReleaseListHeader> getType()
    {
        return PaymentReleaseListHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselist</b>
     * </p>
     *
     * @param paymentreleaselist
     *            List ID
     */
    public void setPaymentreleaselist( @Nullable final String paymentreleaselist )
    {
        rememberChangedField("Paymentreleaselist", this.paymentreleaselist);
        this.paymentreleaselist = paymentreleaselist;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Totactualamtindisplaycurrency</b>
     * </p>
     *
     * @param totactualamtindisplaycurrency
     *            TOTACTUALAMTINDISPLAYCURRENCY
     */
    public void setTotactualamtindisplaycurrency( @Nullable final BigDecimal totactualamtindisplaycurrency )
    {
        rememberChangedField("Totactualamtindisplaycurrency", this.totactualamtindisplaycurrency);
        this.totactualamtindisplaycurrency = totactualamtindisplaycurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuserfullname</b>
     * </p>
     *
     * @param createdbyuserfullname
     *            Description
     */
    public void setCreatedbyuserfullname( @Nullable final String createdbyuserfullname )
    {
        rememberChangedField("Createdbyuserfullname", this.createdbyuserfullname);
        this.createdbyuserfullname = createdbyuserfullname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Incgpaytfiletotalnumberofitems</b>
     * </p>
     *
     * @param incgpaytfiletotalnumberofitems
     *            INCGPAYTFILETOTALNUMBEROFITEMS
     */
    public void setIncgpaytfiletotalnumberofitems( @Nullable final String incgpaytfiletotalnumberofitems )
    {
        rememberChangedField("Incgpaytfiletotalnumberofitems", this.incgpaytfiletotalnumberofitems);
        this.incgpaytfiletotalnumberofitems = incgpaytfiletotalnumberofitems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuser</b>
     * </p>
     *
     * @param createdbyuser
     *            Created By
     */
    public void setCreatedbyuser( @Nullable final String createdbyuser )
    {
        rememberChangedField("Createdbyuser", this.createdbyuser);
        this.createdbyuser = createdbyuser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @param companycode
     *            Company Code
     */
    public void setCompanycode( @Nullable final String companycode )
    {
        rememberChangedField("Companycode", this.companycode);
        this.companycode = companycode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PaymentReleaseListHeaderSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Paymentreleaselist", getPaymentreleaselist());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Paymentreleaselist", getPaymentreleaselist());
        values.put("Totactualamtindisplaycurrency", getTotactualamtindisplaycurrency());
        values.put("Createdbyuserfullname", getCreatedbyuserfullname());
        values.put("Incgpaytfiletotalnumberofitems", getIncgpaytfiletotalnumberofitems());
        values.put("Createdbyuser", getCreatedbyuser());
        values.put("Companycode", getCompanycode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Paymentreleaselist") ) {
                final Object value = values.remove("Paymentreleaselist");
                if( (value == null) || (!value.equals(getPaymentreleaselist())) ) {
                    setPaymentreleaselist(((String) value));
                }
            }
            if( values.containsKey("Totactualamtindisplaycurrency") ) {
                final Object value = values.remove("Totactualamtindisplaycurrency");
                if( (value == null) || (!value.equals(getTotactualamtindisplaycurrency())) ) {
                    setTotactualamtindisplaycurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("Createdbyuserfullname") ) {
                final Object value = values.remove("Createdbyuserfullname");
                if( (value == null) || (!value.equals(getCreatedbyuserfullname())) ) {
                    setCreatedbyuserfullname(((String) value));
                }
            }
            if( values.containsKey("Incgpaytfiletotalnumberofitems") ) {
                final Object value = values.remove("Incgpaytfiletotalnumberofitems");
                if( (value == null) || (!value.equals(getIncgpaytfiletotalnumberofitems())) ) {
                    setIncgpaytfiletotalnumberofitems(((String) value));
                }
            }
            if( values.containsKey("Createdbyuser") ) {
                final Object value = values.remove("Createdbyuser");
                if( (value == null) || (!value.equals(getCreatedbyuser())) ) {
                    setCreatedbyuser(((String) value));
                }
            }
            if( values.containsKey("Companycode") ) {
                final Object value = values.remove("Companycode");
                if( (value == null) || (!value.equals(getCompanycode())) ) {
                    setCompanycode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("PaymentReleaseListHeadertoItem") ) {
                final Object value = (values).remove("PaymentReleaseListHeadertoItem");
                if( value instanceof Iterable ) {
                    if( toPaymentReleaseListHeadertoItem == null ) {
                        toPaymentReleaseListHeadertoItem = Lists.newArrayList();
                    } else {
                        toPaymentReleaseListHeadertoItem = Lists.newArrayList(toPaymentReleaseListHeadertoItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PaymentReleaseListItem entity;
                        if( toPaymentReleaseListHeadertoItem.size() > i ) {
                            entity = toPaymentReleaseListHeadertoItem.get(i);
                        } else {
                            entity = new PaymentReleaseListItem();
                            toPaymentReleaseListHeadertoItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PaymentReleaseListHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PaymentReleaseListHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PaymentReleaseListHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PaymentReleaseListHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPaymentReleaseListHeadertoItem != null ) {
            (values).put("PaymentReleaseListHeadertoItem", toPaymentReleaseListHeadertoItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PaymentReleaseListItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>PaymentReleaseListHeadertoItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PaymentReleaseListItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PaymentReleaseListItem> fetchPaymentReleaseListHeadertoItem()
    {
        return fetchFieldAsList("PaymentReleaseListHeadertoItem", PaymentReleaseListItem.class);
    }

    /**
     * Retrieval of associated <b>PaymentReleaseListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>PaymentReleaseListHeadertoItem</b>.
     * <p>
     * If the navigation property <b>PaymentReleaseListHeadertoItem</b> of a queried <b>PaymentReleaseListHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PaymentReleaseListItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PaymentReleaseListItem> getPaymentReleaseListHeadertoItemOrFetch()
    {
        if( toPaymentReleaseListHeadertoItem == null ) {
            toPaymentReleaseListHeadertoItem = fetchPaymentReleaseListHeadertoItem();
        }
        return toPaymentReleaseListHeadertoItem;
    }

    /**
     * Retrieval of associated <b>PaymentReleaseListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>PaymentReleaseListHeadertoItem</b>.
     * <p>
     * If the navigation property for an entity <b>PaymentReleaseListHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>PaymentReleaseListHeadertoItem</b> is already loaded, the
     *         result will contain the <b>PaymentReleaseListItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PaymentReleaseListItem>> getPaymentReleaseListHeadertoItemIfPresent()
    {
        return Option.of(toPaymentReleaseListHeadertoItem);
    }

    /**
     * Overwrites the list of associated <b>PaymentReleaseListItem</b> entities for the loaded navigation property
     * <b>PaymentReleaseListHeadertoItem</b>.
     * <p>
     * If the navigation property <b>PaymentReleaseListHeadertoItem</b> of a queried <b>PaymentReleaseListHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PaymentReleaseListItem</b> entities.
     */
    public void setPaymentReleaseListHeadertoItem( @Nonnull final List<PaymentReleaseListItem> value )
    {
        if( toPaymentReleaseListHeadertoItem == null ) {
            toPaymentReleaseListHeadertoItem = Lists.newArrayList();
        }
        toPaymentReleaseListHeadertoItem.clear();
        toPaymentReleaseListHeadertoItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PaymentReleaseListItem</b> entities. This corresponds to the OData
     * navigation property <b>PaymentReleaseListHeadertoItem</b>.
     * <p>
     * If the navigation property <b>PaymentReleaseListHeadertoItem</b> of a queried <b>PaymentReleaseListHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PaymentReleaseListItem</b> entities.
     */
    public void addPaymentReleaseListHeadertoItem( PaymentReleaseListItem... entity )
    {
        if( toPaymentReleaseListHeadertoItem == null ) {
            toPaymentReleaseListHeadertoItem = Lists.newArrayList();
        }
        toPaymentReleaseListHeadertoItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PaymentReleaseListHeader instances.
     *
     */
    public final static class PaymentReleaseListHeaderBuilder
    {

        private List<PaymentReleaseListItem> toPaymentReleaseListHeadertoItem = Lists.newArrayList();

        private PaymentReleaseListHeader.PaymentReleaseListHeaderBuilder toPaymentReleaseListHeadertoItem(
            final List<PaymentReleaseListItem> value )
        {
            toPaymentReleaseListHeadertoItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>PaymentReleaseListHeadertoItem</b> for <b>PaymentReleaseListHeader</b> to multiple
         * <b>PaymentReleaseListItem</b>.
         *
         * @param value
         *            The PaymentReleaseListItems to build this PaymentReleaseListHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PaymentReleaseListHeader.PaymentReleaseListHeaderBuilder paymentReleaseListHeadertoItem(
            PaymentReleaseListItem... value )
        {
            return toPaymentReleaseListHeadertoItem(Lists.newArrayList(value));
        }

    }

}
