/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.field.PaymentReleaseListItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable.PaymentReleaseListItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Payment Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PaymentReleaseListItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PaymentReleaseListItem extends VdmEntity<PaymentReleaseListItem>
{

    /**
     * Selector for all available fields of PaymentReleaseListItem.
     *
     */
    public final static PaymentReleaseListItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselistitemuuid</b>
     * </p>
     *
     * @return UUID
     */
    @Key
    @SerializedName( "Paymentreleaselistitemuuid" )
    @JsonProperty( "Paymentreleaselistitemuuid" )
    @Nullable
    @ODataField( odataName = "Paymentreleaselistitemuuid" )
    private UUID paymentreleaselistitemuuid;
    /**
     * Use with available fluent helpers to apply the <b>Paymentreleaselistitemuuid</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<UUID> PAYMENTRELEASELISTITEMUUID =
        new PaymentReleaseListItemField<UUID>("Paymentreleaselistitemuuid");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselist</b>
     * </p>
     *
     * @return List ID
     */
    @SerializedName( "Paymentreleaselist" )
    @JsonProperty( "Paymentreleaselist" )
    @Nullable
    @ODataField( odataName = "Paymentreleaselist" )
    private String paymentreleaselist;
    /**
     * Use with available fluent helpers to apply the <b>Paymentreleaselist</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTRELEASELIST =
        new PaymentReleaseListItemField<String>("Paymentreleaselist");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentstatus</b>
     * </p>
     *
     * @return Item Status
     */
    @SerializedName( "Paymentstatus" )
    @JsonProperty( "Paymentstatus" )
    @Nullable
    @ODataField( odataName = "Paymentstatus" )
    private String paymentstatus;
    /**
     * Use with available fluent helpers to apply the <b>Paymentstatus</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTSTATUS =
        new PaymentReleaseListItemField<String>("Paymentstatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Paytrellistitemapprovallevel</b>
     * </p>
     *
     * @return Approval Level
     */
    @SerializedName( "Paytrellistitemapprovallevel" )
    @JsonProperty( "Paytrellistitemapprovallevel" )
    @Nullable
    @ODataField( odataName = "Paytrellistitemapprovallevel" )
    private String paytrellistitemapprovallevel;
    /**
     * Use with available fluent helpers to apply the <b>Paytrellistitemapprovallevel</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYTRELLISTITEMAPPROVALLEVEL =
        new PaymentReleaseListItemField<String>("Paytrellistitemapprovallevel");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "Createdbyuser" )
    @JsonProperty( "Createdbyuser" )
    @Nullable
    @ODataField( odataName = "Createdbyuser" )
    private String createdbyuser;
    /**
     * Use with available fluent helpers to apply the <b>Createdbyuser</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> CREATEDBYUSER =
        new PaymentReleaseListItemField<String>("Createdbyuser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Lastchangedbyuser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "Lastchangedbyuser" )
    @JsonProperty( "Lastchangedbyuser" )
    @Nullable
    @ODataField( odataName = "Lastchangedbyuser" )
    private String lastchangedbyuser;
    /**
     * Use with available fluent helpers to apply the <b>Lastchangedbyuser</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> LASTCHANGEDBYUSER =
        new PaymentReleaseListItemField<String>("Lastchangedbyuser");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselistapplication</b>
     * </p>
     *
     * @return Application ID
     */
    @SerializedName( "Paymentreleaselistapplication" )
    @JsonProperty( "Paymentreleaselistapplication" )
    @Nullable
    @ODataField( odataName = "Paymentreleaselistapplication" )
    private String paymentreleaselistapplication;
    /**
     * Use with available fluent helpers to apply the <b>Paymentreleaselistapplication</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTRELEASELISTAPPLICATION =
        new PaymentReleaseListItemField<String>("Paymentreleaselistapplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "Companycode" )
    @JsonProperty( "Companycode" )
    @Nullable
    @ODataField( odataName = "Companycode" )
    private String companycode;
    /**
     * Use with available fluent helpers to apply the <b>Companycode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> COMPANYCODE =
        new PaymentReleaseListItemField<String>("Companycode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocument</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "Accountingdocument" )
    @JsonProperty( "Accountingdocument" )
    @Nullable
    @ODataField( odataName = "Accountingdocument" )
    private String accountingdocument;
    /**
     * Use with available fluent helpers to apply the <b>Accountingdocument</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ACCOUNTINGDOCUMENT =
        new PaymentReleaseListItemField<String>("Accountingdocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Fiscalyear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "Fiscalyear" )
    @JsonProperty( "Fiscalyear" )
    @Nullable
    @ODataField( odataName = "Fiscalyear" )
    private String fiscalyear;
    /**
     * Use with available fluent helpers to apply the <b>Fiscalyear</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> FISCALYEAR =
        new PaymentReleaseListItemField<String>("Fiscalyear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocumentitem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "Accountingdocumentitem" )
    @JsonProperty( "Accountingdocumentitem" )
    @Nullable
    @ODataField( odataName = "Accountingdocumentitem" )
    private String accountingdocumentitem;
    /**
     * Use with available fluent helpers to apply the <b>Accountingdocumentitem</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ACCOUNTINGDOCUMENTITEM =
        new PaymentReleaseListItemField<String>("Accountingdocumentitem");
    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>Supplierfullname</b>
     * </p>
     *
     * @return Supplier Name
     */
    @SerializedName( "Supplierfullname" )
    @JsonProperty( "Supplierfullname" )
    @Nullable
    @ODataField( odataName = "Supplierfullname" )
    private String supplierfullname;
    /**
     * Use with available fluent helpers to apply the <b>Supplierfullname</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SUPPLIERFULLNAME =
        new PaymentReleaseListItemField<String>("Supplierfullname");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SUPPLIER =
        new PaymentReleaseListItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> CUSTOMER =
        new PaymentReleaseListItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Branchaccount</b>
     * </p>
     *
     * @return Branch
     */
    @SerializedName( "Branchaccount" )
    @JsonProperty( "Branchaccount" )
    @Nullable
    @ODataField( odataName = "Branchaccount" )
    private String branchaccount;
    /**
     * Use with available fluent helpers to apply the <b>Branchaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BRANCHACCOUNT =
        new PaymentReleaseListItemField<String>("Branchaccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Payerpayee</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "Payerpayee" )
    @JsonProperty( "Payerpayee" )
    @Nullable
    @ODataField( odataName = "Payerpayee" )
    private String payerpayee;
    /**
     * Use with available fluent helpers to apply the <b>Payerpayee</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYERPAYEE =
        new PaymentReleaseListItemField<String>("Payerpayee");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Partnercompany</b>
     * </p>
     *
     * @return Trading Partner
     */
    @SerializedName( "Partnercompany" )
    @JsonProperty( "Partnercompany" )
    @Nullable
    @ODataField( odataName = "Partnercompany" )
    private String partnercompany;
    /**
     * Use with available fluent helpers to apply the <b>Partnercompany</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PARTNERCOMPANY =
        new PaymentReleaseListItemField<String>("Partnercompany");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Debitcreditcode</b>
     * </p>
     *
     * @return Debit/Credit
     */
    @SerializedName( "Debitcreditcode" )
    @JsonProperty( "Debitcreditcode" )
    @Nullable
    @ODataField( odataName = "Debitcreditcode" )
    private String debitcreditcode;
    /**
     * Use with available fluent helpers to apply the <b>Debitcreditcode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DEBITCREDITCODE =
        new PaymentReleaseListItemField<String>("Debitcreditcode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Transactioncurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "Transactioncurrency" )
    @JsonProperty( "Transactioncurrency" )
    @Nullable
    @ODataField( odataName = "Transactioncurrency" )
    private String transactioncurrency;
    /**
     * Use with available fluent helpers to apply the <b>Transactioncurrency</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> TRANSACTIONCURRENCY =
        new PaymentReleaseListItemField<String>("Transactioncurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Amountintransactioncurrency</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "Amountintransactioncurrency" )
    @JsonProperty( "Amountintransactioncurrency" )
    @Nullable
    @ODataField( odataName = "Amountintransactioncurrency" )
    private BigDecimal amountintransactioncurrency;
    /**
     * Use with available fluent helpers to apply the <b>Amountintransactioncurrency</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> AMOUNTINTRANSACTIONCURRENCY =
        new PaymentReleaseListItemField<BigDecimal>("Amountintransactioncurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountbaseamount</b>
     * </p>
     *
     * @return CD Base
     */
    @SerializedName( "Cashdiscountbaseamount" )
    @JsonProperty( "Cashdiscountbaseamount" )
    @Nullable
    @ODataField( odataName = "Cashdiscountbaseamount" )
    private BigDecimal cashdiscountbaseamount;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscountbaseamount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNTBASEAMOUNT =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscountbaseamount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountamtintransaccrcy</b>
     * </p>
     *
     * @return CD Amount
     */
    @SerializedName( "Cashdiscountamtintransaccrcy" )
    @JsonProperty( "Cashdiscountamtintransaccrcy" )
    @Nullable
    @ODataField( odataName = "Cashdiscountamtintransaccrcy" )
    private BigDecimal cashdiscountamtintransaccrcy;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscountamtintransaccrcy</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNTAMTINTRANSACCRCY =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscountamtintransaccrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Whldgtaxamtintransaccrcy</b>
     * </p>
     *
     * @return Withholding Tax
     */
    @SerializedName( "Whldgtaxamtintransaccrcy" )
    @JsonProperty( "Whldgtaxamtintransaccrcy" )
    @Nullable
    @ODataField( odataName = "Whldgtaxamtintransaccrcy" )
    private BigDecimal whldgtaxamtintransaccrcy;
    /**
     * Use with available fluent helpers to apply the <b>Whldgtaxamtintransaccrcy</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> WHLDGTAXAMTINTRANSACCRCY =
        new PaymentReleaseListItemField<BigDecimal>("Whldgtaxamtintransaccrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Balancetransactioncurrency</b>
     * </p>
     *
     * @return G/L currency
     */
    @SerializedName( "Balancetransactioncurrency" )
    @JsonProperty( "Balancetransactioncurrency" )
    @Nullable
    @ODataField( odataName = "Balancetransactioncurrency" )
    private String balancetransactioncurrency;
    /**
     * Use with available fluent helpers to apply the <b>Balancetransactioncurrency</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BALANCETRANSACTIONCURRENCY =
        new PaymentReleaseListItemField<String>("Balancetransactioncurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Amountinbalancetransaccrcy</b>
     * </p>
     *
     * @return G/L Amount
     */
    @SerializedName( "Amountinbalancetransaccrcy" )
    @JsonProperty( "Amountinbalancetransaccrcy" )
    @Nullable
    @ODataField( odataName = "Amountinbalancetransaccrcy" )
    private BigDecimal amountinbalancetransaccrcy;
    /**
     * Use with available fluent helpers to apply the <b>Amountinbalancetransaccrcy</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> AMOUNTINBALANCETRANSACCRCY =
        new PaymentReleaseListItemField<BigDecimal>("Amountinbalancetransaccrcy");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountamount</b>
     * </p>
     *
     * @return G/L Discount
     */
    @SerializedName( "Cashdiscountamount" )
    @JsonProperty( "Cashdiscountamount" )
    @Nullable
    @ODataField( odataName = "Cashdiscountamount" )
    private BigDecimal cashdiscountamount;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscountamount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNTAMOUNT =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscountamount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocumenttype</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "Accountingdocumenttype" )
    @JsonProperty( "Accountingdocumenttype" )
    @Nullable
    @ODataField( odataName = "Accountingdocumenttype" )
    private String accountingdocumenttype;
    /**
     * Use with available fluent helpers to apply the <b>Accountingdocumenttype</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ACCOUNTINGDOCUMENTTYPE =
        new PaymentReleaseListItemField<String>("Accountingdocumenttype");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Postingdate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "Postingdate" )
    @JsonProperty( "Postingdate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Postingdate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingdate;
    /**
     * Use with available fluent helpers to apply the <b>Postingdate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> POSTINGDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Postingdate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Documentdate</b>
     * </p>
     *
     * @return Document Date
     */
    @SerializedName( "Documentdate" )
    @JsonProperty( "Documentdate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Documentdate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentdate;
    /**
     * Use with available fluent helpers to apply the <b>Documentdate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> DOCUMENTDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Documentdate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Financialaccounttype</b>
     * </p>
     *
     * @return Account Type
     */
    @SerializedName( "Financialaccounttype" )
    @JsonProperty( "Financialaccounttype" )
    @Nullable
    @ODataField( odataName = "Financialaccounttype" )
    private String financialaccounttype;
    /**
     * Use with available fluent helpers to apply the <b>Financialaccounttype</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> FINANCIALACCOUNTTYPE =
        new PaymentReleaseListItemField<String>("Financialaccounttype");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Postingkey</b>
     * </p>
     *
     * @return Posting Key
     */
    @SerializedName( "Postingkey" )
    @JsonProperty( "Postingkey" )
    @Nullable
    @ODataField( odataName = "Postingkey" )
    private String postingkey;
    /**
     * Use with available fluent helpers to apply the <b>Postingkey</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> POSTINGKEY =
        new PaymentReleaseListItemField<String>("Postingkey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Glaccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "Glaccount" )
    @JsonProperty( "Glaccount" )
    @Nullable
    @ODataField( odataName = "Glaccount" )
    private String glaccount;
    /**
     * Use with available fluent helpers to apply the <b>Glaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> GLACCOUNT =
        new PaymentReleaseListItemField<String>("Glaccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Operationalglaccount</b>
     * </p>
     *
     * @return G/L Account
     */
    @SerializedName( "Operationalglaccount" )
    @JsonProperty( "Operationalglaccount" )
    @Nullable
    @ODataField( odataName = "Operationalglaccount" )
    private String operationalglaccount;
    /**
     * Use with available fluent helpers to apply the <b>Operationalglaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> OPERATIONALGLACCOUNT =
        new PaymentReleaseListItemField<String>("Operationalglaccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Specialglcode</b>
     * </p>
     *
     * @return Special G/L ind
     */
    @SerializedName( "Specialglcode" )
    @JsonProperty( "Specialglcode" )
    @Nullable
    @ODataField( odataName = "Specialglcode" )
    private String specialglcode;
    /**
     * Use with available fluent helpers to apply the <b>Specialglcode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SPECIALGLCODE =
        new PaymentReleaseListItemField<String>("Specialglcode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Businessarea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "Businessarea" )
    @JsonProperty( "Businessarea" )
    @Nullable
    @ODataField( odataName = "Businessarea" )
    private String businessarea;
    /**
     * Use with available fluent helpers to apply the <b>Businessarea</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BUSINESSAREA =
        new PaymentReleaseListItemField<String>("Businessarea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Taxcode</b>
     * </p>
     *
     * @return Tax Code
     */
    @SerializedName( "Taxcode" )
    @JsonProperty( "Taxcode" )
    @Nullable
    @ODataField( odataName = "Taxcode" )
    private String taxcode;
    /**
     * Use with available fluent helpers to apply the <b>Taxcode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> TAXCODE =
        new PaymentReleaseListItemField<String>("Taxcode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Withholdingtaxcode</b>
     * </p>
     *
     * @return W. Tax Code
     */
    @SerializedName( "Withholdingtaxcode" )
    @JsonProperty( "Withholdingtaxcode" )
    @Nullable
    @ODataField( odataName = "Withholdingtaxcode" )
    private String withholdingtaxcode;
    /**
     * Use with available fluent helpers to apply the <b>Withholdingtaxcode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> WITHHOLDINGTAXCODE =
        new PaymentReleaseListItemField<String>("Withholdingtaxcode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Documentitemtext</b>
     * </p>
     *
     * @return Text
     */
    @SerializedName( "Documentitemtext" )
    @JsonProperty( "Documentitemtext" )
    @Nullable
    @ODataField( odataName = "Documentitemtext" )
    private String documentitemtext;
    /**
     * Use with available fluent helpers to apply the <b>Documentitemtext</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DOCUMENTITEMTEXT =
        new PaymentReleaseListItemField<String>("Documentitemtext");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Duecalculationbasedate</b>
     * </p>
     *
     * @return Baseline Date
     */
    @SerializedName( "Duecalculationbasedate" )
    @JsonProperty( "Duecalculationbasedate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Duecalculationbasedate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime duecalculationbasedate;
    /**
     * Use with available fluent helpers to apply the <b>Duecalculationbasedate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> DUECALCULATIONBASEDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Duecalculationbasedate");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount1days</b>
     * </p>
     *
     * @return Days 1
     */
    @SerializedName( "Cashdiscount1days" )
    @JsonProperty( "Cashdiscount1days" )
    @Nullable
    @ODataField( odataName = "Cashdiscount1days" )
    private BigDecimal cashdiscount1days;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscount1days</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNT1DAYS =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscount1days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount2days</b>
     * </p>
     *
     * @return Days 2
     */
    @SerializedName( "Cashdiscount2days" )
    @JsonProperty( "Cashdiscount2days" )
    @Nullable
    @ODataField( odataName = "Cashdiscount2days" )
    private BigDecimal cashdiscount2days;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscount2days</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNT2DAYS =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscount2days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Netpaymentdays</b>
     * </p>
     *
     * @return Days Net
     */
    @SerializedName( "Netpaymentdays" )
    @JsonProperty( "Netpaymentdays" )
    @Nullable
    @ODataField( odataName = "Netpaymentdays" )
    private BigDecimal netpaymentdays;
    /**
     * Use with available fluent helpers to apply the <b>Netpaymentdays</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> NETPAYMENTDAYS =
        new PaymentReleaseListItemField<BigDecimal>("Netpaymentdays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount1percent</b>
     * </p>
     *
     * @return CD Percentage 1
     */
    @SerializedName( "Cashdiscount1percent" )
    @JsonProperty( "Cashdiscount1percent" )
    @Nullable
    @ODataField( odataName = "Cashdiscount1percent" )
    private BigDecimal cashdiscount1percent;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscount1percent</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNT1PERCENT =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscount1percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount2percent</b>
     * </p>
     *
     * @return CD Percentage 2
     */
    @SerializedName( "Cashdiscount2percent" )
    @JsonProperty( "Cashdiscount2percent" )
    @Nullable
    @ODataField( odataName = "Cashdiscount2percent" )
    private BigDecimal cashdiscount2percent;
    /**
     * Use with available fluent helpers to apply the <b>Cashdiscount2percent</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> CASHDISCOUNT2PERCENT =
        new PaymentReleaseListItemField<BigDecimal>("Cashdiscount2percent");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Purchasingdocument</b>
     * </p>
     *
     * @return Purchasing doc.
     */
    @SerializedName( "Purchasingdocument" )
    @JsonProperty( "Purchasingdocument" )
    @Nullable
    @ODataField( odataName = "Purchasingdocument" )
    private String purchasingdocument;
    /**
     * Use with available fluent helpers to apply the <b>Purchasingdocument</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PURCHASINGDOCUMENT =
        new PaymentReleaseListItemField<String>("Purchasingdocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Purchasingdocumentitem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "Purchasingdocumentitem" )
    @JsonProperty( "Purchasingdocumentitem" )
    @Nullable
    @ODataField( odataName = "Purchasingdocumentitem" )
    private String purchasingdocumentitem;
    /**
     * Use with available fluent helpers to apply the <b>Purchasingdocumentitem</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PURCHASINGDOCUMENTITEM =
        new PaymentReleaseListItemField<String>("Purchasingdocumentitem");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Vatregistration</b>
     * </p>
     *
     * @return VAT Reg. No.
     */
    @SerializedName( "Vatregistration" )
    @JsonProperty( "Vatregistration" )
    @Nullable
    @ODataField( odataName = "Vatregistration" )
    private String vatregistration;
    /**
     * Use with available fluent helpers to apply the <b>Vatregistration</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> VATREGISTRATION =
        new PaymentReleaseListItemField<String>("Vatregistration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Statecentralbankpaymentreason</b>
     * </p>
     *
     * @return SCB Ind.
     */
    @SerializedName( "Statecentralbankpaymentreason" )
    @JsonProperty( "Statecentralbankpaymentreason" )
    @Nullable
    @ODataField( odataName = "Statecentralbankpaymentreason" )
    private String statecentralbankpaymentreason;
    /**
     * Use with available fluent helpers to apply the <b>Statecentralbankpaymentreason</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> STATECENTRALBANKPAYMENTREASON =
        new PaymentReleaseListItemField<String>("Statecentralbankpaymentreason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Supplyingcountry</b>
     * </p>
     *
     * @return Suppl. Ctry/Reg.
     */
    @SerializedName( "Supplyingcountry" )
    @JsonProperty( "Supplyingcountry" )
    @Nullable
    @ODataField( odataName = "Supplyingcountry" )
    private String supplyingcountry;
    /**
     * Use with available fluent helpers to apply the <b>Supplyingcountry</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SUPPLYINGCOUNTRY =
        new PaymentReleaseListItemField<String>("Supplyingcountry");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Projectnetwork</b>
     * </p>
     *
     * @return Network
     */
    @SerializedName( "Projectnetwork" )
    @JsonProperty( "Projectnetwork" )
    @Nullable
    @ODataField( odataName = "Projectnetwork" )
    private String projectnetwork;
    /**
     * Use with available fluent helpers to apply the <b>Projectnetwork</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PROJECTNETWORK =
        new PaymentReleaseListItemField<String>("Projectnetwork");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Orderinternalbillofoperations</b>
     * </p>
     *
     * @return Plan no.f.oper.
     */
    @SerializedName( "Orderinternalbillofoperations" )
    @JsonProperty( "Orderinternalbillofoperations" )
    @Nullable
    @ODataField( odataName = "Orderinternalbillofoperations" )
    private String orderinternalbillofoperations;
    /**
     * Use with available fluent helpers to apply the <b>Orderinternalbillofoperations</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ORDERINTERNALBILLOFOPERATIONS =
        new PaymentReleaseListItemField<String>("Orderinternalbillofoperations");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assignmentreference</b>
     * </p>
     *
     * @return Assignment
     */
    @SerializedName( "Assignmentreference" )
    @JsonProperty( "Assignmentreference" )
    @Nullable
    @ODataField( odataName = "Assignmentreference" )
    private String assignmentreference;
    /**
     * Use with available fluent helpers to apply the <b>Assignmentreference</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ASSIGNMENTREFERENCE =
        new PaymentReleaseListItemField<String>("Assignmentreference");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>Assetcontract</b>
     * </p>
     *
     * @return Contract Number
     */
    @SerializedName( "Assetcontract" )
    @JsonProperty( "Assetcontract" )
    @Nullable
    @ODataField( odataName = "Assetcontract" )
    private String assetcontract;
    /**
     * Use with available fluent helpers to apply the <b>Assetcontract</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ASSETCONTRACT =
        new PaymentReleaseListItemField<String>("Assetcontract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Followondocumenttype</b>
     * </p>
     *
     * @return Follow-On Doc. Type
     */
    @SerializedName( "Followondocumenttype" )
    @JsonProperty( "Followondocumenttype" )
    @Nullable
    @ODataField( odataName = "Followondocumenttype" )
    private String followondocumenttype;
    /**
     * Use with available fluent helpers to apply the <b>Followondocumenttype</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> FOLLOWONDOCUMENTTYPE =
        new PaymentReleaseListItemField<String>("Followondocumenttype");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Costcenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "Costcenter" )
    @JsonProperty( "Costcenter" )
    @Nullable
    @ODataField( odataName = "Costcenter" )
    private String costcenter;
    /**
     * Use with available fluent helpers to apply the <b>Costcenter</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> COSTCENTER =
        new PaymentReleaseListItemField<String>("Costcenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Salesdocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "Salesdocument" )
    @JsonProperty( "Salesdocument" )
    @Nullable
    @ODataField( odataName = "Salesdocument" )
    private String salesdocument;
    /**
     * Use with available fluent helpers to apply the <b>Salesdocument</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SALESDOCUMENT =
        new PaymentReleaseListItemField<String>("Salesdocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Salesdocumentitem</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "Salesdocumentitem" )
    @JsonProperty( "Salesdocumentitem" )
    @Nullable
    @ODataField( odataName = "Salesdocumentitem" )
    private String salesdocumentitem;
    /**
     * Use with available fluent helpers to apply the <b>Salesdocumentitem</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SALESDOCUMENTITEM =
        new PaymentReleaseListItemField<String>("Salesdocumentitem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Profitcenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "Profitcenter" )
    @JsonProperty( "Profitcenter" )
    @Nullable
    @ODataField( odataName = "Profitcenter" )
    private String profitcenter;
    /**
     * Use with available fluent helpers to apply the <b>Profitcenter</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PROFITCENTER =
        new PaymentReleaseListItemField<String>("Profitcenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1idbybusinesspartner</b>
     * </p>
     *
     * @return Reference Key 1
     */
    @SerializedName( "Reference1idbybusinesspartner" )
    @JsonProperty( "Reference1idbybusinesspartner" )
    @Nullable
    @ODataField( odataName = "Reference1idbybusinesspartner" )
    private String reference1idbybusinesspartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference1idbybusinesspartner</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> REFERENCE1IDBYBUSINESSPARTNER =
        new PaymentReleaseListItemField<String>("Reference1idbybusinesspartner");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2idbybusinesspartner</b>
     * </p>
     *
     * @return Reference Key 2
     */
    @SerializedName( "Reference2idbybusinesspartner" )
    @JsonProperty( "Reference2idbybusinesspartner" )
    @Nullable
    @ODataField( odataName = "Reference2idbybusinesspartner" )
    private String reference2idbybusinesspartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference2idbybusinesspartner</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> REFERENCE2IDBYBUSINESSPARTNER =
        new PaymentReleaseListItemField<String>("Reference2idbybusinesspartner");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference3idbybusinesspartner</b>
     * </p>
     *
     * @return Reference key 3
     */
    @SerializedName( "Reference3idbybusinesspartner" )
    @JsonProperty( "Reference3idbybusinesspartner" )
    @Nullable
    @ODataField( odataName = "Reference3idbybusinesspartner" )
    private String reference3idbybusinesspartner;
    /**
     * Use with available fluent helpers to apply the <b>Reference3idbybusinesspartner</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> REFERENCE3IDBYBUSINESSPARTNER =
        new PaymentReleaseListItemField<String>("Reference3idbybusinesspartner");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction1</b>
     * </p>
     *
     * @return Instruct. Key 1
     */
    @SerializedName( "Dataexchangeinstruction1" )
    @JsonProperty( "Dataexchangeinstruction1" )
    @Nullable
    @ODataField( odataName = "Dataexchangeinstruction1" )
    private String dataexchangeinstruction1;
    /**
     * Use with available fluent helpers to apply the <b>Dataexchangeinstruction1</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DATAEXCHANGEINSTRUCTION1 =
        new PaymentReleaseListItemField<String>("Dataexchangeinstruction1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction2</b>
     * </p>
     *
     * @return Instruct. Key 2
     */
    @SerializedName( "Dataexchangeinstruction2" )
    @JsonProperty( "Dataexchangeinstruction2" )
    @Nullable
    @ODataField( odataName = "Dataexchangeinstruction2" )
    private String dataexchangeinstruction2;
    /**
     * Use with available fluent helpers to apply the <b>Dataexchangeinstruction2</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DATAEXCHANGEINSTRUCTION2 =
        new PaymentReleaseListItemField<String>("Dataexchangeinstruction2");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction3</b>
     * </p>
     *
     * @return Instruct. key 3
     */
    @SerializedName( "Dataexchangeinstruction3" )
    @JsonProperty( "Dataexchangeinstruction3" )
    @Nullable
    @ODataField( odataName = "Dataexchangeinstruction3" )
    private String dataexchangeinstruction3;
    /**
     * Use with available fluent helpers to apply the <b>Dataexchangeinstruction3</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DATAEXCHANGEINSTRUCTION3 =
        new PaymentReleaseListItemField<String>("Dataexchangeinstruction3");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction4</b>
     * </p>
     *
     * @return Instruct. key 4
     */
    @SerializedName( "Dataexchangeinstruction4" )
    @JsonProperty( "Dataexchangeinstruction4" )
    @Nullable
    @ODataField( odataName = "Dataexchangeinstruction4" )
    private String dataexchangeinstruction4;
    /**
     * Use with available fluent helpers to apply the <b>Dataexchangeinstruction4</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DATAEXCHANGEINSTRUCTION4 =
        new PaymentReleaseListItemField<String>("Dataexchangeinstruction4");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Addressandbankissetmanually</b>
     * </p>
     *
     * @return Individ. Set
     */
    @SerializedName( "Addressandbankissetmanually" )
    @JsonProperty( "Addressandbankissetmanually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Addressandbankissetmanually" )
    private Boolean addressandbankissetmanually;
    /**
     * Use with available fluent helpers to apply the <b>Addressandbankissetmanually</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<Boolean> ADDRESSANDBANKISSETMANUALLY =
        new PaymentReleaseListItemField<Boolean>("Addressandbankissetmanually");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Businessplace</b>
     * </p>
     *
     * @return Business Place
     */
    @SerializedName( "Businessplace" )
    @JsonProperty( "Businessplace" )
    @Nullable
    @ODataField( odataName = "Businessplace" )
    private String businessplace;
    /**
     * Use with available fluent helpers to apply the <b>Businessplace</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BUSINESSPLACE =
        new PaymentReleaseListItemField<String>("Businessplace");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Partnerprofitcenter</b>
     * </p>
     *
     * @return Partner PC
     */
    @SerializedName( "Partnerprofitcenter" )
    @JsonProperty( "Partnerprofitcenter" )
    @Nullable
    @ODataField( odataName = "Partnerprofitcenter" )
    private String partnerprofitcenter;
    /**
     * Use with available fluent helpers to apply the <b>Partnerprofitcenter</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PARTNERPROFITCENTER =
        new PaymentReleaseListItemField<String>("Partnerprofitcenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Grantid</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "Grantid" )
    @JsonProperty( "Grantid" )
    @Nullable
    @ODataField( odataName = "Grantid" )
    private String grantid;
    /**
     * Use with available fluent helpers to apply the <b>Grantid</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> GRANTID =
        new PaymentReleaseListItemField<String>("Grantid");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>Functionalarea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "Functionalarea" )
    @JsonProperty( "Functionalarea" )
    @Nullable
    @ODataField( odataName = "Functionalarea" )
    private String functionalarea;
    /**
     * Use with available fluent helpers to apply the <b>Functionalarea</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> FUNCTIONALAREA =
        new PaymentReleaseListItemField<String>("Functionalarea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> FUND = new PaymentReleaseListItemField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequest</b>
     * </p>
     *
     * @return Key number
     */
    @SerializedName( "Paymentrequest" )
    @JsonProperty( "Paymentrequest" )
    @Nullable
    @ODataField( odataName = "Paymentrequest" )
    private String paymentrequest;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrequest</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTREQUEST =
        new PaymentReleaseListItemField<String>("Paymentrequest");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequestamountinpaytcrcy</b>
     * </p>
     *
     * @return PC Amount
     */
    @SerializedName( "Paymentrequestamountinpaytcrcy" )
    @JsonProperty( "Paymentrequestamountinpaytcrcy" )
    @Nullable
    @ODataField( odataName = "Paymentrequestamountinpaytcrcy" )
    private BigDecimal paymentrequestamountinpaytcrcy;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrequestamountinpaytcrcy</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<BigDecimal> PAYMENTREQUESTAMOUNTINPAYTCRCY =
        new PaymentReleaseListItemField<BigDecimal>("Paymentrequestamountinpaytcrcy");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequestorigin</b>
     * </p>
     *
     * @return Origin
     */
    @SerializedName( "Paymentrequestorigin" )
    @JsonProperty( "Paymentrequestorigin" )
    @Nullable
    @ODataField( odataName = "Paymentrequestorigin" )
    private String paymentrequestorigin;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrequestorigin</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTREQUESTORIGIN =
        new PaymentReleaseListItemField<String>("Paymentrequestorigin");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Currentprocessor</b>
     * </p>
     *
     * @return Processor
     */
    @SerializedName( "Currentprocessor" )
    @JsonProperty( "Currentprocessor" )
    @Nullable
    @ODataField( odataName = "Currentprocessor" )
    private String currentprocessor;
    /**
     * Use with available fluent helpers to apply the <b>Currentprocessor</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> CURRENTPROCESSOR =
        new PaymentReleaseListItemField<String>("Currentprocessor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Earmarkedfundsdocument</b>
     * </p>
     *
     * @return Earmarked Funds
     */
    @SerializedName( "Earmarkedfundsdocument" )
    @JsonProperty( "Earmarkedfundsdocument" )
    @Nullable
    @ODataField( odataName = "Earmarkedfundsdocument" )
    private String earmarkedfundsdocument;
    /**
     * Use with available fluent helpers to apply the <b>Earmarkedfundsdocument</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> EARMARKEDFUNDSDOCUMENT =
        new PaymentReleaseListItemField<String>("Earmarkedfundsdocument");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Taxid2</b>
     * </p>
     *
     * @return Tax Number 2
     */
    @SerializedName( "Taxid2" )
    @JsonProperty( "Taxid2" )
    @Nullable
    @ODataField( odataName = "Taxid2" )
    private String taxid2;
    /**
     * Use with available fluent helpers to apply the <b>Taxid2</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> TAXID2 = new PaymentReleaseListItemField<String>("Taxid2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrunitemmessagenumber</b>
     * </p>
     *
     * @return Item indicator
     */
    @SerializedName( "Paymentrunitemmessagenumber" )
    @JsonProperty( "Paymentrunitemmessagenumber" )
    @Nullable
    @ODataField( odataName = "Paymentrunitemmessagenumber" )
    private String paymentrunitemmessagenumber;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrunitemmessagenumber</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTRUNITEMMESSAGENUMBER =
        new PaymentReleaseListItemField<String>("Paymentrunitemmessagenumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Paymentblockingreason</b>
     * </p>
     *
     * @return Pmnt Block
     */
    @SerializedName( "Paymentblockingreason" )
    @JsonProperty( "Paymentblockingreason" )
    @Nullable
    @ODataField( odataName = "Paymentblockingreason" )
    private String paymentblockingreason;
    /**
     * Use with available fluent helpers to apply the <b>Paymentblockingreason</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTBLOCKINGREASON =
        new PaymentReleaseListItemField<String>("Paymentblockingreason");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrundate</b>
     * </p>
     *
     * @return Run On
     */
    @SerializedName( "Paymentrundate" )
    @JsonProperty( "Paymentrundate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Paymentrundate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime paymentrundate;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrundate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> PAYMENTRUNDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Paymentrundate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrunid</b>
     * </p>
     *
     * @return Identification
     */
    @SerializedName( "Paymentrunid" )
    @JsonProperty( "Paymentrunid" )
    @Nullable
    @ODataField( odataName = "Paymentrunid" )
    private String paymentrunid;
    /**
     * Use with available fluent helpers to apply the <b>Paymentrunid</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTRUNID =
        new PaymentReleaseListItemField<String>("Paymentrunid");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentdocument</b>
     * </p>
     *
     * @return Payment doc.no.
     */
    @SerializedName( "Paymentdocument" )
    @JsonProperty( "Paymentdocument" )
    @Nullable
    @ODataField( odataName = "Paymentdocument" )
    private String paymentdocument;
    /**
     * Use with available fluent helpers to apply the <b>Paymentdocument</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTDOCUMENT =
        new PaymentReleaseListItemField<String>("Paymentdocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentorder</b>
     * </p>
     *
     * @return Payment order
     */
    @SerializedName( "Paymentorder" )
    @JsonProperty( "Paymentorder" )
    @Nullable
    @ODataField( odataName = "Paymentorder" )
    private String paymentorder;
    /**
     * Use with available fluent helpers to apply the <b>Paymentorder</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTORDER =
        new PaymentReleaseListItemField<String>("Paymentorder");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Proposalrundate</b>
     * </p>
     *
     * @return Proposal-Run Date
     */
    @SerializedName( "Proposalrundate" )
    @JsonProperty( "Proposalrundate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Proposalrundate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime proposalrundate;
    /**
     * Use with available fluent helpers to apply the <b>Proposalrundate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> PROPOSALRUNDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Proposalrundate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Proposalrunnumber</b>
     * </p>
     *
     * @return Payt Proposal
     */
    @SerializedName( "Proposalrunnumber" )
    @JsonProperty( "Proposalrunnumber" )
    @Nullable
    @ODataField( odataName = "Proposalrunnumber" )
    private String proposalrunnumber;
    /**
     * Use with available fluent helpers to apply the <b>Proposalrunnumber</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PROPOSALRUNNUMBER =
        new PaymentReleaseListItemField<String>("Proposalrunnumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Payingcompanycode</b>
     * </p>
     *
     * @return Paying co. code
     */
    @SerializedName( "Payingcompanycode" )
    @JsonProperty( "Payingcompanycode" )
    @Nullable
    @ODataField( odataName = "Payingcompanycode" )
    private String payingcompanycode;
    /**
     * Use with available fluent helpers to apply the <b>Payingcompanycode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYINGCOMPANYCODE =
        new PaymentReleaseListItemField<String>("Payingcompanycode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Sendingcompanycode</b>
     * </p>
     *
     * @return Sending co.code
     */
    @SerializedName( "Sendingcompanycode" )
    @JsonProperty( "Sendingcompanycode" )
    @Nullable
    @ODataField( odataName = "Sendingcompanycode" )
    private String sendingcompanycode;
    /**
     * Use with available fluent helpers to apply the <b>Sendingcompanycode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SENDINGCOMPANYCODE =
        new PaymentReleaseListItemField<String>("Sendingcompanycode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Payeeadditionalname</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "Payeeadditionalname" )
    @JsonProperty( "Payeeadditionalname" )
    @Nullable
    @ODataField( odataName = "Payeeadditionalname" )
    private String payeeadditionalname;
    /**
     * Use with available fluent helpers to apply the <b>Payeeadditionalname</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEADDITIONALNAME =
        new PaymentReleaseListItemField<String>("Payeeadditionalname");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Payeepostalcode</b>
     * </p>
     *
     * @return Payee Postal Code
     */
    @SerializedName( "Payeepostalcode" )
    @JsonProperty( "Payeepostalcode" )
    @Nullable
    @ODataField( odataName = "Payeepostalcode" )
    private String payeepostalcode;
    /**
     * Use with available fluent helpers to apply the <b>Payeepostalcode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEPOSTALCODE =
        new PaymentReleaseListItemField<String>("Payeepostalcode");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Payeecityname</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "Payeecityname" )
    @JsonProperty( "Payeecityname" )
    @Nullable
    @ODataField( odataName = "Payeecityname" )
    private String payeecityname;
    /**
     * Use with available fluent helpers to apply the <b>Payeecityname</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEECITYNAME =
        new PaymentReleaseListItemField<String>("Payeecityname");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeecountry</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "Payeecountry" )
    @JsonProperty( "Payeecountry" )
    @Nullable
    @ODataField( odataName = "Payeecountry" )
    private String payeecountry;
    /**
     * Use with available fluent helpers to apply the <b>Payeecountry</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEECOUNTRY =
        new PaymentReleaseListItemField<String>("Payeecountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeeregion</b>
     * </p>
     *
     * @return Regional code
     */
    @SerializedName( "Payeeregion" )
    @JsonProperty( "Payeeregion" )
    @Nullable
    @ODataField( odataName = "Payeeregion" )
    private String payeeregion;
    /**
     * Use with available fluent helpers to apply the <b>Payeeregion</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEREGION =
        new PaymentReleaseListItemField<String>("Payeeregion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Payeelanguage</b>
     * </p>
     *
     * @return Payee lang. key
     */
    @SerializedName( "Payeelanguage" )
    @JsonProperty( "Payeelanguage" )
    @Nullable
    @ODataField( odataName = "Payeelanguage" )
    private String payeelanguage;
    /**
     * Use with available fluent helpers to apply the <b>Payeelanguage</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEELANGUAGE =
        new PaymentReleaseListItemField<String>("Payeelanguage");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "Name" )
    @JsonProperty( "Name" )
    @Nullable
    @ODataField( odataName = "Name" )
    private String name;
    /**
     * Use with available fluent helpers to apply the <b>Name</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> NAME = new PaymentReleaseListItemField<String>("Name");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankcountry</b>
     * </p>
     *
     * @return Ctry/Reg. key
     */
    @SerializedName( "Payeebankcountry" )
    @JsonProperty( "Payeebankcountry" )
    @Nullable
    @ODataField( odataName = "Payeebankcountry" )
    private String payeebankcountry;
    /**
     * Use with available fluent helpers to apply the <b>Payeebankcountry</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANKCOUNTRY =
        new PaymentReleaseListItemField<String>("Payeebankcountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Payeebank</b>
     * </p>
     *
     * @return Payee bank key
     */
    @SerializedName( "Payeebank" )
    @JsonProperty( "Payeebank" )
    @Nullable
    @ODataField( odataName = "Payeebank" )
    private String payeebank;
    /**
     * Use with available fluent helpers to apply the <b>Payeebank</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANK =
        new PaymentReleaseListItemField<String>("Payeebank");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Payeebanknumber</b>
     * </p>
     *
     * @return Bank Number
     */
    @SerializedName( "Payeebanknumber" )
    @JsonProperty( "Payeebanknumber" )
    @Nullable
    @ODataField( odataName = "Payeebanknumber" )
    private String payeebanknumber;
    /**
     * Use with available fluent helpers to apply the <b>Payeebanknumber</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANKNUMBER =
        new PaymentReleaseListItemField<String>("Payeebanknumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankaccount</b>
     * </p>
     *
     * @return Payee acct no.
     */
    @SerializedName( "Payeebankaccount" )
    @JsonProperty( "Payeebankaccount" )
    @Nullable
    @ODataField( odataName = "Payeebankaccount" )
    private String payeebankaccount;
    /**
     * Use with available fluent helpers to apply the <b>Payeebankaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANKACCOUNT =
        new PaymentReleaseListItemField<String>("Payeebankaccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankcontrolkey</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "Payeebankcontrolkey" )
    @JsonProperty( "Payeebankcontrolkey" )
    @Nullable
    @ODataField( odataName = "Payeebankcontrolkey" )
    private String payeebankcontrolkey;
    /**
     * Use with available fluent helpers to apply the <b>Payeebankcontrolkey</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANKCONTROLKEY =
        new PaymentReleaseListItemField<String>("Payeebankcontrolkey");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Bankdetailreference</b>
     * </p>
     *
     * @return Reference
     */
    @SerializedName( "Bankdetailreference" )
    @JsonProperty( "Bankdetailreference" )
    @Nullable
    @ODataField( odataName = "Bankdetailreference" )
    private String bankdetailreference;
    /**
     * Use with available fluent helpers to apply the <b>Bankdetailreference</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKDETAILREFERENCE =
        new PaymentReleaseListItemField<String>("Bankdetailreference");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankidentifiercode</b>
     * </p>
     *
     * @return SWIFT/BIC
     */
    @SerializedName( "Payeebankidentifiercode" )
    @JsonProperty( "Payeebankidentifiercode" )
    @Nullable
    @ODataField( odataName = "Payeebankidentifiercode" )
    private String payeebankidentifiercode;
    /**
     * Use with available fluent helpers to apply the <b>Payeebankidentifiercode</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEBANKIDENTIFIERCODE =
        new PaymentReleaseListItemField<String>("Payeebankidentifiercode");
    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>Payeeiban</b>
     * </p>
     *
     * @return IBAN
     */
    @SerializedName( "Payeeiban" )
    @JsonProperty( "Payeeiban" )
    @Nullable
    @ODataField( odataName = "Payeeiban" )
    private String payeeiban;
    /**
     * Use with available fluent helpers to apply the <b>Payeeiban</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYEEIBAN =
        new PaymentReleaseListItemField<String>("Payeeiban");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>Bankaccountholdername</b>
     * </p>
     *
     * @return Account holder
     */
    @SerializedName( "Bankaccountholdername" )
    @JsonProperty( "Bankaccountholdername" )
    @Nullable
    @ODataField( odataName = "Bankaccountholdername" )
    private String bankaccountholdername;
    /**
     * Use with available fluent helpers to apply the <b>Bankaccountholdername</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKACCOUNTHOLDERNAME =
        new PaymentReleaseListItemField<String>("Bankaccountholdername");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Housebankaccount</b>
     * </p>
     *
     * @return Account ID
     */
    @SerializedName( "Housebankaccount" )
    @JsonProperty( "Housebankaccount" )
    @Nullable
    @ODataField( odataName = "Housebankaccount" )
    private String housebankaccount;
    /**
     * Use with available fluent helpers to apply the <b>Housebankaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> HOUSEBANKACCOUNT =
        new PaymentReleaseListItemField<String>("Housebankaccount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Housebank</b>
     * </p>
     *
     * @return House bank
     */
    @SerializedName( "Housebank" )
    @JsonProperty( "Housebank" )
    @Nullable
    @ODataField( odataName = "Housebank" )
    private String housebank;
    /**
     * Use with available fluent helpers to apply the <b>Housebank</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> HOUSEBANK =
        new PaymentReleaseListItemField<String>("Housebank");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Bankcountry</b>
     * </p>
     *
     * @return Bank Ctry/Reg.
     */
    @SerializedName( "Bankcountry" )
    @JsonProperty( "Bankcountry" )
    @Nullable
    @ODataField( odataName = "Bankcountry" )
    private String bankcountry;
    /**
     * Use with available fluent helpers to apply the <b>Bankcountry</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKCOUNTRY =
        new PaymentReleaseListItemField<String>("Bankcountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     *
     * @return House Bank Key
     */
    @SerializedName( "Bank" )
    @JsonProperty( "Bank" )
    @Nullable
    @ODataField( odataName = "Bank" )
    private String bank;
    /**
     * Use with available fluent helpers to apply the <b>Bank</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANK = new PaymentReleaseListItemField<String>("Bank");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Banknumber</b>
     * </p>
     *
     * @return House bank no.
     */
    @SerializedName( "Banknumber" )
    @JsonProperty( "Banknumber" )
    @Nullable
    @ODataField( odataName = "Banknumber" )
    private String banknumber;
    /**
     * Use with available fluent helpers to apply the <b>Banknumber</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKNUMBER =
        new PaymentReleaseListItemField<String>("Banknumber");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Bankaccount</b>
     * </p>
     *
     * @return Our account number
     */
    @SerializedName( "Bankaccount" )
    @JsonProperty( "Bankaccount" )
    @Nullable
    @ODataField( odataName = "Bankaccount" )
    private String bankaccount;
    /**
     * Use with available fluent helpers to apply the <b>Bankaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKACCOUNT =
        new PaymentReleaseListItemField<String>("Bankaccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Bankcontrolkey</b>
     * </p>
     *
     * @return Control Key
     */
    @SerializedName( "Bankcontrolkey" )
    @JsonProperty( "Bankcontrolkey" )
    @Nullable
    @ODataField( odataName = "Bankcontrolkey" )
    private String bankcontrolkey;
    /**
     * Use with available fluent helpers to apply the <b>Bankcontrolkey</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> BANKCONTROLKEY =
        new PaymentReleaseListItemField<String>("Bankcontrolkey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Glaccountforbankaccount</b>
     * </p>
     *
     * @return G/L Account No.
     */
    @SerializedName( "Glaccountforbankaccount" )
    @JsonProperty( "Glaccountforbankaccount" )
    @Nullable
    @ODataField( odataName = "Glaccountforbankaccount" )
    private String glaccountforbankaccount;
    /**
     * Use with available fluent helpers to apply the <b>Glaccountforbankaccount</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> GLACCOUNTFORBANKACCOUNT =
        new PaymentReleaseListItemField<String>("Glaccountforbankaccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Supplierpaymentmethod</b>
     * </p>
     *
     * @return Pymt Meth.
     */
    @SerializedName( "Supplierpaymentmethod" )
    @JsonProperty( "Supplierpaymentmethod" )
    @Nullable
    @ODataField( odataName = "Supplierpaymentmethod" )
    private String supplierpaymentmethod;
    /**
     * Use with available fluent helpers to apply the <b>Supplierpaymentmethod</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SUPPLIERPAYMENTMETHOD =
        new PaymentReleaseListItemField<String>("Supplierpaymentmethod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Paymentmethodsupplement</b>
     * </p>
     *
     * @return Pmt meth.supl.
     */
    @SerializedName( "Paymentmethodsupplement" )
    @JsonProperty( "Paymentmethodsupplement" )
    @Nullable
    @ODataField( odataName = "Paymentmethodsupplement" )
    private String paymentmethodsupplement;
    /**
     * Use with available fluent helpers to apply the <b>Paymentmethodsupplement</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTMETHODSUPPLEMENT =
        new PaymentReleaseListItemField<String>("Paymentmethodsupplement");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstructionkey</b>
     * </p>
     *
     * @return Instruction Key
     */
    @SerializedName( "Dataexchangeinstructionkey" )
    @JsonProperty( "Dataexchangeinstructionkey" )
    @Nullable
    @ODataField( odataName = "Dataexchangeinstructionkey" )
    private String dataexchangeinstructionkey;
    /**
     * Use with available fluent helpers to apply the <b>Dataexchangeinstructionkey</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> DATAEXCHANGEINSTRUCTIONKEY =
        new PaymentReleaseListItemField<String>("Dataexchangeinstructionkey");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paymentdocumentpostingdate</b>
     * </p>
     *
     * @return Doc. Pstg Date
     */
    @SerializedName( "Paymentdocumentpostingdate" )
    @JsonProperty( "Paymentdocumentpostingdate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Paymentdocumentpostingdate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime paymentdocumentpostingdate;
    /**
     * Use with available fluent helpers to apply the <b>Paymentdocumentpostingdate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> PAYMENTDOCUMENTPOSTINGDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Paymentdocumentpostingdate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Valuedate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "Valuedate" )
    @JsonProperty( "Valuedate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Valuedate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valuedate;
    /**
     * Use with available fluent helpers to apply the <b>Valuedate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> VALUEDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Valuedate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paiditemduedate</b>
     * </p>
     *
     * @return Due date
     */
    @SerializedName( "Paiditemduedate" )
    @JsonProperty( "Paiditemduedate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Paiditemduedate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime paiditemduedate;
    /**
     * Use with available fluent helpers to apply the <b>Paiditemduedate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> PAIDITEMDUEDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Paiditemduedate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Billofexchangeduedate</b>
     * </p>
     *
     * @return BoE due date
     */
    @SerializedName( "Billofexchangeduedate" )
    @JsonProperty( "Billofexchangeduedate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Billofexchangeduedate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billofexchangeduedate;
    /**
     * Use with available fluent helpers to apply the <b>Billofexchangeduedate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> BILLOFEXCHANGEDUEDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Billofexchangeduedate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Billofexchangeissuedate</b>
     * </p>
     *
     * @return Issue date
     */
    @SerializedName( "Billofexchangeissuedate" )
    @JsonProperty( "Billofexchangeissuedate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "Billofexchangeissuedate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billofexchangeissuedate;
    /**
     * Use with available fluent helpers to apply the <b>Billofexchangeissuedate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<LocalDateTime> BILLOFEXCHANGEISSUEDATE =
        new PaymentReleaseListItemField<LocalDateTime>("Billofexchangeissuedate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Accountingclerk</b>
     * </p>
     *
     * @return Clerk Abbrev.
     */
    @SerializedName( "Accountingclerk" )
    @JsonProperty( "Accountingclerk" )
    @Nullable
    @ODataField( odataName = "Accountingclerk" )
    private String accountingclerk;
    /**
     * Use with available fluent helpers to apply the <b>Accountingclerk</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ACCOUNTINGCLERK =
        new PaymentReleaseListItemField<String>("Accountingclerk");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Accountbyshipper</b>
     * </p>
     *
     * @return Acct at cust.
     */
    @SerializedName( "Accountbyshipper" )
    @JsonProperty( "Accountbyshipper" )
    @Nullable
    @ODataField( odataName = "Accountbyshipper" )
    private String accountbyshipper;
    /**
     * Use with available fluent helpers to apply the <b>Accountbyshipper</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> ACCOUNTBYSHIPPER =
        new PaymentReleaseListItemField<String>("Accountbyshipper");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreference</b>
     * </p>
     *
     * @return Payment Ref.
     */
    @SerializedName( "Paymentreference" )
    @JsonProperty( "Paymentreference" )
    @Nullable
    @ODataField( odataName = "Paymentreference" )
    private String paymentreference;
    /**
     * Use with available fluent helpers to apply the <b>Paymentreference</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> PAYMENTREFERENCE =
        new PaymentReleaseListItemField<String>("Paymentreference");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>Sepamandateuuid</b>
     * </p>
     *
     * @return Mandate GUID
     */
    @SerializedName( "Sepamandateuuid" )
    @JsonProperty( "Sepamandateuuid" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBinaryAdapter.class )
    @ODataField( odataName = "Sepamandateuuid" )
    private byte[] sepamandateuuid;
    /**
     * Use with available fluent helpers to apply the <b>Sepamandateuuid</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<byte[]> SEPAMANDATEUUID =
        new PaymentReleaseListItemField<byte[]>("Sepamandateuuid");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Sepamandate</b>
     * </p>
     *
     * @return Mandate Ref.
     */
    @SerializedName( "Sepamandate" )
    @JsonProperty( "Sepamandate" )
    @Nullable
    @ODataField( odataName = "Sepamandate" )
    private String sepamandate;
    /**
     * Use with available fluent helpers to apply the <b>Sepamandate</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> SEPAMANDATE =
        new PaymentReleaseListItemField<String>("Sepamandate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Invoicereference</b>
     * </p>
     *
     * @return DocRefNumber
     */
    @SerializedName( "Invoicereference" )
    @JsonProperty( "Invoicereference" )
    @Nullable
    @ODataField( odataName = "Invoicereference" )
    private String invoicereference;
    /**
     * Use with available fluent helpers to apply the <b>Invoicereference</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> INVOICEREFERENCE =
        new PaymentReleaseListItemField<String>("Invoicereference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Invoicereferencefiscalyear</b>
     * </p>
     *
     * @return DocRef Year
     */
    @SerializedName( "Invoicereferencefiscalyear" )
    @JsonProperty( "Invoicereferencefiscalyear" )
    @Nullable
    @ODataField( odataName = "Invoicereferencefiscalyear" )
    private String invoicereferencefiscalyear;
    /**
     * Use with available fluent helpers to apply the <b>Invoicereferencefiscalyear</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> INVOICEREFERENCEFISCALYEAR =
        new PaymentReleaseListItemField<String>("Invoicereferencefiscalyear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Invoiceitemreference</b>
     * </p>
     *
     * @return DocRefItem
     */
    @SerializedName( "Invoiceitemreference" )
    @JsonProperty( "Invoiceitemreference" )
    @Nullable
    @ODataField( odataName = "Invoiceitemreference" )
    private String invoiceitemreference;
    /**
     * Use with available fluent helpers to apply the <b>Invoiceitemreference</b> field to query operations.
     *
     */
    public final static PaymentReleaseListItemField<String> INVOICEITEMREFERENCE =
        new PaymentReleaseListItemField<String>("Invoiceitemreference");

    @Nonnull
    @Override
    public Class<PaymentReleaseListItem> getType()
    {
        return PaymentReleaseListItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselistitemuuid</b>
     * </p>
     *
     * @param paymentreleaselistitemuuid
     *            UUID
     */
    public void setPaymentreleaselistitemuuid( @Nullable final UUID paymentreleaselistitemuuid )
    {
        rememberChangedField("Paymentreleaselistitemuuid", this.paymentreleaselistitemuuid);
        this.paymentreleaselistitemuuid = paymentreleaselistitemuuid;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselist</b>
     * </p>
     *
     * @param paymentreleaselist
     *            List ID
     */
    public void setPaymentreleaselist( @Nullable final String paymentreleaselist )
    {
        rememberChangedField("Paymentreleaselist", this.paymentreleaselist);
        this.paymentreleaselist = paymentreleaselist;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentstatus</b>
     * </p>
     *
     * @param paymentstatus
     *            Item Status
     */
    public void setPaymentstatus( @Nullable final String paymentstatus )
    {
        rememberChangedField("Paymentstatus", this.paymentstatus);
        this.paymentstatus = paymentstatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Paytrellistitemapprovallevel</b>
     * </p>
     *
     * @param paytrellistitemapprovallevel
     *            Approval Level
     */
    public void setPaytrellistitemapprovallevel( @Nullable final String paytrellistitemapprovallevel )
    {
        rememberChangedField("Paytrellistitemapprovallevel", this.paytrellistitemapprovallevel);
        this.paytrellistitemapprovallevel = paytrellistitemapprovallevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Createdbyuser</b>
     * </p>
     *
     * @param createdbyuser
     *            Created By
     */
    public void setCreatedbyuser( @Nullable final String createdbyuser )
    {
        rememberChangedField("Createdbyuser", this.createdbyuser);
        this.createdbyuser = createdbyuser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Lastchangedbyuser</b>
     * </p>
     *
     * @param lastchangedbyuser
     *            Last Changed By
     */
    public void setLastchangedbyuser( @Nullable final String lastchangedbyuser )
    {
        rememberChangedField("Lastchangedbyuser", this.lastchangedbyuser);
        this.lastchangedbyuser = lastchangedbyuser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreleaselistapplication</b>
     * </p>
     *
     * @param paymentreleaselistapplication
     *            Application ID
     */
    public void setPaymentreleaselistapplication( @Nullable final String paymentreleaselistapplication )
    {
        rememberChangedField("Paymentreleaselistapplication", this.paymentreleaselistapplication);
        this.paymentreleaselistapplication = paymentreleaselistapplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Companycode</b>
     * </p>
     *
     * @param companycode
     *            Company Code
     */
    public void setCompanycode( @Nullable final String companycode )
    {
        rememberChangedField("Companycode", this.companycode);
        this.companycode = companycode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocument</b>
     * </p>
     *
     * @param accountingdocument
     *            Document Number
     */
    public void setAccountingdocument( @Nullable final String accountingdocument )
    {
        rememberChangedField("Accountingdocument", this.accountingdocument);
        this.accountingdocument = accountingdocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Fiscalyear</b>
     * </p>
     *
     * @param fiscalyear
     *            Fiscal Year
     */
    public void setFiscalyear( @Nullable final String fiscalyear )
    {
        rememberChangedField("Fiscalyear", this.fiscalyear);
        this.fiscalyear = fiscalyear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocumentitem</b>
     * </p>
     *
     * @param accountingdocumentitem
     *            Item
     */
    public void setAccountingdocumentitem( @Nullable final String accountingdocumentitem )
    {
        rememberChangedField("Accountingdocumentitem", this.accountingdocumentitem);
        this.accountingdocumentitem = accountingdocumentitem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>Supplierfullname</b>
     * </p>
     *
     * @param supplierfullname
     *            Supplier Name
     */
    public void setSupplierfullname( @Nullable final String supplierfullname )
    {
        rememberChangedField("Supplierfullname", this.supplierfullname);
        this.supplierfullname = supplierfullname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Branchaccount</b>
     * </p>
     *
     * @param branchaccount
     *            Branch
     */
    public void setBranchaccount( @Nullable final String branchaccount )
    {
        rememberChangedField("Branchaccount", this.branchaccount);
        this.branchaccount = branchaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Payerpayee</b>
     * </p>
     *
     * @param payerpayee
     *            Payer
     */
    public void setPayerpayee( @Nullable final String payerpayee )
    {
        rememberChangedField("Payerpayee", this.payerpayee);
        this.payerpayee = payerpayee;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Partnercompany</b>
     * </p>
     *
     * @param partnercompany
     *            Trading Partner
     */
    public void setPartnercompany( @Nullable final String partnercompany )
    {
        rememberChangedField("Partnercompany", this.partnercompany);
        this.partnercompany = partnercompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Debitcreditcode</b>
     * </p>
     *
     * @param debitcreditcode
     *            Debit/Credit
     */
    public void setDebitcreditcode( @Nullable final String debitcreditcode )
    {
        rememberChangedField("Debitcreditcode", this.debitcreditcode);
        this.debitcreditcode = debitcreditcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Transactioncurrency</b>
     * </p>
     *
     * @param transactioncurrency
     *            Currency
     */
    public void setTransactioncurrency( @Nullable final String transactioncurrency )
    {
        rememberChangedField("Transactioncurrency", this.transactioncurrency);
        this.transactioncurrency = transactioncurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Amountintransactioncurrency</b>
     * </p>
     *
     * @param amountintransactioncurrency
     *            Amount
     */
    public void setAmountintransactioncurrency( @Nullable final BigDecimal amountintransactioncurrency )
    {
        rememberChangedField("Amountintransactioncurrency", this.amountintransactioncurrency);
        this.amountintransactioncurrency = amountintransactioncurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountbaseamount</b>
     * </p>
     *
     * @param cashdiscountbaseamount
     *            CD Base
     */
    public void setCashdiscountbaseamount( @Nullable final BigDecimal cashdiscountbaseamount )
    {
        rememberChangedField("Cashdiscountbaseamount", this.cashdiscountbaseamount);
        this.cashdiscountbaseamount = cashdiscountbaseamount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountamtintransaccrcy</b>
     * </p>
     *
     * @param cashdiscountamtintransaccrcy
     *            CD Amount
     */
    public void setCashdiscountamtintransaccrcy( @Nullable final BigDecimal cashdiscountamtintransaccrcy )
    {
        rememberChangedField("Cashdiscountamtintransaccrcy", this.cashdiscountamtintransaccrcy);
        this.cashdiscountamtintransaccrcy = cashdiscountamtintransaccrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Whldgtaxamtintransaccrcy</b>
     * </p>
     *
     * @param whldgtaxamtintransaccrcy
     *            Withholding Tax
     */
    public void setWhldgtaxamtintransaccrcy( @Nullable final BigDecimal whldgtaxamtintransaccrcy )
    {
        rememberChangedField("Whldgtaxamtintransaccrcy", this.whldgtaxamtintransaccrcy);
        this.whldgtaxamtintransaccrcy = whldgtaxamtintransaccrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Balancetransactioncurrency</b>
     * </p>
     *
     * @param balancetransactioncurrency
     *            G/L currency
     */
    public void setBalancetransactioncurrency( @Nullable final String balancetransactioncurrency )
    {
        rememberChangedField("Balancetransactioncurrency", this.balancetransactioncurrency);
        this.balancetransactioncurrency = balancetransactioncurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Amountinbalancetransaccrcy</b>
     * </p>
     *
     * @param amountinbalancetransaccrcy
     *            G/L Amount
     */
    public void setAmountinbalancetransaccrcy( @Nullable final BigDecimal amountinbalancetransaccrcy )
    {
        rememberChangedField("Amountinbalancetransaccrcy", this.amountinbalancetransaccrcy);
        this.amountinbalancetransaccrcy = amountinbalancetransaccrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscountamount</b>
     * </p>
     *
     * @param cashdiscountamount
     *            G/L Discount
     */
    public void setCashdiscountamount( @Nullable final BigDecimal cashdiscountamount )
    {
        rememberChangedField("Cashdiscountamount", this.cashdiscountamount);
        this.cashdiscountamount = cashdiscountamount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Accountingdocumenttype</b>
     * </p>
     *
     * @param accountingdocumenttype
     *            Document Type
     */
    public void setAccountingdocumenttype( @Nullable final String accountingdocumenttype )
    {
        rememberChangedField("Accountingdocumenttype", this.accountingdocumenttype);
        this.accountingdocumenttype = accountingdocumenttype;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Postingdate</b>
     * </p>
     *
     * @param postingdate
     *            Posting Date
     */
    public void setPostingdate( @Nullable final LocalDateTime postingdate )
    {
        rememberChangedField("Postingdate", this.postingdate);
        this.postingdate = postingdate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Documentdate</b>
     * </p>
     *
     * @param documentdate
     *            Document Date
     */
    public void setDocumentdate( @Nullable final LocalDateTime documentdate )
    {
        rememberChangedField("Documentdate", this.documentdate);
        this.documentdate = documentdate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Financialaccounttype</b>
     * </p>
     *
     * @param financialaccounttype
     *            Account Type
     */
    public void setFinancialaccounttype( @Nullable final String financialaccounttype )
    {
        rememberChangedField("Financialaccounttype", this.financialaccounttype);
        this.financialaccounttype = financialaccounttype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Postingkey</b>
     * </p>
     *
     * @param postingkey
     *            Posting Key
     */
    public void setPostingkey( @Nullable final String postingkey )
    {
        rememberChangedField("Postingkey", this.postingkey);
        this.postingkey = postingkey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Glaccount</b>
     * </p>
     *
     * @param glaccount
     *            G/L Account
     */
    public void setGlaccount( @Nullable final String glaccount )
    {
        rememberChangedField("Glaccount", this.glaccount);
        this.glaccount = glaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Operationalglaccount</b>
     * </p>
     *
     * @param operationalglaccount
     *            G/L Account
     */
    public void setOperationalglaccount( @Nullable final String operationalglaccount )
    {
        rememberChangedField("Operationalglaccount", this.operationalglaccount);
        this.operationalglaccount = operationalglaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Specialglcode</b>
     * </p>
     *
     * @param specialglcode
     *            Special G/L ind
     */
    public void setSpecialglcode( @Nullable final String specialglcode )
    {
        rememberChangedField("Specialglcode", this.specialglcode);
        this.specialglcode = specialglcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Businessarea</b>
     * </p>
     *
     * @param businessarea
     *            Business Area
     */
    public void setBusinessarea( @Nullable final String businessarea )
    {
        rememberChangedField("Businessarea", this.businessarea);
        this.businessarea = businessarea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Taxcode</b>
     * </p>
     *
     * @param taxcode
     *            Tax Code
     */
    public void setTaxcode( @Nullable final String taxcode )
    {
        rememberChangedField("Taxcode", this.taxcode);
        this.taxcode = taxcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Withholdingtaxcode</b>
     * </p>
     *
     * @param withholdingtaxcode
     *            W. Tax Code
     */
    public void setWithholdingtaxcode( @Nullable final String withholdingtaxcode )
    {
        rememberChangedField("Withholdingtaxcode", this.withholdingtaxcode);
        this.withholdingtaxcode = withholdingtaxcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Documentitemtext</b>
     * </p>
     *
     * @param documentitemtext
     *            Text
     */
    public void setDocumentitemtext( @Nullable final String documentitemtext )
    {
        rememberChangedField("Documentitemtext", this.documentitemtext);
        this.documentitemtext = documentitemtext;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Duecalculationbasedate</b>
     * </p>
     *
     * @param duecalculationbasedate
     *            Baseline Date
     */
    public void setDuecalculationbasedate( @Nullable final LocalDateTime duecalculationbasedate )
    {
        rememberChangedField("Duecalculationbasedate", this.duecalculationbasedate);
        this.duecalculationbasedate = duecalculationbasedate;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount1days</b>
     * </p>
     *
     * @param cashdiscount1days
     *            Days 1
     */
    public void setCashdiscount1days( @Nullable final BigDecimal cashdiscount1days )
    {
        rememberChangedField("Cashdiscount1days", this.cashdiscount1days);
        this.cashdiscount1days = cashdiscount1days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount2days</b>
     * </p>
     *
     * @param cashdiscount2days
     *            Days 2
     */
    public void setCashdiscount2days( @Nullable final BigDecimal cashdiscount2days )
    {
        rememberChangedField("Cashdiscount2days", this.cashdiscount2days);
        this.cashdiscount2days = cashdiscount2days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>Netpaymentdays</b>
     * </p>
     *
     * @param netpaymentdays
     *            Days Net
     */
    public void setNetpaymentdays( @Nullable final BigDecimal netpaymentdays )
    {
        rememberChangedField("Netpaymentdays", this.netpaymentdays);
        this.netpaymentdays = netpaymentdays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount1percent</b>
     * </p>
     *
     * @param cashdiscount1percent
     *            CD Percentage 1
     */
    public void setCashdiscount1percent( @Nullable final BigDecimal cashdiscount1percent )
    {
        rememberChangedField("Cashdiscount1percent", this.cashdiscount1percent);
        this.cashdiscount1percent = cashdiscount1percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Cashdiscount2percent</b>
     * </p>
     *
     * @param cashdiscount2percent
     *            CD Percentage 2
     */
    public void setCashdiscount2percent( @Nullable final BigDecimal cashdiscount2percent )
    {
        rememberChangedField("Cashdiscount2percent", this.cashdiscount2percent);
        this.cashdiscount2percent = cashdiscount2percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Purchasingdocument</b>
     * </p>
     *
     * @param purchasingdocument
     *            Purchasing doc.
     */
    public void setPurchasingdocument( @Nullable final String purchasingdocument )
    {
        rememberChangedField("Purchasingdocument", this.purchasingdocument);
        this.purchasingdocument = purchasingdocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Purchasingdocumentitem</b>
     * </p>
     *
     * @param purchasingdocumentitem
     *            Item
     */
    public void setPurchasingdocumentitem( @Nullable final String purchasingdocumentitem )
    {
        rememberChangedField("Purchasingdocumentitem", this.purchasingdocumentitem);
        this.purchasingdocumentitem = purchasingdocumentitem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Vatregistration</b>
     * </p>
     *
     * @param vatregistration
     *            VAT Reg. No.
     */
    public void setVatregistration( @Nullable final String vatregistration )
    {
        rememberChangedField("Vatregistration", this.vatregistration);
        this.vatregistration = vatregistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Statecentralbankpaymentreason</b>
     * </p>
     *
     * @param statecentralbankpaymentreason
     *            SCB Ind.
     */
    public void setStatecentralbankpaymentreason( @Nullable final String statecentralbankpaymentreason )
    {
        rememberChangedField("Statecentralbankpaymentreason", this.statecentralbankpaymentreason);
        this.statecentralbankpaymentreason = statecentralbankpaymentreason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Supplyingcountry</b>
     * </p>
     *
     * @param supplyingcountry
     *            Suppl. Ctry/Reg.
     */
    public void setSupplyingcountry( @Nullable final String supplyingcountry )
    {
        rememberChangedField("Supplyingcountry", this.supplyingcountry);
        this.supplyingcountry = supplyingcountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Projectnetwork</b>
     * </p>
     *
     * @param projectnetwork
     *            Network
     */
    public void setProjectnetwork( @Nullable final String projectnetwork )
    {
        rememberChangedField("Projectnetwork", this.projectnetwork);
        this.projectnetwork = projectnetwork;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Orderinternalbillofoperations</b>
     * </p>
     *
     * @param orderinternalbillofoperations
     *            Plan no.f.oper.
     */
    public void setOrderinternalbillofoperations( @Nullable final String orderinternalbillofoperations )
    {
        rememberChangedField("Orderinternalbillofoperations", this.orderinternalbillofoperations);
        this.orderinternalbillofoperations = orderinternalbillofoperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assignmentreference</b>
     * </p>
     *
     * @param assignmentreference
     *            Assignment
     */
    public void setAssignmentreference( @Nullable final String assignmentreference )
    {
        rememberChangedField("Assignmentreference", this.assignmentreference);
        this.assignmentreference = assignmentreference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>Assetcontract</b>
     * </p>
     *
     * @param assetcontract
     *            Contract Number
     */
    public void setAssetcontract( @Nullable final String assetcontract )
    {
        rememberChangedField("Assetcontract", this.assetcontract);
        this.assetcontract = assetcontract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Followondocumenttype</b>
     * </p>
     *
     * @param followondocumenttype
     *            Follow-On Doc. Type
     */
    public void setFollowondocumenttype( @Nullable final String followondocumenttype )
    {
        rememberChangedField("Followondocumenttype", this.followondocumenttype);
        this.followondocumenttype = followondocumenttype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Costcenter</b>
     * </p>
     *
     * @param costcenter
     *            Cost Center
     */
    public void setCostcenter( @Nullable final String costcenter )
    {
        rememberChangedField("Costcenter", this.costcenter);
        this.costcenter = costcenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Salesdocument</b>
     * </p>
     *
     * @param salesdocument
     *            Sales Document
     */
    public void setSalesdocument( @Nullable final String salesdocument )
    {
        rememberChangedField("Salesdocument", this.salesdocument);
        this.salesdocument = salesdocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Salesdocumentitem</b>
     * </p>
     *
     * @param salesdocumentitem
     *            Item
     */
    public void setSalesdocumentitem( @Nullable final String salesdocumentitem )
    {
        rememberChangedField("Salesdocumentitem", this.salesdocumentitem);
        this.salesdocumentitem = salesdocumentitem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Profitcenter</b>
     * </p>
     *
     * @param profitcenter
     *            Profit Center
     */
    public void setProfitcenter( @Nullable final String profitcenter )
    {
        rememberChangedField("Profitcenter", this.profitcenter);
        this.profitcenter = profitcenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference1idbybusinesspartner</b>
     * </p>
     *
     * @param reference1idbybusinesspartner
     *            Reference Key 1
     */
    public void setReference1idbybusinesspartner( @Nullable final String reference1idbybusinesspartner )
    {
        rememberChangedField("Reference1idbybusinesspartner", this.reference1idbybusinesspartner);
        this.reference1idbybusinesspartner = reference1idbybusinesspartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Reference2idbybusinesspartner</b>
     * </p>
     *
     * @param reference2idbybusinesspartner
     *            Reference Key 2
     */
    public void setReference2idbybusinesspartner( @Nullable final String reference2idbybusinesspartner )
    {
        rememberChangedField("Reference2idbybusinesspartner", this.reference2idbybusinesspartner);
        this.reference2idbybusinesspartner = reference2idbybusinesspartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Reference3idbybusinesspartner</b>
     * </p>
     *
     * @param reference3idbybusinesspartner
     *            Reference key 3
     */
    public void setReference3idbybusinesspartner( @Nullable final String reference3idbybusinesspartner )
    {
        rememberChangedField("Reference3idbybusinesspartner", this.reference3idbybusinesspartner);
        this.reference3idbybusinesspartner = reference3idbybusinesspartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction1</b>
     * </p>
     *
     * @param dataexchangeinstruction1
     *            Instruct. Key 1
     */
    public void setDataexchangeinstruction1( @Nullable final String dataexchangeinstruction1 )
    {
        rememberChangedField("Dataexchangeinstruction1", this.dataexchangeinstruction1);
        this.dataexchangeinstruction1 = dataexchangeinstruction1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction2</b>
     * </p>
     *
     * @param dataexchangeinstruction2
     *            Instruct. Key 2
     */
    public void setDataexchangeinstruction2( @Nullable final String dataexchangeinstruction2 )
    {
        rememberChangedField("Dataexchangeinstruction2", this.dataexchangeinstruction2);
        this.dataexchangeinstruction2 = dataexchangeinstruction2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction3</b>
     * </p>
     *
     * @param dataexchangeinstruction3
     *            Instruct. key 3
     */
    public void setDataexchangeinstruction3( @Nullable final String dataexchangeinstruction3 )
    {
        rememberChangedField("Dataexchangeinstruction3", this.dataexchangeinstruction3);
        this.dataexchangeinstruction3 = dataexchangeinstruction3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstruction4</b>
     * </p>
     *
     * @param dataexchangeinstruction4
     *            Instruct. key 4
     */
    public void setDataexchangeinstruction4( @Nullable final String dataexchangeinstruction4 )
    {
        rememberChangedField("Dataexchangeinstruction4", this.dataexchangeinstruction4);
        this.dataexchangeinstruction4 = dataexchangeinstruction4;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Addressandbankissetmanually</b>
     * </p>
     *
     * @param addressandbankissetmanually
     *            Individ. Set
     */
    public void setAddressandbankissetmanually( @Nullable final Boolean addressandbankissetmanually )
    {
        rememberChangedField("Addressandbankissetmanually", this.addressandbankissetmanually);
        this.addressandbankissetmanually = addressandbankissetmanually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Businessplace</b>
     * </p>
     *
     * @param businessplace
     *            Business Place
     */
    public void setBusinessplace( @Nullable final String businessplace )
    {
        rememberChangedField("Businessplace", this.businessplace);
        this.businessplace = businessplace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Partnerprofitcenter</b>
     * </p>
     *
     * @param partnerprofitcenter
     *            Partner PC
     */
    public void setPartnerprofitcenter( @Nullable final String partnerprofitcenter )
    {
        rememberChangedField("Partnerprofitcenter", this.partnerprofitcenter);
        this.partnerprofitcenter = partnerprofitcenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Grantid</b>
     * </p>
     *
     * @param grantid
     *            Grant
     */
    public void setGrantid( @Nullable final String grantid )
    {
        rememberChangedField("Grantid", this.grantid);
        this.grantid = grantid;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>Functionalarea</b>
     * </p>
     *
     * @param functionalarea
     *            Functional Area
     */
    public void setFunctionalarea( @Nullable final String functionalarea )
    {
        rememberChangedField("Functionalarea", this.functionalarea);
        this.functionalarea = functionalarea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequest</b>
     * </p>
     *
     * @param paymentrequest
     *            Key number
     */
    public void setPaymentrequest( @Nullable final String paymentrequest )
    {
        rememberChangedField("Paymentrequest", this.paymentrequest);
        this.paymentrequest = paymentrequest;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequestamountinpaytcrcy</b>
     * </p>
     *
     * @param paymentrequestamountinpaytcrcy
     *            PC Amount
     */
    public void setPaymentrequestamountinpaytcrcy( @Nullable final BigDecimal paymentrequestamountinpaytcrcy )
    {
        rememberChangedField("Paymentrequestamountinpaytcrcy", this.paymentrequestamountinpaytcrcy);
        this.paymentrequestamountinpaytcrcy = paymentrequestamountinpaytcrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrequestorigin</b>
     * </p>
     *
     * @param paymentrequestorigin
     *            Origin
     */
    public void setPaymentrequestorigin( @Nullable final String paymentrequestorigin )
    {
        rememberChangedField("Paymentrequestorigin", this.paymentrequestorigin);
        this.paymentrequestorigin = paymentrequestorigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Currentprocessor</b>
     * </p>
     *
     * @param currentprocessor
     *            Processor
     */
    public void setCurrentprocessor( @Nullable final String currentprocessor )
    {
        rememberChangedField("Currentprocessor", this.currentprocessor);
        this.currentprocessor = currentprocessor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Earmarkedfundsdocument</b>
     * </p>
     *
     * @param earmarkedfundsdocument
     *            Earmarked Funds
     */
    public void setEarmarkedfundsdocument( @Nullable final String earmarkedfundsdocument )
    {
        rememberChangedField("Earmarkedfundsdocument", this.earmarkedfundsdocument);
        this.earmarkedfundsdocument = earmarkedfundsdocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Taxid2</b>
     * </p>
     *
     * @param taxid2
     *            Tax Number 2
     */
    public void setTaxid2( @Nullable final String taxid2 )
    {
        rememberChangedField("Taxid2", this.taxid2);
        this.taxid2 = taxid2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrunitemmessagenumber</b>
     * </p>
     *
     * @param paymentrunitemmessagenumber
     *            Item indicator
     */
    public void setPaymentrunitemmessagenumber( @Nullable final String paymentrunitemmessagenumber )
    {
        rememberChangedField("Paymentrunitemmessagenumber", this.paymentrunitemmessagenumber);
        this.paymentrunitemmessagenumber = paymentrunitemmessagenumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Paymentblockingreason</b>
     * </p>
     *
     * @param paymentblockingreason
     *            Pmnt Block
     */
    public void setPaymentblockingreason( @Nullable final String paymentblockingreason )
    {
        rememberChangedField("Paymentblockingreason", this.paymentblockingreason);
        this.paymentblockingreason = paymentblockingreason;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrundate</b>
     * </p>
     *
     * @param paymentrundate
     *            Run On
     */
    public void setPaymentrundate( @Nullable final LocalDateTime paymentrundate )
    {
        rememberChangedField("Paymentrundate", this.paymentrundate);
        this.paymentrundate = paymentrundate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Paymentrunid</b>
     * </p>
     *
     * @param paymentrunid
     *            Identification
     */
    public void setPaymentrunid( @Nullable final String paymentrunid )
    {
        rememberChangedField("Paymentrunid", this.paymentrunid);
        this.paymentrunid = paymentrunid;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentdocument</b>
     * </p>
     *
     * @param paymentdocument
     *            Payment doc.no.
     */
    public void setPaymentdocument( @Nullable final String paymentdocument )
    {
        rememberChangedField("Paymentdocument", this.paymentdocument);
        this.paymentdocument = paymentdocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Paymentorder</b>
     * </p>
     *
     * @param paymentorder
     *            Payment order
     */
    public void setPaymentorder( @Nullable final String paymentorder )
    {
        rememberChangedField("Paymentorder", this.paymentorder);
        this.paymentorder = paymentorder;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Proposalrundate</b>
     * </p>
     *
     * @param proposalrundate
     *            Proposal-Run Date
     */
    public void setProposalrundate( @Nullable final LocalDateTime proposalrundate )
    {
        rememberChangedField("Proposalrundate", this.proposalrundate);
        this.proposalrundate = proposalrundate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Proposalrunnumber</b>
     * </p>
     *
     * @param proposalrunnumber
     *            Payt Proposal
     */
    public void setProposalrunnumber( @Nullable final String proposalrunnumber )
    {
        rememberChangedField("Proposalrunnumber", this.proposalrunnumber);
        this.proposalrunnumber = proposalrunnumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Payingcompanycode</b>
     * </p>
     *
     * @param payingcompanycode
     *            Paying co. code
     */
    public void setPayingcompanycode( @Nullable final String payingcompanycode )
    {
        rememberChangedField("Payingcompanycode", this.payingcompanycode);
        this.payingcompanycode = payingcompanycode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Sendingcompanycode</b>
     * </p>
     *
     * @param sendingcompanycode
     *            Sending co.code
     */
    public void setSendingcompanycode( @Nullable final String sendingcompanycode )
    {
        rememberChangedField("Sendingcompanycode", this.sendingcompanycode);
        this.sendingcompanycode = sendingcompanycode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Payeeadditionalname</b>
     * </p>
     *
     * @param payeeadditionalname
     *            Name
     */
    public void setPayeeadditionalname( @Nullable final String payeeadditionalname )
    {
        rememberChangedField("Payeeadditionalname", this.payeeadditionalname);
        this.payeeadditionalname = payeeadditionalname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Payeepostalcode</b>
     * </p>
     *
     * @param payeepostalcode
     *            Payee Postal Code
     */
    public void setPayeepostalcode( @Nullable final String payeepostalcode )
    {
        rememberChangedField("Payeepostalcode", this.payeepostalcode);
        this.payeepostalcode = payeepostalcode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Payeecityname</b>
     * </p>
     *
     * @param payeecityname
     *            City
     */
    public void setPayeecityname( @Nullable final String payeecityname )
    {
        rememberChangedField("Payeecityname", this.payeecityname);
        this.payeecityname = payeecityname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeecountry</b>
     * </p>
     *
     * @param payeecountry
     *            Country/Region
     */
    public void setPayeecountry( @Nullable final String payeecountry )
    {
        rememberChangedField("Payeecountry", this.payeecountry);
        this.payeecountry = payeecountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeeregion</b>
     * </p>
     *
     * @param payeeregion
     *            Regional code
     */
    public void setPayeeregion( @Nullable final String payeeregion )
    {
        rememberChangedField("Payeeregion", this.payeeregion);
        this.payeeregion = payeeregion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Payeelanguage</b>
     * </p>
     *
     * @param payeelanguage
     *            Payee lang. key
     */
    public void setPayeelanguage( @Nullable final String payeelanguage )
    {
        rememberChangedField("Payeelanguage", this.payeelanguage);
        this.payeelanguage = payeelanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @param name
     *            Name
     */
    public void setName( @Nullable final String name )
    {
        rememberChangedField("Name", this.name);
        this.name = name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankcountry</b>
     * </p>
     *
     * @param payeebankcountry
     *            Ctry/Reg. key
     */
    public void setPayeebankcountry( @Nullable final String payeebankcountry )
    {
        rememberChangedField("Payeebankcountry", this.payeebankcountry);
        this.payeebankcountry = payeebankcountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Payeebank</b>
     * </p>
     *
     * @param payeebank
     *            Payee bank key
     */
    public void setPayeebank( @Nullable final String payeebank )
    {
        rememberChangedField("Payeebank", this.payeebank);
        this.payeebank = payeebank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Payeebanknumber</b>
     * </p>
     *
     * @param payeebanknumber
     *            Bank Number
     */
    public void setPayeebanknumber( @Nullable final String payeebanknumber )
    {
        rememberChangedField("Payeebanknumber", this.payeebanknumber);
        this.payeebanknumber = payeebanknumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankaccount</b>
     * </p>
     *
     * @param payeebankaccount
     *            Payee acct no.
     */
    public void setPayeebankaccount( @Nullable final String payeebankaccount )
    {
        rememberChangedField("Payeebankaccount", this.payeebankaccount);
        this.payeebankaccount = payeebankaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankcontrolkey</b>
     * </p>
     *
     * @param payeebankcontrolkey
     *            Control Key
     */
    public void setPayeebankcontrolkey( @Nullable final String payeebankcontrolkey )
    {
        rememberChangedField("Payeebankcontrolkey", this.payeebankcontrolkey);
        this.payeebankcontrolkey = payeebankcontrolkey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Bankdetailreference</b>
     * </p>
     *
     * @param bankdetailreference
     *            Reference
     */
    public void setBankdetailreference( @Nullable final String bankdetailreference )
    {
        rememberChangedField("Bankdetailreference", this.bankdetailreference);
        this.bankdetailreference = bankdetailreference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>Payeebankidentifiercode</b>
     * </p>
     *
     * @param payeebankidentifiercode
     *            SWIFT/BIC
     */
    public void setPayeebankidentifiercode( @Nullable final String payeebankidentifiercode )
    {
        rememberChangedField("Payeebankidentifiercode", this.payeebankidentifiercode);
        this.payeebankidentifiercode = payeebankidentifiercode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 34
     * <p>
     * Original property name from the Odata EDM: <b>Payeeiban</b>
     * </p>
     *
     * @param payeeiban
     *            IBAN
     */
    public void setPayeeiban( @Nullable final String payeeiban )
    {
        rememberChangedField("Payeeiban", this.payeeiban);
        this.payeeiban = payeeiban;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>Bankaccountholdername</b>
     * </p>
     *
     * @param bankaccountholdername
     *            Account holder
     */
    public void setBankaccountholdername( @Nullable final String bankaccountholdername )
    {
        rememberChangedField("Bankaccountholdername", this.bankaccountholdername);
        this.bankaccountholdername = bankaccountholdername;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Housebankaccount</b>
     * </p>
     *
     * @param housebankaccount
     *            Account ID
     */
    public void setHousebankaccount( @Nullable final String housebankaccount )
    {
        rememberChangedField("Housebankaccount", this.housebankaccount);
        this.housebankaccount = housebankaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Housebank</b>
     * </p>
     *
     * @param housebank
     *            House bank
     */
    public void setHousebank( @Nullable final String housebank )
    {
        rememberChangedField("Housebank", this.housebank);
        this.housebank = housebank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Bankcountry</b>
     * </p>
     *
     * @param bankcountry
     *            Bank Ctry/Reg.
     */
    public void setBankcountry( @Nullable final String bankcountry )
    {
        rememberChangedField("Bankcountry", this.bankcountry);
        this.bankcountry = bankcountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     *
     * @param bank
     *            House Bank Key
     */
    public void setBank( @Nullable final String bank )
    {
        rememberChangedField("Bank", this.bank);
        this.bank = bank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Banknumber</b>
     * </p>
     *
     * @param banknumber
     *            House bank no.
     */
    public void setBanknumber( @Nullable final String banknumber )
    {
        rememberChangedField("Banknumber", this.banknumber);
        this.banknumber = banknumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Bankaccount</b>
     * </p>
     *
     * @param bankaccount
     *            Our account number
     */
    public void setBankaccount( @Nullable final String bankaccount )
    {
        rememberChangedField("Bankaccount", this.bankaccount);
        this.bankaccount = bankaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Bankcontrolkey</b>
     * </p>
     *
     * @param bankcontrolkey
     *            Control Key
     */
    public void setBankcontrolkey( @Nullable final String bankcontrolkey )
    {
        rememberChangedField("Bankcontrolkey", this.bankcontrolkey);
        this.bankcontrolkey = bankcontrolkey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Glaccountforbankaccount</b>
     * </p>
     *
     * @param glaccountforbankaccount
     *            G/L Account No.
     */
    public void setGlaccountforbankaccount( @Nullable final String glaccountforbankaccount )
    {
        rememberChangedField("Glaccountforbankaccount", this.glaccountforbankaccount);
        this.glaccountforbankaccount = glaccountforbankaccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Supplierpaymentmethod</b>
     * </p>
     *
     * @param supplierpaymentmethod
     *            Pymt Meth.
     */
    public void setSupplierpaymentmethod( @Nullable final String supplierpaymentmethod )
    {
        rememberChangedField("Supplierpaymentmethod", this.supplierpaymentmethod);
        this.supplierpaymentmethod = supplierpaymentmethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Paymentmethodsupplement</b>
     * </p>
     *
     * @param paymentmethodsupplement
     *            Pmt meth.supl.
     */
    public void setPaymentmethodsupplement( @Nullable final String paymentmethodsupplement )
    {
        rememberChangedField("Paymentmethodsupplement", this.paymentmethodsupplement);
        this.paymentmethodsupplement = paymentmethodsupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Dataexchangeinstructionkey</b>
     * </p>
     *
     * @param dataexchangeinstructionkey
     *            Instruction Key
     */
    public void setDataexchangeinstructionkey( @Nullable final String dataexchangeinstructionkey )
    {
        rememberChangedField("Dataexchangeinstructionkey", this.dataexchangeinstructionkey);
        this.dataexchangeinstructionkey = dataexchangeinstructionkey;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paymentdocumentpostingdate</b>
     * </p>
     *
     * @param paymentdocumentpostingdate
     *            Doc. Pstg Date
     */
    public void setPaymentdocumentpostingdate( @Nullable final LocalDateTime paymentdocumentpostingdate )
    {
        rememberChangedField("Paymentdocumentpostingdate", this.paymentdocumentpostingdate);
        this.paymentdocumentpostingdate = paymentdocumentpostingdate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Valuedate</b>
     * </p>
     *
     * @param valuedate
     *            Value Date
     */
    public void setValuedate( @Nullable final LocalDateTime valuedate )
    {
        rememberChangedField("Valuedate", this.valuedate);
        this.valuedate = valuedate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Paiditemduedate</b>
     * </p>
     *
     * @param paiditemduedate
     *            Due date
     */
    public void setPaiditemduedate( @Nullable final LocalDateTime paiditemduedate )
    {
        rememberChangedField("Paiditemduedate", this.paiditemduedate);
        this.paiditemduedate = paiditemduedate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Billofexchangeduedate</b>
     * </p>
     *
     * @param billofexchangeduedate
     *            BoE due date
     */
    public void setBillofexchangeduedate( @Nullable final LocalDateTime billofexchangeduedate )
    {
        rememberChangedField("Billofexchangeduedate", this.billofexchangeduedate);
        this.billofexchangeduedate = billofexchangeduedate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>Billofexchangeissuedate</b>
     * </p>
     *
     * @param billofexchangeissuedate
     *            Issue date
     */
    public void setBillofexchangeissuedate( @Nullable final LocalDateTime billofexchangeissuedate )
    {
        rememberChangedField("Billofexchangeissuedate", this.billofexchangeissuedate);
        this.billofexchangeissuedate = billofexchangeissuedate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Accountingclerk</b>
     * </p>
     *
     * @param accountingclerk
     *            Clerk Abbrev.
     */
    public void setAccountingclerk( @Nullable final String accountingclerk )
    {
        rememberChangedField("Accountingclerk", this.accountingclerk);
        this.accountingclerk = accountingclerk;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Accountbyshipper</b>
     * </p>
     *
     * @param accountbyshipper
     *            Acct at cust.
     */
    public void setAccountbyshipper( @Nullable final String accountbyshipper )
    {
        rememberChangedField("Accountbyshipper", this.accountbyshipper);
        this.accountbyshipper = accountbyshipper;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Paymentreference</b>
     * </p>
     *
     * @param paymentreference
     *            Payment Ref.
     */
    public void setPaymentreference( @Nullable final String paymentreference )
    {
        rememberChangedField("Paymentreference", this.paymentreference);
        this.paymentreference = paymentreference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>Sepamandateuuid</b>
     * </p>
     *
     * @param sepamandateuuid
     *            Mandate GUID
     */
    public void setSepamandateuuid( @Nullable final byte[] sepamandateuuid )
    {
        rememberChangedField("Sepamandateuuid", this.sepamandateuuid);
        this.sepamandateuuid = sepamandateuuid;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Sepamandate</b>
     * </p>
     *
     * @param sepamandate
     *            Mandate Ref.
     */
    public void setSepamandate( @Nullable final String sepamandate )
    {
        rememberChangedField("Sepamandate", this.sepamandate);
        this.sepamandate = sepamandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Invoicereference</b>
     * </p>
     *
     * @param invoicereference
     *            DocRefNumber
     */
    public void setInvoicereference( @Nullable final String invoicereference )
    {
        rememberChangedField("Invoicereference", this.invoicereference);
        this.invoicereference = invoicereference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Invoicereferencefiscalyear</b>
     * </p>
     *
     * @param invoicereferencefiscalyear
     *            DocRef Year
     */
    public void setInvoicereferencefiscalyear( @Nullable final String invoicereferencefiscalyear )
    {
        rememberChangedField("Invoicereferencefiscalyear", this.invoicereferencefiscalyear);
        this.invoicereferencefiscalyear = invoicereferencefiscalyear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Invoiceitemreference</b>
     * </p>
     *
     * @param invoiceitemreference
     *            DocRefItem
     */
    public void setInvoiceitemreference( @Nullable final String invoiceitemreference )
    {
        rememberChangedField("Invoiceitemreference", this.invoiceitemreference);
        this.invoiceitemreference = invoiceitemreference;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PaymentReleaseListItemSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Paymentreleaselistitemuuid", getPaymentreleaselistitemuuid());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Paymentreleaselistitemuuid", getPaymentreleaselistitemuuid());
        values.put("Paymentreleaselist", getPaymentreleaselist());
        values.put("Paymentstatus", getPaymentstatus());
        values.put("Paytrellistitemapprovallevel", getPaytrellistitemapprovallevel());
        values.put("Createdbyuser", getCreatedbyuser());
        values.put("Lastchangedbyuser", getLastchangedbyuser());
        values.put("Paymentreleaselistapplication", getPaymentreleaselistapplication());
        values.put("Companycode", getCompanycode());
        values.put("Accountingdocument", getAccountingdocument());
        values.put("Fiscalyear", getFiscalyear());
        values.put("Accountingdocumentitem", getAccountingdocumentitem());
        values.put("Supplierfullname", getSupplierfullname());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("Branchaccount", getBranchaccount());
        values.put("Payerpayee", getPayerpayee());
        values.put("Partnercompany", getPartnercompany());
        values.put("Debitcreditcode", getDebitcreditcode());
        values.put("Transactioncurrency", getTransactioncurrency());
        values.put("Amountintransactioncurrency", getAmountintransactioncurrency());
        values.put("Cashdiscountbaseamount", getCashdiscountbaseamount());
        values.put("Cashdiscountamtintransaccrcy", getCashdiscountamtintransaccrcy());
        values.put("Whldgtaxamtintransaccrcy", getWhldgtaxamtintransaccrcy());
        values.put("Balancetransactioncurrency", getBalancetransactioncurrency());
        values.put("Amountinbalancetransaccrcy", getAmountinbalancetransaccrcy());
        values.put("Cashdiscountamount", getCashdiscountamount());
        values.put("Accountingdocumenttype", getAccountingdocumenttype());
        values.put("Postingdate", getPostingdate());
        values.put("Documentdate", getDocumentdate());
        values.put("Financialaccounttype", getFinancialaccounttype());
        values.put("Postingkey", getPostingkey());
        values.put("Glaccount", getGlaccount());
        values.put("Operationalglaccount", getOperationalglaccount());
        values.put("Specialglcode", getSpecialglcode());
        values.put("Businessarea", getBusinessarea());
        values.put("Taxcode", getTaxcode());
        values.put("Withholdingtaxcode", getWithholdingtaxcode());
        values.put("Documentitemtext", getDocumentitemtext());
        values.put("Duecalculationbasedate", getDuecalculationbasedate());
        values.put("Cashdiscount1days", getCashdiscount1days());
        values.put("Cashdiscount2days", getCashdiscount2days());
        values.put("Netpaymentdays", getNetpaymentdays());
        values.put("Cashdiscount1percent", getCashdiscount1percent());
        values.put("Cashdiscount2percent", getCashdiscount2percent());
        values.put("Purchasingdocument", getPurchasingdocument());
        values.put("Purchasingdocumentitem", getPurchasingdocumentitem());
        values.put("Vatregistration", getVatregistration());
        values.put("Statecentralbankpaymentreason", getStatecentralbankpaymentreason());
        values.put("Supplyingcountry", getSupplyingcountry());
        values.put("Projectnetwork", getProjectnetwork());
        values.put("Orderinternalbillofoperations", getOrderinternalbillofoperations());
        values.put("Assignmentreference", getAssignmentreference());
        values.put("Assetcontract", getAssetcontract());
        values.put("Followondocumenttype", getFollowondocumenttype());
        values.put("Costcenter", getCostcenter());
        values.put("Salesdocument", getSalesdocument());
        values.put("Salesdocumentitem", getSalesdocumentitem());
        values.put("Profitcenter", getProfitcenter());
        values.put("Reference1idbybusinesspartner", getReference1idbybusinesspartner());
        values.put("Reference2idbybusinesspartner", getReference2idbybusinesspartner());
        values.put("Reference3idbybusinesspartner", getReference3idbybusinesspartner());
        values.put("Dataexchangeinstruction1", getDataexchangeinstruction1());
        values.put("Dataexchangeinstruction2", getDataexchangeinstruction2());
        values.put("Dataexchangeinstruction3", getDataexchangeinstruction3());
        values.put("Dataexchangeinstruction4", getDataexchangeinstruction4());
        values.put("Addressandbankissetmanually", getAddressandbankissetmanually());
        values.put("Businessplace", getBusinessplace());
        values.put("Partnerprofitcenter", getPartnerprofitcenter());
        values.put("Grantid", getGrantid());
        values.put("Functionalarea", getFunctionalarea());
        values.put("Fund", getFund());
        values.put("Paymentrequest", getPaymentrequest());
        values.put("Paymentrequestamountinpaytcrcy", getPaymentrequestamountinpaytcrcy());
        values.put("Paymentrequestorigin", getPaymentrequestorigin());
        values.put("Currentprocessor", getCurrentprocessor());
        values.put("Earmarkedfundsdocument", getEarmarkedfundsdocument());
        values.put("Taxid2", getTaxid2());
        values.put("Paymentrunitemmessagenumber", getPaymentrunitemmessagenumber());
        values.put("Paymentblockingreason", getPaymentblockingreason());
        values.put("Paymentrundate", getPaymentrundate());
        values.put("Paymentrunid", getPaymentrunid());
        values.put("Paymentdocument", getPaymentdocument());
        values.put("Paymentorder", getPaymentorder());
        values.put("Proposalrundate", getProposalrundate());
        values.put("Proposalrunnumber", getProposalrunnumber());
        values.put("Payingcompanycode", getPayingcompanycode());
        values.put("Sendingcompanycode", getSendingcompanycode());
        values.put("Payeeadditionalname", getPayeeadditionalname());
        values.put("Payeepostalcode", getPayeepostalcode());
        values.put("Payeecityname", getPayeecityname());
        values.put("Payeecountry", getPayeecountry());
        values.put("Payeeregion", getPayeeregion());
        values.put("Payeelanguage", getPayeelanguage());
        values.put("Name", getName());
        values.put("Payeebankcountry", getPayeebankcountry());
        values.put("Payeebank", getPayeebank());
        values.put("Payeebanknumber", getPayeebanknumber());
        values.put("Payeebankaccount", getPayeebankaccount());
        values.put("Payeebankcontrolkey", getPayeebankcontrolkey());
        values.put("Bankdetailreference", getBankdetailreference());
        values.put("Payeebankidentifiercode", getPayeebankidentifiercode());
        values.put("Payeeiban", getPayeeiban());
        values.put("Bankaccountholdername", getBankaccountholdername());
        values.put("Housebankaccount", getHousebankaccount());
        values.put("Housebank", getHousebank());
        values.put("Bankcountry", getBankcountry());
        values.put("Bank", getBank());
        values.put("Banknumber", getBanknumber());
        values.put("Bankaccount", getBankaccount());
        values.put("Bankcontrolkey", getBankcontrolkey());
        values.put("Glaccountforbankaccount", getGlaccountforbankaccount());
        values.put("Supplierpaymentmethod", getSupplierpaymentmethod());
        values.put("Paymentmethodsupplement", getPaymentmethodsupplement());
        values.put("Dataexchangeinstructionkey", getDataexchangeinstructionkey());
        values.put("Paymentdocumentpostingdate", getPaymentdocumentpostingdate());
        values.put("Valuedate", getValuedate());
        values.put("Paiditemduedate", getPaiditemduedate());
        values.put("Billofexchangeduedate", getBillofexchangeduedate());
        values.put("Billofexchangeissuedate", getBillofexchangeissuedate());
        values.put("Accountingclerk", getAccountingclerk());
        values.put("Accountbyshipper", getAccountbyshipper());
        values.put("Paymentreference", getPaymentreference());
        values.put("Sepamandateuuid", getSepamandateuuid());
        values.put("Sepamandate", getSepamandate());
        values.put("Invoicereference", getInvoicereference());
        values.put("Invoicereferencefiscalyear", getInvoicereferencefiscalyear());
        values.put("Invoiceitemreference", getInvoiceitemreference());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Paymentreleaselistitemuuid") ) {
                final Object value = values.remove("Paymentreleaselistitemuuid");
                if( (value == null) || (!value.equals(getPaymentreleaselistitemuuid())) ) {
                    setPaymentreleaselistitemuuid(((UUID) value));
                }
            }
            if( values.containsKey("Paymentreleaselist") ) {
                final Object value = values.remove("Paymentreleaselist");
                if( (value == null) || (!value.equals(getPaymentreleaselist())) ) {
                    setPaymentreleaselist(((String) value));
                }
            }
            if( values.containsKey("Paymentstatus") ) {
                final Object value = values.remove("Paymentstatus");
                if( (value == null) || (!value.equals(getPaymentstatus())) ) {
                    setPaymentstatus(((String) value));
                }
            }
            if( values.containsKey("Paytrellistitemapprovallevel") ) {
                final Object value = values.remove("Paytrellistitemapprovallevel");
                if( (value == null) || (!value.equals(getPaytrellistitemapprovallevel())) ) {
                    setPaytrellistitemapprovallevel(((String) value));
                }
            }
            if( values.containsKey("Createdbyuser") ) {
                final Object value = values.remove("Createdbyuser");
                if( (value == null) || (!value.equals(getCreatedbyuser())) ) {
                    setCreatedbyuser(((String) value));
                }
            }
            if( values.containsKey("Lastchangedbyuser") ) {
                final Object value = values.remove("Lastchangedbyuser");
                if( (value == null) || (!value.equals(getLastchangedbyuser())) ) {
                    setLastchangedbyuser(((String) value));
                }
            }
            if( values.containsKey("Paymentreleaselistapplication") ) {
                final Object value = values.remove("Paymentreleaselistapplication");
                if( (value == null) || (!value.equals(getPaymentreleaselistapplication())) ) {
                    setPaymentreleaselistapplication(((String) value));
                }
            }
            if( values.containsKey("Companycode") ) {
                final Object value = values.remove("Companycode");
                if( (value == null) || (!value.equals(getCompanycode())) ) {
                    setCompanycode(((String) value));
                }
            }
            if( values.containsKey("Accountingdocument") ) {
                final Object value = values.remove("Accountingdocument");
                if( (value == null) || (!value.equals(getAccountingdocument())) ) {
                    setAccountingdocument(((String) value));
                }
            }
            if( values.containsKey("Fiscalyear") ) {
                final Object value = values.remove("Fiscalyear");
                if( (value == null) || (!value.equals(getFiscalyear())) ) {
                    setFiscalyear(((String) value));
                }
            }
            if( values.containsKey("Accountingdocumentitem") ) {
                final Object value = values.remove("Accountingdocumentitem");
                if( (value == null) || (!value.equals(getAccountingdocumentitem())) ) {
                    setAccountingdocumentitem(((String) value));
                }
            }
            if( values.containsKey("Supplierfullname") ) {
                final Object value = values.remove("Supplierfullname");
                if( (value == null) || (!value.equals(getSupplierfullname())) ) {
                    setSupplierfullname(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Branchaccount") ) {
                final Object value = values.remove("Branchaccount");
                if( (value == null) || (!value.equals(getBranchaccount())) ) {
                    setBranchaccount(((String) value));
                }
            }
            if( values.containsKey("Payerpayee") ) {
                final Object value = values.remove("Payerpayee");
                if( (value == null) || (!value.equals(getPayerpayee())) ) {
                    setPayerpayee(((String) value));
                }
            }
            if( values.containsKey("Partnercompany") ) {
                final Object value = values.remove("Partnercompany");
                if( (value == null) || (!value.equals(getPartnercompany())) ) {
                    setPartnercompany(((String) value));
                }
            }
            if( values.containsKey("Debitcreditcode") ) {
                final Object value = values.remove("Debitcreditcode");
                if( (value == null) || (!value.equals(getDebitcreditcode())) ) {
                    setDebitcreditcode(((String) value));
                }
            }
            if( values.containsKey("Transactioncurrency") ) {
                final Object value = values.remove("Transactioncurrency");
                if( (value == null) || (!value.equals(getTransactioncurrency())) ) {
                    setTransactioncurrency(((String) value));
                }
            }
            if( values.containsKey("Amountintransactioncurrency") ) {
                final Object value = values.remove("Amountintransactioncurrency");
                if( (value == null) || (!value.equals(getAmountintransactioncurrency())) ) {
                    setAmountintransactioncurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscountbaseamount") ) {
                final Object value = values.remove("Cashdiscountbaseamount");
                if( (value == null) || (!value.equals(getCashdiscountbaseamount())) ) {
                    setCashdiscountbaseamount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscountamtintransaccrcy") ) {
                final Object value = values.remove("Cashdiscountamtintransaccrcy");
                if( (value == null) || (!value.equals(getCashdiscountamtintransaccrcy())) ) {
                    setCashdiscountamtintransaccrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Whldgtaxamtintransaccrcy") ) {
                final Object value = values.remove("Whldgtaxamtintransaccrcy");
                if( (value == null) || (!value.equals(getWhldgtaxamtintransaccrcy())) ) {
                    setWhldgtaxamtintransaccrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Balancetransactioncurrency") ) {
                final Object value = values.remove("Balancetransactioncurrency");
                if( (value == null) || (!value.equals(getBalancetransactioncurrency())) ) {
                    setBalancetransactioncurrency(((String) value));
                }
            }
            if( values.containsKey("Amountinbalancetransaccrcy") ) {
                final Object value = values.remove("Amountinbalancetransaccrcy");
                if( (value == null) || (!value.equals(getAmountinbalancetransaccrcy())) ) {
                    setAmountinbalancetransaccrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscountamount") ) {
                final Object value = values.remove("Cashdiscountamount");
                if( (value == null) || (!value.equals(getCashdiscountamount())) ) {
                    setCashdiscountamount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Accountingdocumenttype") ) {
                final Object value = values.remove("Accountingdocumenttype");
                if( (value == null) || (!value.equals(getAccountingdocumenttype())) ) {
                    setAccountingdocumenttype(((String) value));
                }
            }
            if( values.containsKey("Postingdate") ) {
                final Object value = values.remove("Postingdate");
                if( (value == null) || (!value.equals(getPostingdate())) ) {
                    setPostingdate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Documentdate") ) {
                final Object value = values.remove("Documentdate");
                if( (value == null) || (!value.equals(getDocumentdate())) ) {
                    setDocumentdate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Financialaccounttype") ) {
                final Object value = values.remove("Financialaccounttype");
                if( (value == null) || (!value.equals(getFinancialaccounttype())) ) {
                    setFinancialaccounttype(((String) value));
                }
            }
            if( values.containsKey("Postingkey") ) {
                final Object value = values.remove("Postingkey");
                if( (value == null) || (!value.equals(getPostingkey())) ) {
                    setPostingkey(((String) value));
                }
            }
            if( values.containsKey("Glaccount") ) {
                final Object value = values.remove("Glaccount");
                if( (value == null) || (!value.equals(getGlaccount())) ) {
                    setGlaccount(((String) value));
                }
            }
            if( values.containsKey("Operationalglaccount") ) {
                final Object value = values.remove("Operationalglaccount");
                if( (value == null) || (!value.equals(getOperationalglaccount())) ) {
                    setOperationalglaccount(((String) value));
                }
            }
            if( values.containsKey("Specialglcode") ) {
                final Object value = values.remove("Specialglcode");
                if( (value == null) || (!value.equals(getSpecialglcode())) ) {
                    setSpecialglcode(((String) value));
                }
            }
            if( values.containsKey("Businessarea") ) {
                final Object value = values.remove("Businessarea");
                if( (value == null) || (!value.equals(getBusinessarea())) ) {
                    setBusinessarea(((String) value));
                }
            }
            if( values.containsKey("Taxcode") ) {
                final Object value = values.remove("Taxcode");
                if( (value == null) || (!value.equals(getTaxcode())) ) {
                    setTaxcode(((String) value));
                }
            }
            if( values.containsKey("Withholdingtaxcode") ) {
                final Object value = values.remove("Withholdingtaxcode");
                if( (value == null) || (!value.equals(getWithholdingtaxcode())) ) {
                    setWithholdingtaxcode(((String) value));
                }
            }
            if( values.containsKey("Documentitemtext") ) {
                final Object value = values.remove("Documentitemtext");
                if( (value == null) || (!value.equals(getDocumentitemtext())) ) {
                    setDocumentitemtext(((String) value));
                }
            }
            if( values.containsKey("Duecalculationbasedate") ) {
                final Object value = values.remove("Duecalculationbasedate");
                if( (value == null) || (!value.equals(getDuecalculationbasedate())) ) {
                    setDuecalculationbasedate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Cashdiscount1days") ) {
                final Object value = values.remove("Cashdiscount1days");
                if( (value == null) || (!value.equals(getCashdiscount1days())) ) {
                    setCashdiscount1days(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscount2days") ) {
                final Object value = values.remove("Cashdiscount2days");
                if( (value == null) || (!value.equals(getCashdiscount2days())) ) {
                    setCashdiscount2days(((BigDecimal) value));
                }
            }
            if( values.containsKey("Netpaymentdays") ) {
                final Object value = values.remove("Netpaymentdays");
                if( (value == null) || (!value.equals(getNetpaymentdays())) ) {
                    setNetpaymentdays(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscount1percent") ) {
                final Object value = values.remove("Cashdiscount1percent");
                if( (value == null) || (!value.equals(getCashdiscount1percent())) ) {
                    setCashdiscount1percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("Cashdiscount2percent") ) {
                final Object value = values.remove("Cashdiscount2percent");
                if( (value == null) || (!value.equals(getCashdiscount2percent())) ) {
                    setCashdiscount2percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("Purchasingdocument") ) {
                final Object value = values.remove("Purchasingdocument");
                if( (value == null) || (!value.equals(getPurchasingdocument())) ) {
                    setPurchasingdocument(((String) value));
                }
            }
            if( values.containsKey("Purchasingdocumentitem") ) {
                final Object value = values.remove("Purchasingdocumentitem");
                if( (value == null) || (!value.equals(getPurchasingdocumentitem())) ) {
                    setPurchasingdocumentitem(((String) value));
                }
            }
            if( values.containsKey("Vatregistration") ) {
                final Object value = values.remove("Vatregistration");
                if( (value == null) || (!value.equals(getVatregistration())) ) {
                    setVatregistration(((String) value));
                }
            }
            if( values.containsKey("Statecentralbankpaymentreason") ) {
                final Object value = values.remove("Statecentralbankpaymentreason");
                if( (value == null) || (!value.equals(getStatecentralbankpaymentreason())) ) {
                    setStatecentralbankpaymentreason(((String) value));
                }
            }
            if( values.containsKey("Supplyingcountry") ) {
                final Object value = values.remove("Supplyingcountry");
                if( (value == null) || (!value.equals(getSupplyingcountry())) ) {
                    setSupplyingcountry(((String) value));
                }
            }
            if( values.containsKey("Projectnetwork") ) {
                final Object value = values.remove("Projectnetwork");
                if( (value == null) || (!value.equals(getProjectnetwork())) ) {
                    setProjectnetwork(((String) value));
                }
            }
            if( values.containsKey("Orderinternalbillofoperations") ) {
                final Object value = values.remove("Orderinternalbillofoperations");
                if( (value == null) || (!value.equals(getOrderinternalbillofoperations())) ) {
                    setOrderinternalbillofoperations(((String) value));
                }
            }
            if( values.containsKey("Assignmentreference") ) {
                final Object value = values.remove("Assignmentreference");
                if( (value == null) || (!value.equals(getAssignmentreference())) ) {
                    setAssignmentreference(((String) value));
                }
            }
            if( values.containsKey("Assetcontract") ) {
                final Object value = values.remove("Assetcontract");
                if( (value == null) || (!value.equals(getAssetcontract())) ) {
                    setAssetcontract(((String) value));
                }
            }
            if( values.containsKey("Followondocumenttype") ) {
                final Object value = values.remove("Followondocumenttype");
                if( (value == null) || (!value.equals(getFollowondocumenttype())) ) {
                    setFollowondocumenttype(((String) value));
                }
            }
            if( values.containsKey("Costcenter") ) {
                final Object value = values.remove("Costcenter");
                if( (value == null) || (!value.equals(getCostcenter())) ) {
                    setCostcenter(((String) value));
                }
            }
            if( values.containsKey("Salesdocument") ) {
                final Object value = values.remove("Salesdocument");
                if( (value == null) || (!value.equals(getSalesdocument())) ) {
                    setSalesdocument(((String) value));
                }
            }
            if( values.containsKey("Salesdocumentitem") ) {
                final Object value = values.remove("Salesdocumentitem");
                if( (value == null) || (!value.equals(getSalesdocumentitem())) ) {
                    setSalesdocumentitem(((String) value));
                }
            }
            if( values.containsKey("Profitcenter") ) {
                final Object value = values.remove("Profitcenter");
                if( (value == null) || (!value.equals(getProfitcenter())) ) {
                    setProfitcenter(((String) value));
                }
            }
            if( values.containsKey("Reference1idbybusinesspartner") ) {
                final Object value = values.remove("Reference1idbybusinesspartner");
                if( (value == null) || (!value.equals(getReference1idbybusinesspartner())) ) {
                    setReference1idbybusinesspartner(((String) value));
                }
            }
            if( values.containsKey("Reference2idbybusinesspartner") ) {
                final Object value = values.remove("Reference2idbybusinesspartner");
                if( (value == null) || (!value.equals(getReference2idbybusinesspartner())) ) {
                    setReference2idbybusinesspartner(((String) value));
                }
            }
            if( values.containsKey("Reference3idbybusinesspartner") ) {
                final Object value = values.remove("Reference3idbybusinesspartner");
                if( (value == null) || (!value.equals(getReference3idbybusinesspartner())) ) {
                    setReference3idbybusinesspartner(((String) value));
                }
            }
            if( values.containsKey("Dataexchangeinstruction1") ) {
                final Object value = values.remove("Dataexchangeinstruction1");
                if( (value == null) || (!value.equals(getDataexchangeinstruction1())) ) {
                    setDataexchangeinstruction1(((String) value));
                }
            }
            if( values.containsKey("Dataexchangeinstruction2") ) {
                final Object value = values.remove("Dataexchangeinstruction2");
                if( (value == null) || (!value.equals(getDataexchangeinstruction2())) ) {
                    setDataexchangeinstruction2(((String) value));
                }
            }
            if( values.containsKey("Dataexchangeinstruction3") ) {
                final Object value = values.remove("Dataexchangeinstruction3");
                if( (value == null) || (!value.equals(getDataexchangeinstruction3())) ) {
                    setDataexchangeinstruction3(((String) value));
                }
            }
            if( values.containsKey("Dataexchangeinstruction4") ) {
                final Object value = values.remove("Dataexchangeinstruction4");
                if( (value == null) || (!value.equals(getDataexchangeinstruction4())) ) {
                    setDataexchangeinstruction4(((String) value));
                }
            }
            if( values.containsKey("Addressandbankissetmanually") ) {
                final Object value = values.remove("Addressandbankissetmanually");
                if( (value == null) || (!value.equals(getAddressandbankissetmanually())) ) {
                    setAddressandbankissetmanually(((Boolean) value));
                }
            }
            if( values.containsKey("Businessplace") ) {
                final Object value = values.remove("Businessplace");
                if( (value == null) || (!value.equals(getBusinessplace())) ) {
                    setBusinessplace(((String) value));
                }
            }
            if( values.containsKey("Partnerprofitcenter") ) {
                final Object value = values.remove("Partnerprofitcenter");
                if( (value == null) || (!value.equals(getPartnerprofitcenter())) ) {
                    setPartnerprofitcenter(((String) value));
                }
            }
            if( values.containsKey("Grantid") ) {
                final Object value = values.remove("Grantid");
                if( (value == null) || (!value.equals(getGrantid())) ) {
                    setGrantid(((String) value));
                }
            }
            if( values.containsKey("Functionalarea") ) {
                final Object value = values.remove("Functionalarea");
                if( (value == null) || (!value.equals(getFunctionalarea())) ) {
                    setFunctionalarea(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("Paymentrequest") ) {
                final Object value = values.remove("Paymentrequest");
                if( (value == null) || (!value.equals(getPaymentrequest())) ) {
                    setPaymentrequest(((String) value));
                }
            }
            if( values.containsKey("Paymentrequestamountinpaytcrcy") ) {
                final Object value = values.remove("Paymentrequestamountinpaytcrcy");
                if( (value == null) || (!value.equals(getPaymentrequestamountinpaytcrcy())) ) {
                    setPaymentrequestamountinpaytcrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("Paymentrequestorigin") ) {
                final Object value = values.remove("Paymentrequestorigin");
                if( (value == null) || (!value.equals(getPaymentrequestorigin())) ) {
                    setPaymentrequestorigin(((String) value));
                }
            }
            if( values.containsKey("Currentprocessor") ) {
                final Object value = values.remove("Currentprocessor");
                if( (value == null) || (!value.equals(getCurrentprocessor())) ) {
                    setCurrentprocessor(((String) value));
                }
            }
            if( values.containsKey("Earmarkedfundsdocument") ) {
                final Object value = values.remove("Earmarkedfundsdocument");
                if( (value == null) || (!value.equals(getEarmarkedfundsdocument())) ) {
                    setEarmarkedfundsdocument(((String) value));
                }
            }
            if( values.containsKey("Taxid2") ) {
                final Object value = values.remove("Taxid2");
                if( (value == null) || (!value.equals(getTaxid2())) ) {
                    setTaxid2(((String) value));
                }
            }
            if( values.containsKey("Paymentrunitemmessagenumber") ) {
                final Object value = values.remove("Paymentrunitemmessagenumber");
                if( (value == null) || (!value.equals(getPaymentrunitemmessagenumber())) ) {
                    setPaymentrunitemmessagenumber(((String) value));
                }
            }
            if( values.containsKey("Paymentblockingreason") ) {
                final Object value = values.remove("Paymentblockingreason");
                if( (value == null) || (!value.equals(getPaymentblockingreason())) ) {
                    setPaymentblockingreason(((String) value));
                }
            }
            if( values.containsKey("Paymentrundate") ) {
                final Object value = values.remove("Paymentrundate");
                if( (value == null) || (!value.equals(getPaymentrundate())) ) {
                    setPaymentrundate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Paymentrunid") ) {
                final Object value = values.remove("Paymentrunid");
                if( (value == null) || (!value.equals(getPaymentrunid())) ) {
                    setPaymentrunid(((String) value));
                }
            }
            if( values.containsKey("Paymentdocument") ) {
                final Object value = values.remove("Paymentdocument");
                if( (value == null) || (!value.equals(getPaymentdocument())) ) {
                    setPaymentdocument(((String) value));
                }
            }
            if( values.containsKey("Paymentorder") ) {
                final Object value = values.remove("Paymentorder");
                if( (value == null) || (!value.equals(getPaymentorder())) ) {
                    setPaymentorder(((String) value));
                }
            }
            if( values.containsKey("Proposalrundate") ) {
                final Object value = values.remove("Proposalrundate");
                if( (value == null) || (!value.equals(getProposalrundate())) ) {
                    setProposalrundate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Proposalrunnumber") ) {
                final Object value = values.remove("Proposalrunnumber");
                if( (value == null) || (!value.equals(getProposalrunnumber())) ) {
                    setProposalrunnumber(((String) value));
                }
            }
            if( values.containsKey("Payingcompanycode") ) {
                final Object value = values.remove("Payingcompanycode");
                if( (value == null) || (!value.equals(getPayingcompanycode())) ) {
                    setPayingcompanycode(((String) value));
                }
            }
            if( values.containsKey("Sendingcompanycode") ) {
                final Object value = values.remove("Sendingcompanycode");
                if( (value == null) || (!value.equals(getSendingcompanycode())) ) {
                    setSendingcompanycode(((String) value));
                }
            }
            if( values.containsKey("Payeeadditionalname") ) {
                final Object value = values.remove("Payeeadditionalname");
                if( (value == null) || (!value.equals(getPayeeadditionalname())) ) {
                    setPayeeadditionalname(((String) value));
                }
            }
            if( values.containsKey("Payeepostalcode") ) {
                final Object value = values.remove("Payeepostalcode");
                if( (value == null) || (!value.equals(getPayeepostalcode())) ) {
                    setPayeepostalcode(((String) value));
                }
            }
            if( values.containsKey("Payeecityname") ) {
                final Object value = values.remove("Payeecityname");
                if( (value == null) || (!value.equals(getPayeecityname())) ) {
                    setPayeecityname(((String) value));
                }
            }
            if( values.containsKey("Payeecountry") ) {
                final Object value = values.remove("Payeecountry");
                if( (value == null) || (!value.equals(getPayeecountry())) ) {
                    setPayeecountry(((String) value));
                }
            }
            if( values.containsKey("Payeeregion") ) {
                final Object value = values.remove("Payeeregion");
                if( (value == null) || (!value.equals(getPayeeregion())) ) {
                    setPayeeregion(((String) value));
                }
            }
            if( values.containsKey("Payeelanguage") ) {
                final Object value = values.remove("Payeelanguage");
                if( (value == null) || (!value.equals(getPayeelanguage())) ) {
                    setPayeelanguage(((String) value));
                }
            }
            if( values.containsKey("Name") ) {
                final Object value = values.remove("Name");
                if( (value == null) || (!value.equals(getName())) ) {
                    setName(((String) value));
                }
            }
            if( values.containsKey("Payeebankcountry") ) {
                final Object value = values.remove("Payeebankcountry");
                if( (value == null) || (!value.equals(getPayeebankcountry())) ) {
                    setPayeebankcountry(((String) value));
                }
            }
            if( values.containsKey("Payeebank") ) {
                final Object value = values.remove("Payeebank");
                if( (value == null) || (!value.equals(getPayeebank())) ) {
                    setPayeebank(((String) value));
                }
            }
            if( values.containsKey("Payeebanknumber") ) {
                final Object value = values.remove("Payeebanknumber");
                if( (value == null) || (!value.equals(getPayeebanknumber())) ) {
                    setPayeebanknumber(((String) value));
                }
            }
            if( values.containsKey("Payeebankaccount") ) {
                final Object value = values.remove("Payeebankaccount");
                if( (value == null) || (!value.equals(getPayeebankaccount())) ) {
                    setPayeebankaccount(((String) value));
                }
            }
            if( values.containsKey("Payeebankcontrolkey") ) {
                final Object value = values.remove("Payeebankcontrolkey");
                if( (value == null) || (!value.equals(getPayeebankcontrolkey())) ) {
                    setPayeebankcontrolkey(((String) value));
                }
            }
            if( values.containsKey("Bankdetailreference") ) {
                final Object value = values.remove("Bankdetailreference");
                if( (value == null) || (!value.equals(getBankdetailreference())) ) {
                    setBankdetailreference(((String) value));
                }
            }
            if( values.containsKey("Payeebankidentifiercode") ) {
                final Object value = values.remove("Payeebankidentifiercode");
                if( (value == null) || (!value.equals(getPayeebankidentifiercode())) ) {
                    setPayeebankidentifiercode(((String) value));
                }
            }
            if( values.containsKey("Payeeiban") ) {
                final Object value = values.remove("Payeeiban");
                if( (value == null) || (!value.equals(getPayeeiban())) ) {
                    setPayeeiban(((String) value));
                }
            }
            if( values.containsKey("Bankaccountholdername") ) {
                final Object value = values.remove("Bankaccountholdername");
                if( (value == null) || (!value.equals(getBankaccountholdername())) ) {
                    setBankaccountholdername(((String) value));
                }
            }
            if( values.containsKey("Housebankaccount") ) {
                final Object value = values.remove("Housebankaccount");
                if( (value == null) || (!value.equals(getHousebankaccount())) ) {
                    setHousebankaccount(((String) value));
                }
            }
            if( values.containsKey("Housebank") ) {
                final Object value = values.remove("Housebank");
                if( (value == null) || (!value.equals(getHousebank())) ) {
                    setHousebank(((String) value));
                }
            }
            if( values.containsKey("Bankcountry") ) {
                final Object value = values.remove("Bankcountry");
                if( (value == null) || (!value.equals(getBankcountry())) ) {
                    setBankcountry(((String) value));
                }
            }
            if( values.containsKey("Bank") ) {
                final Object value = values.remove("Bank");
                if( (value == null) || (!value.equals(getBank())) ) {
                    setBank(((String) value));
                }
            }
            if( values.containsKey("Banknumber") ) {
                final Object value = values.remove("Banknumber");
                if( (value == null) || (!value.equals(getBanknumber())) ) {
                    setBanknumber(((String) value));
                }
            }
            if( values.containsKey("Bankaccount") ) {
                final Object value = values.remove("Bankaccount");
                if( (value == null) || (!value.equals(getBankaccount())) ) {
                    setBankaccount(((String) value));
                }
            }
            if( values.containsKey("Bankcontrolkey") ) {
                final Object value = values.remove("Bankcontrolkey");
                if( (value == null) || (!value.equals(getBankcontrolkey())) ) {
                    setBankcontrolkey(((String) value));
                }
            }
            if( values.containsKey("Glaccountforbankaccount") ) {
                final Object value = values.remove("Glaccountforbankaccount");
                if( (value == null) || (!value.equals(getGlaccountforbankaccount())) ) {
                    setGlaccountforbankaccount(((String) value));
                }
            }
            if( values.containsKey("Supplierpaymentmethod") ) {
                final Object value = values.remove("Supplierpaymentmethod");
                if( (value == null) || (!value.equals(getSupplierpaymentmethod())) ) {
                    setSupplierpaymentmethod(((String) value));
                }
            }
            if( values.containsKey("Paymentmethodsupplement") ) {
                final Object value = values.remove("Paymentmethodsupplement");
                if( (value == null) || (!value.equals(getPaymentmethodsupplement())) ) {
                    setPaymentmethodsupplement(((String) value));
                }
            }
            if( values.containsKey("Dataexchangeinstructionkey") ) {
                final Object value = values.remove("Dataexchangeinstructionkey");
                if( (value == null) || (!value.equals(getDataexchangeinstructionkey())) ) {
                    setDataexchangeinstructionkey(((String) value));
                }
            }
            if( values.containsKey("Paymentdocumentpostingdate") ) {
                final Object value = values.remove("Paymentdocumentpostingdate");
                if( (value == null) || (!value.equals(getPaymentdocumentpostingdate())) ) {
                    setPaymentdocumentpostingdate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Valuedate") ) {
                final Object value = values.remove("Valuedate");
                if( (value == null) || (!value.equals(getValuedate())) ) {
                    setValuedate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Paiditemduedate") ) {
                final Object value = values.remove("Paiditemduedate");
                if( (value == null) || (!value.equals(getPaiditemduedate())) ) {
                    setPaiditemduedate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Billofexchangeduedate") ) {
                final Object value = values.remove("Billofexchangeduedate");
                if( (value == null) || (!value.equals(getBillofexchangeduedate())) ) {
                    setBillofexchangeduedate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Billofexchangeissuedate") ) {
                final Object value = values.remove("Billofexchangeissuedate");
                if( (value == null) || (!value.equals(getBillofexchangeissuedate())) ) {
                    setBillofexchangeissuedate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Accountingclerk") ) {
                final Object value = values.remove("Accountingclerk");
                if( (value == null) || (!value.equals(getAccountingclerk())) ) {
                    setAccountingclerk(((String) value));
                }
            }
            if( values.containsKey("Accountbyshipper") ) {
                final Object value = values.remove("Accountbyshipper");
                if( (value == null) || (!value.equals(getAccountbyshipper())) ) {
                    setAccountbyshipper(((String) value));
                }
            }
            if( values.containsKey("Paymentreference") ) {
                final Object value = values.remove("Paymentreference");
                if( (value == null) || (!value.equals(getPaymentreference())) ) {
                    setPaymentreference(((String) value));
                }
            }
            if( values.containsKey("Sepamandateuuid") ) {
                final Object value = values.remove("Sepamandateuuid");
                if( (value == null) || (!value.equals(getSepamandateuuid())) ) {
                    setSepamandateuuid(((byte[]) value));
                }
            }
            if( values.containsKey("Sepamandate") ) {
                final Object value = values.remove("Sepamandate");
                if( (value == null) || (!value.equals(getSepamandate())) ) {
                    setSepamandate(((String) value));
                }
            }
            if( values.containsKey("Invoicereference") ) {
                final Object value = values.remove("Invoicereference");
                if( (value == null) || (!value.equals(getInvoicereference())) ) {
                    setInvoicereference(((String) value));
                }
            }
            if( values.containsKey("Invoicereferencefiscalyear") ) {
                final Object value = values.remove("Invoicereferencefiscalyear");
                if( (value == null) || (!value.equals(getInvoicereferencefiscalyear())) ) {
                    setInvoicereferencefiscalyear(((String) value));
                }
            }
            if( values.containsKey("Invoiceitemreference") ) {
                final Object value = values.remove("Invoiceitemreference");
                if( (value == null) || (!value.equals(getInvoiceitemreference())) ) {
                    setInvoiceitemreference(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PaymentReleaseListItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PaymentReleaseListItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PaymentReleaseListItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PaymentReleaseListItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService.DEFAULT_SERVICE_PATH);
    }

}
