/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable.PaymentReleaseListItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem PaymentReleaseListItem}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class PaymentReleaseListItemByKeyFluentHelper
    extends
    FluentHelperByKey<PaymentReleaseListItemByKeyFluentHelper, PaymentReleaseListItem, PaymentReleaseListItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem
     * PaymentReleaseListItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PaymentReleaseListItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PaymentReleaseListItem}
     * @param paymentreleaselistitemuuid
     *            UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public PaymentReleaseListItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID paymentreleaselistitemuuid )
    {
        super(servicePath, entityCollection);
        this.key.put("Paymentreleaselistitemuuid", paymentreleaselistitemuuid);
    }

    @Override
    @Nonnull
    protected Class<PaymentReleaseListItem> getEntityClass()
    {
        return PaymentReleaseListItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
