/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable.PaymentReleaseListItemSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem PaymentReleaseListItem}
 * entities. This fluent helper allows methods which modify the underlying query to be called before executing the query
 * itself.
 *
 */
public class PaymentReleaseListItemFluentHelper
    extends
    FluentHelperRead<PaymentReleaseListItemFluentHelper, PaymentReleaseListItem, PaymentReleaseListItemSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public PaymentReleaseListItemFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<PaymentReleaseListItem> getEntityClass()
    {
        return PaymentReleaseListItem.class;
    }

}
