/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PaymentItemServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService PaymentItemService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPaymentItemServiceBatch
    extends
    BatchFluentHelperBasic<PaymentItemServiceBatch, PaymentItemServiceBatchChangeSet>
    implements
    PaymentItemServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPaymentItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPaymentItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPaymentItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPaymentItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPaymentItemServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PaymentItemServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPaymentItemServiceBatchChangeSet(this, service);
    }

}
