/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem;

/**
 * Implementation of the {@link PaymentItemServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService PaymentItemService}.
 *
 */
public class DefaultPaymentItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PaymentItemServiceBatch, PaymentItemServiceBatchChangeSet>
    implements
    PaymentItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultPaymentItemServiceBatchChangeSet(
        @Nonnull final DefaultPaymentItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPaymentItemServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PaymentItemServiceBatchChangeSet updatePaymentReleaseListItem(
        @Nonnull final PaymentReleaseListItem paymentReleaseListItem )
    {
        return addRequestUpdate(service::updatePaymentReleaseListItem, paymentReleaseListItem);
    }

}
