/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentItemService PaymentItemService}.
 *
 */
public interface PaymentItemServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PaymentItemServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PaymentItemServiceBatch>
{

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem
     * PaymentReleaseListItem} entity and save it to the S/4HANA system.
     *
     * @param paymentReleaseListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem
     *            PaymentReleaseListItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PaymentItemServiceBatchChangeSet
        updatePaymentReleaseListItem( @Nonnull final PaymentReleaseListItem paymentReleaseListItem );

}
