/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader
 * PaymentReleaseListHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.field.PaymentReleaseListHeaderField
 * PaymentReleaseListHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.link.PaymentReleaseListHeaderLink
 * PaymentReleaseListHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#PAYMENTRELEASELIST
 * PAYMENTRELEASELIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#TOTACTUALAMTINDISPLAYCURRENCY
 * TOTACTUALAMTINDISPLAYCURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#CREATEDBYUSERFULLNAME
 * CREATEDBYUSERFULLNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#INCGPAYTFILETOTALNUMBEROFITEMS
 * INCGPAYTFILETOTALNUMBEROFITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#CREATEDBYUSER
 * CREATEDBYUSER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#COMPANYCODE
 * COMPANYCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListHeader#TO_PAYMENT_RELEASE_LIST_HEADERTO_ITEM
 * TO_PAYMENT_RELEASE_LIST_HEADERTO_ITEM}</li>
 * </ul>
 *
 */
public interface PaymentReleaseListHeaderSelectable extends EntitySelectable<PaymentReleaseListHeader>
{

}
