/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem
 * PaymentReleaseListItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.field.PaymentReleaseListItemField
 * PaymentReleaseListItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.link.PaymentReleaseListItemLink
 * PaymentReleaseListItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRELEASELISTITEMUUID
 * PAYMENTRELEASELISTITEMUUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRELEASELIST
 * PAYMENTRELEASELIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTSTATUS
 * PAYMENTSTATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYTRELLISTITEMAPPROVALLEVEL
 * PAYTRELLISTITEMAPPROVALLEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CREATEDBYUSER
 * CREATEDBYUSER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#LASTCHANGEDBYUSER
 * LASTCHANGEDBYUSER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRELEASELISTAPPLICATION
 * PAYMENTRELEASELISTAPPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#COMPANYCODE
 * COMPANYCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ACCOUNTINGDOCUMENT
 * ACCOUNTINGDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#FISCALYEAR
 * FISCALYEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ACCOUNTINGDOCUMENTITEM
 * ACCOUNTINGDOCUMENTITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SUPPLIERFULLNAME
 * SUPPLIERFULLNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BRANCHACCOUNT
 * BRANCHACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYERPAYEE
 * PAYERPAYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PARTNERCOMPANY
 * PARTNERCOMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DEBITCREDITCODE
 * DEBITCREDITCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#TRANSACTIONCURRENCY
 * TRANSACTIONCURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#AMOUNTINTRANSACTIONCURRENCY
 * AMOUNTINTRANSACTIONCURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNTBASEAMOUNT
 * CASHDISCOUNTBASEAMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNTAMTINTRANSACCRCY
 * CASHDISCOUNTAMTINTRANSACCRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#WHLDGTAXAMTINTRANSACCRCY
 * WHLDGTAXAMTINTRANSACCRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BALANCETRANSACTIONCURRENCY
 * BALANCETRANSACTIONCURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#AMOUNTINBALANCETRANSACCRCY
 * AMOUNTINBALANCETRANSACCRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNTAMOUNT
 * CASHDISCOUNTAMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ACCOUNTINGDOCUMENTTYPE
 * ACCOUNTINGDOCUMENTTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#POSTINGDATE
 * POSTINGDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DOCUMENTDATE
 * DOCUMENTDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#FINANCIALACCOUNTTYPE
 * FINANCIALACCOUNTTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#POSTINGKEY
 * POSTINGKEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#GLACCOUNT
 * GLACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#OPERATIONALGLACCOUNT
 * OPERATIONALGLACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SPECIALGLCODE
 * SPECIALGLCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BUSINESSAREA
 * BUSINESSAREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#TAXCODE
 * TAXCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#WITHHOLDINGTAXCODE
 * WITHHOLDINGTAXCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DOCUMENTITEMTEXT
 * DOCUMENTITEMTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DUECALCULATIONBASEDATE
 * DUECALCULATIONBASEDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNT1DAYS
 * CASHDISCOUNT1DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNT2DAYS
 * CASHDISCOUNT2DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#NETPAYMENTDAYS
 * NETPAYMENTDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNT1PERCENT
 * CASHDISCOUNT1PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CASHDISCOUNT2PERCENT
 * CASHDISCOUNT2PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PURCHASINGDOCUMENT
 * PURCHASINGDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PURCHASINGDOCUMENTITEM
 * PURCHASINGDOCUMENTITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#VATREGISTRATION
 * VATREGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#STATECENTRALBANKPAYMENTREASON
 * STATECENTRALBANKPAYMENTREASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SUPPLYINGCOUNTRY
 * SUPPLYINGCOUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PROJECTNETWORK
 * PROJECTNETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ORDERINTERNALBILLOFOPERATIONS
 * ORDERINTERNALBILLOFOPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ASSIGNMENTREFERENCE
 * ASSIGNMENTREFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ASSETCONTRACT
 * ASSETCONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#FOLLOWONDOCUMENTTYPE
 * FOLLOWONDOCUMENTTYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#COSTCENTER
 * COSTCENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SALESDOCUMENT
 * SALESDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SALESDOCUMENTITEM
 * SALESDOCUMENTITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PROFITCENTER
 * PROFITCENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#REFERENCE1IDBYBUSINESSPARTNER
 * REFERENCE1IDBYBUSINESSPARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#REFERENCE2IDBYBUSINESSPARTNER
 * REFERENCE2IDBYBUSINESSPARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#REFERENCE3IDBYBUSINESSPARTNER
 * REFERENCE3IDBYBUSINESSPARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DATAEXCHANGEINSTRUCTION1
 * DATAEXCHANGEINSTRUCTION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DATAEXCHANGEINSTRUCTION2
 * DATAEXCHANGEINSTRUCTION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DATAEXCHANGEINSTRUCTION3
 * DATAEXCHANGEINSTRUCTION3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DATAEXCHANGEINSTRUCTION4
 * DATAEXCHANGEINSTRUCTION4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ADDRESSANDBANKISSETMANUALLY
 * ADDRESSANDBANKISSETMANUALLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BUSINESSPLACE
 * BUSINESSPLACE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PARTNERPROFITCENTER
 * PARTNERPROFITCENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#GRANTID
 * GRANTID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#FUNCTIONALAREA
 * FUNCTIONALAREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTREQUEST
 * PAYMENTREQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTREQUESTAMOUNTINPAYTCRCY
 * PAYMENTREQUESTAMOUNTINPAYTCRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTREQUESTORIGIN
 * PAYMENTREQUESTORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#CURRENTPROCESSOR
 * CURRENTPROCESSOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#EARMARKEDFUNDSDOCUMENT
 * EARMARKEDFUNDSDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#TAXID2 TAXID2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRUNITEMMESSAGENUMBER
 * PAYMENTRUNITEMMESSAGENUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTBLOCKINGREASON
 * PAYMENTBLOCKINGREASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRUNDATE
 * PAYMENTRUNDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTRUNID
 * PAYMENTRUNID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTDOCUMENT
 * PAYMENTDOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTORDER
 * PAYMENTORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PROPOSALRUNDATE
 * PROPOSALRUNDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PROPOSALRUNNUMBER
 * PROPOSALRUNNUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYINGCOMPANYCODE
 * PAYINGCOMPANYCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SENDINGCOMPANYCODE
 * SENDINGCOMPANYCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEADDITIONALNAME
 * PAYEEADDITIONALNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEPOSTALCODE
 * PAYEEPOSTALCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEECITYNAME
 * PAYEECITYNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEECOUNTRY
 * PAYEECOUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEREGION
 * PAYEEREGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEELANGUAGE
 * PAYEELANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#NAME NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANKCOUNTRY
 * PAYEEBANKCOUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANK
 * PAYEEBANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANKNUMBER
 * PAYEEBANKNUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANKACCOUNT
 * PAYEEBANKACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANKCONTROLKEY
 * PAYEEBANKCONTROLKEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKDETAILREFERENCE
 * BANKDETAILREFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEBANKIDENTIFIERCODE
 * PAYEEBANKIDENTIFIERCODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYEEIBAN
 * PAYEEIBAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKACCOUNTHOLDERNAME
 * BANKACCOUNTHOLDERNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#HOUSEBANKACCOUNT
 * HOUSEBANKACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#HOUSEBANK
 * HOUSEBANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKCOUNTRY
 * BANKCOUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANK BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKNUMBER
 * BANKNUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKACCOUNT
 * BANKACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BANKCONTROLKEY
 * BANKCONTROLKEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#GLACCOUNTFORBANKACCOUNT
 * GLACCOUNTFORBANKACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SUPPLIERPAYMENTMETHOD
 * SUPPLIERPAYMENTMETHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTMETHODSUPPLEMENT
 * PAYMENTMETHODSUPPLEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#DATAEXCHANGEINSTRUCTIONKEY
 * DATAEXCHANGEINSTRUCTIONKEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTDOCUMENTPOSTINGDATE
 * PAYMENTDOCUMENTPOSTINGDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#VALUEDATE
 * VALUEDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAIDITEMDUEDATE
 * PAIDITEMDUEDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BILLOFEXCHANGEDUEDATE
 * BILLOFEXCHANGEDUEDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#BILLOFEXCHANGEISSUEDATE
 * BILLOFEXCHANGEISSUEDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ACCOUNTINGCLERK
 * ACCOUNTINGCLERK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#ACCOUNTBYSHIPPER
 * ACCOUNTBYSHIPPER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#PAYMENTREFERENCE
 * PAYMENTREFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SEPAMANDATEUUID
 * SEPAMANDATEUUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#SEPAMANDATE
 * SEPAMANDATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#INVOICEREFERENCE
 * INVOICEREFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#INVOICEREFERENCEFISCALYEAR
 * INVOICEREFERENCEFISCALYEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentitem.PaymentReleaseListItem#INVOICEITEMREFERENCE
 * INVOICEITEMREFERENCE}</li>
 * </ul>
 *
 */
public interface PaymentReleaseListItemSelectable extends EntitySelectable<PaymentReleaseListItem>
{

}
