/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.field.PaymentMethodValidationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.selectable.PaymentMethodValidationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>PaymentMethodValidation</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PaymentMethodValidation extends VdmEntity<PaymentMethodValidation>
{

    /**
     * Selector for all available fields of PaymentMethodValidation.
     *
     */
    public final static PaymentMethodValidationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ISOCountryCodeForBank</b>
     * </p>
     *
     * @return ISO Code
     */
    @Key
    @SerializedName( "ISOCountryCodeForBank" )
    @JsonProperty( "ISOCountryCodeForBank" )
    @Nullable
    @ODataField( odataName = "ISOCountryCodeForBank" )
    private String iSOCountryCodeForBank;
    /**
     * Use with available fluent helpers to apply the <b>ISOCountryCodeForBank</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> ISO_COUNTRY_CODE_FOR_BANK =
        new PaymentMethodValidationField<String>("ISOCountryCodeForBank");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodInEC</b>
     * </p>
     *
     * @return SF Payment Method
     */
    @Key
    @SerializedName( "PaymentMethodInEC" )
    @JsonProperty( "PaymentMethodInEC" )
    @Nullable
    @ODataField( odataName = "PaymentMethodInEC" )
    private String paymentMethodInEC;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethodInEC</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> PAYMENT_METHOD_IN_EC =
        new PaymentMethodValidationField<String>("PaymentMethodInEC");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> COMPANY_CODE =
        new PaymentMethodValidationField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IBANExists</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @Key
    @SerializedName( "IBANExists" )
    @JsonProperty( "IBANExists" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IBANExists" )
    private Boolean iBANExists;
    /**
     * Use with available fluent helpers to apply the <b>IBANExists</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<Boolean> IBAN_EXISTS =
        new PaymentMethodValidationField<Boolean>("IBANExists");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SwiftExists</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @Key
    @SerializedName( "SwiftExists" )
    @JsonProperty( "SwiftExists" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SwiftExists" )
    private Boolean swiftExists;
    /**
     * Use with available fluent helpers to apply the <b>SwiftExists</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<Boolean> SWIFT_EXISTS =
        new PaymentMethodValidationField<Boolean>("SwiftExists");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BankAccountNumberExists</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @Key
    @SerializedName( "BankAccountNumberExists" )
    @JsonProperty( "BankAccountNumberExists" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BankAccountNumberExists" )
    private Boolean bankAccountNumberExists;
    /**
     * Use with available fluent helpers to apply the <b>BankAccountNumberExists</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<Boolean> BANK_ACCOUNT_NUMBER_EXISTS =
        new PaymentMethodValidationField<Boolean>("BankAccountNumberExists");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ISOEmployeeCountryCode</b>
     * </p>
     *
     * @return ISO Code
     */
    @Key
    @SerializedName( "ISOEmployeeCountryCode" )
    @JsonProperty( "ISOEmployeeCountryCode" )
    @Nullable
    @ODataField( odataName = "ISOEmployeeCountryCode" )
    private String iSOEmployeeCountryCode;
    /**
     * Use with available fluent helpers to apply the <b>ISOEmployeeCountryCode</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> ISO_EMPLOYEE_COUNTRY_CODE =
        new PaymentMethodValidationField<String>("ISOEmployeeCountryCode");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BankKeyExists</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @Key
    @SerializedName( "BankKeyExists" )
    @JsonProperty( "BankKeyExists" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BankKeyExists" )
    private Boolean bankKeyExists;
    /**
     * Use with available fluent helpers to apply the <b>BankKeyExists</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<Boolean> BANK_KEY_EXISTS =
        new PaymentMethodValidationField<Boolean>("BankKeyExists");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Locale
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> LANGUAGE =
        new PaymentMethodValidationField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Pymt Meth.
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<String> PAYMENT_METHOD =
        new PaymentMethodValidationField<String>("PaymentMethod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsValid</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "IsValid" )
    @JsonProperty( "IsValid" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsValid" )
    private Boolean isValid;
    /**
     * Use with available fluent helpers to apply the <b>IsValid</b> field to query operations.
     *
     */
    public final static PaymentMethodValidationField<Boolean> IS_VALID =
        new PaymentMethodValidationField<Boolean>("IsValid");

    @Nonnull
    @Override
    public Class<PaymentMethodValidation> getType()
    {
        return PaymentMethodValidation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ISOCountryCodeForBank</b>
     * </p>
     *
     * @param iSOCountryCodeForBank
     *            ISO Code
     */
    public void setISOCountryCodeForBank( @Nullable final String iSOCountryCodeForBank )
    {
        rememberChangedField("ISOCountryCodeForBank", this.iSOCountryCodeForBank);
        this.iSOCountryCodeForBank = iSOCountryCodeForBank;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethodInEC</b>
     * </p>
     *
     * @param paymentMethodInEC
     *            SF Payment Method
     */
    public void setPaymentMethodInEC( @Nullable final String paymentMethodInEC )
    {
        rememberChangedField("PaymentMethodInEC", this.paymentMethodInEC);
        this.paymentMethodInEC = paymentMethodInEC;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IBANExists</b>
     * </p>
     *
     * @param iBANExists
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setIBANExists( @Nullable final Boolean iBANExists )
    {
        rememberChangedField("IBANExists", this.iBANExists);
        this.iBANExists = iBANExists;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SwiftExists</b>
     * </p>
     *
     * @param swiftExists
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setSwiftExists( @Nullable final Boolean swiftExists )
    {
        rememberChangedField("SwiftExists", this.swiftExists);
        this.swiftExists = swiftExists;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BankAccountNumberExists</b>
     * </p>
     *
     * @param bankAccountNumberExists
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setBankAccountNumberExists( @Nullable final Boolean bankAccountNumberExists )
    {
        rememberChangedField("BankAccountNumberExists", this.bankAccountNumberExists);
        this.bankAccountNumberExists = bankAccountNumberExists;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ISOEmployeeCountryCode</b>
     * </p>
     *
     * @param iSOEmployeeCountryCode
     *            ISO Code
     */
    public void setISOEmployeeCountryCode( @Nullable final String iSOEmployeeCountryCode )
    {
        rememberChangedField("ISOEmployeeCountryCode", this.iSOEmployeeCountryCode);
        this.iSOEmployeeCountryCode = iSOEmployeeCountryCode;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BankKeyExists</b>
     * </p>
     *
     * @param bankKeyExists
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setBankKeyExists( @Nullable final Boolean bankKeyExists )
    {
        rememberChangedField("BankKeyExists", this.bankKeyExists);
        this.bankKeyExists = bankKeyExists;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Locale
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Pymt Meth.
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsValid</b>
     * </p>
     *
     * @param isValid
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setIsValid( @Nullable final Boolean isValid )
    {
        rememberChangedField("IsValid", this.isValid);
        this.isValid = isValid;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PaymentMethodValidationSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ISOCountryCodeForBank", getISOCountryCodeForBank());
        result.put("PaymentMethodInEC", getPaymentMethodInEC());
        result.put("CompanyCode", getCompanyCode());
        result.put("IBANExists", getIBANExists());
        result.put("SwiftExists", getSwiftExists());
        result.put("BankAccountNumberExists", getBankAccountNumberExists());
        result.put("ISOEmployeeCountryCode", getISOEmployeeCountryCode());
        result.put("BankKeyExists", getBankKeyExists());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ISOCountryCodeForBank", getISOCountryCodeForBank());
        values.put("PaymentMethodInEC", getPaymentMethodInEC());
        values.put("CompanyCode", getCompanyCode());
        values.put("IBANExists", getIBANExists());
        values.put("SwiftExists", getSwiftExists());
        values.put("BankAccountNumberExists", getBankAccountNumberExists());
        values.put("ISOEmployeeCountryCode", getISOEmployeeCountryCode());
        values.put("BankKeyExists", getBankKeyExists());
        values.put("Language", getLanguage());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("IsValid", getIsValid());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ISOCountryCodeForBank") ) {
                final Object value = values.remove("ISOCountryCodeForBank");
                if( (value == null) || (!value.equals(getISOCountryCodeForBank())) ) {
                    setISOCountryCodeForBank(((String) value));
                }
            }
            if( values.containsKey("PaymentMethodInEC") ) {
                final Object value = values.remove("PaymentMethodInEC");
                if( (value == null) || (!value.equals(getPaymentMethodInEC())) ) {
                    setPaymentMethodInEC(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("IBANExists") ) {
                final Object value = values.remove("IBANExists");
                if( (value == null) || (!value.equals(getIBANExists())) ) {
                    setIBANExists(((Boolean) value));
                }
            }
            if( values.containsKey("SwiftExists") ) {
                final Object value = values.remove("SwiftExists");
                if( (value == null) || (!value.equals(getSwiftExists())) ) {
                    setSwiftExists(((Boolean) value));
                }
            }
            if( values.containsKey("BankAccountNumberExists") ) {
                final Object value = values.remove("BankAccountNumberExists");
                if( (value == null) || (!value.equals(getBankAccountNumberExists())) ) {
                    setBankAccountNumberExists(((Boolean) value));
                }
            }
            if( values.containsKey("ISOEmployeeCountryCode") ) {
                final Object value = values.remove("ISOEmployeeCountryCode");
                if( (value == null) || (!value.equals(getISOEmployeeCountryCode())) ) {
                    setISOEmployeeCountryCode(((String) value));
                }
            }
            if( values.containsKey("BankKeyExists") ) {
                final Object value = values.remove("BankKeyExists");
                if( (value == null) || (!value.equals(getBankKeyExists())) ) {
                    setBankKeyExists(((Boolean) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("IsValid") ) {
                final Object value = values.remove("IsValid");
                if( (value == null) || (!value.equals(getIsValid())) ) {
                    setIsValid(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PaymentMethodValidationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PaymentMethodValidationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PaymentMethodValidationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PaymentMethodValidationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentMethodValidationService.DEFAULT_SERVICE_PATH);
    }

}
