/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PaymentMethodValidationServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentMethodValidationService
 * PaymentMethodValidationService}.
 *
 */
public class DefaultPaymentMethodValidationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PaymentMethodValidationServiceBatch, PaymentMethodValidationServiceBatchChangeSet>
    implements
    PaymentMethodValidationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentMethodValidationService service;

    @SuppressWarnings( "deprecation" )
    DefaultPaymentMethodValidationServiceBatchChangeSet(
        @Nonnull final DefaultPaymentMethodValidationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PaymentMethodValidationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPaymentMethodValidationServiceBatchChangeSet getThis()
    {
        return this;
    }

}
